/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.material.PartService;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_entities.part_001.Part;
import net.datastream.schemas.mp_fields.PARTID_Type;
import net.datastream.schemas.mp_functions.mp0240_001.MP0240_AddPart_001;
import net.datastream.schemas.mp_functions.mp0241_001.MP0241_GetPart_001;
import net.datastream.schemas.mp_functions.mp0242_001.MP0242_SyncPart_001;
import net.datastream.schemas.mp_functions.mp0243_001.MP0243_DeletePart_001;
import net.datastream.schemas.mp_functions.mp2072_001.ChangePartNumber;
import net.datastream.schemas.mp_functions.mp2072_001.MP2072_ChangePartNumber_001;
import net.datastream.schemas.mp_results.mp0240_001.MP0240_AddPart_001_Result;
import net.datastream.schemas.mp_results.mp0241_001.MP0241_GetPart_001_Result;
import net.datastream.schemas.mp_results.mp0242_001.MP0242_SyncPart_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class PartServiceImpl
implements PartService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public PartServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public ch.cern.eam.wshub.core.services.material.entities.Part readPart(InforContext context, String partCode) throws InforException {
        return this.tools.getInforFieldTools().transformInforObject(new ch.cern.eam.wshub.core.services.material.entities.Part(), this.readPartInfor(context, partCode));
    }

    private Part readPartInfor(InforContext context, String partCode) throws InforException {
        MP0241_GetPart_001 getPart = new MP0241_GetPart_001();
        getPart.setPARTID(new PARTID_Type());
        getPart.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
        getPart.getPARTID().setPARTCODE(partCode);
        MP0241_GetPart_001_Result getPartResult = null;
        getPartResult = context.getCredentials() != null ? this.inforws.getPartOp(getPart, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context)) : this.inforws.getPartOp(getPart, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        return getPartResult.getResultData().getPart();
    }

    @Override
    public String createPart(InforContext context, ch.cern.eam.wshub.core.services.material.entities.Part partParam) throws InforException {
        Part inforPart = new Part();
        if (partParam.getCustomFields() != null && partParam.getCustomFields().length > 0) {
            if (partParam.getClassCode() != null && !partParam.getClassCode().trim().equals("")) {
                inforPart.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, "PART", partParam.getClassCode()));
            } else {
                inforPart.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, "PART", "*"));
            }
        }
        this.tools.getInforFieldTools().transformWSHubObject(inforPart, partParam, context);
        MP0240_AddPart_001 addPart = new MP0240_AddPart_001();
        addPart.setPart(inforPart);
        MP0240_AddPart_001_Result result = null;
        result = context.getCredentials() != null ? this.inforws.addPartOp(addPart, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context)) : this.inforws.addPartOp(addPart, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        return result.getPARTID().getPARTCODE();
    }

    @Override
    public String updatePart(InforContext context, ch.cern.eam.wshub.core.services.material.entities.Part partParam) throws InforException {
        if (partParam.getNewCode() != null && !partParam.getNewCode().trim().equals("")) {
            MP2072_ChangePartNumber_001 changePartNumber = new MP2072_ChangePartNumber_001();
            changePartNumber.setChangePartNumber(new ChangePartNumber());
            changePartNumber.getChangePartNumber().setOLDPARTID(new PARTID_Type());
            changePartNumber.getChangePartNumber().getOLDPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            changePartNumber.getChangePartNumber().getOLDPARTID().setPARTCODE(partParam.getCode());
            changePartNumber.getChangePartNumber().setNEWPARTID(new PARTID_Type());
            changePartNumber.getChangePartNumber().getNEWPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            changePartNumber.getChangePartNumber().getNEWPARTID().setPARTCODE(partParam.getNewCode());
            if (context.getCredentials() != null) {
                this.inforws.changePartNumberOp(changePartNumber, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context));
            } else {
                this.inforws.changePartNumberOp(changePartNumber, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
            }
            partParam.setCode(partParam.getNewCode());
        }
        Part inforPart = this.readPartInfor(context, partParam.getCode());
        if (!(partParam.getClassCode() == null || inforPart.getCLASSID() != null && partParam.getClassCode().toUpperCase().equals(inforPart.getCLASSID().getCLASSCODE()))) {
            inforPart.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, "PART", partParam.getClassCode().toUpperCase()));
        }
        this.tools.getInforFieldTools().transformWSHubObject(inforPart, partParam, context);
        MP0242_SyncPart_001 syncPart = new MP0242_SyncPart_001();
        syncPart.setPart(inforPart);
        MP0242_SyncPart_001_Result result = null;
        result = context.getCredentials() != null ? this.inforws.syncPartOp(syncPart, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context)) : this.inforws.syncPartOp(syncPart, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        return result.getResultData().getPart().getPARTID().getPARTCODE();
    }

    @Override
    public String deletePart(InforContext context, String partCode) throws InforException {
        MP0243_DeletePart_001 deletePart = new MP0243_DeletePart_001();
        deletePart.setPARTID(new PARTID_Type());
        deletePart.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
        deletePart.getPARTID().setPARTCODE(partCode);
        if (context.getCredentials() != null) {
            this.inforws.deletePartOp(deletePart, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context));
        } else {
            this.inforws.deletePartOp(deletePart, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        }
        return partCode;
    }
}

