/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.material.PartStoreService;
import ch.cern.eam.wshub.core.services.material.entities.PartStore;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_entities.partstores_001.PartStores;
import net.datastream.schemas.mp_fields.BINID_Type;
import net.datastream.schemas.mp_fields.PARTID_Type;
import net.datastream.schemas.mp_fields.STOREID_Type;
import net.datastream.schemas.mp_fields.STOREPARTID_Type;
import net.datastream.schemas.mp_fields.SUPPLIERID_Type;
import net.datastream.schemas.mp_functions.mp0254_001.MP0254_GetPartStores_001;
import net.datastream.schemas.mp_functions.mp0255_001.MP0255_AddPartStores_001;
import net.datastream.schemas.mp_functions.mp0256_001.MP0256_SyncPartStores_001;
import net.datastream.schemas.mp_results.mp0254_001.MP0254_GetPartStores_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class PartStoreServiceImpl
implements PartStoreService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public PartStoreServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public String updatePartStore(InforContext context, PartStore partStoreParam) throws InforException {
        MP0254_GetPartStores_001 getPartStores = new MP0254_GetPartStores_001();
        getPartStores.setSTOREPARTID(new STOREPARTID_Type());
        getPartStores.getSTOREPARTID().setPARTID(new PARTID_Type());
        getPartStores.getSTOREPARTID().getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
        getPartStores.getSTOREPARTID().getPARTID().setPARTCODE(partStoreParam.getPartCode());
        getPartStores.getSTOREPARTID().setSTOREID(new STOREID_Type());
        getPartStores.getSTOREPARTID().getSTOREID().setORGANIZATIONID(this.tools.getOrganization(context));
        getPartStores.getSTOREPARTID().getSTOREID().setSTORECODE(partStoreParam.getStoreCode());
        MP0254_GetPartStores_001_Result result = context.getCredentials() != null ? this.inforws.getPartStoresOp(getPartStores, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context)) : this.inforws.getPartStoresOp(getPartStores, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        PartStores partStoresResult = result.getResultData().getPartStores();
        if (partStoreParam.getDefaultBin() != null) {
            partStoresResult.setDEFAULTBIN(new BINID_Type());
            partStoresResult.getDEFAULTBIN().setBIN(partStoreParam.getDefaultBin());
        }
        if (partStoreParam.getOrderQty() != null) {
            this.tools.getDataTypeTools();
            partStoresResult.setORDERQTY(DataTypeTools.encodeAmount(partStoreParam.getOrderQty(), "Ordery Qty."));
        }
        if (partStoreParam.getReorderLevel() != null) {
            this.tools.getDataTypeTools();
            partStoresResult.setREORDERLEVEL(DataTypeTools.encodeAmount(partStoreParam.getReorderLevel(), "Reorder Level"));
        }
        if (partStoreParam.getDefaultReturnBin() != null) {
            partStoresResult.setDEFAULTRETURNBIN(new BINID_Type());
            partStoresResult.getDEFAULTRETURNBIN().setBIN(partStoreParam.getDefaultReturnBin());
        }
        if (partStoreParam.getAbcClass() != null) {
            partStoresResult.setABCCODE(partStoreParam.getAbcClass());
        }
        if (partStoreParam.getPreferredSupplier() != null) {
            partStoresResult.setPREFERREDSUPPLIER(new SUPPLIERID_Type());
            partStoresResult.getPREFERREDSUPPLIER().setORGANIZATIONID(this.tools.getOrganization(context));
            partStoresResult.getPREFERREDSUPPLIER().setSUPPLIERCODE(partStoreParam.getPreferredSupplier());
        }
        if (partStoreParam.getPreventIssueFromDefaultReturnBin() != null) {
            partStoresResult.setPREVENTISSUEDEFRTNBIN(partStoreParam.getPreventIssueFromDefaultReturnBin());
        } else {
            partStoresResult.setPREVENTISSUEDEFRTNBIN("true");
        }
        if (partStoreParam.getPreferredStore() != null) {
            partStoresResult.setPREFERREDSTORE(new STOREID_Type());
            partStoresResult.getPREFERREDSTORE().setORGANIZATIONID(this.tools.getOrganization(context));
            partStoresResult.getPREFERREDSTORE().setSTORECODE(partStoreParam.getPreferredStore());
        }
        if (partStoreParam.getMinimumQty() != null) {
            this.tools.getDataTypeTools();
            partStoresResult.setMINIMUMQTY(DataTypeTools.encodeAmount(partStoreParam.getMinimumQty(), "Minimum Qty"));
        }
        if (partStoreParam.getStockMethod() != null) {
            partStoresResult.setONDEMAND(partStoreParam.getStockMethod());
        }
        MP0256_SyncPartStores_001 syncPartStores = new MP0256_SyncPartStores_001();
        syncPartStores.setPartStores(partStoresResult);
        if (context.getCredentials() != null) {
            this.inforws.syncPartStoresOp(syncPartStores, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context));
        } else {
            this.inforws.syncPartStoresOp(syncPartStores, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        }
        return null;
    }

    @Override
    public String addPartStore(InforContext context, PartStore partStoreParam) throws InforException {
        PartStores partStoresInfor = new PartStores();
        if (partStoreParam.getPartCode() != null) {
            partStoresInfor.setPARTID(new PARTID_Type());
            partStoresInfor.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            partStoresInfor.getPARTID().setPARTCODE(partStoreParam.getPartCode());
        }
        if (partStoreParam.getDefaultBin() != null) {
            partStoresInfor.setDEFAULTBIN(new BINID_Type());
            partStoresInfor.getDEFAULTBIN().setBIN(partStoreParam.getDefaultBin());
        }
        partStoresInfor.setLABELPRINTINGDEFAULT("");
        if (partStoreParam.getOrderQty() != null) {
            this.tools.getDataTypeTools();
            partStoresInfor.setORDERQTY(DataTypeTools.encodeAmount(partStoreParam.getOrderQty(), "Ordery Qty."));
        }
        if (partStoreParam.getReorderLevel() != null) {
            this.tools.getDataTypeTools();
            partStoresInfor.setREORDERLEVEL(DataTypeTools.encodeAmount(partStoreParam.getReorderLevel(), "Reorder Level"));
        }
        if (partStoreParam.getDefaultReturnBin() != null) {
            partStoresInfor.setDEFAULTRETURNBIN(new BINID_Type());
            partStoresInfor.getDEFAULTRETURNBIN().setBIN(partStoreParam.getDefaultReturnBin());
        }
        if (partStoreParam.getAbcClass() != null) {
            partStoresInfor.setABCCODE(partStoreParam.getAbcClass());
        }
        if (partStoreParam.getPreferredSupplier() != null) {
            partStoresInfor.setPREFERREDSUPPLIER(new SUPPLIERID_Type());
            partStoresInfor.getPREFERREDSUPPLIER().setORGANIZATIONID(this.tools.getOrganization(context));
            partStoresInfor.getPREFERREDSUPPLIER().setSUPPLIERCODE(partStoreParam.getPreferredSupplier());
        }
        if (partStoreParam.getStoreCode() != null) {
            partStoresInfor.setSTOREID(new STOREID_Type());
            partStoresInfor.getSTOREID().setORGANIZATIONID(this.tools.getOrganization(context));
            partStoresInfor.getSTOREID().setSTORECODE(partStoreParam.getStoreCode());
        }
        if (partStoreParam.getPreventIssueFromDefaultReturnBin() != null) {
            partStoresInfor.setPREVENTISSUEDEFRTNBIN(partStoreParam.getPreventIssueFromDefaultReturnBin());
        } else {
            partStoresInfor.setPREVENTISSUEDEFRTNBIN("true");
        }
        if (partStoreParam.getPreferredStore() != null) {
            partStoresInfor.setPREFERREDSTORE(new STOREID_Type());
            partStoresInfor.getPREFERREDSTORE().setORGANIZATIONID(this.tools.getOrganization(context));
            partStoresInfor.getPREFERREDSTORE().setSTORECODE(partStoreParam.getPreferredStore());
        }
        if (partStoreParam.getMinimumQty() != null) {
            this.tools.getDataTypeTools();
            partStoresInfor.setMINIMUMQTY(DataTypeTools.encodeAmount(partStoreParam.getMinimumQty(), "Minimum Qty"));
        }
        if (partStoreParam.getStockMethod() != null) {
            partStoresInfor.setONDEMAND(partStoreParam.getStockMethod());
        }
        MP0255_AddPartStores_001 addPartStores = new MP0255_AddPartStores_001();
        addPartStores.setPartStores(partStoresInfor);
        if (context.getCredentials() != null) {
            this.inforws.addPartStoresOp(addPartStores, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context));
        } else {
            this.inforws.addPartStoresOp(addPartStores, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        }
        return null;
    }
}

