/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.equipment.AssetService;
import ch.cern.eam.wshub.core.services.equipment.EquipmentFacadeService;
import ch.cern.eam.wshub.core.services.equipment.LocationService;
import ch.cern.eam.wshub.core.services.equipment.PositionService;
import ch.cern.eam.wshub.core.services.equipment.SystemService;
import ch.cern.eam.wshub.core.services.equipment.entities.Equipment;
import ch.cern.eam.wshub.core.services.equipment.impl.AssetServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.LocationServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.PositionServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.SystemServiceImpl;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestFilter;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestResult;
import ch.cern.eam.wshub.core.services.grids.impl.GridsServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.HashMap;
import java.util.List;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class EquipmentFacadeServiceImpl
implements EquipmentFacadeService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private AssetService assetService;
    private PositionService positionService;
    private SystemService systemService;
    private LocationService locationService;
    private GridsService gridsService;

    public EquipmentFacadeServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.assetService = new AssetServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
        this.positionService = new PositionServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
        this.systemService = new SystemServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
        this.locationService = new LocationServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
        this.gridsService = new GridsServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public BatchResponse<String> createEquipmentBatch(InforContext inforContext, List<Equipment> equipmentList) {
        return this.tools.batchOperation(inforContext, this::createEquipment, equipmentList);
    }

    @Override
    public BatchResponse<Equipment> readEquipmentBatch(InforContext inforContext, List<String> equipmentCodes) {
        return this.tools.batchOperation(inforContext, this::readEquipment, equipmentCodes);
    }

    @Override
    public BatchResponse<String> updateEquipmentBatch(InforContext inforContext, List<Equipment> equipmentList) {
        return this.tools.batchOperation(inforContext, this::updateEquipment, equipmentList);
    }

    @Override
    public BatchResponse<String> deleteEquipmentBatch(InforContext inforContext, List<String> equipmentCodes) {
        return this.tools.batchOperation(inforContext, this::deleteEquipment, equipmentCodes);
    }

    @Override
    public String updateEquipment(InforContext inforContext, Equipment equipment) throws InforException {
        if (equipment.getTypeCode() == null) {
            equipment.setTypeCode(this.getEquipmentTypeCode(inforContext, equipment.getCode()));
        }
        switch (equipment.getTypeCode()) {
            case "A": 
            case "PB": 
            case "PM": 
            case "T": {
                return this.assetService.updateAsset(inforContext, equipment);
            }
            case "P": {
                return this.positionService.updatePosition(inforContext, equipment);
            }
            case "B": 
            case "M": 
            case "R": 
            case "S": {
                return this.systemService.updateSystem(inforContext, equipment);
            }
            case "L": {
                throw Tools.generateFault("Locations are not available here. Use LocationService.");
            }
        }
        throw Tools.generateFault("Wrong equipment type.");
    }

    @Override
    public String createEquipment(InforContext inforContext, Equipment equipment) throws InforException {
        if (equipment.getTypeCode() == null) {
            throw Tools.generateFault("Equipment type can not be empty.");
        }
        switch (equipment.getTypeCode()) {
            case "A": 
            case "PB": 
            case "PM": 
            case "T": {
                return this.assetService.createAsset(inforContext, equipment);
            }
            case "P": {
                return this.positionService.createPosition(inforContext, equipment);
            }
            case "B": 
            case "M": 
            case "R": 
            case "S": {
                return this.systemService.createSystem(inforContext, equipment);
            }
            case "L": {
                throw Tools.generateFault("Locations are not available here. Use LocationService.");
            }
        }
        throw Tools.generateFault("Equipment type not recognized.");
    }

    @Override
    public Equipment readEquipment(InforContext inforContext, String equipmentCode) throws InforException {
        String equipmentTypeCode;
        switch (equipmentTypeCode = this.getEquipmentTypeCode(inforContext, equipmentCode)) {
            case "A": 
            case "PB": 
            case "PM": 
            case "T": {
                return this.assetService.readAsset(inforContext, equipmentCode);
            }
            case "P": {
                return this.positionService.readPosition(inforContext, equipmentCode);
            }
            case "B": 
            case "M": 
            case "R": 
            case "S": {
                return this.systemService.readSystem(inforContext, equipmentCode);
            }
            case "L": {
                throw Tools.generateFault("Locations are no longer available here. Use LocationService.");
            }
        }
        throw Tools.generateFault("Equipment type not recognized.");
    }

    @Override
    public String deleteEquipment(InforContext inforContext, String equipmentCode) throws InforException {
        String equipmentTypeCode;
        switch (equipmentTypeCode = this.getEquipmentTypeCode(inforContext, equipmentCode)) {
            case "A": 
            case "PB": 
            case "PM": 
            case "T": {
                return this.assetService.deleteAsset(inforContext, equipmentCode);
            }
            case "P": {
                return this.positionService.deletePosition(inforContext, equipmentCode);
            }
            case "B": 
            case "M": 
            case "R": 
            case "S": {
                return this.systemService.deleteSystem(inforContext, equipmentCode);
            }
            case "L": {
                throw Tools.generateFault("Locations are no longer available here. Use LocationService.");
            }
        }
        throw Tools.generateFault("Equipment type not recognized.");
    }

    private String getEquipmentTypeCode(InforContext inforContext, String equipmentCode) throws InforException {
        HashMap<String, String> types = new HashMap<String, String>();
        types.put("Equipement", "A");
        types.put("Asset", "A");
        types.put("Position", "P");
        types.put("Position fonctionelle", "P");
        types.put("System", "S");
        types.put("Systeme", "S");
        types.put("Lot", "B");
        types.put("Route", "R");
        types.put("Material", "M");
        GridRequest gridRequest = new GridRequest("LVREPCOGALLEQUIPMENT", GridRequest.GRIDTYPE.LOV);
        gridRequest.getGridRequestFilters().add(new GridRequestFilter("code", equipmentCode, "="));
        GridRequestResult requestResult = this.gridsService.executeQuery(inforContext, gridRequest);
        if (requestResult.getRows().length != 1) {
            throw Tools.generateFault("The equipment record couldn't be found.");
        }
        String type = (String)types.get(GridTools.getCellContent("type", requestResult.getRows()[0]));
        if (type == null) {
            throw Tools.generateFault("This code does not correspond to an equipment.");
        }
        return type;
    }
}

