/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.workorders.CaseTaskService;
import ch.cern.eam.wshub.core.services.workorders.entities.InforCaseTask;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import net.datastream.schemas.mp_entities.casemanagementtask_001.CaseManagementTask;
import net.datastream.schemas.mp_entities.casemanagementtask_001.TrackingDetails;
import net.datastream.schemas.mp_fields.CASEID_Type;
import net.datastream.schemas.mp_fields.CASEMANAGEMENTTASKID_Type;
import net.datastream.schemas.mp_fields.PERSONID_Type;
import net.datastream.schemas.mp_fields.PLANNEDDURATIONUOM;
import net.datastream.schemas.mp_fields.PLANNEDDURATION_Type;
import net.datastream.schemas.mp_fields.PRIORITY;
import net.datastream.schemas.mp_fields.StandardUserDefinedFields;
import net.datastream.schemas.mp_functions.mp3655_001.MP3655_AddCaseManagementTask_001;
import net.datastream.schemas.mp_functions.mp3656_001.MP3656_SyncCaseManagementTask_001;
import net.datastream.schemas.mp_functions.mp3657_001.MP3657_DeleteCaseManagementTask_001;
import net.datastream.schemas.mp_functions.mp3658_001.MP3658_GetCaseManagementTask_001;
import net.datastream.schemas.mp_results.mp3655_001.MP3655_AddCaseManagementTask_001_Result;
import net.datastream.schemas.mp_results.mp3656_001.MP3656_SyncCaseManagementTask_001_Result;
import net.datastream.schemas.mp_results.mp3658_001.MP3658_GetCaseManagementTask_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class CaseTaskServiceImpl
implements CaseTaskService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public CaseTaskServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public InforCaseTask readCaseTask(InforContext context, String caseTaskID) throws InforException {
        MP3658_GetCaseManagementTask_001 getCaseTask = new MP3658_GetCaseManagementTask_001();
        getCaseTask.setCASEMANAGEMENTTASKID(new CASEMANAGEMENTTASKID_Type());
        getCaseTask.getCASEMANAGEMENTTASKID().setCASEMANAGEMENTTASKCODE(caseTaskID);
        MP3658_GetCaseManagementTask_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getCaseManagementTaskOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getCaseTask);
        CaseManagementTask caseTaskInfor = result.getResultData().getCaseManagementTask();
        InforCaseTask caseTaskMT = new InforCaseTask();
        if (caseTaskInfor.getCASEMANAGEMENTTASKID() != null) {
            caseTaskMT.setCaseCode(caseTaskInfor.getCASEID().getCASECODE());
            caseTaskMT.setTaskCode(caseTaskInfor.getCASEMANAGEMENTTASKID().getCASEMANAGEMENTTASKCODE());
            caseTaskMT.setDescription(caseTaskInfor.getCASEMANAGEMENTTASKID().getDESCRIPTION());
        }
        caseTaskMT.setSequence(caseTaskInfor.getSEQUENCE());
        if (caseTaskInfor.getSTEP() != null) {
            caseTaskMT.setStep(caseTaskInfor.getSTEP());
        }
        if (caseTaskInfor.getESTIMATEDCOSTS() != null) {
            this.tools.getDataTypeTools();
            caseTaskMT.setEstimatedCosts(DataTypeTools.decodeAmount(caseTaskInfor.getESTIMATEDCOSTS()));
        }
        if (caseTaskInfor.getPRIORITY() != null) {
            caseTaskMT.setPriority(caseTaskInfor.getPRIORITY().getPRIORITYCODE());
        }
        if (caseTaskInfor.getCREATEDBY() != null) {
            caseTaskMT.setCreatedBy(caseTaskInfor.getCREATEDBY().getUSERCODE());
        }
        if (caseTaskInfor.getCREATEDDATE() != null) {
            this.tools.getDataTypeTools();
            caseTaskMT.setDateCreated(DataTypeTools.decodeInforDate(caseTaskInfor.getCREATEDDATE()));
        }
        if (caseTaskInfor.getUPDATEDBY() != null) {
            caseTaskMT.setUpdatedBy(caseTaskInfor.getUPDATEDBY().getUSERCODE());
        }
        if (caseTaskInfor.getDATEUPDATED() != null) {
            this.tools.getDataTypeTools();
            caseTaskMT.setDateUpdated(DataTypeTools.decodeInforDate(caseTaskInfor.getDATEUPDATED()));
        }
        if (caseTaskInfor.getTrackingDetails() != null) {
            TrackingDetails trackingDetails = caseTaskInfor.getTrackingDetails();
            this.tools.getDataTypeTools();
            caseTaskMT.setStartDate(DataTypeTools.decodeInforDate(caseTaskInfor.getTrackingDetails().getSTARTDATE()));
            if (trackingDetails.getCOMPLETEDDATE() != null) {
                this.tools.getDataTypeTools();
                caseTaskMT.setCompletedDate(DataTypeTools.decodeInforDate(caseTaskInfor.getTrackingDetails().getCOMPLETEDDATE()));
            }
            if (trackingDetails.getSCHEDULEDSTARTDATE() != null) {
                this.tools.getDataTypeTools();
                caseTaskMT.setScheduledStartDate(DataTypeTools.decodeInforDate(caseTaskInfor.getTrackingDetails().getSCHEDULEDSTARTDATE()));
            }
            if (trackingDetails.getSCHEDULEDENDDATE() != null) {
                this.tools.getDataTypeTools();
                caseTaskMT.setScheduledEndDate(DataTypeTools.decodeInforDate(caseTaskInfor.getTrackingDetails().getSCHEDULEDENDDATE()));
            }
            if (caseTaskInfor.getTrackingDetails().getPLANNEDDURATION() != null) {
                PLANNEDDURATION_Type planneddurationType = caseTaskInfor.getTrackingDetails().getPLANNEDDURATION();
                if (planneddurationType.getPLANNEDDURATIONVALUE() != null) {
                    this.tools.getDataTypeTools();
                    caseTaskMT.setPlannedDuration(DataTypeTools.decodeQuantity(planneddurationType.getPLANNEDDURATIONVALUE()));
                }
                if (planneddurationType.getPLANNEDDURATIONUOM() != null && planneddurationType.getPLANNEDDURATIONUOM().getPLANNEDDURATIONUOMCODE() != null) {
                    caseTaskMT.setPlannedDurationUnit(planneddurationType.getPLANNEDDURATIONUOM().getPLANNEDDURATIONUOMCODE());
                }
            }
        }
        caseTaskMT.setCustomFields(this.tools.getCustomFieldsTools().readInforCustomFields(caseTaskInfor.getUSERDEFINEDAREA()));
        caseTaskMT.setUserDefinedFields(this.tools.getUDFTools().readInforUserDefinedFields(caseTaskInfor.getStandardUserDefinedFields()));
        return caseTaskMT;
    }

    @Override
    public String createCaseTask(InforContext context, InforCaseTask caseTaskMT) throws InforException {
        CaseManagementTask caseManagement = new CaseManagementTask();
        caseManagement.setStandardUserDefinedFields(new StandardUserDefinedFields());
        this.initCaseTaskObject(caseManagement, caseTaskMT, context);
        MP3655_AddCaseManagementTask_001 initCaseTask = new MP3655_AddCaseManagementTask_001();
        initCaseTask.setCaseManagementTask(caseManagement);
        MP3655_AddCaseManagementTask_001_Result initCaseTaskResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addCaseManagementTaskOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), initCaseTask);
        return initCaseTaskResult.getResultData().getCASEMANAGEMENTTASKID().getCASEMANAGEMENTTASKCODE();
    }

    @Override
    public String updateCaseTask(InforContext context, InforCaseTask caseTaskMT) throws InforException {
        MP3658_GetCaseManagementTask_001 getCaseTask = new MP3658_GetCaseManagementTask_001();
        getCaseTask.setCASEMANAGEMENTTASKID(new CASEMANAGEMENTTASKID_Type());
        getCaseTask.getCASEMANAGEMENTTASKID().setCASEMANAGEMENTTASKCODE(caseTaskMT.getTaskCode());
        MP3658_GetCaseManagementTask_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getCaseManagementTaskOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getCaseTask);
        CaseManagementTask caseManagementTask = result.getResultData().getCaseManagementTask();
        this.initCaseTaskObject(caseManagementTask, caseTaskMT, context);
        MP3656_SyncCaseManagementTask_001 syncCase = new MP3656_SyncCaseManagementTask_001();
        syncCase.setCaseManagementTask(caseManagementTask);
        MP3656_SyncCaseManagementTask_001_Result syncCaseResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncCaseManagementTaskOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncCase);
        return syncCaseResult.getResultData().getCASEMANAGEMENTTASKID().getCASEMANAGEMENTTASKCODE();
    }

    @Override
    public String deleteCaseTask(InforContext context, String caseTaskID) throws InforException {
        MP3657_DeleteCaseManagementTask_001 deleteCaseTask = new MP3657_DeleteCaseManagementTask_001();
        CASEMANAGEMENTTASKID_Type caseManagementTaskIdType = new CASEMANAGEMENTTASKID_Type();
        caseManagementTaskIdType.setCASEMANAGEMENTTASKCODE(caseTaskID);
        deleteCaseTask.setCASEMANAGEMENTTASKID(caseManagementTaskIdType);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteCaseManagementTaskOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteCaseTask);
        return deleteCaseTask.getCASEMANAGEMENTTASKID().getCASEMANAGEMENTTASKCODE();
    }

    private void initCaseTaskObject(CaseManagementTask caseTaskInfor, InforCaseTask caseTaskMT, InforContext context) throws InforException {
        if (caseTaskInfor.getCASEID() == null) {
            CASEID_Type caseIdType = new CASEID_Type();
            caseIdType.setCASECODE(caseTaskMT.getCaseCode());
            caseTaskInfor.setCASEID(caseIdType);
        }
        if (caseTaskInfor.getCASEID().getORGANIZATIONID() == null) {
            caseTaskInfor.getCASEID().setORGANIZATIONID(this.tools.getOrganization(context));
        }
        if (caseTaskInfor.getCASEMANAGEMENTTASKID() == null) {
            caseTaskInfor.setCASEMANAGEMENTTASKID(new CASEMANAGEMENTTASKID_Type());
            caseTaskInfor.getCASEMANAGEMENTTASKID().setCASEMANAGEMENTTASKCODE("0");
        }
        if (caseTaskMT.getDescription() != null) {
            caseTaskInfor.getCASEMANAGEMENTTASKID().setDESCRIPTION(caseTaskMT.getDescription());
        }
        if (caseTaskMT.getSequence() != null) {
            caseTaskInfor.setSEQUENCE(caseTaskMT.getSequence().longValue());
        }
        if (caseTaskMT.getEstimatedCosts() != null) {
            this.tools.getDataTypeTools();
            caseTaskInfor.setESTIMATEDCOSTS(DataTypeTools.encodeAmount(caseTaskMT.getEstimatedCosts(), null));
        }
        if (caseTaskMT.getSequence() != null) {
            caseTaskInfor.setSEQUENCE(caseTaskMT.getSequence().longValue());
        }
        if (caseTaskMT.getStep() != null) {
            caseTaskInfor.setSTEP(caseTaskMT.getStep());
        }
        if (caseTaskMT.getPriority() != null) {
            caseTaskInfor.setPRIORITY(new PRIORITY());
            caseTaskInfor.getPRIORITY().setPRIORITYCODE(caseTaskMT.getPriority());
        }
        this.tools.getUDFTools().updateInforUserDefinedFields(caseTaskInfor.getStandardUserDefinedFields(), caseTaskMT.getUserDefinedFields());
        if (caseTaskMT.getAssignedTo() != null) {
            if (caseTaskInfor.getTrackingDetails() == null) {
                caseTaskInfor.setTrackingDetails(new TrackingDetails());
            }
            caseTaskInfor.getTrackingDetails().setASSIGNEDTO(new PERSONID_Type());
            caseTaskInfor.getTrackingDetails().getASSIGNEDTO().setPERSONCODE(caseTaskMT.getAssignedTo());
        }
        if (caseTaskMT.getStartDate() != null) {
            if (caseTaskInfor.getTrackingDetails() == null) {
                caseTaskInfor.setTrackingDetails(new TrackingDetails());
            }
            TrackingDetails trackingDetails = caseTaskInfor.getTrackingDetails();
            this.tools.getDataTypeTools();
            trackingDetails.setSTARTDATE(DataTypeTools.encodeInforDate(caseTaskMT.getStartDate(), "Start Date"));
        }
        if (caseTaskMT.getCompletedDate() != null) {
            if (caseTaskInfor.getTrackingDetails() == null) {
                caseTaskInfor.setTrackingDetails(new TrackingDetails());
            }
            TrackingDetails trackingDetails = caseTaskInfor.getTrackingDetails();
            this.tools.getDataTypeTools();
            trackingDetails.setCOMPLETEDDATE(DataTypeTools.encodeInforDate(caseTaskMT.getCompletedDate(), "Completed Date"));
        }
        if (caseTaskMT.getScheduledStartDate() != null) {
            if (caseTaskInfor.getTrackingDetails() == null) {
                caseTaskInfor.setTrackingDetails(new TrackingDetails());
            }
            TrackingDetails trackingDetails = caseTaskInfor.getTrackingDetails();
            this.tools.getDataTypeTools();
            trackingDetails.setSCHEDULEDSTARTDATE(DataTypeTools.encodeInforDate(caseTaskMT.getScheduledStartDate(), "Scheduling Start Date"));
        }
        if (caseTaskMT.getPlannedDuration() != null && caseTaskMT.getPlannedDurationUnit() != null) {
            if (caseTaskInfor.getTrackingDetails() == null) {
                caseTaskInfor.setTrackingDetails(new TrackingDetails());
            }
            if (caseTaskInfor.getTrackingDetails().getPLANNEDDURATION() == null) {
                caseTaskInfor.getTrackingDetails().setPLANNEDDURATION(new PLANNEDDURATION_Type());
                caseTaskInfor.getTrackingDetails().getPLANNEDDURATION().setPLANNEDDURATIONUOM(new PLANNEDDURATIONUOM());
                caseTaskInfor.getTrackingDetails().getPLANNEDDURATION().getPLANNEDDURATIONUOM().setPLANNEDDURATIONUOMCODE(caseTaskMT.getPlannedDurationUnit());
                PLANNEDDURATION_Type pLANNEDDURATION_Type = caseTaskInfor.getTrackingDetails().getPLANNEDDURATION();
                this.tools.getDataTypeTools();
                pLANNEDDURATION_Type.setPLANNEDDURATIONVALUE(DataTypeTools.encodeQuantity(caseTaskMT.getPlannedDuration(), "Planned Duration"));
            }
        }
        if (caseTaskMT.getRequestedStartDate() != null) {
            if (caseTaskInfor.getTrackingDetails() == null) {
                caseTaskInfor.setTrackingDetails(new TrackingDetails());
            }
            TrackingDetails trackingDetails = caseTaskInfor.getTrackingDetails();
            this.tools.getDataTypeTools();
            trackingDetails.setREQUESTEDSTART(DataTypeTools.encodeInforDate(caseTaskMT.getRequestedStartDate(), "Requested Start Date"));
        }
        if (caseTaskMT.getRequestedEndDate() != null) {
            if (caseTaskInfor.getTrackingDetails() == null) {
                caseTaskInfor.setTrackingDetails(new TrackingDetails());
            }
            TrackingDetails trackingDetails = caseTaskInfor.getTrackingDetails();
            this.tools.getDataTypeTools();
            trackingDetails.setREQUESTEDEND(DataTypeTools.encodeInforDate(caseTaskMT.getRequestedEndDate(), "Requested End Date"));
        }
    }
}

