/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.annotations.BooleanType;
import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestResult;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestRow;
import ch.cern.eam.wshub.core.services.grids.impl.GridsServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.ChecklistService;
import ch.cern.eam.wshub.core.services.workorders.entities.Activity;
import ch.cern.eam.wshub.core.services.workorders.entities.Finding;
import ch.cern.eam.wshub.core.services.workorders.entities.TaskplanCheckList;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityCheckList;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.function.Function;
import javax.persistence.EntityManager;
import net.datastream.schemas.mp_entities.taskchecklist_001.TaskChecklist;
import net.datastream.schemas.mp_fields.ACTIVITYCODE;
import net.datastream.schemas.mp_fields.ACTIVITYID;
import net.datastream.schemas.mp_fields.ASPECTID_Type;
import net.datastream.schemas.mp_fields.CATEGORYID;
import net.datastream.schemas.mp_fields.CHECKLISTID_Type;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.FINDINGID_Type;
import net.datastream.schemas.mp_fields.POINTTYPEID_Type;
import net.datastream.schemas.mp_fields.TASKLISTID_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_fields.UOMID_Type;
import net.datastream.schemas.mp_fields.USERDEFINEDCODEID_Type;
import net.datastream.schemas.mp_fields.WOID_Type;
import net.datastream.schemas.mp_functions.mp7913_001.MP7913_SyncWorkOrderActivityCheckList_001;
import net.datastream.schemas.mp_functions.mp7914_001.MP7914_GetWorkOrderActivityCheckList_001;
import net.datastream.schemas.mp_functions.mp7916_001.MP7916_AddTaskChecklist_001;
import net.datastream.schemas.mp_functions.mp8000_001.MP8000_CreateFollowUpWorkOrder_001;
import net.datastream.schemas.mp_results.mp7914_001.MP7914_GetWorkOrderActivityCheckList_001_Result;
import net.datastream.schemas.mp_results.mp8000_001.MP8000_CreateFollowUpWorkOrder_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class ChecklistServiceImpl
implements ChecklistService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private GridsService gridsService;

    public ChecklistServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.gridsService = new GridsServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public String updateWorkOrderChecklist(InforContext context, WorkOrderActivityCheckList workOrderActivityCheckList) throws InforException {
        MP7914_GetWorkOrderActivityCheckList_001 getwoactchl = new MP7914_GetWorkOrderActivityCheckList_001();
        getwoactchl.setCHECKLISTCODE(workOrderActivityCheckList.getCheckListCode());
        MP7914_GetWorkOrderActivityCheckList_001_Result getresult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getWorkOrderActivityCheckListOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getwoactchl);
        net.datastream.schemas.mp_entities.workorderactivitychecklist_001.WorkOrderActivityCheckList workOrderActivityCheckListInfor = getresult.getResultData().getWorkOrderActivityCheckList();
        if (workOrderActivityCheckList.getFollowUp() != null) {
            this.tools.getDataTypeTools();
            workOrderActivityCheckListInfor.setFOLLOWUP(DataTypeTools.encodeBoolean(workOrderActivityCheckList.getFollowUp(), BooleanType.PLUS_MINUS));
        }
        Function<String, String> getStringBool = key -> String.valueOf(key.equals(workOrderActivityCheckList.getResult()));
        switch (workOrderActivityCheckList.getType()) {
            case "01": {
                if ("COMPLETED".equalsIgnoreCase(workOrderActivityCheckList.getResult())) {
                    workOrderActivityCheckListInfor.setCOMPLETED("true");
                    break;
                }
                workOrderActivityCheckListInfor.setCOMPLETED("false");
                break;
            }
            case "02": {
                workOrderActivityCheckListInfor.setYES(getStringBool.apply("YES"));
                workOrderActivityCheckListInfor.setNO(getStringBool.apply("NO"));
                break;
            }
            case "03": {
                if (workOrderActivityCheckList.getFinding() != null) {
                    workOrderActivityCheckListInfor.setFINDINGID(new FINDINGID_Type());
                    workOrderActivityCheckListInfor.getFINDINGID().setFINDINGCODE(workOrderActivityCheckList.getFinding());
                    break;
                }
                workOrderActivityCheckListInfor.setFINDINGID(null);
                break;
            }
            case "06": {
                if (workOrderActivityCheckList.getFinding() != null) {
                    workOrderActivityCheckListInfor.setFINDINGID(new FINDINGID_Type());
                    workOrderActivityCheckListInfor.getFINDINGID().setFINDINGCODE(workOrderActivityCheckList.getFinding());
                } else {
                    workOrderActivityCheckListInfor.setFINDINGID(null);
                }
            }
            case "04": 
            case "05": {
                BigDecimal possibleNumericValue;
                BigDecimal numericValue = workOrderActivityCheckList.getNumericValue();
                if (numericValue == null && (possibleNumericValue = DataTypeTools.encodeBigDecimal(workOrderActivityCheckList.getResult(), "")) != null) {
                    numericValue = possibleNumericValue;
                }
                this.tools.getDataTypeTools();
                workOrderActivityCheckListInfor.setRESULTVALUE(DataTypeTools.encodeQuantity(numericValue, "Checklists Value"));
                break;
            }
            case "07": {
                workOrderActivityCheckListInfor.setOKFLAG(getStringBool.apply("OK"));
                workOrderActivityCheckListInfor.setREPAIRSNEEDED(getStringBool.apply("REPAIRSNEEDED"));
                if (DataTypeTools.isEmpty(workOrderActivityCheckList.getFinding())) {
                    workOrderActivityCheckListInfor.setRESOLUTIONID(null);
                    break;
                }
                workOrderActivityCheckListInfor.setRESOLUTIONID(new USERDEFINEDCODEID_Type());
                workOrderActivityCheckListInfor.getRESOLUTIONID().setUSERDEFINEDCODE(workOrderActivityCheckList.getFinding());
                break;
            }
            case "08": {
                workOrderActivityCheckListInfor.setGOOD(getStringBool.apply("GOOD"));
                workOrderActivityCheckListInfor.setPOOR(getStringBool.apply("POOR"));
                break;
            }
            case "10": {
                this.tools.getDataTypeTools();
                workOrderActivityCheckListInfor.setRESULTVALUE(DataTypeTools.encodeQuantity(workOrderActivityCheckList.getNumericValue(), "Checklists Value"));
            }
            case "09": {
                workOrderActivityCheckListInfor.setOKFLAG(getStringBool.apply("OK"));
                workOrderActivityCheckListInfor.setADJUSTED(getStringBool.apply("ADJUSTED"));
                break;
            }
            case "12": {
                this.tools.getDataTypeTools();
                workOrderActivityCheckListInfor.setRESULTVALUE(DataTypeTools.encodeQuantity(workOrderActivityCheckList.getNumericValue(), "Checklists Value"));
            }
            case "11": {
                workOrderActivityCheckListInfor.setOKFLAG(getStringBool.apply("OK"));
                workOrderActivityCheckListInfor.setNONCONFORMITYFLAG(getStringBool.apply("NONCONFORMITY"));
            }
        }
        if (workOrderActivityCheckList.getNotes() != null) {
            workOrderActivityCheckListInfor.setNOTES(workOrderActivityCheckList.getNotes());
        }
        MP7913_SyncWorkOrderActivityCheckList_001 syncwoactchl = new MP7913_SyncWorkOrderActivityCheckList_001();
        syncwoactchl.setWorkOrderActivityCheckList(workOrderActivityCheckListInfor);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncWorkOrderActivityCheckListOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncwoactchl);
        return null;
    }

    @Override
    public String createTaskplanChecklist(InforContext context, TaskplanCheckList taskChecklist) throws InforException {
        TaskChecklist taskChecklistInfor = new TaskChecklist();
        taskChecklistInfor.setTASKLISTID(new TASKLISTID_Type());
        taskChecklistInfor.getTASKLISTID().setORGANIZATIONID(this.tools.getOrganization(context));
        taskChecklistInfor.getTASKLISTID().setTASKCODE(taskChecklist.getTaskPlanCode());
        if (taskChecklist.getTaskPlanRevision() == null) {
            taskChecklistInfor.getTASKLISTID().setTASKREVISION(Long.valueOf(0L));
        } else {
            taskChecklistInfor.getTASKLISTID().setTASKREVISION(Long.valueOf(this.tools.getDataTypeTools().encodeLong(taskChecklist.getTaskPlanRevision(), "Task Revision")));
        }
        taskChecklistInfor.setCHECKLISTID(new CHECKLISTID_Type());
        taskChecklistInfor.getCHECKLISTID().setCHECKLISTCODE("0");
        taskChecklistInfor.getCHECKLISTID().setDESCRIPTION(taskChecklist.getChecklistDesc());
        taskChecklistInfor.setSEQUENCE(this.tools.getDataTypeTools().encodeLong(taskChecklist.getSequence(), "Sequence number"));
        taskChecklistInfor.setTYPE(new TYPE_Type());
        taskChecklistInfor.getTYPE().setTYPECODE(taskChecklist.getType());
        taskChecklistInfor.setREQUIREDTOCLOSEDOC(new USERDEFINEDCODEID_Type());
        taskChecklistInfor.getREQUIREDTOCLOSEDOC().setUSERDEFINEDCODE(taskChecklist.getRequiredEntry());
        taskChecklistInfor.setEQUIPMENTLEVEL(new USERDEFINEDCODEID_Type());
        taskChecklistInfor.getEQUIPMENTLEVEL().setUSERDEFINEDCODE(taskChecklist.getEquipmentLevel());
        if (taskChecklist.getFindings() != null) {
            taskChecklistInfor.setPOSSIBLEFINDINGS(taskChecklist.getFindings());
        }
        if (taskChecklist.getUOM() != null) {
            taskChecklistInfor.setUOMID(new UOMID_Type());
            taskChecklistInfor.getUOMID().setUOMCODE(taskChecklist.getUOM());
        }
        if (taskChecklist.getAspectCode() != null) {
            taskChecklistInfor.setASPECTID(new ASPECTID_Type());
            taskChecklistInfor.getASPECTID().setASPECTCODE(taskChecklist.getAspectCode());
        }
        if (taskChecklist.getPointType() != null) {
            taskChecklistInfor.setPOINTTYPEID(new POINTTYPEID_Type());
            taskChecklistInfor.getPOINTTYPEID().setPOINTTYPECODE(taskChecklist.getPointType());
        }
        taskChecklistInfor.setREPEATINGOCCURRENCES(taskChecklist.getRepeatingOccurrences());
        if (taskChecklist.getFollowUpTaskPlan() != null) {
            taskChecklistInfor.setFOLLOWUPTASKID(new TASKLISTID_Type());
            taskChecklistInfor.getFOLLOWUPTASKID().setORGANIZATIONID(this.tools.getOrganization(context));
            taskChecklistInfor.getFOLLOWUPTASKID().setTASKCODE(taskChecklist.getFollowUpTaskPlan());
            if (taskChecklist.getFollowUpTaskPlanRevision() != null) {
                taskChecklistInfor.getFOLLOWUPTASKID().setTASKREVISION(Long.valueOf(this.tools.getDataTypeTools().encodeLong(taskChecklist.getFollowUpTaskPlanRevision(), "Follow Up Task Plan Revision")));
            } else {
                taskChecklistInfor.getFOLLOWUPTASKID().setTASKREVISION(Long.valueOf(0L));
            }
        }
        if (taskChecklist.getClassCode() != null && !taskChecklist.getClassCode().trim().equals("")) {
            taskChecklistInfor.setCLASSID(new CLASSID_Type());
            taskChecklistInfor.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
            taskChecklistInfor.getCLASSID().setCLASSCODE(taskChecklist.getClassCode());
        }
        if (taskChecklist.getCategoryCode() != null && !taskChecklist.getCategoryCode().trim().equals("")) {
            taskChecklistInfor.setCATEGORYID(new CATEGORYID());
            taskChecklistInfor.getCATEGORYID().setCATEGORYCODE(taskChecklist.getCategoryCode());
        }
        MP7916_AddTaskChecklist_001 addTaskChecklist = new MP7916_AddTaskChecklist_001();
        addTaskChecklist.setTaskChecklist(taskChecklistInfor);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addTaskChecklistOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addTaskChecklist);
        return "OK";
    }

    @Override
    public WorkOrderActivityCheckList[] readWorkOrderChecklists(InforContext context, Activity activity) throws InforException {
        GridRequest gridRequest = new GridRequest("3315", "WSJOBS_ACK", "3369");
        gridRequest.setRowCount(1000);
        gridRequest.setUseNative(false);
        gridRequest.getParams().put("param.workordernum", activity.getWorkOrderNumber());
        gridRequest.getParams().put("param.activity", activity.getActivityCode());
        gridRequest.getParams().put("param.jobseq", "0");
        GridRequestResult gridRequestResult = this.gridsService.executeQuery(context, gridRequest);
        LinkedList<WorkOrderActivityCheckList> checklists = new LinkedList<WorkOrderActivityCheckList>();
        for (GridRequestRow row : gridRequestResult.getRows()) {
            checklists.add(this.getCheckList(row, activity));
        }
        return checklists.toArray(new WorkOrderActivityCheckList[0]);
    }

    private WorkOrderActivityCheckList getCheckList(GridRequestRow row, Activity activity) throws InforException {
        String required;
        WorkOrderActivityCheckList checklist = new WorkOrderActivityCheckList();
        checklist.setWorkOrderCode(activity.getWorkOrderNumber());
        checklist.setActivityCode(activity.getActivityCode());
        checklist.setCheckListCode(GridTools.getCellContent("checklistcode", row));
        checklist.setSequence(GridTools.getCellContent("checklistsequence", row));
        checklist.setEquipmentCode(GridTools.getCellContent("equipment", row));
        checklist.setEquipmentDesc(GridTools.getCellContent("equipmentdesc", row));
        checklist.setType(GridTools.getCellContent("checklisttype", row));
        checklist.setFollowUp(DataTypeTools.decodeBoolean(GridTools.getCellContent("followup", row)));
        String followUpWorkOrderActivity = GridTools.getCellContent("followupwoactivity", row);
        this.tools.getDataTypeTools();
        if (DataTypeTools.isNotEmpty(followUpWorkOrderActivity)) {
            checklist.setFollowUpWorkOrder(followUpWorkOrderActivity.split("-")[0]);
        }
        if ("Yes".equals(required = GridTools.getCellContent("requiredtoclosedocument", row))) {
            checklist.setRequiredToClose(true);
        } else {
            checklist.setRequiredToClose(false);
        }
        checklist.setNotes(GridTools.getCellContent("notes", row));
        checklist.setDesc(GridTools.getCellContent("checklistdescription", row));
        checklist.setHideFollowUp(this.cellEquals(row, "hidefollowup", "true"));
        switch (checklist.getType()) {
            case "01": {
                if (this.cellEquals(row, "completed", "true")) {
                    checklist.setResult("COMPLETED");
                    break;
                }
                checklist.setResult(WorkOrderActivityCheckList.ReturnType.NULL);
                break;
            }
            case "02": {
                if (this.cellEquals(row, "yes", "true")) {
                    checklist.setResult("YES");
                    break;
                }
                if (this.cellEquals(row, "no", "true")) {
                    checklist.setResult("NO");
                    break;
                }
                checklist.setResult(null);
                break;
            }
            case "03": {
                checklist.setFinding(GridTools.getCellContent("finding", row));
                checklist.setPossibleFindings(this.getPossibleFindings(row));
                break;
            }
            case "06": {
                checklist.setFinding(GridTools.getCellContent("finding", row));
                checklist.setPossibleFindings(this.getPossibleFindings(row));
            }
            case "04": 
            case "05": {
                checklist.setNumericValue(DataTypeTools.encodeBigDecimal(GridTools.getCellContent("value", row), ""));
                checklist.setUOM(GridTools.getCellContent("uom", row));
                checklist.setResult(GridTools.getCellContent("value", row));
                break;
            }
            case "08": {
                if (this.cellEquals(row, "good", "true")) {
                    checklist.setResult("GOOD");
                    break;
                }
                if (this.cellEquals(row, "poor", "true")) {
                    checklist.setResult("POOR");
                    break;
                }
                checklist.setResult(WorkOrderActivityCheckList.ReturnType.NULL);
                break;
            }
            case "12": {
                checklist.setNumericValue(DataTypeTools.encodeBigDecimal(GridTools.getCellContent("value", row), ""));
                checklist.setUOM(GridTools.getCellContent("uom", row));
            }
            case "11": {
                if (this.cellEquals(row, "ok", "true")) {
                    checklist.setResult("OK");
                    break;
                }
                if (this.cellEquals(row, "nonconformityfound", "true")) {
                    checklist.setResult("NONCONFORMITY");
                    break;
                }
                checklist.setResult(WorkOrderActivityCheckList.ReturnType.NULL);
                break;
            }
            case "10": {
                checklist.setNumericValue(DataTypeTools.encodeBigDecimal(GridTools.getCellContent("value", row), ""));
                checklist.setUOM(GridTools.getCellContent("uom", row));
            }
            case "09": {
                if (this.cellEquals(row, "ok", "true")) {
                    checklist.setResult("OK");
                    break;
                }
                if (this.cellEquals(row, "adjusted", "true")) {
                    checklist.setResult("ADJUSTED");
                    break;
                }
                checklist.setResult(WorkOrderActivityCheckList.ReturnType.NULL);
                break;
            }
            case "07": {
                checklist.setFinding(GridTools.getCellContent("resolution", row));
                if (this.cellEquals(row, "ok", "true")) {
                    checklist.setResult("OK");
                    break;
                }
                if (this.cellEquals(row, "repairsneeded", "true")) {
                    checklist.setResult("REPAIRSNEEDED");
                    break;
                }
                checklist.setResult(WorkOrderActivityCheckList.ReturnType.NULL);
            }
        }
        return checklist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Finding[] getPossibleFindings(GridRequestRow row) {
        String[] possibleFindings = GridTools.getCellContent("possiblefindings", row).split(",");
        LinkedList<Finding> findings = new LinkedList<Finding>();
        if (this.tools.isDatabaseConnectionConfigured()) {
            for (String findingCode : possibleFindings) {
                try (EntityManager em = this.tools.getEntityManager();){
                    Finding findingTemp = (Finding)em.find(Finding.class, (Object)findingCode);
                    findings.add(findingTemp);
                }
            }
        }
        return findings.toArray(new Finding[findings.size()]);
    }

    private boolean cellEquals(GridRequestRow row, String key, String value) {
        return GridTools.getCellContent(key, row) != null && GridTools.getCellContent(key, row).equals(value);
    }

    private String getValue(ResultSet v_result) throws SQLException {
        Double value = v_result.getDouble("ack_value");
        if (v_result.wasNull()) {
            return null;
        }
        return Double.toString(value);
    }

    @Override
    public Long createFollowUpWorkOrders(InforContext context, Activity activity) throws InforException {
        Long activityNumber;
        MP8000_CreateFollowUpWorkOrder_001 createFUWO = new MP8000_CreateFollowUpWorkOrder_001();
        try {
            activityNumber = Long.valueOf(activity.getActivityCode());
        }
        catch (Exception e) {
            throw new InforException("Activity code '" + activity.getActivityCode() + "' is not a valid number.", e.getCause(), null);
        }
        createFUWO.setACTIVITYID(new ACTIVITYID());
        createFUWO.getACTIVITYID().setWORKORDERID(new WOID_Type());
        createFUWO.getACTIVITYID().getWORKORDERID().setJOBNUM(activity.getWorkOrderNumber());
        createFUWO.getACTIVITYID().setACTIVITYCODE(new ACTIVITYCODE());
        createFUWO.getACTIVITYID().getACTIVITYCODE().setValue(activityNumber.longValue());
        createFUWO.getACTIVITYID().getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        MP8000_CreateFollowUpWorkOrder_001_Result createFUWOResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).createFollowUpWorkOrderOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), createFUWO);
        return createFUWOResult.getResultData().getWORKORDERCOUNT();
    }
}

