/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.administration.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.administration.UserSetupService;
import ch.cern.eam.wshub.core.services.administration.entities.EAMUser;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.impl.GridsServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_entities.usersetup_001.UserSetup;
import net.datastream.schemas.mp_fields.USERID_Type;
import net.datastream.schemas.mp_functions.SessionType;
import net.datastream.schemas.mp_functions.mp0601_001.MP0601_GetUserSetup_001;
import net.datastream.schemas.mp_functions.mp0602_001.MP0602_AddUserSetup_001;
import net.datastream.schemas.mp_functions.mp0603_001.MP0603_SyncUserSetup_001;
import net.datastream.schemas.mp_functions.mp0604_001.MP0604_DeleteUserSetup_001;
import net.datastream.schemas.mp_functions.mp9532_001.MP9532_RunEmptyOp_001;
import net.datastream.schemas.mp_results.mp0601_001.MP0601_GetUserSetup_001_Result;
import net.datastream.schemas.mp_results.mp0602_001.MP0602_AddUserSetup_001_Result;
import net.datastream.schemas.mp_results.mp0603_001.MP0603_SyncUserSetup_001_Result;
import net.datastream.schemas.mp_results.mp9532_001.MP9532_RunEmptyOp_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class UserSetupServiceImpl
implements UserSetupService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private GridsService gridsService;

    public UserSetupServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.gridsService = new GridsServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public String login(InforContext context, String userCode) throws InforException {
        MP9532_RunEmptyOp_001 runEmptyOp = new MP9532_RunEmptyOp_001();
        if (context != null && context.getCredentials() != null) {
            Holder sessionTypeHolder = new Holder();
            MP9532_RunEmptyOp_001_Result result = this.inforws.runEmptyOpOp(runEmptyOp, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "", sessionTypeHolder, null, this.tools.getTenant(context));
            return ((SessionType)sessionTypeHolder.value).getSessionId();
        }
        throw Tools.generateFault("Please supply valid credentials");
    }

    @Override
    public EAMUser readUserSetup(InforContext context, String userCode) throws InforException {
        MP0601_GetUserSetup_001 getUserSetup = new MP0601_GetUserSetup_001();
        getUserSetup.setUSERID(new USERID_Type());
        getUserSetup.getUSERID().setUSERCODE(userCode);
        MP0601_GetUserSetup_001_Result getUserSetupResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getUserSetupOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getUserSetup);
        UserSetup userInfor = getUserSetupResult.getResultData().getUserSetup();
        EAMUser user = this.tools.getInforFieldTools().transformInforObject(new EAMUser(), userInfor);
        GridRequest gridRequest = new GridRequest("WSEMPS", GridRequest.GRIDTYPE.LIST);
        gridRequest.addFilter("associateduser", userCode, "=");
        user.setEmployeeCode(GridTools.extractSingleResultFromGridResult(this.gridsService.executeQuery(context, gridRequest), "employee"));
        return user;
    }

    @Override
    public String createUserSetup(InforContext context, EAMUser userParam) throws InforException {
        UserSetup userInfor = new UserSetup();
        userInfor.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(userInfor.getCLASSID()), userInfor.getUSERDEFINEDAREA(), userParam.getClassCode(), "USER"));
        this.tools.getInforFieldTools().transformWSHubObject(userInfor, userParam, context);
        userInfor.setLANGUAGE("EN");
        this.tools.getDataTypeTools();
        userInfor.setMSGTIMEOUT(DataTypeTools.encodeAmount(BigDecimal.TEN, "Success Msg. Timeout"));
        userInfor.setISCONNECTOR("+");
        MP0602_AddUserSetup_001 addUser = new MP0602_AddUserSetup_001();
        addUser.setUserSetup(userInfor);
        MP0602_AddUserSetup_001_Result result = null;
        result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addUserSetupOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addUser);
        return result.getUSERID().getUSERCODE();
    }

    @Override
    public String updateUserSetup(InforContext context, EAMUser userParam) throws InforException {
        MP0601_GetUserSetup_001_Result getUserSetupResult = null;
        MP0601_GetUserSetup_001 getUserSetup = new MP0601_GetUserSetup_001();
        getUserSetup.setUSERID(new USERID_Type());
        getUserSetup.getUSERID().setUSERCODE(userParam.getUserCode());
        getUserSetupResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getUserSetupOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getUserSetup);
        UserSetup userInfor = getUserSetupResult.getResultData().getUserSetup();
        userInfor.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(userInfor.getCLASSID()), userInfor.getUSERDEFINEDAREA(), userParam.getClassCode(), "USER"));
        this.tools.getInforFieldTools().transformWSHubObject(userInfor, userParam, context);
        MP0603_SyncUserSetup_001 syncUser = new MP0603_SyncUserSetup_001();
        syncUser.setUserSetup(userInfor);
        MP0603_SyncUserSetup_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncUserSetupOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncUser);
        return result.getUSERID().getUSERCODE();
    }

    @Override
    public BatchResponse<String> updateUserSetupBatch(InforContext context, List<EAMUser> eamUsers) throws InforException {
        List callableList = eamUsers.stream().map(eamUser -> () -> this.updateUserSetup(context, (EAMUser)eamUser)).collect(Collectors.toList());
        return this.tools.processCallables(callableList);
    }

    @Override
    public String deleteUserSetup(InforContext context, String userCode) throws InforException {
        MP0604_DeleteUserSetup_001 deleteUser = new MP0604_DeleteUserSetup_001();
        deleteUser.setUSERID(new USERID_Type());
        deleteUser.getUSERID().setUSERCODE(userCode);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteUserSetupOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteUser);
        return "success";
    }
}

