/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.material.PartService;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import net.datastream.schemas.mp_entities.part_001.Part;
import net.datastream.schemas.mp_fields.PARTID_Type;
import net.datastream.schemas.mp_functions.mp0240_001.MP0240_AddPart_001;
import net.datastream.schemas.mp_functions.mp0241_001.MP0241_GetPart_001;
import net.datastream.schemas.mp_functions.mp0242_001.MP0242_SyncPart_001;
import net.datastream.schemas.mp_functions.mp0243_001.MP0243_DeletePart_001;
import net.datastream.schemas.mp_functions.mp2072_001.ChangePartNumber;
import net.datastream.schemas.mp_functions.mp2072_001.MP2072_ChangePartNumber_001;
import net.datastream.schemas.mp_results.mp0240_001.MP0240_AddPart_001_Result;
import net.datastream.schemas.mp_results.mp0241_001.MP0241_GetPart_001_Result;
import net.datastream.schemas.mp_results.mp0242_001.MP0242_SyncPart_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class PartServiceImpl
implements PartService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public PartServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public ch.cern.eam.wshub.core.services.material.entities.Part readPart(InforContext context, String partCode) throws InforException {
        return this.tools.getInforFieldTools().transformInforObject(new ch.cern.eam.wshub.core.services.material.entities.Part(), this.readPartInfor(context, partCode));
    }

    private Part readPartInfor(InforContext context, String partCode) throws InforException {
        MP0241_GetPart_001 getPart = new MP0241_GetPart_001();
        getPart.setPARTID(new PARTID_Type());
        getPart.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
        getPart.getPARTID().setPARTCODE(partCode);
        MP0241_GetPart_001_Result getPartResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getPartOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getPart);
        return getPartResult.getResultData().getPart();
    }

    @Override
    public String createPart(InforContext context, ch.cern.eam.wshub.core.services.material.entities.Part partParam) throws InforException {
        Part inforPart = new Part();
        inforPart.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(inforPart.getCLASSID()), inforPart.getUSERDEFINEDAREA(), partParam.getClassCode(), "PART"));
        this.tools.getInforFieldTools().transformWSHubObject(inforPart, partParam, context);
        MP0240_AddPart_001 addPart = new MP0240_AddPart_001();
        addPart.setPart(inforPart);
        MP0240_AddPart_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addPartOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addPart);
        return result.getPARTID().getPARTCODE();
    }

    @Override
    public String updatePart(InforContext context, ch.cern.eam.wshub.core.services.material.entities.Part partParam) throws InforException {
        if (partParam.getNewCode() != null && !partParam.getNewCode().trim().equals("")) {
            MP2072_ChangePartNumber_001 changePartNumber = new MP2072_ChangePartNumber_001();
            changePartNumber.setChangePartNumber(new ChangePartNumber());
            changePartNumber.getChangePartNumber().setOLDPARTID(new PARTID_Type());
            changePartNumber.getChangePartNumber().getOLDPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            changePartNumber.getChangePartNumber().getOLDPARTID().setPARTCODE(partParam.getCode());
            changePartNumber.getChangePartNumber().setNEWPARTID(new PARTID_Type());
            changePartNumber.getChangePartNumber().getNEWPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            changePartNumber.getChangePartNumber().getNEWPARTID().setPARTCODE(partParam.getNewCode());
            this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).changePartNumberOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), changePartNumber);
            partParam.setCode(partParam.getNewCode());
        }
        Part inforPart = this.readPartInfor(context, partParam.getCode());
        inforPart.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(inforPart.getCLASSID()), inforPart.getUSERDEFINEDAREA(), partParam.getClassCode(), "PART"));
        this.tools.getInforFieldTools().transformWSHubObject(inforPart, partParam, context);
        MP0242_SyncPart_001 syncPart = new MP0242_SyncPart_001();
        syncPart.setPart(inforPart);
        MP0242_SyncPart_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncPartOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncPart);
        return result.getResultData().getPart().getPARTID().getPARTCODE();
    }

    @Override
    public String deletePart(InforContext context, String partCode) throws InforException {
        MP0243_DeletePart_001 deletePart = new MP0243_DeletePart_001();
        deletePart.setPARTID(new PARTID_Type());
        deletePart.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
        deletePart.getPARTID().setPARTCODE(partCode);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deletePartOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deletePart);
        return partCode;
    }
}

