/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.grids.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.entities.Credentials;
import ch.cern.eam.wshub.core.services.grids.customfields.GridCustomFieldHandler;
import ch.cern.eam.wshub.core.services.grids.entities.DataspyField;
import ch.cern.eam.wshub.core.services.grids.entities.GridDDSpyFieldsResult;
import ch.cern.eam.wshub.core.services.grids.entities.GridDataspy;
import ch.cern.eam.wshub.core.services.grids.entities.GridField;
import ch.cern.eam.wshub.core.services.grids.entities.GridMetadataRequestResult;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestCell;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestFilter;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestResult;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestRow;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestSort;
import ch.cern.eam.wshub.core.services.grids.exceptions.IncorrectParenthesesGridFilterException;
import ch.cern.eam.wshub.core.services.grids.exceptions.IncorrectSortTypeException;
import ch.cern.eam.wshub.core.services.grids.exceptions.MissingJoinerGridFilterException;
import ch.cern.eam.wshub.core.services.grids.impl.DataField;
import ch.cern.eam.wshub.core.services.grids.impl.DataType;
import ch.cern.eam.wshub.core.services.grids.impl.InstallParametersManager;
import ch.cern.eam.wshub.core.services.grids.impl.JPAFieldDataConverter;
import ch.cern.eam.wshub.core.services.grids.impl.JPATypes;
import ch.cern.eam.wshub.core.services.grids.impl.Operator;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.QueryTimeoutException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.datastream.wsdls.inforws.InforWebServicesPT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class JPAGrids
implements Serializable {
    private static final long serialVersionUID = -7463612088169746465L;
    private static String QUERY_TIMEOUT_DEFAULT_VALUE = "15000";
    public static Boolean USE_CUSTOM_FIELDS = false;
    private InstallParametersManager paramManager;
    private GridCustomFieldHandler gridCustomFieldHandler;
    private ApplicationData applicationData;
    private Tools tools;
    private InforWebServicesPT inforws;

    public JPAGrids(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.paramManager = new InstallParametersManager(tools);
        this.gridCustomFieldHandler = new GridCustomFieldHandler(tools);
    }

    /*
     * WARNING - void declaration
     */
    public GridRequestResult executeQuery(InforContext context, GridRequest gridRequest) throws InforException {
        Integer cursorPosition;
        Integer rowCount;
        String queryTimeout = QUERY_TIMEOUT_DEFAULT_VALUE;
        if (gridRequest.getQueryTimeout().booleanValue()) {
            if (gridRequest.getQueryTimeoutWaitingTime() != null) {
                queryTimeout = gridRequest.getQueryTimeoutWaitingTime().toString();
            } else {
                String queryTimeoutO = this.applicationData.getQueryTimeout();
                if (queryTimeoutO != null) {
                    queryTimeout = queryTimeout.toString();
                }
            }
        }
        if (gridRequest.getGridID() == null || gridRequest.getGridName() == null || gridRequest.getDataspyID() == null) {
            throw Tools.generateFault("Please supply grid name and grid id and dataSpy id.");
        }
        BigInteger gridID = new BigInteger(gridRequest.getGridID().trim());
        String gridName = gridRequest.getGridName();
        BigInteger dataSpyID = new BigInteger(gridRequest.getDataspyID());
        if (gridRequest.getRowCount() != null && gridRequest.getCursorPosition() != null) {
            rowCount = new Integer(gridRequest.getRowCount());
            if (rowCount <= 0) {
                throw Tools.generateFault("Please supply row count > 0");
            }
            cursorPosition = new Integer(gridRequest.getCursorPosition()) - 1;
            if (cursorPosition < 0) {
                throw Tools.generateFault("Please supply cursor position >= 1");
            }
        } else {
            throw Tools.generateFault("Please supply row count and cursor position.");
        }
        EntityManager em = this.tools.getEntityManager();
        try {
            String sqlStatementWhere;
            HashMap<String, DataField> tagNames = new HashMap<String, DataField>();
            Object userfunctionValue = gridRequest.getParams().get("userfunction");
            List selectFields = em.createNamedQuery("GridDataspy.GETGRIDFIELDSANDSTATEMENT").setParameter("gridID", (Object)gridID).setParameter("userfunction", (Object)(userfunctionValue == null ? gridName : userfunctionValue.toString())).getResultList();
            if (selectFields == null) {
                throw Tools.generateFault("Couldn't fetch data for this grid. No select fields found. Verify Grid Type or other parameters.");
            }
            for (Object[] o : selectFields) {
                String tagName = ((String)o[0]).trim();
                String selectColumn = ((String)o[1]).trim();
                String tagDataType = ((String)o[2]).trim();
                String uppercase = (String)o[3] != null ? ((String)o[3]).trim() : "";
                selectColumn = this.replaceParamPrefix(selectColumn);
                Boolean isUppercase = "uppercase".equals(uppercase);
                DataField dataField = new DataField(tagName, selectColumn, DataType.valueOf(tagDataType), isUppercase);
                tagNames.put(tagName, dataField);
            }
            if (USE_CUSTOM_FIELDS.booleanValue()) {
                tagNames.putAll(this.gridCustomFieldHandler.getCustomFieldsForGrid(gridRequest.getGridID()));
            }
            List<String> sqlStatements = em.createNamedQuery("GridDataspy.GETGRIDDATASPYSELECTSTATEMENT").setParameter("requestType", (Object)gridRequest.getGridType().toString()).setParameter("gridID", (Object)gridID).setParameter("dataSpyID", (Object)dataSpyID).getResultList();
            if (USE_CUSTOM_FIELDS.booleanValue()) {
                this.gridCustomFieldHandler.initializeForDataspy(gridRequest.getDataspyID());
                sqlStatements = this.gridCustomFieldHandler.attachCustomFields(sqlStatements);
            }
            String sqlStatementSelect = "select " + sqlStatements.stream().collect(Collectors.joining(","));
            sqlStatementSelect = this.replaceParamPrefix(sqlStatementSelect);
            String sqlStatementFW = (String)em.createNamedQuery("GridDataspy.GETGRIDDATASPYQUERY").setParameter("gridID", (Object)gridID).setParameter("dataSpyID", (Object)dataSpyID).getSingleResult();
            int i = (sqlStatementFW = this.replaceParamPrefix(sqlStatementFW)).toLowerCase().indexOf("where");
            if (i == -1) {
                i = sqlStatementFW.length();
            }
            String[] sqlStatementO = new String[]{sqlStatementFW.substring(0, i), sqlStatementFW.substring(i)};
            String sqlStatementFrom = sqlStatementO[0];
            if (USE_CUSTOM_FIELDS.booleanValue()) {
                sqlStatementFrom = this.gridCustomFieldHandler.addCustomFieldsJoinClause(sqlStatementFrom);
            }
            if ((i = (sqlStatementWhere = sqlStatementO[1]).toLowerCase().lastIndexOf("order by")) == -1) {
                i = sqlStatementWhere.length();
            }
            String[] sqlStatementOR = new String[]{sqlStatementWhere.substring(0, i), sqlStatementWhere.substring(i)};
            sqlStatementWhere = sqlStatementOR[0];
            String sqlStatementOrderBy = "";
            if (sqlStatementOR.length > 1 && !sqlStatementOR[1].isEmpty()) {
                sqlStatementOrderBy = sqlStatementOR[1];
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            gridRequest.getParams().forEach((key, value) -> {
                if (key.startsWith("param.")) {
                    params.put(key.substring(6), value);
                } else {
                    params.put((String)key, value);
                }
            });
            List gridListOfSortAndFilters = em.createNamedQuery("GridDataspy.GETGRIDDDSFILTER_AND_SORT_STRXML").setParameter("dataspyid", (Object)dataSpyID).setParameter("userid", (Object)context.getCredentials().getUsername()).setParameter("userfunction", (Object)(userfunctionValue == null ? gridName : userfunctionValue.toString())).getResultList();
            if (gridListOfSortAndFilters == null) {
                throw Tools.generateFault("Couldn't fetch data for this grid. No filter or sorting parameters found.");
            }
            ArrayList<GridRequestFilter> dataspyFiltersArr = new ArrayList<GridRequestFilter>();
            ArrayList<GridRequestSort> dataspySortArr = new ArrayList<GridRequestSort>();
            for (Object[] objectArray : gridListOfSortAndFilters) {
                Element el;
                Node nNode;
                int n;
                NodeList nl;
                Document doc;
                if (objectArray[0] != null) {
                    String filterResult = ((String)objectArray[0]).trim();
                    doc = JPAGrids.loadXMLFromString(filterResult);
                    doc.getDocumentElement().normalize();
                    nl = doc.getElementsByTagName("FILTER_ELEMENT");
                    for (n = 0; n < nl.getLength(); ++n) {
                        GridRequestFilter filter;
                        nNode = nl.item(n);
                        if (nNode.getNodeType() != 1) continue;
                        el = (Element)nNode;
                        String joiner = el.getAttribute("JOINER");
                        GridRequestFilter.JOINER gridJoiner = GridRequestFilter.JOINER.OR;
                        if (joiner != null && joiner.equals("AND")) {
                            gridJoiner = GridRequestFilter.JOINER.AND;
                        }
                        if (tagNames.get((filter = new GridRequestFilter(el.getAttribute("ALIAS_NAME"), el.getAttribute("VALUE"), el.getAttribute("OPERATOR"), gridJoiner, "true".equalsIgnoreCase(el.getAttribute("LPAREN")), "true".equalsIgnoreCase(el.getAttribute("RPAREN")))).getFieldName()) == null) continue;
                        dataspyFiltersArr.add(filter);
                    }
                }
                if (!dataspyFiltersArr.isEmpty()) {
                    String filterString = "";
                    filterString = this.createFilterSQLStatement(dataspyFiltersArr, tagNames, params, "D");
                    if (!filterString.isEmpty()) {
                        sqlStatementWhere = sqlStatementWhere + " AND (" + filterString + ")";
                    }
                    dataspyFiltersArr = new ArrayList();
                }
                if (gridRequest.getGridRequestSorts() != null && gridRequest.getGridRequestSorts().length > 0) {
                    dataspySortArr.addAll(new ArrayList<GridRequestSort>(Arrays.asList(gridRequest.getGridRequestSorts())));
                } else if (objectArray[1] != null) {
                    String sortResult = ((String)objectArray[1]).trim();
                    doc = JPAGrids.loadXMLFromString(sortResult);
                    doc.getDocumentElement().normalize();
                    nl = doc.getElementsByTagName("SORT_ELEMENT");
                    for (n = 0; n < nl.getLength(); ++n) {
                        nNode = nl.item(n);
                        if (nNode.getNodeType() != 1) continue;
                        el = (Element)nNode;
                        GridRequestSort sort = new GridRequestSort(el.getAttribute("ALIAS_NAME"), el.getAttribute("TYPE"));
                        dataspySortArr.add(sort);
                    }
                }
                this.removeDuplicates(dataspySortArr);
            }
            if (USE_CUSTOM_FIELDS.booleanValue()) {
                sqlStatementWhere = sqlStatementWhere + this.gridCustomFieldHandler.getCustomFieldJoinConditions();
            }
            if (gridRequest.getGridRequestFilters() != null && gridRequest.getGridRequestFilters().size() > 0) {
                String filterString = "";
                filterString = this.createFilterSQLStatement(gridRequest.getGridRequestFilters(), tagNames, params, "U");
                if (!filterString.isEmpty()) {
                    sqlStatementWhere = sqlStatementWhere + " AND (" + filterString + ")";
                }
            }
            if (gridRequest.getDepartmentSecurityGridColumn() != null) {
                Iterator<GridRequestSort> deptSecCol = gridRequest.getDepartmentSecurityGridColumn();
                if (!sqlStatementWhere.isEmpty()) {
                    sqlStatementWhere = sqlStatementWhere + " AND ";
                }
                sqlStatementWhere = sqlStatementWhere + "(:deptsec = 'OFF' OR EXISTS (SELECT 1 FROM r5departmentsecurity WHERE dse_user =:r5user AND dse_mrc = " + deptSecCol + "))";
            }
            sqlStatementWhere = this.replaceParamPrefix(sqlStatementWhere);
            for (Map.Entry entry : params.entrySet()) {
                String keyWithoutSuffix = ((String)entry.getKey()).replaceAll("(U|D)\\d*$", "");
                if (!(entry.getValue() instanceof List)) continue;
                List nList = (List)entry.getValue();
                nList.replaceAll(String::toUpperCase);
            }
            for (GridRequestSort gridRequestSort : dataspySortArr) {
                String so = Arrays.asList("DESC", "ASC").stream().filter(str -> sort.getSortType() != null && str.equals(sort.getSortType().toUpperCase())).findFirst().orElseThrow(IncorrectSortTypeException::new);
                if (tagNames.get(gridRequestSort.getSortBy()) == null) continue;
                if (sqlStatementOrderBy.length() > 0) {
                    sqlStatementOrderBy = sqlStatementOrderBy + "," + ((DataField)tagNames.get(gridRequestSort.getSortBy())).getSourcename() + " " + so;
                    continue;
                }
                sqlStatementOrderBy = " order by " + ((DataField)tagNames.get(gridRequestSort.getSortBy())).getSourcename() + " " + so;
            }
            GridRequestResult grr = new GridRequestResult();
            Integer n = 0;
            if (!gridRequest.getFetchAllResults().booleanValue()) {
                Integer wsgridsz = Integer.parseInt(this.paramManager.getParams().get("WSGRIDSZ"));
                if (rowCount > wsgridsz) {
                    rowCount = wsgridsz;
                }
                if (gridRequest.getCountTotal().booleanValue()) {
                    Integer maxRecord = ((cursorPosition + rowCount + 1) / wsgridsz + 1) * wsgridsz;
                    String sqlStatement = "select count(1) " + sqlStatementFrom + sqlStatementWhere + " and rownum <= " + (maxRecord + 1);
                    sqlStatement = this.filterOutNULLValues(sqlStatement, params);
                    Query q = em.createNativeQuery(sqlStatement);
                    this.defineParameters(gridName, sqlStatement, q, context.getCredentials(), params, gridRequest.getLang());
                    Date d1 = new Date();
                    Number number = (Number)q.getSingleResult();
                    Date d2 = new Date();
                    this.tools.log(Level.FINE, "TOTAL COUNT INFO in " + (d2.getTime() - d1.getTime()) + ":\n" + sqlStatement + "\n" + params);
                    if (number.longValue() > (long)maxRecord.intValue()) {
                        Integer n2 = maxRecord;
                        grr.setRecords(((Object)n2).toString() + "+");
                    } else {
                        grr.setRecords(number.toString());
                    }
                }
            }
            String rownumString = "";
            if (gridRequest.getCountTotal().booleanValue()) {
                rownumString = ", rownum rn";
            }
            if (sqlStatementOrderBy.length() > 0) {
                rownumString = ", row_number() over (" + sqlStatementOrderBy + ") rn";
            }
            String sqlStatement = sqlStatementSelect + rownumString + " " + sqlStatementFrom + sqlStatementWhere + sqlStatementOrderBy;
            JPATypes jpaType = JPATypes.JPA_FINAL;
            if (gridRequest.getJPAType() != null) {
                jpaType = JPATypes.valueOf(gridRequest.getJPAType());
            }
            switch (jpaType) {
                default: 
            }
            String paginationQueryBeg = "";
            String paginationQueryEnd = "";
            if (!gridRequest.getFetchAllResults().booleanValue()) {
                paginationQueryBeg = "SELECT * FROM ( SELECT a.*, ROWNUM rnum FROM ( ";
                paginationQueryEnd = " ) a WHERE ROWNUM <= :MAX_ROW ) WHERE rnum > :MIN_ROW";
                params.put("MIN_ROW", cursorPosition);
                int maxRow = gridRequest.getCountTotal() != false ? cursorPosition + rowCount : cursorPosition + rowCount + 1;
                params.put("MAX_ROW", maxRow);
            }
            sqlStatement = paginationQueryBeg + sqlStatement + paginationQueryEnd;
            sqlStatement = this.filterOutNULLValues(sqlStatement, params);
            Query q = em.createNativeQuery(sqlStatement);
            if (gridRequest.getQueryTimeout().booleanValue()) {
                q.setHint("javax.persistence.query.timeout", (Object)queryTimeout.toString());
            }
            this.defineParameters(gridName, sqlStatement, q, context.getCredentials(), params, gridRequest.getLang());
            Date d1 = new Date();
            this.tools.log(Level.FINE, "EXECUTING STATEMENT:\n" + sqlStatement + "\n" + params + "\n");
            List qResult = q.getResultList();
            Date d2 = new Date();
            this.tools.log(Level.FINE, "RESULT DATA in " + (d2.getTime() - d1.getTime()));
            if (!gridRequest.getCountTotal().booleanValue()) {
                Long totalCount;
                Integer n3 = qResult.size();
                if (!gridRequest.getFetchAllResults().booleanValue() && ((Number)n3).longValue() > (long)rowCount.intValue()) {
                    qResult = qResult.subList(0, qResult.size() - 1);
                    grr.setMoreRowsPresent("TRUE");
                    totalCount = ((Number)n3).longValue() + (long)cursorPosition.intValue() - 1L;
                    grr.setRecords(((Object)totalCount).toString() + "+");
                } else {
                    grr.setMoreRowsPresent("FALSE");
                    totalCount = ((Number)n3).longValue() == 0L ? 0L : ((Number)n3).longValue() + (long)cursorPosition.intValue();
                    grr.setRecords(((Object)totalCount).toString());
                }
            } else {
                void var27_41;
                Long totalNumberOfRecords = var27_41.longValue();
                Number indexOfLastRecord = 0;
                if (qResult.size() > 0) {
                    indexOfLastRecord = (Number)((Object[])qResult.get(qResult.size() - 1))[((Object[])qResult.get(qResult.size() - 1)).length - 1];
                }
                if (((Number)totalNumberOfRecords).longValue() == ((Number)indexOfLastRecord).longValue()) {
                    grr.setMoreRowsPresent("FALSE");
                } else {
                    grr.setMoreRowsPresent("TRUE");
                }
            }
            List fields = em.createNamedQuery("GridField.GETDATASPYFIELDS", DataspyField.class).setParameter("requestType", (Object)gridRequest.getGridType().toString()).setParameter("dataspyid", (Object)gridRequest.getDataspyID()).getResultList();
            Comparator<DataspyField> comparator = Comparator.comparingInt(df -> df.getOrder());
            comparator = comparator.thenComparing(Comparator.comparing(df -> Integer.valueOf(df.getId())));
            fields = fields.stream().sorted(comparator).collect(Collectors.toList());
            if (USE_CUSTOM_FIELDS.booleanValue()) {
                fields.addAll(this.gridCustomFieldHandler.getCustomFieldsAsDataspyFields());
            }
            if (qResult != null && qResult.size() > 0) {
                LinkedList<GridRequestRow> rows = new LinkedList<GridRequestRow>();
                Integer id = 1;
                for (Object[] a : qResult) {
                    List<Object> cells = new ArrayList();
                    int count = 0;
                    for (DataspyField dsf : fields) {
                        String content = JPAFieldDataConverter.getAsString(dsf, a[count]);
                        cells.add(new GridRequestCell(dsf.getId(), content, dsf.getOrder(), dsf.getTagName()));
                        ++count;
                    }
                    cells = cells.stream().sorted((e1, e2) -> Integer.compare(e1.getOrder(), e2.getOrder())).collect(Collectors.toList());
                    GridRequestRow row = new GridRequestRow();
                    Object indexO = a[a.length - 1];
                    String index = indexO == null ? "NULL" : indexO.toString();
                    try {
                        Integer.parseInt(index);
                        row.setId(index);
                    }
                    catch (NumberFormatException ex) {
                        row.setId(id.toString());
                    }
                    row.setCells(cells.toArray(new GridRequestCell[0]));
                    rows.add(row);
                    Integer n4 = id;
                    Integer n5 = id = Integer.valueOf(id + 1);
                }
                grr.setRows(rows.toArray(new GridRequestRow[0]));
            } else {
                grr.setRows(new GridRequestRow[0]);
            }
            GridRequestResult gridRequestResult = grr;
            return gridRequestResult;
        }
        catch (QueryTimeoutException e) {
            this.tools.log(Level.SEVERE, e.getMessage());
            throw Tools.generateFault("Current database operation timeout. Please try again.");
        }
        catch (MissingJoinerGridFilterException e) {
            throw Tools.generateFault("Couldn't fetch data for this grid. Missing joiner in grid filter.");
        }
        catch (IncorrectParenthesesGridFilterException e) {
            throw Tools.generateFault("Couldn't fetch data for this grid. Incorrect parentheses in grid filter.");
        }
        catch (IncorrectSortTypeException e) {
            throw Tools.generateFault("Couldn't fetch data for this grid. Incorrect sort type defined in gridSort.");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.tools.log(Level.SEVERE, "Error whlie executing Grid Query");
            throw Tools.generateFault("Couldn't fetch data for this grid.");
        }
        finally {
            em.clear();
            em.close();
        }
    }

    private String replaceParamPrefix(String inputString) {
        inputString = inputString.replaceAll(":parameter.", ":");
        inputString = inputString.replaceAll(":param.", ":");
        return inputString;
    }

    private String filterOutNULLValues(String sqlStatement, Map<String, Object> params) {
        for (String p : params.keySet()) {
            Object value;
            if (!sqlStatement.contains(":" + p) || (value = params.get(p)) != null) continue;
            sqlStatement = sqlStatement.replaceAll(":" + p, "NULL");
        }
        return sqlStatement;
    }

    private void defineParameters(String gridName, String sqlStatement, Query q, Credentials credentials, Map<String, Object> params, String lang) {
        HashMap<String, String> installParams = this.paramManager.getParams();
        if (sqlStatement.contains(":r5user")) {
            q.setParameter("r5user", (Object)credentials.getUsername().toUpperCase());
        }
        if (sqlStatement.contains(":r5role")) {
            q.setParameter("r5role", (Object)"*");
        }
        if (sqlStatement.contains(":MP5USER")) {
            q.setParameter("MP5USER", (Object)credentials.getUsername().toUpperCase());
        }
        if (sqlStatement.contains(":deptsec")) {
            q.setParameter("deptsec", (Object)installParams.get("DEPTSEC"));
        }
        if (sqlStatement.contains(":storesec")) {
            q.setParameter("storesec", (Object)installParams.get("STORESEC"));
        }
        if (sqlStatement.contains(":language")) {
            q.setParameter("language", (Object)lang);
        }
        if (sqlStatement.contains(":userfunction") && params.get("userfunction") == null) {
            q.setParameter("userfunction", (Object)gridName);
        }
        if (sqlStatement.contains(":syskit2")) {
            q.setParameter("syskit2", (Object)installParams.get("SYSKIT2"));
        }
        if (sqlStatement.contains(":syskit1")) {
            q.setParameter("syskit1", (Object)installParams.get("SYSKIT1"));
        }
        if (sqlStatement.contains(":filternonconformity")) {
            q.setParameter("filternonconformity", (Object)"false");
        }
        if (sqlStatement.contains(":bypassstatuscheck")) {
            q.setParameter("bypassstatuscheck", null);
        }
        if (sqlStatement.contains(":bypassdeptsecurity")) {
            q.setParameter("bypassdeptsecurity", null);
        }
        if (sqlStatement.contains(":excludeparentpart")) {
            q.setParameter("excludeparentpart", (Object)"true");
        }
        for (String p : params.keySet()) {
            if (q.getParameters().stream().filter(par -> par.getName().equals(p)).collect(Collectors.toList()).size() <= 0) continue;
            if (params.get(p) != null && params.get(p) instanceof List && ((List)params.get(p)).size() == 0) {
                q.setParameter(p, (Object)"");
                continue;
            }
            q.setParameter(p, params.get(p));
        }
    }

    private static Document loadXMLFromString(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xml));
        return builder.parse(is);
    }

    private String createFilterSQLStatement(List<GridRequestFilter> filters, Map<String, DataField> tagNames, Map<String, Object> params, String filterType) throws Exception {
        StringBuilder filterString = new StringBuilder();
        int count = 0;
        int filtersLengthMinusOne = filters.size() - 1;
        for (GridRequestFilter filter : filters) {
            String value;
            if (tagNames.get(filter.getFieldName()) == null) continue;
            if (filter.getLeftParenthesis().booleanValue()) {
                filterString.append("(");
            }
            String p = (value = filter.getFieldValue()) != null && value.startsWith(":") ? filter.getFieldValue().substring(1) : filter.getFieldName() + filterType + count;
            Operator op = Operator.fromString(filter.getOperator().toUpperCase());
            DataType fieldDataType = tagNames.get(filter.getFieldName()).getDatatype();
            block0 : switch (fieldDataType) {
                case DATE: 
                case DATETIME: {
                    filterString.append(this.buildSQLStatementForDateTypeOfValue(op, filter, tagNames, p, params));
                    break;
                }
                case DECIMAL: 
                case NUMBER: {
                    filterString.append(this.buildSQLStatementForDecimalTypeOfValue(op, filter, tagNames, p, params));
                    break;
                }
                case CHKBOOLEAN: {
                    String sourcename = tagNames.get(filter.getFieldName()).getSourcename();
                    filterString.append(sourcename).append(" = :").append(p);
                    switch (op) {
                        case SELECTED: {
                            params.put(p, "+");
                            break block0;
                        }
                        case NOT_SELECTED: {
                            params.put(p, "-");
                            break block0;
                        }
                    }
                    params.put(p, "false".equals(filter.getFieldValue()) ? "-" : "+");
                    break;
                }
                default: {
                    String sourcename1 = this.isCaseInsensitive(tagNames, filter) ? "UPPER(" + tagNames.get(filter.getFieldName()).getSourcename() + ")" : tagNames.get(filter.getFieldName()).getSourcename();
                    filterString.append(this.buildSQLStatementForOtherTypeOfValue(op, filter, tagNames, p, params, sourcename1));
                }
            }
            if (filter.getRightParenthesis().booleanValue()) {
                filterString.append(")");
            }
            if (filter.getJoiner() == GridRequestFilter.JOINER.AND) {
                filterString.append(" AND ");
            } else if (filter.getJoiner() == GridRequestFilter.JOINER.OR) {
                filterString.append(" OR ");
            }
            if (filter.getJoiner() == null && count < filtersLengthMinusOne) {
                throw new MissingJoinerGridFilterException();
            }
            ++count;
        }
        if (filterType == "U" && !this.isParenthesisSyntacticallyCorrect(filters)) {
            throw new IncorrectParenthesesGridFilterException();
        }
        if (filterString.length() >= 5 && filterString.subSequence(filterString.length() - 5, filterString.length()).equals(" AND ")) {
            filterString = new StringBuilder(filterString.subSequence(0, filterString.length() - 5).toString());
        } else if (filterString.length() >= 4 && filterString.subSequence(filterString.length() - 4, filterString.length()).equals(" OR ")) {
            filterString = new StringBuilder(filterString.subSequence(0, filterString.length() - 4).toString());
        }
        return filterString.toString();
    }

    private boolean isParenthesisSyntacticallyCorrect(List<GridRequestFilter> filters) {
        int parenthesisCounter = 0;
        for (GridRequestFilter filter : filters) {
            if (filter.getLeftParenthesis() != null && filter.getLeftParenthesis().booleanValue()) {
                ++parenthesisCounter;
            }
            if (filter.getRightParenthesis() != null && filter.getRightParenthesis().booleanValue()) {
                --parenthesisCounter;
            }
            if (parenthesisCounter >= 0) continue;
            return false;
        }
        return parenthesisCounter == 0;
    }

    private String buildSQLStatementForDateTypeOfValue(Operator op, GridRequestFilter filter, Map<String, DataField> tagNames, String p, Map<String, Object> params) {
        String dateWithOneMoreDay;
        String parameter;
        String dateDBFormat;
        String dateFormat;
        String sourcename = tagNames.get(filter.getFieldName()).getSourcename();
        switch (tagNames.get(filter.getFieldName()).getDatatype()) {
            case DATETIME: {
                dateFormat = this.applicationData.getDateTimeFormat();
                dateDBFormat = this.applicationData.getDateTimeDBFormat();
                parameter = this.formatDateToProperPattern(filter, dateFormat, dateDBFormat);
                dateWithOneMoreDay = this.dateIncrementOfOneDay(filter, dateFormat, dateDBFormat);
                dateDBFormat = dateDBFormat.replaceAll("HH:mm", "HH24:mi");
                break;
            }
            default: {
                dateFormat = this.applicationData.getDateFormat();
                dateDBFormat = this.applicationData.getDateDBFormat();
                parameter = this.formatDateToProperPattern(filter, dateFormat, dateDBFormat);
                dateWithOneMoreDay = this.dateIncrementOfOneDay(filter, dateFormat, dateDBFormat);
            }
        }
        dateFormat = ",'" + dateDBFormat + "')";
        String filterString = "";
        switch (op) {
            case LESS_THAN: {
                filterString = filterString + sourcename + " < to_date(:" + p + dateFormat;
                break;
            }
            case GREATER_THAN: {
                filterString = filterString + sourcename + " > to_date(:" + p + dateFormat;
                break;
            }
            case LESS_THAN_EQUALS: {
                filterString = filterString + sourcename + " <= to_date(:" + p + dateFormat;
                break;
            }
            case GREATER_THAN_EQUALS: {
                filterString = filterString + sourcename + " >= to_date(:" + p + dateFormat;
                break;
            }
            case EQUALS: {
                filterString = filterString + sourcename + " >= to_date(:" + p + dateFormat + " AND " + sourcename + " < to_date('" + dateWithOneMoreDay + "'" + dateFormat;
                break;
            }
            case NOT_EQUAL: {
                filterString = filterString + "nvl(trunc(" + sourcename + ",'DD'),to_date('" + dateWithOneMoreDay + "'" + dateFormat + ") != to_date(:" + p + dateFormat;
                break;
            }
            case IS_EMPTY: {
                filterString = filterString + sourcename + " IS NULL";
                break;
            }
            case NOT_EMPTY: {
                filterString = filterString + sourcename + " IS NOT NULL";
                break;
            }
            default: {
                filterString = filterString + sourcename + " " + filter.getOperator() + " :" + p;
            }
        }
        params.put(p, parameter);
        return filterString;
    }

    private String formatDateToProperPattern(GridRequestFilter filter, String dateInputFormat, String dateOutputFormat) {
        Date date = null;
        try {
            date = new SimpleDateFormat(dateInputFormat, Locale.ENGLISH).parse(filter.getFieldValue().toString());
            return new SimpleDateFormat(dateOutputFormat, Locale.ENGLISH).format(date);
        }
        catch (ParseException e) {
            this.tools.log(Level.SEVERE, "Couldn't retrieve given date type");
            this.tools.log(Level.SEVERE, "Error in formatDateToProperPattern dateInputFormat=" + dateInputFormat + " dateOutputFormat=" + dateOutputFormat);
            return filter.getFieldValue().toString();
        }
    }

    private String buildSQLStatementForDecimalTypeOfValue(Operator op, GridRequestFilter filter, Map<String, DataField> tagNames, String p, Map<String, Object> params) {
        Object parameter = filter.getFieldValue();
        String sourcename = tagNames.get(filter.getFieldName()).getSourcename();
        String filterString = "";
        switch (op) {
            case EQUALS: {
                filterString = filterString + sourcename + " = :" + p;
                break;
            }
            case LESS_THAN: {
                filterString = filterString + sourcename + " < :" + p;
                break;
            }
            case GREATER_THAN: {
                filterString = filterString + sourcename + " > :" + p;
                break;
            }
            case LESS_THAN_EQUALS: {
                filterString = filterString + sourcename + " <= :" + p;
                break;
            }
            case GREATER_THAN_EQUALS: {
                filterString = filterString + sourcename + " >= :" + p;
                break;
            }
            case IS_EMPTY: {
                filterString = filterString + sourcename + " IS NULL";
                break;
            }
            case NOT_EMPTY: {
                filterString = filterString + sourcename + " IS NOT NULL";
                break;
            }
            case NOT_EQUAL: {
                filterString = filterString + "nvl(" + sourcename + "," + Float.toString(Float.parseFloat(filter.getFieldValue()) + 1.0f) + ") != :" + p;
                break;
            }
            case IN: {
                StringTokenizer inVars = new StringTokenizer(filter.getFieldValue().trim(), ",");
                ArrayList<String> vars = new ArrayList<String>();
                while (inVars.hasMoreElements()) {
                    String sv = (String)inVars.nextElement();
                    vars.add(sv.substring(1, sv.length() - 1));
                }
                parameter = vars;
                filterString = filterString + sourcename + " " + filter.getOperator() + " (:" + p + ")";
                break;
            }
            default: {
                filterString = filterString + sourcename + " " + filter.getOperator() + " :" + p;
            }
        }
        params.put(p, parameter);
        return filterString;
    }

    private String dateIncrementOfOneDay(GridRequestFilter filter, String dateInputFormat, String dateOutputFormat) {
        Date dt = null;
        String dateWithOneMoreDay = "";
        String dateValue = filter.getFieldValue();
        try {
            dt = new SimpleDateFormat(dateInputFormat, Locale.ENGLISH).parse(dateValue);
            Calendar c = Calendar.getInstance();
            c.setTime(dt);
            c.add(5, 1);
            dt = c.getTime();
            dateWithOneMoreDay = new SimpleDateFormat(dateOutputFormat, Locale.ENGLISH).format(dt);
        }
        catch (ParseException e) {
            this.tools.log(Level.SEVERE, "Couldn't retrieve given date type");
            this.tools.log(Level.SEVERE, "Error in dateIncrementOfOneDay dateInputFormat=" + dateInputFormat + " dateOutputFormat=" + dateOutputFormat);
        }
        return dateWithOneMoreDay;
    }

    private String buildSQLStatementForOtherTypeOfValue(Operator op, GridRequestFilter filter, Map<String, DataField> tagNames, String p, Map<String, Object> params, String sourcename) {
        Object parameter = filter.getFieldValue();
        if (parameter != null && parameter instanceof String) {
            parameter = ((String)parameter).trim();
        }
        String filterString = "";
        String p1 = this.isUppercase(tagNames, filter) || this.isCaseInsensitive(tagNames, filter) ? " UPPER(:" + p + ")" : " :" + p;
        switch (op) {
            case IN: {
                StringTokenizer inVars = new StringTokenizer(filter.getFieldValue().trim(), ",");
                ArrayList<String> vars = new ArrayList<String>();
                while (inVars.hasMoreElements()) {
                    String sv = (String)inVars.nextElement();
                    if (sv.length() > 1 && sv.charAt(0) == '\'') {
                        vars.add(sv.substring(1, sv.length() - 1));
                        continue;
                    }
                    vars.add(sv);
                }
                parameter = vars;
                filterString = filterString + sourcename + " " + filter.getOperator() + " (:" + p + ")";
                break;
            }
            case CONTAINS: {
                parameter = "%" + this.escapeCharacters(parameter) + "%";
                filterString = filterString + sourcename + " LIKE" + p1 + this.buildLIKEEscapeStatement();
                break;
            }
            case NOT_CONTAINS: {
                parameter = "%" + this.escapeCharacters(parameter) + "%";
                filterString = filterString + "( " + sourcename + " NOT LIKE" + p1 + this.buildLIKEEscapeStatement() + " OR " + sourcename + " IS NULL )";
                break;
            }
            case BEGINS: {
                parameter = this.escapeCharacters(parameter) + "%";
                filterString = filterString + sourcename + " LIKE" + p1 + this.buildLIKEEscapeStatement();
                break;
            }
            case ENDS: {
                parameter = "%" + this.escapeCharacters(parameter);
                filterString = filterString + sourcename + " LIKE" + p1 + this.buildLIKEEscapeStatement();
                break;
            }
            case EQUALS: {
                filterString = filterString + sourcename + " = " + p1;
                break;
            }
            case NOT_EQUAL: {
                filterString = filterString + "nvl(" + sourcename + "," + p1 + ") !=" + p1;
                break;
            }
            case IS_EMPTY: {
                filterString = filterString + sourcename + " IS NULL";
                break;
            }
            case NOT_EMPTY: {
                filterString = filterString + sourcename + " IS NOT NULL";
                break;
            }
            default: {
                filterString = "LIKE".equals(filter.getOperator().toUpperCase()) ? filterString + sourcename + " " + filter.getOperator() + p1 + this.buildLIKEEscapeStatement() : filterString + sourcename + " " + filter.getOperator() + p1;
            }
        }
        params.put(p, parameter);
        return filterString;
    }

    private String escapeCharacters(Object i) {
        if (i == null) {
            return null;
        }
        return i.toString().replaceAll("_", "|_");
    }

    private String buildLIKEEscapeStatement() {
        return " ESCAPE '|' ";
    }

    public int removeDuplicates(ArrayList<GridRequestSort> list) {
        int size = list.size();
        int dups = 0;
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                if (!list.get(i).getSortBy().equals(list.get(j).getSortBy())) continue;
                ++dups;
                list.remove(j);
                --j;
                --size;
            }
        }
        return dups;
    }

    private boolean isUppercase(Map<String, DataField> tagNames, GridRequestFilter filter) {
        return filter.getUpperCase() != false || tagNames.get(filter.getFieldName()).isUppercase() != false;
    }

    private boolean isCaseInsensitive(Map<String, DataField> tagNames, GridRequestFilter filter) {
        if (filter.getForceCaseInsensitive().booleanValue()) {
            return true;
        }
        if (this.isUppercase(tagNames, filter) && tagNames.get(filter.getFieldName()).getSourcename().startsWith("r5o7")) {
            return true;
        }
        if (this.isUppercase(tagNames, filter)) {
            return false;
        }
        return tagNames.get(filter.getFieldName()).getDatatype().toString().equals("MIXVARCHAR");
    }

    public GridMetadataRequestResult getGridMetadata(InforContext context, String gridCode, String viewType, String language) throws InforException {
        this.tools.demandDatabaseConnection();
        if (gridCode == null || gridCode.trim().equals("")) {
            throw Tools.generateFault("Grid code is a mandatory field.");
        }
        if (viewType == null || viewType.trim().equals("")) {
            throw Tools.generateFault("View Type is a mandatory field.");
        }
        EntityManager em = this.tools.getEntityManager();
        try {
            GridMetadataRequestResult result = (GridMetadataRequestResult)em.find(GridMetadataRequestResult.class, (Object)gridCode);
            if (result == null) {
                throw new Exception();
            }
            GridDataspy[] gridDataspies = em.createNamedQuery("GridDataspy.GETGRIDDATASPIESS", GridDataspy.class).setParameter("gridid", (Object)gridCode).setParameter("userid", (Object)context.getCredentials().getUsername()).getResultList().toArray(new GridDataspy[0]);
            List selectedDataSpyList = Arrays.stream(gridDataspies).filter(ds -> ds.isDefaultDataspy()).collect(Collectors.toList());
            GridDataspy selectedDataSpy = gridDataspies[0];
            if (!selectedDataSpyList.isEmpty()) {
                selectedDataSpy = (GridDataspy)selectedDataSpyList.get(0);
            }
            result.setGridCode(gridCode);
            result.setGridDataspies(gridDataspies);
            result.setDataSpyId(selectedDataSpy.getCode());
            GridField[] gridFields = em.createNamedQuery("GridField.GETDDSPYFIELDS", GridField.class).setParameter("gridid", (Object)gridCode).setParameter("ddspyid", (Object)selectedDataSpy.getCode()).setParameter("viewtype", (Object)viewType).setParameter("language", (Object)(language != null ? language.toUpperCase() : "EN")).getResultList().toArray(new GridField[0]);
            if (USE_CUSTOM_FIELDS.booleanValue()) {
                gridFields = (GridField[])Stream.of(gridFields, this.gridCustomFieldHandler.getCustomFieldsAsGridFields(selectedDataSpy.getCode())).flatMap(Stream::of).toArray(GridField[]::new);
            }
            result.setGridFields(gridFields);
            GridMetadataRequestResult gridMetadataRequestResult = result;
            return gridMetadataRequestResult;
        }
        catch (Exception e) {
            this.tools.log(Level.SEVERE, "Error while fetching grid metadata for gridCode " + gridCode);
            throw Tools.generateFault("Couldn't fetch the metadata for this grid.");
        }
        finally {
            em.clear();
            em.close();
        }
    }

    public GridDDSpyFieldsResult getDDspyFields(InforContext context, String gridCode, String viewType, String ddSpyId, String language) throws InforException {
        this.tools.demandDatabaseConnection();
        if (gridCode == null || gridCode.trim().equals("")) {
            throw Tools.generateFault("Grid code is a mandatory field.");
        }
        if (ddSpyId == null || ddSpyId.trim().equals("")) {
            throw Tools.generateFault("DataSpy id is a mandatory field.");
        }
        if (viewType == null || viewType.trim().equals("")) {
            throw Tools.generateFault("View Type is a mandatory field.");
        }
        EntityManager em = this.tools.getEntityManager();
        try {
            GridDDSpyFieldsResult result = new GridDDSpyFieldsResult();
            GridField[] gridFields = em.createNamedQuery("GridField.GETDDSPYFIELDS", GridField.class).setParameter("gridid", (Object)gridCode).setParameter("ddspyid", (Object)ddSpyId).setParameter("viewtype", (Object)viewType).setParameter("language", (Object)(language != null ? language.toUpperCase() : "EN")).getResultList().toArray(new GridField[0]);
            if (USE_CUSTOM_FIELDS.booleanValue()) {
                gridFields = (GridField[])Stream.of(gridFields, this.gridCustomFieldHandler.getCustomFieldsAsGridFields(ddSpyId)).flatMap(Stream::of).toArray(GridField[]::new);
            }
            result.setGridFields(gridFields);
            result.setDataSpyId(ddSpyId);
            GridDDSpyFieldsResult gridDDSpyFieldsResult = result;
            return gridDDSpyFieldsResult;
        }
        catch (Exception e) {
            this.tools.log(Level.SEVERE, "Error");
            throw Tools.generateFault("Couldn't fetch the metadata for this grid.");
        }
        finally {
            em.clear();
            em.close();
        }
    }

    public GridDataspy getDefaultDataspy(InforContext context, String gridCode, String viewType) throws InforException {
        this.tools.demandDatabaseConnection();
        if (gridCode == null || gridCode.trim().equals("")) {
            throw Tools.generateFault("Grid code is a mandatory field.");
        }
        if (viewType == null || viewType.trim().equals("")) {
            throw Tools.generateFault("View Type is a mandatory field.");
        }
        EntityManager em = this.tools.getEntityManager();
        try {
            GridDataspy gridDataspy;
            GridMetadataRequestResult result = (GridMetadataRequestResult)em.find(GridMetadataRequestResult.class, (Object)gridCode);
            if (result == null) {
                throw new Exception();
            }
            GridDataspy gridDataspy2 = gridDataspy = (GridDataspy)em.createNamedQuery("GridDataspy.GETDEFAULTDATASPY", GridDataspy.class).setParameter("gridid", (Object)gridCode).setParameter("userid", (Object)context.getCredentials().getUsername()).getSingleResult();
            return gridDataspy2;
        }
        catch (Exception e) {
            this.tools.log(Level.SEVERE, "Error while fetching default dataspy for grid code " + gridCode + " and view type " + viewType);
            throw Tools.generateFault("Couldn't fetch the metadata for this grid.");
        }
        finally {
            em.clear();
            em.close();
        }
    }
}

