/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.annotations.BooleanType;
import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.equipment.SystemService;
import ch.cern.eam.wshub.core.services.equipment.entities.Equipment;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import net.datastream.schemas.mp_entities.systemequipment_001.FacilityConditionIndex;
import net.datastream.schemas.mp_entities.systemequipment_001.ManufacturerInfo;
import net.datastream.schemas.mp_entities.systemequipment_001.SystemEquipment;
import net.datastream.schemas.mp_entities.systemequipment_001.SystemParentHierarchy;
import net.datastream.schemas.mp_entities.systemequipment_001.Variables;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.LINEARREFERENCEDETAILS_Type;
import net.datastream.schemas.mp_fields.LOCATIONID_Type;
import net.datastream.schemas.mp_fields.LOCATIONPARENT_Type;
import net.datastream.schemas.mp_fields.SYSTEMPARENT_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_functions.mp0311_001.MP0311_AddSystemEquipment_001;
import net.datastream.schemas.mp_functions.mp0312_001.MP0312_GetSystemEquipment_001;
import net.datastream.schemas.mp_functions.mp0313_001.MP0313_SyncSystemEquipment_001;
import net.datastream.schemas.mp_functions.mp0314_001.MP0314_DeleteSystemEquipment_001;
import net.datastream.schemas.mp_functions.mp0329_001.MP0329_GetSystemParentHierarchy_001;
import net.datastream.schemas.mp_results.mp0311_001.MP0311_AddSystemEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0312_001.MP0312_GetSystemEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0329_001.MP0329_GetSystemParentHierarchy_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class SystemServiceImpl
implements SystemService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public SystemServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public Equipment readSystem(InforContext context, String systemCode) throws InforException {
        SystemEquipment systemEquipment = this.readSystemInfor(context, systemCode);
        Equipment system = this.tools.getInforFieldTools().transformInforObject(new Equipment(), systemEquipment);
        if (systemEquipment.getSYSTEMID() != null) {
            system.setCode(systemEquipment.getSYSTEMID().getEQUIPMENTCODE());
            system.setDescription(systemEquipment.getSYSTEMID().getDESCRIPTION());
        }
        MP0329_GetSystemParentHierarchy_001 getsystemh = new MP0329_GetSystemParentHierarchy_001();
        getsystemh.setSYSTEMID(systemEquipment.getSYSTEMID());
        MP0329_GetSystemParentHierarchy_001_Result gethresult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getSystemParentHierarchyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getsystemh);
        systemEquipment.setSystemParentHierarchy(gethresult.getResultData().getSystemParentHierarchy());
        if (systemEquipment.getSystemParentHierarchy().getLOCATIONID() != null) {
            system.setHierarchyLocationCode(systemEquipment.getSystemParentHierarchy().getLOCATIONID().getLOCATIONCODE());
            system.setHierarchyLocationDesc(systemEquipment.getSystemParentHierarchy().getLOCATIONID().getDESCRIPTION());
        }
        if (systemEquipment.getSystemParentHierarchy().getDEPENDENTPRIMARYSYSTEM() != null) {
            system.setHierarchyPrimarySystemCode(systemEquipment.getSystemParentHierarchy().getDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
            system.setHierarchyPrimarySystemDesc(systemEquipment.getSystemParentHierarchy().getDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
            system.setHierarchyPrimarySystemDependent(true);
            system.setHierarchyPrimarySystemCostRollUp(DataTypeTools.decodeBoolean(systemEquipment.getSystemParentHierarchy().getDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP()));
        } else if (systemEquipment.getSystemParentHierarchy().getNONDEPENDENTPRIMARYSYSTEM() != null) {
            system.setHierarchyPrimarySystemCode(systemEquipment.getSystemParentHierarchy().getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
            system.setHierarchyPrimarySystemDesc(systemEquipment.getSystemParentHierarchy().getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
            system.setHierarchyPrimarySystemDependent(false);
            system.setHierarchyPrimarySystemCostRollUp(DataTypeTools.decodeBoolean(systemEquipment.getSystemParentHierarchy().getNONDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP()));
        }
        return system;
    }

    public SystemEquipment readSystemInfor(InforContext context, String systemCode) throws InforException {
        MP0312_GetSystemEquipment_001 getSystem = new MP0312_GetSystemEquipment_001();
        getSystem.setSYSTEMID(new EQUIPMENTID_Type());
        getSystem.getSYSTEMID().setORGANIZATIONID(this.tools.getOrganization(context));
        getSystem.getSYSTEMID().setEQUIPMENTCODE(systemCode);
        MP0312_GetSystemEquipment_001_Result getAssetResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getSystemEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getSystem);
        return getAssetResult.getResultData().getSystemEquipment();
    }

    @Override
    public String updateSystem(InforContext context, Equipment systemParam) throws InforException {
        SystemEquipment systemEquipment = this.readSystemInfor(context, systemParam.getCode());
        systemEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(systemEquipment.getCLASSID()), systemEquipment.getUSERDEFINEDAREA(), systemParam.getClassCode(), "OBJ"));
        this.initializeSystemObject(systemEquipment, systemParam, context);
        this.tools.getInforFieldTools().transformWSHubObject(systemEquipment, systemParam, context);
        MP0313_SyncSystemEquipment_001 syncPosition = new MP0313_SyncSystemEquipment_001();
        syncPosition.setSystemEquipment(systemEquipment);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncSystemEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncPosition);
        return systemParam.getCode();
    }

    @Override
    public String createSystem(InforContext context, Equipment systemParam) throws InforException {
        SystemEquipment systemEquipment = new SystemEquipment();
        systemEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(systemEquipment.getCLASSID()), systemEquipment.getUSERDEFINEDAREA(), systemParam.getClassCode(), "OBJ"));
        this.initializeSystemObject(systemEquipment, systemParam, context);
        this.tools.getInforFieldTools().transformWSHubObject(systemEquipment, systemParam, context);
        MP0311_AddSystemEquipment_001 addPosition = new MP0311_AddSystemEquipment_001();
        addPosition.setSystemEquipment(systemEquipment);
        MP0311_AddSystemEquipment_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addSystemEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addPosition);
        return result.getResultData().getSYSTEMID().getEQUIPMENTCODE();
    }

    @Override
    public String deleteSystem(InforContext context, String systemCode) throws InforException {
        MP0314_DeleteSystemEquipment_001 deleteSystem = new MP0314_DeleteSystemEquipment_001();
        deleteSystem.setSYSTEMID(new EQUIPMENTID_Type());
        deleteSystem.getSYSTEMID().setORGANIZATIONID(this.tools.getOrganization(context));
        deleteSystem.getSYSTEMID().setEQUIPMENTCODE(systemCode);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteSystemEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteSystem);
        return systemCode;
    }

    private void initializeSystemObject(SystemEquipment systemInfor, Equipment systemParam, InforContext context) throws InforException {
        if (systemInfor.getSYSTEMID() == null) {
            systemInfor.setSYSTEMID(new EQUIPMENTID_Type());
            systemInfor.getSYSTEMID().setORGANIZATIONID(this.tools.getOrganization(context));
            systemInfor.getSYSTEMID().setEQUIPMENTCODE(systemParam.getCode());
        }
        if (systemParam.getDescription() != null) {
            systemInfor.getSYSTEMID().setDESCRIPTION(systemParam.getDescription());
        }
        if (systemParam.getManufacturerCode() != null || systemParam.getSerialNumber() != null || systemParam.getModel() != null || systemParam.getRevision() != null || systemParam.getxCoordinate() != null || systemParam.getyCoordinate() != null || systemParam.getzCoordinate() != null) {
            if (systemInfor.getManufacturerInfo() == null) {
                systemInfor.setManufacturerInfo(new ManufacturerInfo());
            }
            if (systemParam.getManufacturerCode() != null) {
                systemInfor.getManufacturerInfo().setMANUFACTURERCODE(systemParam.getManufacturerCode().toUpperCase());
            }
            if (systemParam.getModel() != null) {
                systemInfor.getManufacturerInfo().setMODEL(systemParam.getModel());
            }
            if (systemParam.getRevision() != null) {
                systemInfor.getManufacturerInfo().setMODELREVISION(systemParam.getRevision());
            }
            if (systemParam.getSerialNumber() != null) {
                systemInfor.getManufacturerInfo().setSERIALNUMBER(systemParam.getSerialNumber());
            }
            if (systemParam.getxCoordinate() != null) {
                ManufacturerInfo manufacturerInfo = systemInfor.getManufacturerInfo();
                this.tools.getDataTypeTools();
                manufacturerInfo.setXCOORDINATE(DataTypeTools.encodeQuantity(systemParam.getxCoordinate(), "X-Coordinate"));
            }
            if (systemParam.getyCoordinate() != null) {
                ManufacturerInfo manufacturerInfo = systemInfor.getManufacturerInfo();
                this.tools.getDataTypeTools();
                manufacturerInfo.setYCOORDINATE(DataTypeTools.encodeQuantity(systemParam.getyCoordinate(), "Y-Coordinate"));
            }
            if (systemParam.getzCoordinate() != null) {
                ManufacturerInfo manufacturerInfo = systemInfor.getManufacturerInfo();
                this.tools.getDataTypeTools();
                manufacturerInfo.setZCOORDINATE(DataTypeTools.encodeQuantity(systemParam.getzCoordinate(), "Z-Coordiante"));
            }
        }
        if (systemParam.getLinearRefGeographicalRef() != null || systemParam.getLinearRefEquipmentLength() != null || systemParam.getLinearRefEquipmentLengthUOM() != null || systemParam.getLinearRefPrecision() != null || systemParam.getLinearRefUOM() != null) {
            systemInfor.setLINEARREFERENCEDETAILS(new LINEARREFERENCEDETAILS_Type());
            LINEARREFERENCEDETAILS_Type lINEARREFERENCEDETAILS_Type = systemInfor.getLINEARREFERENCEDETAILS();
            this.tools.getDataTypeTools();
            lINEARREFERENCEDETAILS_Type.setEQUIPMENTLENGTH(DataTypeTools.encodeQuantity(systemParam.getLinearRefEquipmentLength(), "Linear Ref. Equipment Length"));
            systemInfor.getLINEARREFERENCEDETAILS().setEQUIPMENTLENGTHUOM(systemParam.getLinearRefEquipmentLengthUOM());
            systemInfor.getLINEARREFERENCEDETAILS().setGEOGRAPHICALREFERENCE(systemParam.getLinearRefGeographicalRef());
            LINEARREFERENCEDETAILS_Type lINEARREFERENCEDETAILS_Type2 = systemInfor.getLINEARREFERENCEDETAILS();
            this.tools.getDataTypeTools();
            lINEARREFERENCEDETAILS_Type2.setLINEARREFPRECISION(DataTypeTools.encodeBigInteger(systemParam.getLinearRefPrecision(), "Linear Ref. Precision"));
            systemInfor.getLINEARREFERENCEDETAILS().setLINEARREFUOM(systemParam.getLinearRefUOM());
        }
        systemInfor.setVariables(new Variables());
        if (systemParam.getVariable1() != null) {
            systemInfor.getVariables().setVARIABLE1(systemParam.getVariable1());
        }
        if (systemParam.getVariable2() != null) {
            systemInfor.getVariables().setVARIABLE2(systemParam.getVariable2());
        }
        if (systemParam.getVariable3() != null) {
            systemInfor.getVariables().setVARIABLE3(systemParam.getVariable3());
        }
        if (systemParam.getVariable4() != null) {
            systemInfor.getVariables().setVARIABLE4(systemParam.getVariable4());
        }
        if (systemParam.getVariable5() != null) {
            systemInfor.getVariables().setVARIABLE5(systemParam.getVariable5());
        }
        if (systemParam.getVariable6() != null) {
            systemInfor.getVariables().setVARIABLE6(systemParam.getVariable6());
        }
        if (systemParam.getCostOfNeededRepairs() != null || systemParam.getReplacementValue() != null || systemParam.getFacilityConditionIndex() != null || systemParam.getServiceLifetime() != null || systemParam.getYearBuilt() != null) {
            if (systemInfor.getFacilityConditionIndex() == null) {
                systemInfor.setFacilityConditionIndex(new FacilityConditionIndex());
            }
            if (systemParam.getCostOfNeededRepairs() != null) {
                FacilityConditionIndex facilityConditionIndex = systemInfor.getFacilityConditionIndex();
                this.tools.getDataTypeTools();
                facilityConditionIndex.setCOSTOFNEEDEDREPAIRS(DataTypeTools.encodeAmount(systemParam.getCostOfNeededRepairs(), "Cost of Needed Repairs"));
            }
            if (systemParam.getReplacementValue() != null) {
                FacilityConditionIndex facilityConditionIndex = systemInfor.getFacilityConditionIndex();
                this.tools.getDataTypeTools();
                facilityConditionIndex.setREPLACEMENTVALUE(DataTypeTools.encodeAmount(systemParam.getReplacementValue(), "Replacement Value"));
            }
            if (systemParam.getFacilityConditionIndex() != null) {
                FacilityConditionIndex facilityConditionIndex = systemInfor.getFacilityConditionIndex();
                this.tools.getDataTypeTools();
                facilityConditionIndex.setFACILITYCONDITIONINDEX(DataTypeTools.encodeAmount(systemParam.getFacilityConditionIndex(), "Facility Condition Index"));
            }
            if (systemParam.getServiceLifetime() != null) {
                FacilityConditionIndex facilityConditionIndex = systemInfor.getFacilityConditionIndex();
                this.tools.getDataTypeTools();
                facilityConditionIndex.setSERVICELIFE(DataTypeTools.encodeQuantity(systemParam.getServiceLifetime(), "Service Life Time"));
            }
            if (systemParam.getYearBuilt() != null) {
                FacilityConditionIndex facilityConditionIndex = systemInfor.getFacilityConditionIndex();
                this.tools.getDataTypeTools();
                facilityConditionIndex.setYEARBUILT(DataTypeTools.encodeQuantity(systemParam.getYearBuilt(), "Service Life Time"));
            }
        }
        if (DataTypeTools.isNotEmpty(systemParam.getHierarchyLocationCode()) || DataTypeTools.isNotEmpty(systemParam.getHierarchyPrimarySystemCode())) {
            this.populateSystemHierarchy(context, systemParam, systemInfor);
        }
    }

    private void populateSystemHierarchy(InforContext context, Equipment systemParam, SystemEquipment systemInfor) {
        SystemParentHierarchy systemParentHierarchy = new SystemParentHierarchy();
        systemParentHierarchy.setSYSTEMID(new EQUIPMENTID_Type());
        systemParentHierarchy.getSYSTEMID().setORGANIZATIONID(this.tools.getOrganization(context));
        systemParentHierarchy.getSYSTEMID().setEQUIPMENTCODE(systemParam.getCode());
        systemParentHierarchy.setTYPE(new TYPE_Type());
        systemParentHierarchy.getTYPE().setTYPECODE("S");
        this.tools.getDataTypeTools();
        if (DataTypeTools.isNotEmpty(systemParam.getHierarchyPrimarySystemCode())) {
            if (systemParam.getHierarchyPrimarySystemDependent() == null || !systemParam.getHierarchyPrimarySystemDependent().booleanValue()) {
                systemParam.setHierarchyAssetDependent(false);
            }
            EQUIPMENTID_Type hierarchySystem = new EQUIPMENTID_Type();
            hierarchySystem.setORGANIZATIONID(this.tools.getOrganization(context));
            hierarchySystem.setEQUIPMENTCODE(systemParam.getHierarchyPrimarySystemCode());
            if (systemParam.getHierarchyPrimarySystemDependent() != null && systemParam.getHierarchyPrimarySystemDependent().booleanValue()) {
                SYSTEMPARENT_Type systemType = new SYSTEMPARENT_Type();
                systemType.setSYSTEMID(hierarchySystem);
                systemType.setCOSTROLLUP(DataTypeTools.encodeBoolean(systemParam.getHierarchyPrimarySystemCostRollUp(), BooleanType.TRUE_FALSE));
                systemParentHierarchy.setDEPENDENTPRIMARYSYSTEM(systemType);
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(systemParam.getHierarchyLocationCode())) {
                    systemParentHierarchy.setLOCATIONID(new LOCATIONID_Type());
                    systemParentHierarchy.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
                    systemParentHierarchy.getLOCATIONID().setLOCATIONCODE(systemParam.getHierarchyLocationCode());
                }
            } else {
                SYSTEMPARENT_Type systemType = new SYSTEMPARENT_Type();
                systemType.setSYSTEMID(hierarchySystem);
                systemType.setCOSTROLLUP(DataTypeTools.encodeBoolean(systemParam.getHierarchyPrimarySystemCostRollUp(), BooleanType.TRUE_FALSE));
                systemParentHierarchy.setNONDEPENDENTPRIMARYSYSTEM(systemType);
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(systemParam.getHierarchyLocationCode())) {
                    systemParentHierarchy.setDEPENDENTLOCATION(new LOCATIONPARENT_Type());
                    systemParentHierarchy.getDEPENDENTLOCATION().setLOCATIONID(new LOCATIONID_Type());
                    systemParentHierarchy.getDEPENDENTLOCATION().getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
                    systemParentHierarchy.getDEPENDENTLOCATION().getLOCATIONID().setLOCATIONCODE(systemParam.getHierarchyLocationCode());
                }
            }
        } else {
            this.tools.getDataTypeTools();
            if (DataTypeTools.isNotEmpty(systemParam.getHierarchyLocationCode())) {
                systemParentHierarchy.setDEPENDENTLOCATION(new LOCATIONPARENT_Type());
                systemParentHierarchy.getDEPENDENTLOCATION().setLOCATIONID(new LOCATIONID_Type());
                systemParentHierarchy.getDEPENDENTLOCATION().getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
                systemParentHierarchy.getDEPENDENTLOCATION().getLOCATIONID().setLOCATIONCODE(systemParam.getHierarchyLocationCode());
            }
        }
        systemInfor.setSystemParentHierarchy(systemParentHierarchy);
    }
}

