/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.comments.CommentService;
import ch.cern.eam.wshub.core.services.comments.entities.Comment;
import ch.cern.eam.wshub.core.services.comments.impl.CommentServiceImpl;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.workorders.StandardWorkOrderService;
import ch.cern.eam.wshub.core.services.workorders.WorkOrderService;
import ch.cern.eam.wshub.core.services.workorders.entities.StandardWorkOrder;
import ch.cern.eam.wshub.core.services.workorders.impl.StandardWorkOrderServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.LinkedList;
import java.util.List;
import net.datastream.schemas.mp_entities.workorder_001.WorkOrder;
import net.datastream.schemas.mp_fields.ORGANIZATIONID_Type;
import net.datastream.schemas.mp_fields.STATUS_Type;
import net.datastream.schemas.mp_fields.WOID_Type;
import net.datastream.schemas.mp_functions.mp0023_001.MP0023_AddWorkOrder_001;
import net.datastream.schemas.mp_functions.mp0024_001.MP0024_GetWorkOrder_001;
import net.datastream.schemas.mp_functions.mp0025_001.MP0025_SyncWorkOrder_001;
import net.datastream.schemas.mp_functions.mp0026_001.MP0026_GetWorkOrderDefault_001;
import net.datastream.schemas.mp_functions.mp0055_001.MP0055_DeleteWorkOrder_001;
import net.datastream.schemas.mp_functions.mp7161_001.MP7161_ChangeWorkOrderStatus_001;
import net.datastream.schemas.mp_results.mp0023_001.MP0023_AddWorkOrder_001_Result;
import net.datastream.schemas.mp_results.mp0024_001.MP0024_GetWorkOrder_001_Result;
import net.datastream.schemas.mp_results.mp0026_001.MP0026_GetWorkOrderDefault_001_Result;
import net.datastream.schemas.mp_results.mp0026_001.ResultData;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class WorkOrderServiceImpl
implements WorkOrderService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private CommentService comments;
    private StandardWorkOrderService standardWorkOrderService;

    public WorkOrderServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.comments = new CommentServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
        this.standardWorkOrderService = new StandardWorkOrderServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public BatchResponse<String> createWorkOrderBatch(InforContext context, List<ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder> workOrderParam) {
        return this.tools.batchOperation(context, this::createWorkOrder, workOrderParam);
    }

    @Override
    public BatchResponse<ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder> readWorkOrderBatch(InforContext context, List<String> workOrderNumbers) {
        return this.tools.batchOperation(context, this::readWorkOrder, workOrderNumbers);
    }

    @Override
    public BatchResponse<String> updateWorkOrderBatch(InforContext context, List<ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder> workOrders) {
        return this.tools.batchOperation(context, this::updateWorkOrder, workOrders);
    }

    @Override
    public BatchResponse<String> deleteWorkOrderBatch(InforContext context, List<String> workOrderNumbers) {
        return this.tools.batchOperation(context, this::deleteWorkOrder, workOrderNumbers);
    }

    @Override
    public ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder readWorkOrder(InforContext context, String number) throws InforException {
        WorkOrder inforWorkOrder = this.readWorkOrderInfor(context, number);
        ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder workOrder = this.tools.getInforFieldTools().transformInforObject(new ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder(), inforWorkOrder);
        LinkedList<Runnable> runnables = new LinkedList<Runnable>();
        runnables.add(() -> workOrder.setAssignedToDesc(this.tools.getFieldDescriptionsTools().readPersonDesc(context, workOrder.getAssignedTo())));
        runnables.add(() -> workOrder.setDepartmentDesc(this.tools.getFieldDescriptionsTools().readDepartmentDesc(context, workOrder.getDepartmentCode())));
        runnables.add(() -> workOrder.setClassDesc(this.tools.getFieldDescriptionsTools().readClassDesc(context, "EVNT", workOrder.getClassCode())));
        this.tools.processRunnables(runnables);
        return workOrder;
    }

    public WorkOrder readWorkOrderInfor(InforContext context, String number) throws InforException {
        MP0024_GetWorkOrder_001 getWorkOrder = new MP0024_GetWorkOrder_001();
        getWorkOrder.setWORKORDERID(new WOID_Type());
        getWorkOrder.getWORKORDERID().setJOBNUM(number);
        getWorkOrder.getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        MP0024_GetWorkOrder_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getWorkOrderOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getWorkOrder);
        return result.getResultData().getWorkOrder();
    }

    @Override
    public ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder readWorkOrderDefault(InforContext context, String number) throws InforException {
        MP0026_GetWorkOrderDefault_001 getWorkOrderDefault = new MP0026_GetWorkOrderDefault_001();
        getWorkOrderDefault.setORGANIZATIONID(new ORGANIZATIONID_Type());
        getWorkOrderDefault.getORGANIZATIONID().setORGANIZATIONCODE(context.getOrganizationCode());
        MP0026_GetWorkOrderDefault_001_Result getWODefaultResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getWorkOrderDefaultOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getWorkOrderDefault);
        ResultData resultData = getWODefaultResult.getResultData();
        ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder workOrder = new ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder();
        if (resultData.getSTATUS() != null) {
            workOrder.setStatusCode(resultData.getSTATUS().getSTATUSCODE());
        }
        if (resultData.getTYPE() != null) {
            workOrder.setTypeCode(resultData.getTYPE().getTYPECODE());
        }
        if (resultData.getTARGETDATE() != null) {
            this.tools.getDataTypeTools();
            workOrder.setScheduledStartDate(DataTypeTools.decodeInforDate(resultData.getTARGETDATE()));
        }
        if (resultData.getSCHEDEND() != null) {
            this.tools.getDataTypeTools();
            workOrder.setScheduledEndDate(DataTypeTools.decodeInforDate(resultData.getSCHEDEND()));
        }
        if (resultData.getREPORTED() != null) {
            this.tools.getDataTypeTools();
            workOrder.setReportedDate(DataTypeTools.decodeInforDate(resultData.getREPORTED()));
        }
        return workOrder;
    }

    @Override
    public String createWorkOrder(InforContext context, ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder workorderParam) throws InforException {
        WorkOrder inforWorkOrder = new WorkOrder();
        inforWorkOrder.setWORKORDERID(new WOID_Type());
        inforWorkOrder.getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        inforWorkOrder.getWORKORDERID().setJOBNUM("0");
        inforWorkOrder.setFIXED("V");
        if (workorderParam.getStandardWO() != null && !workorderParam.getStandardWO().trim().equals("")) {
            StandardWorkOrder standardWorkOrder = this.standardWorkOrderService.readStandardWorkOrder(context, workorderParam.getStandardWO());
            workorderParam.setDescription(standardWorkOrder.getDesc());
            workorderParam.setClassCode(standardWorkOrder.getWoClassCode());
            workorderParam.setPriorityCode(standardWorkOrder.getPriorityCode());
            workorderParam.setTypeCode(standardWorkOrder.getWorkOrderTypeCode());
            workorderParam.setProblemCode(standardWorkOrder.getProblemCode());
            workorderParam.setCustomFields(standardWorkOrder.getCustomFields());
            workorderParam.setUserDefinedFields(standardWorkOrder.getUserDefinedFields());
        }
        inforWorkOrder.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(inforWorkOrder.getCLASSID()), inforWorkOrder.getUSERDEFINEDAREA(), workorderParam.getClassCode(), "EVNT"));
        this.tools.getInforFieldTools().transformWSHubObject(inforWorkOrder, workorderParam, context);
        MP0023_AddWorkOrder_001 addWO = new MP0023_AddWorkOrder_001();
        addWO.setWorkOrder(inforWorkOrder);
        MP0023_AddWorkOrder_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addWorkOrderOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addWO);
        if (workorderParam.getComment() != null && !workorderParam.getComment().trim().equals("")) {
            Comment comment = new Comment();
            comment.setEntityCode("EVNT");
            comment.setEntityKeyCode(result.getResultData().getJOBNUM());
            comment.setText(workorderParam.getComment());
            comment.setTypeCode("*");
            this.comments.createComment(context, comment);
        }
        return result.getResultData().getJOBNUM();
    }

    @Override
    public String updateWorkOrder(InforContext context, ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder workorderParam) throws InforException {
        WorkOrder inforWorkOrder = this.readWorkOrderInfor(context, workorderParam.getNumber());
        inforWorkOrder.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(inforWorkOrder.getCLASSID()), inforWorkOrder.getUSERDEFINEDAREA(), workorderParam.getClassCode(), "EVNT"));
        this.tools.getInforFieldTools().transformWSHubObject(inforWorkOrder, workorderParam, context);
        MP0025_SyncWorkOrder_001 syncWO = new MP0025_SyncWorkOrder_001();
        syncWO.setWorkOrder(inforWorkOrder);
        if (workorderParam.isConfirmedIncompleteChecklist().booleanValue()) {
            syncWO.setConfirmincompletechecklist("confirmed");
        }
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncWorkOrderOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncWO);
        return inforWorkOrder.getWORKORDERID().getJOBNUM();
    }

    @Override
    public String deleteWorkOrder(InforContext context, String workOrderNumber) throws InforException {
        MP0055_DeleteWorkOrder_001 deleteWO = new MP0055_DeleteWorkOrder_001();
        deleteWO.setWORKORDERID(new WOID_Type());
        deleteWO.getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        deleteWO.getWORKORDERID().setJOBNUM(workOrderNumber);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteWorkOrderOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteWO);
        return workOrderNumber;
    }

    @Override
    public String updateWorkOrderStatus(InforContext context, String workOrderNumber, String statusCode) throws InforException {
        MP7161_ChangeWorkOrderStatus_001 changeWOStatus = new MP7161_ChangeWorkOrderStatus_001();
        changeWOStatus.setWORKORDERID(new WOID_Type());
        changeWOStatus.getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        changeWOStatus.getWORKORDERID().setJOBNUM(workOrderNumber);
        changeWOStatus.setNEWSTATUS(new STATUS_Type());
        changeWOStatus.getNEWSTATUS().setSTATUSCODE(statusCode);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).changeWorkOrderStatusOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), changeWOStatus);
        return workOrderNumber;
    }
}

