/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.annotations.BooleanType;
import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.equipment.PositionService;
import ch.cern.eam.wshub.core.services.equipment.entities.Equipment;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import net.datastream.schemas.mp_entities.positionequipment_001.FacilityConditionIndex;
import net.datastream.schemas.mp_entities.positionequipment_001.ManufacturerInfo;
import net.datastream.schemas.mp_entities.positionequipment_001.PositionEquipment;
import net.datastream.schemas.mp_entities.positionequipment_001.Variables;
import net.datastream.schemas.mp_entities.positionhierarchy_002.AssetDependency;
import net.datastream.schemas.mp_entities.positionhierarchy_002.LocationDependency;
import net.datastream.schemas.mp_entities.positionhierarchy_002.NonDependentParents_Type;
import net.datastream.schemas.mp_entities.positionhierarchy_002.PositionDependency;
import net.datastream.schemas.mp_entities.positionhierarchy_002.PositionParentHierarchy;
import net.datastream.schemas.mp_entities.positionhierarchy_002.PrimarySystemDependency;
import net.datastream.schemas.mp_entities.positionhierarchy_002.SystemDependency;
import net.datastream.schemas.mp_fields.ASSETPARENT_Type;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.LINEARREFERENCEDETAILS_Type;
import net.datastream.schemas.mp_fields.LOCATIONID_Type;
import net.datastream.schemas.mp_fields.LOCATIONPARENT_Type;
import net.datastream.schemas.mp_fields.ORGANIZATIONID_Type;
import net.datastream.schemas.mp_fields.POSITIONPARENT_Type;
import net.datastream.schemas.mp_fields.SYSTEMPARENT_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_functions.mp0306_001.MP0306_AddPositionEquipment_001;
import net.datastream.schemas.mp_functions.mp0307_001.MP0307_GetPositionEquipment_001;
import net.datastream.schemas.mp_functions.mp0308_001.MP0308_SyncPositionEquipment_001;
import net.datastream.schemas.mp_functions.mp0309_001.MP0309_DeletePositionEquipment_001;
import net.datastream.schemas.mp_functions.mp0310_001.MP0310_GetPositionEquipmentDefault_001;
import net.datastream.schemas.mp_functions.mp0328_002.MP0328_GetPositionParentHierarchy_002;
import net.datastream.schemas.mp_results.mp0306_001.MP0306_AddPositionEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0307_001.MP0307_GetPositionEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0310_001.MP0310_GetPositionEquipmentDefault_001_Result;
import net.datastream.schemas.mp_results.mp0328_002.MP0328_GetPositionParentHierarchy_002_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class PositionServiceImpl
implements PositionService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public PositionServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public String createPosition(InforContext context, Equipment positionParam) throws InforException {
        PositionEquipment positionEquipment = new PositionEquipment();
        positionEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(positionEquipment.getCLASSID()), positionEquipment.getUSERDEFINEDAREA(), positionParam.getClassCode(), "OBJ"));
        this.initializePositionObject(context, positionEquipment, positionParam, true);
        this.tools.getInforFieldTools().transformWSHubObject(positionEquipment, positionParam, context);
        MP0306_AddPositionEquipment_001 addPosition = new MP0306_AddPositionEquipment_001();
        addPosition.setPositionEquipment(positionEquipment);
        MP0306_AddPositionEquipment_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addPositionEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addPosition);
        return result.getResultData().getPOSITIONID().getEQUIPMENTCODE();
    }

    @Override
    public String deletePosition(InforContext context, String positionCode) throws InforException {
        MP0309_DeletePositionEquipment_001 deletePosition = new MP0309_DeletePositionEquipment_001();
        deletePosition.setPOSITIONID(new EQUIPMENTID_Type());
        deletePosition.getPOSITIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        deletePosition.getPOSITIONID().setEQUIPMENTCODE(positionCode);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deletePositionEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deletePosition);
        return positionCode;
    }

    private PositionParentHierarchy readInforPositionParentHierarchy(InforContext context, String assetCode) throws InforException {
        MP0328_GetPositionParentHierarchy_002 getpositionph = new MP0328_GetPositionParentHierarchy_002();
        getpositionph.setPOSITIONID(new EQUIPMENTID_Type());
        getpositionph.getPOSITIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        getpositionph.getPOSITIONID().setEQUIPMENTCODE(assetCode);
        MP0328_GetPositionParentHierarchy_002_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getPositionParentHierarchyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getpositionph);
        return result.getResultData().getPositionParentHierarchy();
    }

    @Override
    public Equipment readPositionDefault(InforContext context, String organization) throws InforException {
        MP0310_GetPositionEquipmentDefault_001 getPositionEquipmentDefault_001 = new MP0310_GetPositionEquipmentDefault_001();
        if (DataTypeTools.isEmpty(organization)) {
            getPositionEquipmentDefault_001.setORGANIZATIONID(this.tools.getOrganization(context));
        } else {
            getPositionEquipmentDefault_001.setORGANIZATIONID(new ORGANIZATIONID_Type());
            getPositionEquipmentDefault_001.getORGANIZATIONID().setORGANIZATIONCODE(organization);
        }
        MP0310_GetPositionEquipmentDefault_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getPositionEquipmentDefaultOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getPositionEquipmentDefault_001);
        return this.tools.getInforFieldTools().transformInforObject(new Equipment(), result.getResultData().getPositionEquipment());
    }

    @Override
    public Equipment readPosition(InforContext context, String positionCode) throws InforException {
        PositionEquipment positionEquipment = this.readInforPosition(context, positionCode);
        Equipment position = this.tools.getInforFieldTools().transformInforObject(new Equipment(), positionEquipment);
        position.setSystemTypeCode("P");
        if (positionEquipment.getPOSITIONID() != null) {
            position.setCode(positionEquipment.getPOSITIONID().getEQUIPMENTCODE());
            position.setDescription(positionEquipment.getPOSITIONID().getDESCRIPTION());
        }
        positionEquipment.setPositionParentHierarchy(this.readInforPositionParentHierarchy(context, positionCode));
        if (positionEquipment.getPositionParentHierarchy().getLOCATIONID() != null) {
            position.setHierarchyLocationCode(positionEquipment.getPositionParentHierarchy().getLOCATIONID().getLOCATIONCODE());
            position.setHierarchyLocationDesc(positionEquipment.getPositionParentHierarchy().getLOCATIONID().getDESCRIPTION());
        }
        if (positionEquipment.getPositionParentHierarchy().getPositionDependency() != null) {
            PositionDependency positionDep = positionEquipment.getPositionParentHierarchy().getPositionDependency();
            position.setHierarchyPositionCode(positionDep.getDEPENDENTPOSITION().getPOSITIONID().getEQUIPMENTCODE());
            position.setHierarchyPositionDesc(positionDep.getDEPENDENTPOSITION().getPOSITIONID().getDESCRIPTION());
            position.setHierarchyPositionDependent(true);
            position.setHierarchyPositionCostRollUp(DataTypeTools.decodeBoolean(positionDep.getDEPENDENTPOSITION().getCOSTROLLUP()));
            if (positionDep.getNONDEPENDENTASSET() != null) {
                position.setHierarchyAssetCode(positionDep.getNONDEPENDENTASSET().getASSETID().getEQUIPMENTCODE());
                position.setHierarchyAssetDesc(positionDep.getNONDEPENDENTASSET().getASSETID().getDESCRIPTION());
                position.setHierarchyAssetCostRollUp(DataTypeTools.decodeBoolean(positionDep.getNONDEPENDENTASSET().getCOSTROLLUP()));
                position.setHierarchyAssetDependent(false);
            }
            if (positionDep.getNONDEPENDENTPRIMARYSYSTEM() != null) {
                position.setHierarchyPrimarySystemCode(positionDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
                position.setHierarchyPrimarySystemDesc(positionDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
                position.setHierarchyPrimarySystemCostRollUp(DataTypeTools.decodeBoolean(positionDep.getNONDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP()));
                position.setHierarchyPrimarySystemDependent(false);
            }
        } else if (positionEquipment.getPositionParentHierarchy().getAssetDependency() != null) {
            AssetDependency assetDep = positionEquipment.getPositionParentHierarchy().getAssetDependency();
            position.setHierarchyAssetCode(assetDep.getDEPENDENTASSET().getASSETID().getEQUIPMENTCODE());
            position.setHierarchyAssetDesc(assetDep.getDEPENDENTASSET().getASSETID().getDESCRIPTION());
            position.setHierarchyAssetCostRollUp(DataTypeTools.decodeBoolean(assetDep.getDEPENDENTASSET().getCOSTROLLUP()));
            position.setHierarchyAssetDependent(true);
            if (assetDep.getNONDEPENDENTPOSITION() != null) {
                position.setHierarchyPositionCode(assetDep.getNONDEPENDENTPOSITION().getPOSITIONID().getEQUIPMENTCODE());
                position.setHierarchyPositionDesc(assetDep.getNONDEPENDENTPOSITION().getPOSITIONID().getDESCRIPTION());
                position.setHierarchyPositionDependent(false);
                position.setHierarchyPositionCostRollUp(DataTypeTools.decodeBoolean(assetDep.getNONDEPENDENTPOSITION().getCOSTROLLUP()));
            }
            if (assetDep.getNONDEPENDENTPRIMARYSYSTEM() != null) {
                position.setHierarchyPrimarySystemCode(assetDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
                position.setHierarchyPrimarySystemDesc(assetDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
                position.setHierarchyPrimarySystemCostRollUp(DataTypeTools.decodeBoolean(assetDep.getNONDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP()));
                position.setHierarchyPrimarySystemDependent(false);
            }
        } else if (positionEquipment.getPositionParentHierarchy().getSystemDependency() != null) {
            SystemDependency systemDep = positionEquipment.getPositionParentHierarchy().getSystemDependency();
            position.setHierarchyPrimarySystemCode(systemDep.getDEPENDENTSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
            position.setHierarchyPrimarySystemDesc(systemDep.getDEPENDENTSYSTEM().getSYSTEMID().getDESCRIPTION());
            position.setHierarchyPrimarySystemCostRollUp(DataTypeTools.decodeBoolean(systemDep.getDEPENDENTSYSTEM().getCOSTROLLUP()));
            position.setHierarchyPrimarySystemDependent(true);
            if (systemDep.getNONDEPENDENTPOSITION() != null) {
                position.setHierarchyPositionCode(systemDep.getNONDEPENDENTPOSITION().getPOSITIONID().getEQUIPMENTCODE());
                position.setHierarchyPositionDesc(systemDep.getNONDEPENDENTPOSITION().getPOSITIONID().getDESCRIPTION());
                position.setHierarchyPositionDependent(false);
                position.setHierarchyPositionCostRollUp(DataTypeTools.decodeBoolean(systemDep.getNONDEPENDENTPOSITION().getCOSTROLLUP()));
            }
            if (systemDep.getNONDEPENDENTASSET() != null) {
                position.setHierarchyAssetCode(systemDep.getNONDEPENDENTASSET().getASSETID().getEQUIPMENTCODE());
                position.setHierarchyAssetDesc(systemDep.getNONDEPENDENTASSET().getASSETID().getDESCRIPTION());
                position.setHierarchyAssetCostRollUp(DataTypeTools.decodeBoolean(systemDep.getNONDEPENDENTASSET().getCOSTROLLUP()));
                position.setHierarchyAssetDependent(false);
            }
        } else if (positionEquipment.getPositionParentHierarchy().getNonDependentParents() != null) {
            NonDependentParents_Type nonDepParents = positionEquipment.getPositionParentHierarchy().getNonDependentParents();
            if (nonDepParents.getNONDEPENDENTASSET() != null) {
                position.setHierarchyAssetCode(nonDepParents.getNONDEPENDENTASSET().getASSETID().getEQUIPMENTCODE());
                position.setHierarchyAssetDesc(nonDepParents.getNONDEPENDENTASSET().getASSETID().getDESCRIPTION());
                position.setHierarchyAssetCostRollUp(DataTypeTools.decodeBoolean(nonDepParents.getNONDEPENDENTASSET().getCOSTROLLUP()));
                position.setHierarchyAssetDependent(false);
            }
            if (nonDepParents.getNONDEPENDENTPOSITION() != null) {
                position.setHierarchyPositionCode(nonDepParents.getNONDEPENDENTPOSITION().getPOSITIONID().getEQUIPMENTCODE());
                position.setHierarchyPositionDesc(nonDepParents.getNONDEPENDENTPOSITION().getPOSITIONID().getDESCRIPTION());
                position.setHierarchyPositionDependent(false);
                position.setHierarchyPositionCostRollUp(DataTypeTools.decodeBoolean(nonDepParents.getNONDEPENDENTPOSITION().getCOSTROLLUP()));
            }
            if (nonDepParents.getNONDEPENDENTPRIMARYSYSTEM() != null) {
                position.setHierarchyPrimarySystemCode(nonDepParents.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
                position.setHierarchyPrimarySystemDesc(nonDepParents.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
                position.setHierarchyPrimarySystemCostRollUp(DataTypeTools.decodeBoolean(nonDepParents.getNONDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP()));
                position.setHierarchyPrimarySystemDependent(false);
            }
        } else if (positionEquipment.getPositionParentHierarchy().getLocationDependency() != null) {
            LocationDependency locationDep = positionEquipment.getPositionParentHierarchy().getLocationDependency();
            position.setHierarchyLocationCode(locationDep.getDEPENDENTLOCATION().getLOCATIONID().getLOCATIONCODE());
            position.setHierarchyLocationDesc(locationDep.getDEPENDENTLOCATION().getLOCATIONID().getDESCRIPTION());
            if (locationDep.getNONDEPENDENTASSET() != null) {
                position.setHierarchyAssetCode(locationDep.getNONDEPENDENTASSET().getASSETID().getEQUIPMENTCODE());
                position.setHierarchyAssetDesc(locationDep.getNONDEPENDENTASSET().getASSETID().getDESCRIPTION());
                position.setHierarchyAssetCostRollUp(DataTypeTools.decodeBoolean(locationDep.getNONDEPENDENTASSET().getCOSTROLLUP()));
                position.setHierarchyAssetDependent(false);
            }
            if (locationDep.getNONDEPENDENTPOSITION() != null) {
                position.setHierarchyPositionCode(locationDep.getNONDEPENDENTPOSITION().getPOSITIONID().getEQUIPMENTCODE());
                position.setHierarchyPositionDesc(locationDep.getNONDEPENDENTPOSITION().getPOSITIONID().getDESCRIPTION());
                position.setHierarchyPositionDependent(false);
                position.setHierarchyPositionCostRollUp(DataTypeTools.decodeBoolean(locationDep.getNONDEPENDENTPOSITION().getCOSTROLLUP()));
            }
            if (locationDep.getNONDEPENDENTPRIMARYSYSTEM() != null) {
                position.setHierarchyPrimarySystemCode(locationDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
                position.setHierarchyPrimarySystemDesc(locationDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
                position.setHierarchyPrimarySystemCostRollUp(DataTypeTools.decodeBoolean(locationDep.getNONDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP()));
                position.setHierarchyPrimarySystemDependent(false);
            }
        }
        return position;
    }

    private PositionEquipment readInforPosition(InforContext context, String positionCode) throws InforException {
        MP0307_GetPositionEquipment_001 getPosition = new MP0307_GetPositionEquipment_001();
        getPosition.setPOSITIONID(new EQUIPMENTID_Type());
        getPosition.getPOSITIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        getPosition.getPOSITIONID().setEQUIPMENTCODE(positionCode);
        MP0307_GetPositionEquipment_001_Result getAssetResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getPositionEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getPosition);
        return getAssetResult.getResultData().getPositionEquipment();
    }

    @Override
    public String updatePosition(InforContext context, Equipment positionParam) throws InforException {
        PositionEquipment positionEquipment = this.readInforPosition(context, positionParam.getCode());
        positionEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(positionEquipment.getCLASSID()), positionEquipment.getUSERDEFINEDAREA(), positionParam.getClassCode(), "OBJ"));
        this.initializePositionObject(context, positionEquipment, positionParam, false);
        this.tools.getInforFieldTools().transformWSHubObject(positionEquipment, positionParam, context);
        MP0308_SyncPositionEquipment_001 syncPosition = new MP0308_SyncPositionEquipment_001();
        syncPosition.setPositionEquipment(positionEquipment);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncPositionEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncPosition);
        return positionParam.getCode();
    }

    private void initializePositionObject(InforContext context, PositionEquipment positionInfor, Equipment positionParam, boolean creationRequest) throws InforException {
        if (positionInfor.getPOSITIONID() == null) {
            positionInfor.setPOSITIONID(new EQUIPMENTID_Type());
            positionInfor.getPOSITIONID().setORGANIZATIONID(this.tools.getOrganization(context));
            positionInfor.getPOSITIONID().setEQUIPMENTCODE(positionParam.getCode().toUpperCase().trim());
        }
        if (positionParam.getDescription() != null) {
            positionInfor.getPOSITIONID().setDESCRIPTION(positionParam.getDescription());
        }
        if (positionParam.getManufacturerCode() != null || positionParam.getSerialNumber() != null || positionParam.getModel() != null || positionParam.getRevision() != null || positionParam.getxCoordinate() != null || positionParam.getyCoordinate() != null || positionParam.getzCoordinate() != null) {
            if (positionInfor.getManufacturerInfo() == null) {
                positionInfor.setManufacturerInfo(new ManufacturerInfo());
            }
            if (positionParam.getManufacturerCode() != null) {
                positionInfor.getManufacturerInfo().setMANUFACTURERCODE(positionParam.getManufacturerCode().toUpperCase());
            }
            if (positionParam.getModel() != null) {
                positionInfor.getManufacturerInfo().setMODEL(positionParam.getModel());
            }
            if (positionParam.getRevision() != null) {
                positionInfor.getManufacturerInfo().setMODELREVISION(positionParam.getRevision());
            }
            if (positionParam.getSerialNumber() != null) {
                positionInfor.getManufacturerInfo().setSERIALNUMBER(positionParam.getSerialNumber());
            }
            if (positionParam.getxCoordinate() != null) {
                ManufacturerInfo manufacturerInfo = positionInfor.getManufacturerInfo();
                this.tools.getDataTypeTools();
                manufacturerInfo.setXCOORDINATE(DataTypeTools.encodeQuantity(positionParam.getxCoordinate(), "X-Coordinate"));
            }
            if (positionParam.getyCoordinate() != null) {
                ManufacturerInfo manufacturerInfo = positionInfor.getManufacturerInfo();
                this.tools.getDataTypeTools();
                manufacturerInfo.setYCOORDINATE(DataTypeTools.encodeQuantity(positionParam.getyCoordinate(), "Y-Coordinate"));
            }
            if (positionParam.getzCoordinate() != null) {
                ManufacturerInfo manufacturerInfo = positionInfor.getManufacturerInfo();
                this.tools.getDataTypeTools();
                manufacturerInfo.setZCOORDINATE(DataTypeTools.encodeQuantity(positionParam.getzCoordinate(), "Z-Coordiante"));
            }
        }
        if (positionParam.getLinearRefGeographicalRef() != null || positionParam.getLinearRefEquipmentLength() != null || positionParam.getLinearRefEquipmentLengthUOM() != null || positionParam.getLinearRefPrecision() != null || positionParam.getLinearRefUOM() != null) {
            positionInfor.setLINEARREFERENCEDETAILS(new LINEARREFERENCEDETAILS_Type());
            LINEARREFERENCEDETAILS_Type lINEARREFERENCEDETAILS_Type = positionInfor.getLINEARREFERENCEDETAILS();
            this.tools.getDataTypeTools();
            lINEARREFERENCEDETAILS_Type.setEQUIPMENTLENGTH(DataTypeTools.encodeQuantity(positionParam.getLinearRefEquipmentLength(), "Linear Ref. Equipment Length"));
            positionInfor.getLINEARREFERENCEDETAILS().setEQUIPMENTLENGTHUOM(positionParam.getLinearRefEquipmentLengthUOM());
            positionInfor.getLINEARREFERENCEDETAILS().setGEOGRAPHICALREFERENCE(positionParam.getLinearRefGeographicalRef());
            LINEARREFERENCEDETAILS_Type lINEARREFERENCEDETAILS_Type2 = positionInfor.getLINEARREFERENCEDETAILS();
            this.tools.getDataTypeTools();
            lINEARREFERENCEDETAILS_Type2.setLINEARREFPRECISION(DataTypeTools.encodeBigInteger(positionParam.getLinearRefPrecision(), "Linear Ref. Precision"));
            positionInfor.getLINEARREFERENCEDETAILS().setLINEARREFUOM(positionParam.getLinearRefUOM());
        }
        if (positionInfor.getVariables() == null) {
            positionInfor.setVariables(new Variables());
        }
        if (positionParam.getVariable1() != null) {
            positionInfor.getVariables().setVARIABLE1(positionParam.getVariable1());
        }
        if (positionParam.getVariable2() != null) {
            positionInfor.getVariables().setVARIABLE2(positionParam.getVariable2());
        }
        if (positionParam.getVariable3() != null) {
            positionInfor.getVariables().setVARIABLE3(positionParam.getVariable3());
        }
        if (positionParam.getVariable4() != null) {
            positionInfor.getVariables().setVARIABLE4(positionParam.getVariable4());
        }
        if (positionParam.getVariable5() != null) {
            positionInfor.getVariables().setVARIABLE5(positionParam.getVariable5());
        }
        if (positionParam.getVariable6() != null) {
            positionInfor.getVariables().setVARIABLE6(positionParam.getVariable6());
        }
        if (positionParam.getCostOfNeededRepairs() != null || positionParam.getReplacementValue() != null || positionParam.getFacilityConditionIndex() != null || positionParam.getServiceLifetime() != null || positionParam.getYearBuilt() != null) {
            if (positionInfor.getFacilityConditionIndex() == null) {
                positionInfor.setFacilityConditionIndex(new FacilityConditionIndex());
            }
            if (positionParam.getCostOfNeededRepairs() != null) {
                FacilityConditionIndex facilityConditionIndex = positionInfor.getFacilityConditionIndex();
                this.tools.getDataTypeTools();
                facilityConditionIndex.setCOSTOFNEEDEDREPAIRS(DataTypeTools.encodeAmount(positionParam.getCostOfNeededRepairs(), "Cost of Needed Repairs"));
            }
            if (positionParam.getReplacementValue() != null) {
                FacilityConditionIndex facilityConditionIndex = positionInfor.getFacilityConditionIndex();
                this.tools.getDataTypeTools();
                facilityConditionIndex.setREPLACEMENTVALUE(DataTypeTools.encodeAmount(positionParam.getReplacementValue(), "Replacement Value"));
            }
            if (positionParam.getFacilityConditionIndex() != null) {
                FacilityConditionIndex facilityConditionIndex = positionInfor.getFacilityConditionIndex();
                this.tools.getDataTypeTools();
                facilityConditionIndex.setFACILITYCONDITIONINDEX(DataTypeTools.encodeAmount(positionParam.getFacilityConditionIndex(), "Facility Condition Index"));
            }
            if (positionParam.getServiceLifetime() != null) {
                FacilityConditionIndex facilityConditionIndex = positionInfor.getFacilityConditionIndex();
                this.tools.getDataTypeTools();
                facilityConditionIndex.setSERVICELIFE(DataTypeTools.encodeQuantity(positionParam.getServiceLifetime(), "Service Life Time"));
            }
            if (positionParam.getYearBuilt() != null) {
                FacilityConditionIndex facilityConditionIndex = positionInfor.getFacilityConditionIndex();
                this.tools.getDataTypeTools();
                facilityConditionIndex.setYEARBUILT(DataTypeTools.encodeQuantity(positionParam.getYearBuilt(), "Service Life Time"));
            }
        }
        if (positionParam.getHierarchyAssetCode() != null || positionParam.getHierarchyPositionCode() != null || positionParam.getHierarchyLocationCode() != null) {
            this.initializePositionHierarchy(positionInfor, positionParam, context);
        }
    }

    private void initializePositionHierarchy(PositionEquipment positionInfor, Equipment positionParam, InforContext context) {
        PositionParentHierarchy positionParentHierarchy = new PositionParentHierarchy();
        positionParentHierarchy.setPOSITIONID(new EQUIPMENTID_Type());
        positionParentHierarchy.getPOSITIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        positionParentHierarchy.getPOSITIONID().setEQUIPMENTCODE(positionParam.getCode());
        positionParentHierarchy.setTYPE(new TYPE_Type());
        positionParentHierarchy.getTYPE().setTYPECODE(positionParam.getTypeCode());
        EQUIPMENTID_Type hierarchyAsset = new EQUIPMENTID_Type();
        hierarchyAsset.setORGANIZATIONID(this.tools.getOrganization(context));
        hierarchyAsset.setEQUIPMENTCODE(positionParam.getHierarchyAssetCode());
        EQUIPMENTID_Type hierarchyPosition = new EQUIPMENTID_Type();
        hierarchyPosition.setORGANIZATIONID(this.tools.getOrganization(context));
        hierarchyPosition.setEQUIPMENTCODE(positionParam.getHierarchyPositionCode());
        EQUIPMENTID_Type hierarchySystem = new EQUIPMENTID_Type();
        hierarchySystem.setORGANIZATIONID(this.tools.getOrganization(context));
        hierarchySystem.setEQUIPMENTCODE(positionParam.getHierarchyPrimarySystemCode());
        if (positionParam.getHierarchyAssetDependent() != null && positionParam.getHierarchyAssetDependent().booleanValue()) {
            positionParentHierarchy.setAssetDependency(new AssetDependency());
            this.tools.getDataTypeTools();
            if (DataTypeTools.isNotEmpty(positionParam.getHierarchyPositionCode())) {
                positionParentHierarchy.getAssetDependency().setNONDEPENDENTPOSITION(this.createHierarchyPosition(positionParam, hierarchyPosition));
            }
            this.tools.getDataTypeTools();
            if (DataTypeTools.isNotEmpty(positionParam.getHierarchyPrimarySystemCode())) {
                positionParentHierarchy.getAssetDependency().setNONDEPENDENTPRIMARYSYSTEM(this.createHierarchyPrymarySystem(positionParam, hierarchySystem));
            }
            positionParentHierarchy.getAssetDependency().setDEPENDENTASSET(this.createHierarchyAsset(positionParam, hierarchyAsset));
        } else if (positionParam.getHierarchyPositionDependent() != null && positionParam.getHierarchyPositionDependent().booleanValue()) {
            positionParentHierarchy.setPositionDependency(new PositionDependency());
            this.tools.getDataTypeTools();
            if (DataTypeTools.isNotEmpty(positionParam.getHierarchyAssetCode())) {
                positionParentHierarchy.getPositionDependency().setNONDEPENDENTASSET(this.createHierarchyAsset(positionParam, hierarchyAsset));
            }
            this.tools.getDataTypeTools();
            if (DataTypeTools.isNotEmpty(positionParam.getHierarchyPrimarySystemCode())) {
                positionParentHierarchy.getPositionDependency().setNONDEPENDENTPRIMARYSYSTEM(this.createHierarchyPrymarySystem(positionParam, hierarchySystem));
            }
            positionParentHierarchy.getPositionDependency().setDEPENDENTPOSITION(this.createHierarchyPosition(positionParam, hierarchyPosition));
        } else if (positionParam.getHierarchyPrimarySystemDependent() != null && positionParam.getHierarchyPrimarySystemDependent().booleanValue()) {
            positionParentHierarchy.setPrimarySystemDependency(new PrimarySystemDependency());
            this.tools.getDataTypeTools();
            if (DataTypeTools.isNotEmpty(positionParam.getHierarchyPositionCode())) {
                positionParentHierarchy.getPrimarySystemDependency().setNONDEPENDENTPOSITION(this.createHierarchyPosition(positionParam, hierarchyPosition));
            }
            this.tools.getDataTypeTools();
            if (DataTypeTools.isNotEmpty(positionParam.getHierarchyAssetCode())) {
                positionParentHierarchy.getPrimarySystemDependency().setNONDEPENDENTASSET(this.createHierarchyAsset(positionParam, hierarchyAsset));
            }
            positionParentHierarchy.getPrimarySystemDependency().setDEPENDENTPRIMARYSYSTEM(this.createHierarchyPrymarySystem(positionParam, hierarchySystem));
        } else if (!(positionParam.getHierarchyAssetDependent() != null && positionParam.getHierarchyAssetDependent().booleanValue() || positionParam.getHierarchyPositionDependent() != null && positionParam.getHierarchyPositionDependent().booleanValue() || positionParam.getHierarchyPrimarySystemDependent() != null && positionParam.getHierarchyPrimarySystemDependent().booleanValue())) {
            if (positionParam.getHierarchyLocationCode() == null) {
                positionParentHierarchy.setNonDependentParents(new NonDependentParents_Type());
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(positionParam.getHierarchyPositionCode())) {
                    positionParentHierarchy.getNonDependentParents().setNONDEPENDENTPOSITION(this.createHierarchyPosition(positionParam, hierarchyPosition));
                }
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(positionParam.getHierarchyAssetCode())) {
                    positionParentHierarchy.getNonDependentParents().setNONDEPENDENTASSET(this.createHierarchyAsset(positionParam, hierarchyAsset));
                }
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(positionParam.getHierarchyPrimarySystemCode())) {
                    positionParentHierarchy.getNonDependentParents().setNONDEPENDENTPRIMARYSYSTEM(this.createHierarchyPrymarySystem(positionParam, hierarchySystem));
                }
            } else {
                positionParentHierarchy.setLocationDependency(new LocationDependency());
                positionParentHierarchy.getLocationDependency().setDEPENDENTLOCATION(new LOCATIONPARENT_Type());
                positionParentHierarchy.getLocationDependency().getDEPENDENTLOCATION().setLOCATIONID(new LOCATIONID_Type());
                positionParentHierarchy.getLocationDependency().getDEPENDENTLOCATION().getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
                positionParentHierarchy.getLocationDependency().getDEPENDENTLOCATION().getLOCATIONID().setLOCATIONCODE(positionParam.getHierarchyLocationCode());
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(positionParam.getHierarchyPositionCode())) {
                    positionParentHierarchy.getLocationDependency().setNONDEPENDENTPOSITION(this.createHierarchyPosition(positionParam, hierarchyPosition));
                }
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(positionParam.getHierarchyAssetCode())) {
                    positionParentHierarchy.getLocationDependency().setNONDEPENDENTASSET(this.createHierarchyAsset(positionParam, hierarchyAsset));
                }
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(positionParam.getHierarchyPrimarySystemCode())) {
                    positionParentHierarchy.getLocationDependency().setNONDEPENDENTPRIMARYSYSTEM(this.createHierarchyPrymarySystem(positionParam, hierarchySystem));
                }
            }
        }
        positionInfor.setPositionParentHierarchy(positionParentHierarchy);
    }

    private ASSETPARENT_Type createHierarchyAsset(Equipment positionParam, EQUIPMENTID_Type hierarchyAsset) {
        ASSETPARENT_Type assetType = new ASSETPARENT_Type();
        assetType.setASSETID(hierarchyAsset);
        assetType.setCOSTROLLUP(DataTypeTools.encodeBoolean(positionParam.getHierarchyAssetCostRollUp(), BooleanType.TRUE_FALSE));
        return assetType;
    }

    private POSITIONPARENT_Type createHierarchyPosition(Equipment positionParam, EQUIPMENTID_Type hierarchyPosition) {
        POSITIONPARENT_Type positionType = new POSITIONPARENT_Type();
        positionType.setPOSITIONID(hierarchyPosition);
        positionType.setCOSTROLLUP(DataTypeTools.encodeBoolean(positionParam.getHierarchyPositionCostRollUp(), BooleanType.TRUE_FALSE));
        return positionType;
    }

    private SYSTEMPARENT_Type createHierarchyPrymarySystem(Equipment positionParam, EQUIPMENTID_Type hierarchySystem) {
        SYSTEMPARENT_Type systemType = new SYSTEMPARENT_Type();
        systemType.setSYSTEMID(hierarchySystem);
        systemType.setCOSTROLLUP(DataTypeTools.encodeBoolean(positionParam.getHierarchyPrimarySystemCostRollUp(), BooleanType.TRUE_FALSE));
        return systemType;
    }
}

