/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.material.entities.MaterialList;
import ch.cern.eam.wshub.core.services.workorders.WorkOrderMiscService;
import ch.cern.eam.wshub.core.services.workorders.entities.TaskPlan;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import net.datastream.schemas.mp_entities.materiallistpart_001.MaterialListPart;
import net.datastream.schemas.mp_entities.meterreading_001.MeterReading;
import net.datastream.schemas.mp_entities.routeequipment_001.RouteEquipment;
import net.datastream.schemas.mp_entities.task_001.Task;
import net.datastream.schemas.mp_entities.workorderadditionalcosts_001.WorkOrderAdditionalCosts;
import net.datastream.schemas.mp_entities.workorderpart_001.WorkOrderPart;
import net.datastream.schemas.mp_fields.ACTIVITYCODE;
import net.datastream.schemas.mp_fields.ACTIVITYID;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.COSTTYPEID_Type;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.MATERIALLISTID_Type;
import net.datastream.schemas.mp_fields.MATERIALLISTPARTID_Type;
import net.datastream.schemas.mp_fields.PARTID_Type;
import net.datastream.schemas.mp_fields.ROUTEEQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.ROUTEEQUIPMENTTYPE_Type;
import net.datastream.schemas.mp_fields.ROUTE_Type;
import net.datastream.schemas.mp_fields.STATUS_Type;
import net.datastream.schemas.mp_fields.STOREID_Type;
import net.datastream.schemas.mp_fields.TASKLISTID_Type;
import net.datastream.schemas.mp_fields.TRADEID_Type;
import net.datastream.schemas.mp_fields.UOMID_Type;
import net.datastream.schemas.mp_fields.WOID_Type;
import net.datastream.schemas.mp_fields.WORKORDERPARTID;
import net.datastream.schemas.mp_functions.mp0044_001.MP0044_AddMeterReading_001;
import net.datastream.schemas.mp_functions.mp0067_001.MP0067_AddMaterialListPart_001;
import net.datastream.schemas.mp_functions.mp0071_001.MP0071_AddWorkOrderPart_001;
import net.datastream.schemas.mp_functions.mp0080_001.MP0080_AddTask_001;
import net.datastream.schemas.mp_functions.mp7153_001.MP7153_AddRouteEquipment_001;
import net.datastream.schemas.mp_functions.mp7156_001.MP7156_DeleteRouteEquipment_001;
import net.datastream.schemas.mp_functions.mp7593_001.MP7593_AddWorkOrderAdditionalCosts_001;
import net.datastream.schemas.mp_results.mp0044_001.MP0044_AddMeterReading_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class WorkOrderMiscServiceImpl
implements WorkOrderMiscService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public WorkOrderMiscServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public String createMeterReading(InforContext context, ch.cern.eam.wshub.core.services.workorders.entities.MeterReading meterReadingParam) throws InforException {
        MeterReading meterreadinginfor = new MeterReading();
        meterreadinginfor.setUSAGEUOMID(new UOMID_Type());
        meterreadinginfor.getUSAGEUOMID().setUOMCODE(meterReadingParam.getUOM());
        if (meterReadingParam.getActualValue() != null) {
            this.tools.getDataTypeTools();
            meterreadinginfor.setACTUALREADING(DataTypeTools.encodeQuantity(meterReadingParam.getActualValue(), "Meter Reading Value"));
        } else if (meterReadingParam.getDifferenceValue() != null) {
            this.tools.getDataTypeTools();
            meterreadinginfor.setDIFFERENCEREADING(DataTypeTools.encodeQuantity(meterReadingParam.getDifferenceValue(), "Meter Reading Value"));
        } else {
            throw Tools.generateFault("Supply actual reading or difference reading value.");
        }
        if (meterReadingParam.getReadingDate() == null) {
            this.tools.getDataTypeTools();
            meterreadinginfor.setREADINGDATE(DataTypeTools.formatDate("SYSDATE", "Meter Reading Date"));
        } else {
            this.tools.getDataTypeTools();
            meterreadinginfor.setREADINGDATE(DataTypeTools.encodeInforDate(meterReadingParam.getReadingDate(), "Meter Reading Date"));
        }
        if (meterReadingParam.getEquipmentCode() != null) {
            meterreadinginfor.setTARGETEQUIPMENTID(new EQUIPMENTID_Type());
            meterreadinginfor.getTARGETEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            meterreadinginfor.getTARGETEQUIPMENTID().setEQUIPMENTCODE(meterReadingParam.getEquipmentCode().trim().toUpperCase());
        }
        if (meterReadingParam.getWoNumber() != null) {
            meterreadinginfor.setWORKORDERID(new WOID_Type());
            meterreadinginfor.getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
            meterreadinginfor.getWORKORDERID().setJOBNUM(meterReadingParam.getWoNumber());
        }
        MP0044_AddMeterReading_001 addmeterreading = new MP0044_AddMeterReading_001();
        addmeterreading.setMeterReading(meterreadinginfor);
        MP0044_AddMeterReading_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addMeterReadingOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addmeterreading);
        return result.getResultData().getMETERREADINGCODE();
    }

    @Override
    public String createWorkOrderAdditionalCost(InforContext context, ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderAdditionalCosts workOrderAddCostsParam) throws InforException {
        WorkOrderAdditionalCosts workOrderAddCosts = new WorkOrderAdditionalCosts();
        workOrderAddCosts.setACTIVITYID(new ACTIVITYID());
        workOrderAddCosts.getACTIVITYID().setACTIVITYCODE(new ACTIVITYCODE());
        workOrderAddCosts.getACTIVITYID().getACTIVITYCODE().setValue(this.tools.getDataTypeTools().encodeLong(workOrderAddCostsParam.getActivityCode(), "Activity Code"));
        workOrderAddCosts.getACTIVITYID().setWORKORDERID(new WOID_Type());
        workOrderAddCosts.getACTIVITYID().getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        workOrderAddCosts.getACTIVITYID().getWORKORDERID().setJOBNUM(workOrderAddCostsParam.getWorkOrderNumber());
        workOrderAddCosts.setCOSTTYPEID(new COSTTYPEID_Type());
        workOrderAddCosts.getCOSTTYPEID().setCOSTTYPECODE(workOrderAddCostsParam.getCostType());
        this.tools.getDataTypeTools();
        workOrderAddCosts.setCREATEDDATE(DataTypeTools.formatDate(workOrderAddCostsParam.getDate(), "Created Date"));
        workOrderAddCosts.setDESCRIPTION(workOrderAddCostsParam.getCostDescription());
        this.tools.getDataTypeTools();
        workOrderAddCosts.setUNITPRICE(DataTypeTools.encodeAmount(workOrderAddCostsParam.getCost(), "Cost Value"));
        this.tools.getDataTypeTools();
        workOrderAddCosts.setWOADDITIONALCOSTQTY(DataTypeTools.encodeQuantity(BigDecimal.ONE, "Additional Quantity"));
        MP7593_AddWorkOrderAdditionalCosts_001 addCost = new MP7593_AddWorkOrderAdditionalCosts_001();
        addCost.setWorkOrderAdditionalCosts(workOrderAddCosts);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addWorkOrderAdditionalCostsOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addCost);
        return "done";
    }

    @Override
    public String createMaterialList(InforContext context, MaterialList materialList) throws InforException {
        MP0067_AddMaterialListPart_001 matList = new MP0067_AddMaterialListPart_001();
        matList.setMaterialListPart(new MaterialListPart());
        matList.getMaterialListPart().setMATERIALLISTPARTID(new MATERIALLISTPARTID_Type());
        matList.getMaterialListPart().getMATERIALLISTPARTID().setMATERIALLISTID(new MATERIALLISTID_Type());
        if (materialList.getMaterialListCode() != null && !materialList.getMaterialListCode().trim().equals("")) {
            matList.getMaterialListPart().getMATERIALLISTPARTID().getMATERIALLISTID().setMTLREVISION(Long.valueOf(0L));
            matList.getMaterialListPart().getMATERIALLISTPARTID().getMATERIALLISTID().setMTLCODE(materialList.getMaterialListCode().toUpperCase().trim());
            matList.getMaterialListPart().getMATERIALLISTPARTID().getMATERIALLISTID().setORGANIZATIONID(this.tools.getOrganization(context));
        }
        matList.getMaterialListPart().getMATERIALLISTPARTID().setMATERIALLISTPARTLINENUM(this.tools.getDataTypeTools().encodeLong(materialList.getLineNumber(), "Line Number"));
        if (materialList.getPartCode() != null && !materialList.getPartCode().trim().equals("")) {
            matList.getMaterialListPart().setPARTID(new PARTID_Type());
            matList.getMaterialListPart().getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            matList.getMaterialListPart().getPARTID().setPARTCODE(materialList.getPartCode());
        }
        MaterialListPart materialListPart = matList.getMaterialListPart();
        this.tools.getDataTypeTools();
        materialListPart.setPARTQUANTITY(DataTypeTools.encodeQuantity(materialList.getQuantity(), "Quantity"));
        if (materialList.getReserve() != null) {
            matList.getMaterialListPart().setRESERVEPART(materialList.getReserve().trim());
        }
        if (materialList.getEquipmentCode() != null && !materialList.getEquipmentCode().trim().equals("")) {
            matList.getMaterialListPart().setEQUIPMENTID(new EQUIPMENTID_Type());
            matList.getMaterialListPart().getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            matList.getMaterialListPart().getEQUIPMENTID().setEQUIPMENTCODE(materialList.getEquipmentCode());
        }
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addMaterialListPartOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), matList);
        return "done";
    }

    @Override
    public String addWorkOrderPart(InforContext context, ch.cern.eam.wshub.core.services.entities.WorkOrderPart workOrderPart) throws InforException {
        WorkOrderPart wop = new WorkOrderPart();
        wop.setPARTID(new PARTID_Type());
        wop.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
        wop.getPARTID().setPARTCODE(workOrderPart.getPartCode());
        if (workOrderPart.getStoreCode() != null) {
            wop.setSTOREID(new STOREID_Type());
            wop.getSTOREID().setORGANIZATIONID(this.tools.getOrganization(context));
            wop.getSTOREID().setSTORECODE(workOrderPart.getStoreCode());
        }
        wop.setWORKORDERPARTID(new WORKORDERPARTID());
        wop.getWORKORDERPARTID().setACTIVITYID(new ACTIVITYID());
        wop.getWORKORDERPARTID().getACTIVITYID().setACTIVITYCODE(new ACTIVITYCODE());
        wop.getWORKORDERPARTID().getACTIVITYID().getACTIVITYCODE().setValue(this.tools.getDataTypeTools().encodeLong(workOrderPart.getActivityCode(), "Activity Code"));
        wop.getWORKORDERPARTID().getACTIVITYID().setWORKORDERID(new WOID_Type());
        wop.getWORKORDERPARTID().getACTIVITYID().getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        wop.getWORKORDERPARTID().getACTIVITYID().getWORKORDERID().setJOBNUM(workOrderPart.getWorkOrderNumber());
        if (workOrderPart.getPlannedQty() != null) {
            this.tools.getDataTypeTools();
            wop.setPLANNEDPARTQUANTITY(DataTypeTools.encodeQuantity(workOrderPart.getPlannedQty(), "Planned Qty."));
        }
        if (workOrderPart.getReservedQty() != null) {
            this.tools.getDataTypeTools();
            wop.setRESERVEDPARTQUANTITY(DataTypeTools.encodeQuantity(workOrderPart.getReservedQty(), "Reserved Qty."));
        }
        if (workOrderPart.getAllocatedQty() != null) {
            this.tools.getDataTypeTools();
            wop.setALLOCATEDPARTQUANTITY(DataTypeTools.encodeQuantity(workOrderPart.getAllocatedQty(), "Allocated Qty."));
        }
        if (workOrderPart.getPlannedSource() != null && !workOrderPart.getPlannedSource().trim().equals("")) {
            wop.setDIRECT(workOrderPart.getPlannedSource());
        }
        MP0071_AddWorkOrderPart_001 addwop = new MP0071_AddWorkOrderPart_001();
        addwop.setWorkOrderPart(wop);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addWorkOrderPartOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addwop);
        return "done";
    }

    @Override
    public String createRouteEquipment(InforContext context, ch.cern.eam.wshub.core.services.workorders.entities.RouteEquipment routeEquipment) throws InforException {
        RouteEquipment routeEquipmentInfor = new RouteEquipment();
        routeEquipmentInfor.setROUTEEQUIPMENTID(new ROUTEEQUIPMENTID_Type());
        routeEquipmentInfor.getROUTEEQUIPMENTID().setROUTEEQUIPMENTSEQUENCE(this.tools.getDataTypeTools().encodeLong(routeEquipment.getRouteEquipmentSequence(), "Route Equipment Sequence"));
        routeEquipmentInfor.getROUTEEQUIPMENTID().setROUTEID(new ROUTE_Type());
        routeEquipmentInfor.getROUTEEQUIPMENTID().getROUTEID().setROUTECODE(routeEquipment.getRouteCode());
        if (routeEquipment.getRouteRevision() != null) {
            routeEquipmentInfor.getROUTEEQUIPMENTID().getROUTEID().setROUTEREVISION(Long.valueOf(this.tools.getDataTypeTools().encodeLong(routeEquipment.getRouteRevision(), "Route Revision")));
        } else {
            routeEquipmentInfor.getROUTEEQUIPMENTID().getROUTEID().setROUTEREVISION(Long.valueOf(0L));
        }
        routeEquipmentInfor.setROUTEEQUIPMENTTYPE(new ROUTEEQUIPMENTTYPE_Type());
        routeEquipmentInfor.getROUTEEQUIPMENTTYPE().setEQUIPMENTID(new EQUIPMENTID_Type());
        routeEquipmentInfor.getROUTEEQUIPMENTTYPE().getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
        routeEquipmentInfor.getROUTEEQUIPMENTTYPE().getEQUIPMENTID().setEQUIPMENTCODE(routeEquipment.getEquipmentCode());
        routeEquipmentInfor.getROUTEEQUIPMENTTYPE().setOBJRTYPE(routeEquipment.getObjRType());
        routeEquipmentInfor.getROUTEEQUIPMENTTYPE().setOBJTYPE(routeEquipment.getObjType());
        MP7153_AddRouteEquipment_001 addRouteEquipment = new MP7153_AddRouteEquipment_001();
        addRouteEquipment.setRouteEquipment(routeEquipmentInfor);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addRouteEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addRouteEquipment);
        return "done";
    }

    @Override
    public String deleteRouteEquipment(InforContext context, ch.cern.eam.wshub.core.services.workorders.entities.RouteEquipment routeEquipment) throws InforException {
        MP7156_DeleteRouteEquipment_001 deleteRouteEquipment = new MP7156_DeleteRouteEquipment_001();
        deleteRouteEquipment.setROUTEEQUIPMENTID(new ROUTEEQUIPMENTID_Type());
        deleteRouteEquipment.getROUTEEQUIPMENTID().setROUTEEQUIPMENTSEQUENCE(this.tools.getDataTypeTools().encodeLong(routeEquipment.getRouteEquipmentSequence(), "Route Equipment Sequence"));
        deleteRouteEquipment.getROUTEEQUIPMENTID().setROUTEID(new ROUTE_Type());
        deleteRouteEquipment.getROUTEEQUIPMENTID().getROUTEID().setROUTECODE(routeEquipment.getRouteCode());
        if (routeEquipment.getRouteRevision() != null) {
            deleteRouteEquipment.getROUTEEQUIPMENTID().getROUTEID().setROUTEREVISION(Long.valueOf(this.tools.getDataTypeTools().encodeLong(routeEquipment.getRouteRevision(), "Route Revision")));
        } else {
            deleteRouteEquipment.getROUTEEQUIPMENTID().getROUTEID().setROUTEREVISION(Long.valueOf(0L));
        }
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteRouteEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteRouteEquipment);
        return "done";
    }

    @Override
    public String createTaskPlan(InforContext context, TaskPlan taskPlan) throws InforException {
        Task inforTask = new Task();
        inforTask.setTASKLISTID(new TASKLISTID_Type());
        inforTask.getTASKLISTID().setDESCRIPTION(taskPlan.getDescription());
        inforTask.getTASKLISTID().setTASKCODE(taskPlan.getCode());
        inforTask.getTASKLISTID().setORGANIZATIONID(this.tools.getOrganization(context));
        if (taskPlan.getRevision() == null) {
            inforTask.getTASKLISTID().setTASKREVISION(Long.valueOf(0L));
        } else {
            inforTask.getTASKLISTID().setTASKREVISION(Long.valueOf(this.tools.getDataTypeTools().encodeLong(taskPlan.getRevision(), "Task Revision")));
        }
        if (taskPlan.getTradeCode() != null) {
            inforTask.setTRADEID(new TRADEID_Type());
            inforTask.getTRADEID().setTRADECODE(taskPlan.getTradeCode());
            inforTask.getTRADEID().setORGANIZATIONID(this.tools.getOrganization(context));
            if (taskPlan.getPeopleRequired() == null) {
                inforTask.setPERSONS(Long.valueOf(1L));
            } else {
                inforTask.setPERSONS(Long.valueOf(this.tools.getDataTypeTools().encodeLong(taskPlan.getPeopleRequired(), "People Required")));
            }
            if (taskPlan.getEstimatedHours() == null) {
                this.tools.getDataTypeTools();
                inforTask.setHOURSREQUESTED(DataTypeTools.encodeQuantity(BigDecimal.ONE, "Estimated Hours"));
            } else {
                this.tools.getDataTypeTools();
                inforTask.setHOURSREQUESTED(DataTypeTools.encodeQuantity(taskPlan.getEstimatedHours(), "Estimated Hours"));
            }
        }
        if (taskPlan.getRevisionStatus() == null) {
            inforTask.setSTATUS(new STATUS_Type());
            inforTask.getSTATUS().setSTATUSCODE("A");
        } else {
            inforTask.setSTATUS(new STATUS_Type());
            inforTask.getSTATUS().setSTATUSCODE(taskPlan.getRevisionStatus());
        }
        inforTask.setPLANNINGLEVEL("TP");
        if (taskPlan.getTypeCode() != null) {
            inforTask.setTASKPLANTYPE(taskPlan.getTypeCode());
        }
        if (taskPlan.getClassCode() != null) {
            inforTask.setCLASSID(new CLASSID_Type());
            inforTask.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
            inforTask.getCLASSID().setCLASSCODE(taskPlan.getClassCode());
        }
        if (taskPlan.getOutOfService() != null) {
            inforTask.setOUTOFSERVICE(taskPlan.getOutOfService());
        }
        if (taskPlan.getEquipmentType() != null) {
            inforTask.setEQUIPMENTTYPE(taskPlan.getEquipmentType());
        }
        if (taskPlan.getEquipmentClass() != null) {
            inforTask.setEQUIPMENTCLASSID(new CLASSID_Type());
            inforTask.getEQUIPMENTCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
            inforTask.getEQUIPMENTCLASSID().setCLASSCODE(taskPlan.getEquipmentClass());
        }
        if (taskPlan.getMaterialList() != null) {
            inforTask.setMATERIALLISTID(new MATERIALLISTID_Type());
            inforTask.getMATERIALLISTID().setORGANIZATIONID(this.tools.getOrganization(context));
            inforTask.getMATERIALLISTID().setMTLCODE(taskPlan.getMaterialList());
        }
        MP0080_AddTask_001 addTask = new MP0080_AddTask_001();
        addTask.setTask(inforTask);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addTaskOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addTask);
        return "done";
    }
}

