/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.tools;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.entities.UserDefinedFields;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestFilter;
import ch.cern.eam.wshub.core.services.grids.impl.GridsServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.lang.reflect.Field;
import java.util.List;
import java.util.logging.Level;
import javax.persistence.EntityManager;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class FieldDescriptionTools {
    private Tools tools;
    private ApplicationData applicationData;
    private InforWebServicesPT inforws;
    private GridsService gridsService;

    public FieldDescriptionTools(Tools tools, ApplicationData applicationData, InforWebServicesPT inforws) {
        this.tools = tools;
        this.applicationData = applicationData;
        this.inforws = inforws;
        this.gridsService = new GridsServiceImpl(applicationData, tools, inforws);
    }

    private String getDescription(InforContext context, GridRequest gridRequest, String descriptionKey) {
        try {
            return GridTools.extractSingleResult(this.gridsService.executeQuery(context, gridRequest), descriptionKey);
        }
        catch (InforException inforException) {
            this.tools.log(Level.WARNING, "Couldn't fetch description for " + descriptionKey);
            return null;
        }
    }

    public String readPersonDesc(InforContext context, String personCode) {
        if (DataTypeTools.isEmpty(personCode)) {
            return null;
        }
        GridRequest gridRequest = new GridRequest("LVPERS", GridRequest.GRIDTYPE.LOV, 1);
        gridRequest.addFilter("personcode", personCode, "=");
        gridRequest.addParam("parameter.per_type", "");
        gridRequest.addParam("param.bypassdeptsecurity", "false");
        gridRequest.addParam("param.sessionid", "");
        gridRequest.addParam("parameter.noemployees", "");
        gridRequest.addParam("param.shift", "");
        return this.getDescription(context, gridRequest, "description");
    }

    public String readDepartmentDesc(InforContext context, String departmentCode) {
        if (DataTypeTools.isEmpty(departmentCode)) {
            return null;
        }
        GridRequest gridRequest = new GridRequest("LVMRCS", GridRequest.GRIDTYPE.LOV, 1);
        gridRequest.addFilter("department", departmentCode, "=");
        gridRequest.addParam("param.showstardepartment", "true");
        gridRequest.addParam("param.bypassdeptsecurity", "false");
        return this.getDescription(context, gridRequest, "des_text");
    }

    public String readClassDesc(InforContext context, String entity, String classCode) {
        if (DataTypeTools.isEmpty(classCode)) {
            return null;
        }
        GridRequest gridRequest = new GridRequest("LVCLAS", GridRequest.GRIDTYPE.LOV, 1);
        gridRequest.addFilter("class", classCode, "=");
        gridRequest.addParam("parameter.rentity", entity);
        gridRequest.addParam("parameter.r5role", "");
        gridRequest.addParam("parameter.bypassorg", "");
        return this.getDescription(context, gridRequest, "des_text");
    }

    public String readUOMDesc(InforContext inforContext, String uomCode) {
        if (DataTypeTools.isEmpty(uomCode)) {
            return null;
        }
        GridRequest gridRequest = new GridRequest("LVUOMS", GridRequest.GRIDTYPE.LOV, 1);
        gridRequest.addFilter("uomcode", uomCode, "=");
        gridRequest.addParam("param.aspect", "");
        return this.getDescription(inforContext, gridRequest, "description");
    }

    public String readCategoryDesc(InforContext inforContext, String categoryCode) {
        if (DataTypeTools.isEmpty(categoryCode)) {
            return null;
        }
        GridRequest gridRequest = new GridRequest("LVPARTCAT", GridRequest.GRIDTYPE.LOV, 1);
        gridRequest.addFilter("category", categoryCode, "=");
        return this.getDescription(inforContext, gridRequest, "description");
    }

    public String readCommodityDesc(InforContext inforContext, String commodityCode) {
        if (DataTypeTools.isEmpty(commodityCode)) {
            return null;
        }
        GridRequest gridRequest = new GridRequest("LVCOMM", GridRequest.GRIDTYPE.LOV, 1);
        gridRequest.addFilter("commoditycode", commodityCode, "=");
        return this.getDescription(inforContext, gridRequest, "des_text");
    }

    public String readManufacturerDesc(InforContext inforContext, String manufacturerCode) {
        if (DataTypeTools.isEmpty(manufacturerCode)) {
            return null;
        }
        GridRequest gridRequest = new GridRequest("LVMANU", GridRequest.GRIDTYPE.LOV, 1);
        gridRequest.addFilter("manufacturercode", manufacturerCode, "=");
        return this.getDescription(inforContext, gridRequest, "des_text");
    }

    public String readBinDesc(InforContext inforContext, String storeCode, String binCode) {
        if (DataTypeTools.isEmpty(binCode) || DataTypeTools.isEmpty(storeCode)) {
            return null;
        }
        GridRequest gridRequest = new GridRequest("LVBINALL", GridRequest.GRIDTYPE.LOV, 1);
        gridRequest.addFilter("code", binCode, "=", GridRequestFilter.JOINER.AND);
        gridRequest.addFilter("bis_store", storeCode, "=");
        return this.getDescription(inforContext, gridRequest, "description");
    }

    public String readCostCodeDesc(InforContext inforContext, String costCode) {
        if (DataTypeTools.isEmpty(costCode)) {
            return null;
        }
        GridRequest gridRequest = new GridRequest("LVCSTC", GridRequest.GRIDTYPE.LOV, 1);
        gridRequest.addFilter("costcode", costCode, "=");
        return this.getDescription(inforContext, gridRequest, "des_text");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readCustomFieldDesc(String entityCode, String codeValue) {
        if (!this.tools.isDatabaseConnectionConfigured()) {
            return null;
        }
        this.tools.getDataTypeTools();
        if (DataTypeTools.isEmpty(codeValue)) {
            return null;
        }
        try (EntityManager em = this.tools.getEntityManager();){
            if (entityCode != null && codeValue != null) {
                String string = em.createNativeQuery("SELECT DES_TEXT FROM R5DESCRIPTIONS WHERE DES_RENTITY = :entityCode AND DES_CODE = :codeValue").setParameter("entityCode", (Object)entityCode).setParameter("codeValue", (Object)codeValue).getSingleResult().toString();
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readUDFRENTDescriptions(UserDefinedFields udfs, String entity) {
        if (!this.tools.isDatabaseConnectionConfigured()) {
            return;
        }
        try (EntityManager em = this.tools.getEntityManager();){
            List rentFields = em.createNativeQuery("SELECT UDF_FIELD, UDF_LOOKUPRENTITY FROM R5USERDEFINEDFIELDSETUP WHERE UDF_RENTITY = :entity AND UDF_LOOKUPTYPE = 'RENT'  and UDF_FIELD LIKE 'udfchar%'").setParameter("entity", (Object)entity).getResultList();
            for (Object[] fieldInfo : rentFields) {
                String field = fieldInfo[0].toString();
                String rentity = fieldInfo[1].toString();
                Field reflexField = udfs.getClass().getDeclaredField(field);
                reflexField.setAccessible(true);
                Object realValue = reflexField.get(udfs);
                if (realValue == null || realValue.toString().equals("")) continue;
                String valueDesc = null;
                try {
                    valueDesc = em.createNativeQuery("SELECT DES_TEXT FROM R5DESCRIPTIONS WHERE DES_RENTITY = :entityCode AND DES_CODE = :codeValue").setParameter("entityCode", (Object)rentity).setParameter("codeValue", (Object)realValue.toString()).getSingleResult().toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (valueDesc == null) continue;
                Field reflexFieldDesc = udfs.getClass().getDeclaredField(field + "Desc");
                reflexFieldDesc.setAccessible(true);
                reflexFieldDesc.set(udfs, valueDesc);
            }
        }
    }
}

