/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.userdefinedscreens.entities;

import ch.cern.eam.wshub.core.adapters.BigDecimalAdapter;
import ch.cern.eam.wshub.core.adapters.DateAdapter;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDLValueType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class UDLValue
implements Serializable {
    private static final long serialVersionUID = 3824835369799503639L;
    private Object value;
    private UDLValueType type;

    public UDLValue() {
        this.type = UDLValueType.NULL;
    }

    public UDLValue(String value) {
        this.setString(value);
    }

    public UDLValue(Date value) {
        this.setDate(value);
    }

    public UDLValue(BigDecimal value) {
        this.setNumeric(value);
    }

    public void setString(String value) {
        if (value != null && value.length() > 64) {
            throw new IllegalArgumentException("String too large to include in a UDLValue");
        }
        this.type = UDLValueType.STRING;
        this.value = value;
    }

    public void setDate(Date value) {
        this.type = UDLValueType.DATE;
        this.value = value;
    }

    public void setNumeric(BigDecimal value) {
        this.type = UDLValueType.NUMERIC;
        this.value = value;
    }

    public String getString() {
        return this.type == UDLValueType.STRING ? (String)this.value : null;
    }

    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getDate() {
        return this.type == UDLValueType.DATE ? (Date)this.value : null;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getNumeric() {
        return this.type == UDLValueType.NUMERIC ? (BigDecimal)this.value : null;
    }

    public String toString() {
        switch (this.type) {
            case NULL: {
                return "null";
            }
            case STRING: {
                return "\"" + this.value + "\"";
            }
        }
        return this.value.toString();
    }
}

