/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.workorders.EmployeeService;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.List;
import net.datastream.schemas.mp_entities.employee_001.Employee;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.Employee_Type;
import net.datastream.schemas.mp_fields.StandardUserDefinedFields;
import net.datastream.schemas.mp_functions.mp7037_001.MP7037_GetEmployee_001;
import net.datastream.schemas.mp_functions.mp7038_001.MP7038_AddEmployee_001;
import net.datastream.schemas.mp_functions.mp7039_001.MP7039_SyncEmployee_001;
import net.datastream.schemas.mp_functions.mp7040_001.MP7040_DeleteEmployee_001;
import net.datastream.schemas.mp_results.mp7037_001.MP7037_GetEmployee_001_Result;
import net.datastream.schemas.mp_results.mp7038_001.MP7038_AddEmployee_001_Result;
import net.datastream.schemas.mp_results.mp7039_001.MP7039_SyncEmployee_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class EmployeeServiceImpl
implements EmployeeService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public EmployeeServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public BatchResponse<String> createEmployeeBatch(InforContext context, List<ch.cern.eam.wshub.core.services.workorders.entities.Employee> workOrderParam) {
        return this.tools.batchOperation(context, this::createEmployee, workOrderParam);
    }

    @Override
    public BatchResponse<String> updateEmployeeBatch(InforContext context, List<ch.cern.eam.wshub.core.services.workorders.entities.Employee> workOrders) {
        return this.tools.batchOperation(context, this::updateEmployee, workOrders);
    }

    @Override
    public ch.cern.eam.wshub.core.services.workorders.entities.Employee readEmployee(InforContext context, String employeeCode) throws InforException {
        MP7037_GetEmployee_001 request = new MP7037_GetEmployee_001();
        request.setEMPLOYEEID(new Employee_Type());
        request.getEMPLOYEEID().setEMPLOYEECODE(employeeCode);
        MP7037_GetEmployee_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getEmployeeOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), request);
        ch.cern.eam.wshub.core.services.workorders.entities.Employee employee = this.tools.getInforFieldTools().transformInforObject(new ch.cern.eam.wshub.core.services.workorders.entities.Employee(), result.getResultData().getEmployee());
        employee.setSupervisor(employee.getUserDefinedFields().getUdfnum01());
        employee.setPersonID(employee.getUserDefinedFields().getUdfnum01());
        return employee;
    }

    @Override
    public String createEmployee(InforContext context, ch.cern.eam.wshub.core.services.workorders.entities.Employee employee) throws InforException {
        Employee inforEmployee = new Employee();
        this.populateInforObject(inforEmployee, employee, context);
        MP7038_AddEmployee_001 request = new MP7038_AddEmployee_001();
        request.setEmployee(inforEmployee);
        MP7038_AddEmployee_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addEmployeeOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), request);
        return result.getResultData().getEMPLOYEEID().getEMPLOYEECODE();
    }

    @Override
    public String updateEmployee(InforContext context, ch.cern.eam.wshub.core.services.workorders.entities.Employee employee) throws InforException {
        MP7037_GetEmployee_001 readRequest = new MP7037_GetEmployee_001();
        readRequest.setEMPLOYEEID(new Employee_Type());
        readRequest.getEMPLOYEEID().setEMPLOYEECODE(employee.getCode());
        MP7037_GetEmployee_001_Result readResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getEmployeeOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), readRequest);
        Employee inforEmployee = readResult.getResultData().getEmployee();
        this.populateInforObject(inforEmployee, employee, context);
        MP7039_SyncEmployee_001 syncRequest = new MP7039_SyncEmployee_001();
        syncRequest.setEmployee(inforEmployee);
        MP7039_SyncEmployee_001_Result syncResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncEmployeeOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncRequest);
        return syncResult.getResultData().getEmployee().getEMPLOYEEID().getEMPLOYEECODE();
    }

    @Override
    public String deleteEmployee(InforContext context, String employeeCode) throws InforException {
        MP7040_DeleteEmployee_001 request = new MP7040_DeleteEmployee_001();
        request.setEMPLOYEEID(new Employee_Type());
        request.getEMPLOYEEID().setEMPLOYEECODE(employeeCode);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteEmployeeOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), request);
        return employeeCode;
    }

    private void populateInforObject(Employee inforEmployee, ch.cern.eam.wshub.core.services.workorders.entities.Employee employee, InforContext context) throws InforException {
        if (employee.getCode() != null && inforEmployee.getEMPLOYEEID() == null) {
            inforEmployee.setEMPLOYEEID(new Employee_Type());
            inforEmployee.getEMPLOYEEID().setEMPLOYEECODE(employee.getCode());
            inforEmployee.getEMPLOYEEID().setORGANIZATIONID(this.tools.getOrganization(context));
        }
        if (employee.getDescription() != null) {
            if (inforEmployee.getEMPLOYEEID() == null) {
                inforEmployee.setEMPLOYEEID(new Employee_Type());
            }
            inforEmployee.getEMPLOYEEID().setDESCRIPTION(employee.getDescription());
        }
        if (employee.getPhone() != null) {
            inforEmployee.setPHONE(employee.getPhone());
        }
        if (employee.getMobilePhone() != null) {
            inforEmployee.setMOBILEPHONENUMBER(employee.getMobilePhone());
        }
        if (employee.getAddress() != null) {
            inforEmployee.setADDRESS(employee.getAddress());
        }
        if (employee.getClazz() != null) {
            inforEmployee.setCLASSID(new CLASSID_Type());
            inforEmployee.getCLASSID().setCLASSCODE(employee.getClazz());
            inforEmployee.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
        }
        if (employee.getMRC() != null) {
            inforEmployee.setDEPARTMENTCODE(employee.getMRC());
        }
        if (employee.getEmail() != null) {
            inforEmployee.setEMAIL(employee.getEmail());
        }
        if (employee.getUserCode() != null) {
            inforEmployee.setUSERCODE(employee.getUserCode());
        }
        if (employee.getTrade() != null) {
            inforEmployee.setTRADECODE(employee.getTrade());
        }
        if (inforEmployee.getStandardUserDefinedFields() == null) {
            inforEmployee.setStandardUserDefinedFields(new StandardUserDefinedFields());
        }
        if (employee.getSupervisor() != null) {
            StandardUserDefinedFields standardUserDefinedFields = inforEmployee.getStandardUserDefinedFields();
            this.tools.getDataTypeTools();
            standardUserDefinedFields.setUDFNUM01(DataTypeTools.encodeQuantity(employee.getSupervisor(), "Supervisor"));
        }
        if (employee.getPersonID() != null) {
            StandardUserDefinedFields standardUserDefinedFields = inforEmployee.getStandardUserDefinedFields();
            this.tools.getDataTypeTools();
            standardUserDefinedFields.setUDFNUM02(DataTypeTools.encodeQuantity(employee.getPersonID(), "PersonID"));
        }
        if (employee.getDepartment() != null) {
            inforEmployee.getStandardUserDefinedFields().setUDFCHAR02(employee.getDepartment());
        }
        if (employee.getGroup() != null) {
            inforEmployee.getStandardUserDefinedFields().setUDFCHAR03(employee.getGroup());
        }
        if (employee.getSection() != null) {
            inforEmployee.getStandardUserDefinedFields().setUDFCHAR04(employee.getSection());
        }
        if (employee.getPreferredLanguage() != null) {
            inforEmployee.getStandardUserDefinedFields().setUDFCHAR05(employee.getPreferredLanguage());
        }
        if (employee.getAccountBlocked() != null) {
            inforEmployee.getStandardUserDefinedFields().setUDFCHKBOX01(employee.getAccountBlocked());
        }
        if (employee.getOutOfService() != null) {
            inforEmployee.setOUTOFSERVICE(employee.getOutOfService());
        }
    }
}

