/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestResult;
import ch.cern.eam.wshub.core.services.grids.impl.GridsServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.SafetyService;
import ch.cern.eam.wshub.core.services.workorders.entities.EntitySafety;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.datastream.schemas.mp_functions.mp3219_001.MP3219_AddEntitySafety_001;
import net.datastream.schemas.mp_functions.mp3220_001.MP3220_SyncEntitySafety_001;
import net.datastream.schemas.mp_functions.mp3221_001.MP3221_DeleteEntitySafety_001;
import net.datastream.schemas.mp_functions.mp3222_001.MP3222_GetEntitySafety_001;
import net.datastream.schemas.mp_results.mp3219_001.MP3219_AddEntitySafety_001_Result;
import net.datastream.schemas.mp_results.mp3220_001.MP3220_SyncEntitySafety_001_Result;
import net.datastream.schemas.mp_results.mp3222_001.MP3222_GetEntitySafety_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class SafetyServiceImpl
implements SafetyService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private GridsService gridsService;

    public SafetyServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.gridsService = new GridsServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public List<String> getSafetiesIDList(InforContext context, String entityID, SafetyService.ENTITY_TYPE entityType) throws InforException {
        GridRequest gridRequest;
        SafetyService.validateInput(entityID, entityType);
        switch (entityType) {
            case Equipment: {
                gridRequest = new GridRequest("OSOBJA_ESF", GridRequest.GRIDTYPE.LIST, SafetyService.GRID_ROW_COUNT);
                gridRequest.addParam("parameter.object", entityID);
                gridRequest.addParam("parameter.objorganization", this.tools.getOrganizationCode(context));
                break;
            }
            case Workorder: {
                gridRequest = new GridRequest("WSJOBS_KSF", GridRequest.GRIDTYPE.LIST, SafetyService.GRID_ROW_COUNT);
                gridRequest.addParam("param.workordernum", entityID);
                gridRequest.addParam("parameter.r5role", "");
                gridRequest.setUserFunctionName("WSJOBS");
                break;
            }
            default: {
                throw Tools.generateFault("Invalid entityType");
            }
        }
        GridRequestResult res = this.gridsService.executeQuery(context, gridRequest);
        List<String> listOfIDs = Arrays.stream(res.getRows()).map(gridRequestRow -> gridRequestRow.getCell()[0].getContent()).collect(Collectors.toList());
        return listOfIDs;
    }

    @Override
    public net.datastream.schemas.mp_entities.entitysafety_001.EntitySafety getEntitySafety(InforContext context, String safetyCode) throws InforException {
        SafetyService.validateInput(safetyCode);
        MP3222_GetEntitySafety_001 getEntitySafety = new MP3222_GetEntitySafety_001();
        getEntitySafety.setSAFETYCODE(safetyCode);
        MP3222_GetEntitySafety_001_Result res = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getEntitySafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getEntitySafety);
        return res.getResultData().getEntitySafety();
    }

    @Override
    public BatchResponse<net.datastream.schemas.mp_entities.entitysafety_001.EntitySafety> getEntitySafetiesBatch(InforContext context, List<String> safetyCodes) throws InforException {
        return this.tools.batchOperation(context, this::getEntitySafety, safetyCodes);
    }

    @Override
    public String addSafety(InforContext context, EntitySafety entitySafetywshub) throws InforException {
        SafetyService.validateInput(entitySafetywshub);
        net.datastream.schemas.mp_entities.entitysafety_001.EntitySafety entitySafetyInfor = new net.datastream.schemas.mp_entities.entitysafety_001.EntitySafety();
        entitySafetyInfor.setSAFETYCODE("0");
        this.tools.getInforFieldTools().transformWSHubObject(entitySafetyInfor, entitySafetywshub, context);
        MP3219_AddEntitySafety_001 addEntitySafety = new MP3219_AddEntitySafety_001();
        addEntitySafety.getEntitySafety().add(entitySafetyInfor);
        MP3219_AddEntitySafety_001_Result res = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addEntitySafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addEntitySafety);
        return (String)res.getResultData().getSAFETYCODE().get(0);
    }

    @Override
    public List<String> addSafeties(InforContext context, List<EntitySafety> listOfSafeties) throws InforException {
        SafetyService.validateInput(listOfSafeties);
        MP3219_AddEntitySafety_001 addEntitySafety = new MP3219_AddEntitySafety_001();
        for (EntitySafety entity : listOfSafeties) {
            net.datastream.schemas.mp_entities.entitysafety_001.EntitySafety entitySafetyInfor = new net.datastream.schemas.mp_entities.entitysafety_001.EntitySafety();
            entitySafetyInfor.setSAFETYCODE("0");
            this.tools.getInforFieldTools().transformWSHubObject(entitySafetyInfor, entity, context);
            addEntitySafety.getEntitySafety().add(entitySafetyInfor);
        }
        MP3219_AddEntitySafety_001_Result res = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addEntitySafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addEntitySafety);
        return res.getResultData().getSAFETYCODE();
    }

    @Override
    public String addSafetyToEntity(InforContext context, EntitySafety entitySafetywshub, String parentID, String entity) throws InforException {
        EntitySafety cloned = new EntitySafety(entitySafetywshub);
        cloned.setEntity(entity);
        cloned.setEntitySafetyCode(parentID);
        return this.addSafety(context, cloned);
    }

    @Override
    public BatchResponse<String> addSafetyToEntitiesBatch(InforContext context, EntitySafety entitySafetywshub, List<String> parentIDs, String entity) throws InforException {
        ArrayList safetiesToAdd = new ArrayList();
        parentIDs.stream().forEach(parentID -> {
            EntitySafety cloned = new EntitySafety(entitySafetywshub);
            cloned.setEntity(entity);
            cloned.setEntitySafetyCode((String)parentID);
            safetiesToAdd.add(cloned);
        });
        return this.tools.batchOperation(context, this::addSafety, safetiesToAdd);
    }

    @Override
    public String deleteSafety(InforContext context, String safetyCode) throws InforException {
        SafetyService.validateInput(safetyCode);
        MP3221_DeleteEntitySafety_001 deleteEntitySafety = new MP3221_DeleteEntitySafety_001();
        deleteEntitySafety.setSAFETYCODE(safetyCode);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteEntitySafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteEntitySafety);
        return "OK";
    }

    @Override
    public BatchResponse<String> deleteSafetiesBatch(InforContext context, List<String> safetyCodes) throws InforException {
        return this.tools.batchOperation(context, this::deleteSafety, safetyCodes);
    }

    @Override
    public String syncEntitySafety(InforContext context, EntitySafety entitySafetywshub) throws InforException {
        SafetyService.validateInput(entitySafetywshub);
        MP3222_GetEntitySafety_001 getEntitySafety = new MP3222_GetEntitySafety_001();
        getEntitySafety.setSAFETYCODE(entitySafetywshub.getSafetyCode());
        MP3222_GetEntitySafety_001_Result resGet = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getEntitySafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getEntitySafety);
        net.datastream.schemas.mp_entities.entitysafety_001.EntitySafety entitySafetyInfor = resGet.getResultData().getEntitySafety();
        this.tools.getInforFieldTools().transformWSHubObject(entitySafetyInfor, entitySafetywshub, context);
        MP3220_SyncEntitySafety_001 syncEntitySafety = new MP3220_SyncEntitySafety_001();
        syncEntitySafety.setEntitySafety(entitySafetyInfor);
        MP3220_SyncEntitySafety_001_Result resSync = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncEntitySafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncEntitySafety);
        return resSync.getResultData().getSAFETYCODE();
    }
}

