/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.userdefinedscreens.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedListHelpable;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedListService;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedTableService;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.EntityId;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDLEntry;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDLEntryId;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDLValue;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDTRow;
import ch.cern.eam.wshub.core.services.userdefinedscreens.impl.UserDefinedTableServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class UserDefinedListServiceImpl
implements UserDefinedListService {
    private static final String TABLE_NAME = "U5PROPVALUESLISTS";
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private UserDefinedTableService userDefinedTableService;

    public UserDefinedListServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.userDefinedTableService = new UserDefinedTableServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    private UDTRow initUDLRow(UDLEntryId entryId) {
        UDTRow row = new UDTRow();
        if (entryId.getEntityId().getEntityType() == null || entryId.getEntityId().getEntityCode() == null) {
            throw new IllegalArgumentException("Must at least have entity type and code");
        }
        row.addString("PVL_RENTITY", entryId.getEntityId().getEntityType());
        row.addString("PVL_CODE", entryId.getEntityId().getEntityCode());
        if (entryId.getProperty() != null) {
            row.addString("PVL_PROPERTY", entryId.getProperty());
        }
        if (entryId.getSequenceNumber() != null) {
            row.addInteger("PVL_SEQNO", entryId.getSequenceNumber());
        }
        return row;
    }

    private UDTRow initUDLRow(UDLEntry entry) {
        UDTRow row = new UDTRow();
        UDLEntryId entryId = entry.getEntryId();
        EntityId entityId = entryId.getEntityId();
        row.addString("PVL_RENTITY", entityId.getEntityType());
        row.addString("PVL_CODE", entityId.getEntityCode());
        row.addString("PVL_PROPERTY", entryId.getProperty());
        row.addInteger("PVL_SEQNO", entryId.getSequenceNumber());
        UDLValue value = entry.getValue();
        row.addString("PVL_VALUE", value.getString());
        row.addDate("PVL_DVALUE", value.getDate());
        row.addDecimal("PVL_NVALUE", value.getNumeric());
        return row;
    }

    private UDLEntry getUDLEntry(Map<String, Object> map) {
        String entityType = (String)map.get("PVL_RENTITY");
        String entityCode = (String)map.get("PVL_CODE");
        EntityId entityId = new EntityId(entityType, entityCode);
        String property = (String)map.get("PVL_PROPERTY");
        BigInteger sequenceNumber = (BigInteger)map.get("PVL_SEQNO");
        UDLEntryId entryId = new UDLEntryId(entityId, property, sequenceNumber);
        String stringValue = (String)map.get("PVL_VALUE");
        Date dateValue = (Date)map.get("PVL_DVALUE");
        BigDecimal numericValue = (BigDecimal)map.get("PVL_NVALUE");
        long nonNulls = Arrays.asList(stringValue, dateValue, numericValue).stream().filter(a -> a != null).count();
        if (nonNulls > 1L) {
            throw new RuntimeException("Multiple value types for UDLEntry");
        }
        if (stringValue != null) {
            return new UDLEntry(entryId, new UDLValue(stringValue));
        }
        if (dateValue != null) {
            return new UDLEntry(entryId, new UDLValue(dateValue));
        }
        if (numericValue != null) {
            return new UDLEntry(entryId, new UDLValue(numericValue));
        }
        return new UDLEntry(entryId);
    }

    @Override
    public Map<String, List<UDLValue>> readUserDefinedLists(InforContext context, UDLEntryId entryId) throws InforException {
        List<UDLEntry> entries = this.readUserDefinedListEntries(context, entryId);
        HashMap<String, List<UDLValue>> map = new HashMap<String, List<UDLValue>>();
        for (UDLEntry entry : entries) {
            String property = entry.getEntryId().getProperty();
            UDLValue value = entry.getValue();
            List list = (List)map.get(property);
            if (list == null) {
                ArrayList<UDLValue> newList = new ArrayList<UDLValue>();
                newList.add(value);
                map.put(property, newList);
                continue;
            }
            list.add(value);
        }
        return map;
    }

    @Override
    public String setUserDefinedLists(InforContext context, EntityId entityId, Map<String, List<UDLValue>> values) throws InforException {
        ArrayList<UDTRow> rows = new ArrayList<UDTRow>();
        for (String property : values.keySet()) {
            UDTRow filters = this.initUDLRow(new UDLEntryId(entityId, property));
            this.userDefinedTableService.deleteUserDefinedTableRows(context, TABLE_NAME, filters);
            List<UDLValue> list = values.get(property);
            BigInteger sequenceNumber = BigInteger.ZERO;
            for (UDLValue value : list) {
                UDLEntryId entryId = new UDLEntryId(entityId, property, sequenceNumber);
                rows.add(this.initUDLRow(new UDLEntry(entryId, value)));
                sequenceNumber = sequenceNumber.add(BigInteger.ONE);
            }
        }
        if (!rows.isEmpty()) {
            this.userDefinedTableService.createUserDefinedTableRows(context, TABLE_NAME, rows);
        }
        return "OK";
    }

    @Override
    public List<UDLEntry> readUserDefinedListEntries(InforContext context, UDLEntryId property) throws InforException {
        UDTRow filters = this.initUDLRow(property);
        List<Map<String, Object>> rows = this.userDefinedTableService.readUserDefinedTableRows(context, TABLE_NAME, filters, Arrays.asList("PVL_RENTITY", "PVL_CODE", "PVL_PROPERTY", "PVL_SEQNO", "PVL_VALUE", "PVL_DVALUE", "PVL_NVALUE"));
        try {
            return rows.stream().sorted((a, b) -> {
                String propertyB;
                String propertyA = (String)a.get("PVL_PROPERTY");
                int propertyCompare = propertyA.compareTo(propertyB = (String)b.get("PVL_PROPERTY"));
                if (propertyCompare == 0) {
                    BigInteger sequenceNumberA = (BigInteger)a.get("PVL_SEQNO");
                    BigInteger sequenceNumberB = (BigInteger)b.get("PVL_SEQNO");
                    return sequenceNumberA.compareTo(sequenceNumberB);
                }
                return propertyCompare;
            }).map(this::getUDLEntry).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            throw Tools.generateFault(e.getMessage());
        }
    }

    @Override
    public String createUserDefinedListEntry(InforContext context, UDLEntry entry) throws InforException {
        this.userDefinedTableService.createUserDefinedTableRows(context, TABLE_NAME, Arrays.asList(this.initUDLRow(entry)));
        return "OK";
    }

    @Override
    public String updateUserDefinedListEntry(InforContext context, UDLEntry entry) throws InforException {
        UDTRow filters;
        UDTRow row = this.initUDLRow(entry);
        int updates = this.userDefinedTableService.updateUserDefinedTableRows(context, TABLE_NAME, row, filters = this.initUDLRow(entry.getEntryId()));
        if (updates == 1) {
            return "OK";
        }
        if (updates == 0) {
            throw Tools.generateFault("Specified row not found");
        }
        this.tools.log(Level.SEVERE, "UserDefinedListServiceImpl::updateUserDefinedListEntry updated more than 1 row");
        throw Tools.generateFault("Updated more than one row");
    }

    @Override
    public String deleteUserDefinedListEntries(InforContext context, UDLEntryId filters) throws InforException {
        UDTRow tableFilters = this.initUDLRow(filters);
        this.userDefinedTableService.deleteUserDefinedTableRows(context, TABLE_NAME, tableFilters);
        return "OK";
    }

    @Override
    public void readUDLToEntity(InforContext context, UserDefinedListHelpable entity, EntityId entityId) {
        try {
            Map<String, List<UDLValue>> entries = this.readUserDefinedLists(context, new UDLEntryId(entityId));
            entity.setUserDefinedList(entries);
        }
        catch (Exception e) {
            this.tools.log(Level.SEVERE, "Failed reading UDL from " + entityId);
        }
    }

    @Override
    public void writeUDLToEntityCopyFrom(InforContext context, UserDefinedListHelpable entity, EntityId entityId) {
        try {
            Map<String, List<UDLValue>> entries = entity.getUserDefinedList();
            if (entries != null) {
                this.setUserDefinedLists(context, entityId, entries);
            } else if (entity.getCopyFrom() != null) {
                Map<String, List<UDLValue>> copyFromEntries = this.readUserDefinedLists(context, new UDLEntryId(new EntityId(entityId.getEntityType(), entity.getCopyFrom())));
                this.setUserDefinedLists(context, entityId, copyFromEntries);
            }
        }
        catch (Exception e) {
            this.tools.log(Level.SEVERE, "Failed writing UDL with copyFrom in " + entityId);
        }
    }

    @Override
    public void writeUDLToEntity(InforContext context, UserDefinedListHelpable entity, EntityId entityId) {
        try {
            if (entity.getUserDefinedList() != null) {
                this.setUserDefinedLists(context, entityId, entity.getUserDefinedList());
            }
        }
        catch (Exception e) {
            this.tools.log(Level.SEVERE, "Failed writing UDL in " + entityId);
        }
    }

    @Override
    public void deleteUDLFromEntity(InforContext context, EntityId entityId) {
        try {
            this.deleteUserDefinedListEntries(context, new UDLEntryId(entityId));
        }
        catch (Exception e) {
            this.tools.log(Level.SEVERE, "Failed deleting UDL of " + entityId);
        }
    }
}

