/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.equipment.LocationService;
import ch.cern.eam.wshub.core.services.equipment.entities.Location;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.List;
import net.datastream.schemas.mp_entities.location_001.LocationParentHierarchy;
import net.datastream.schemas.mp_entities.location_001.ParentLocation;
import net.datastream.schemas.mp_fields.DEPARTMENTID_Type;
import net.datastream.schemas.mp_fields.LOCATIONID_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_functions.mp0317_001.MP0317_AddLocation_001;
import net.datastream.schemas.mp_functions.mp0318_001.MP0318_GetLocation_001;
import net.datastream.schemas.mp_functions.mp0319_001.MP0319_SyncLocation_001;
import net.datastream.schemas.mp_functions.mp0320_001.MP0320_DeleteLocation_001;
import net.datastream.schemas.mp_functions.mp0361_001.MP0361_GetLocationParentHierarchy_001;
import net.datastream.schemas.mp_results.mp0318_001.MP0318_GetLocation_001_Result;
import net.datastream.schemas.mp_results.mp0361_001.MP0361_GetLocationParentHierarchy_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class LocationServiceImpl
implements LocationService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public LocationServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public BatchResponse<String> createLocationBatch(InforContext context, List<Location> locations) {
        return this.tools.batchOperation(context, this::createLocation, locations);
    }

    @Override
    public BatchResponse<Location> readLocationBatch(InforContext context, List<String> locationCodes) {
        return this.tools.batchOperation(context, this::readLocation, locationCodes);
    }

    @Override
    public BatchResponse<String> updateLocationBatch(InforContext context, List<Location> locations) {
        return this.tools.batchOperation(context, this::updateLocation, locations);
    }

    @Override
    public BatchResponse<String> deleteLocationBatch(InforContext context, List<String> locationCodes) {
        return this.tools.batchOperation(context, this::deleteLocation, locationCodes);
    }

    @Override
    public Location readLocation(InforContext context, String locationCode) throws InforException {
        MP0318_GetLocation_001 getLocation = new MP0318_GetLocation_001();
        getLocation.setLOCATIONID(new LOCATIONID_Type());
        getLocation.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        getLocation.getLOCATIONID().setLOCATIONCODE(locationCode);
        MP0318_GetLocation_001_Result getLocationResult = new MP0318_GetLocation_001_Result();
        getLocationResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getLocationOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getLocation);
        net.datastream.schemas.mp_entities.location_001.Location locationInfor = getLocationResult.getResultData().getLocation();
        Location location = this.tools.getInforFieldTools().transformInforObject(new Location(), locationInfor);
        if (locationInfor.getParentLocationID() != null) {
            location.setHierarchyLocationCode(locationInfor.getParentLocationID().getLOCATIONCODE());
        }
        return location;
    }

    @Override
    public String createLocation(InforContext context, Location locationParam) throws InforException {
        net.datastream.schemas.mp_entities.location_001.Location locationInfor = new net.datastream.schemas.mp_entities.location_001.Location();
        locationInfor.setLOCATIONID(new LOCATIONID_Type());
        locationInfor.getLOCATIONID().setLOCATIONCODE(locationParam.getCode());
        locationInfor.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        locationInfor.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(locationInfor.getCLASSID()), locationInfor.getUSERDEFINEDAREA(), locationParam.getClassCode(), "LOC"));
        this.tools.getInforFieldTools().transformWSHubObject(locationInfor, locationParam, context);
        if (locationParam.getHierarchyLocationCode() != null) {
            locationInfor.setLocationParentHierarchy(this.getLocationParentHierarchy(context, locationParam));
        }
        MP0317_AddLocation_001 addLocation = new MP0317_AddLocation_001();
        addLocation.setLocation(locationInfor);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addLocationOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addLocation);
        return locationInfor.getLOCATIONID().getLOCATIONCODE();
    }

    @Override
    public String updateLocation(InforContext context, Location locationParam) throws InforException {
        MP0318_GetLocation_001 getLocation = new MP0318_GetLocation_001();
        getLocation.setLOCATIONID(new LOCATIONID_Type());
        getLocation.getLOCATIONID().setLOCATIONCODE(locationParam.getCode());
        getLocation.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        MP0318_GetLocation_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getLocationOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getLocation);
        net.datastream.schemas.mp_entities.location_001.Location locationInfor = result.getResultData().getLocation();
        locationInfor.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(locationInfor.getCLASSID()), locationInfor.getUSERDEFINEDAREA(), locationParam.getClassCode(), "LOC"));
        if (locationParam.getHierarchyLocationCode() == null) {
            locationParam.setHierarchyLocationCode(DataTypeTools.toCodeString(locationInfor.getParentLocationID()));
        }
        if (locationParam.getHierarchyLocationCode() != null && !locationParam.getHierarchyLocationCode().equals("")) {
            locationInfor.setLocationParentHierarchy(this.getLocationParentHierarchy(context, locationParam));
        }
        locationInfor.setParentLocationID(null);
        this.tools.getInforFieldTools().transformWSHubObject(locationInfor, locationParam, context);
        MP0319_SyncLocation_001 syncLocation = new MP0319_SyncLocation_001();
        syncLocation.setLocation(locationInfor);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncLocationOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncLocation);
        return locationInfor.getLOCATIONID().getLOCATIONCODE();
    }

    @Override
    public String deleteLocation(InforContext context, String locationCode) throws InforException {
        MP0320_DeleteLocation_001 deleteLocation = new MP0320_DeleteLocation_001();
        deleteLocation.setLOCATIONID(new LOCATIONID_Type());
        deleteLocation.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        deleteLocation.getLOCATIONID().setLOCATIONCODE(locationCode);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteLocationOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteLocation);
        return locationCode;
    }

    private LocationParentHierarchy getLocationParentHierarchy(InforContext context, String locationCode) throws InforException {
        MP0361_GetLocationParentHierarchy_001 getLocationParentHierarchy = new MP0361_GetLocationParentHierarchy_001();
        getLocationParentHierarchy.setLOCATIONID(new LOCATIONID_Type());
        getLocationParentHierarchy.getLOCATIONID().setLOCATIONCODE(locationCode);
        getLocationParentHierarchy.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        MP0361_GetLocationParentHierarchy_001_Result getLocationParentHierarchyResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getLocationParentHierarchyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getLocationParentHierarchy);
        return getLocationParentHierarchyResult.getResultData().getLocationParentHierarchy();
    }

    private LocationParentHierarchy getLocationParentHierarchy(InforContext context, Location location) {
        if (location.getHierarchyLocationCode() == null) {
            return null;
        }
        LocationParentHierarchy locationParentHierarchy = new LocationParentHierarchy();
        TYPE_Type lType = new TYPE_Type();
        lType.setTYPECODE("L");
        lType.setDESCRIPTION("Localisation");
        locationParentHierarchy.setLOCATIONID(new LOCATIONID_Type());
        locationParentHierarchy.getLOCATIONID().setLOCATIONCODE(location.getCode());
        locationParentHierarchy.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        locationParentHierarchy.setTYPE(lType);
        ParentLocation parentLocation = new ParentLocation();
        parentLocation.setTYPE(lType);
        parentLocation.setLOCATIONID(new LOCATIONID_Type());
        parentLocation.getLOCATIONID().setLOCATIONCODE(location.getHierarchyLocationCode());
        parentLocation.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        parentLocation.setDEPARTMENTID(new DEPARTMENTID_Type());
        parentLocation.getDEPARTMENTID().setDEPARTMENTCODE("*");
        parentLocation.getDEPARTMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
        locationParentHierarchy.setParentLocation(parentLocation);
        return locationParentHierarchy;
    }
}

