/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.annotations.BooleanType;
import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.equipment.AssetService;
import ch.cern.eam.wshub.core.services.equipment.entities.Equipment;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import net.datastream.schemas.mp_entities.assetequipment_001.AssetDependency;
import net.datastream.schemas.mp_entities.assetequipment_001.AssetEquipment;
import net.datastream.schemas.mp_entities.assetequipment_001.AssetParentHierarchy;
import net.datastream.schemas.mp_entities.assetequipment_001.LocationDependency;
import net.datastream.schemas.mp_entities.assetequipment_001.NonDependentParents_Type;
import net.datastream.schemas.mp_entities.assetequipment_001.PositionDependency;
import net.datastream.schemas.mp_entities.assetequipment_001.PrimarySystemDependency;
import net.datastream.schemas.mp_entities.assetequipment_001.SystemDependency;
import net.datastream.schemas.mp_fields.ASSETPARENT_Type;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.LOCATIONID_Type;
import net.datastream.schemas.mp_fields.LOCATIONPARENT_Type;
import net.datastream.schemas.mp_fields.ORGANIZATIONID_Type;
import net.datastream.schemas.mp_fields.POSITIONPARENT_Type;
import net.datastream.schemas.mp_fields.SYSTEMPARENT_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_functions.mp0301_001.MP0301_AddAssetEquipment_001;
import net.datastream.schemas.mp_functions.mp0302_001.MP0302_GetAssetEquipment_001;
import net.datastream.schemas.mp_functions.mp0303_001.MP0303_SyncAssetEquipment_001;
import net.datastream.schemas.mp_functions.mp0304_001.MP0304_DeleteAssetEquipment_001;
import net.datastream.schemas.mp_functions.mp0305_001.MP0305_GetAssetEquipmentDefault_001;
import net.datastream.schemas.mp_functions.mp0327_001.MP0327_GetAssetParentHierarchy_001;
import net.datastream.schemas.mp_results.mp0301_001.MP0301_AddAssetEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0302_001.MP0302_GetAssetEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0305_001.MP0305_GetAssetEquipmentDefault_001_Result;
import net.datastream.schemas.mp_results.mp0327_001.MP0327_GetAssetParentHierarchy_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class AssetServiceImpl
implements AssetService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public AssetServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public Equipment readAssetDefault(InforContext context, String organization) throws InforException {
        MP0305_GetAssetEquipmentDefault_001 getAssetEquipmentDefault_001 = new MP0305_GetAssetEquipmentDefault_001();
        if (DataTypeTools.isEmpty(organization)) {
            getAssetEquipmentDefault_001.setORGANIZATIONID(this.tools.getOrganization(context));
        } else {
            getAssetEquipmentDefault_001.setORGANIZATIONID(new ORGANIZATIONID_Type());
            getAssetEquipmentDefault_001.getORGANIZATIONID().setORGANIZATIONCODE(organization);
        }
        MP0305_GetAssetEquipmentDefault_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getAssetEquipmentDefaultOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getAssetEquipmentDefault_001);
        return this.tools.getInforFieldTools().transformInforObject(new Equipment(), result.getResultData().getAssetEquipment());
    }

    @Override
    public Equipment readAsset(InforContext context, String assetCode) throws InforException {
        AssetEquipment assetEquipment = this.readInforAsset(context, assetCode);
        Equipment asset = this.tools.getInforFieldTools().transformInforObject(new Equipment(), assetEquipment);
        asset.setSystemTypeCode("A");
        if (assetEquipment.getASSETID() != null) {
            asset.setCode(assetEquipment.getASSETID().getEQUIPMENTCODE());
            asset.setDescription(assetEquipment.getASSETID().getDESCRIPTION());
        }
        this.tools.processRunnables(() -> asset.setManufacturerDesc(this.tools.getFieldDescriptionsTools().readManufacturerDesc(context, asset.getManufacturerCode())), () -> asset.setBinDesc(this.tools.getFieldDescriptionsTools().readBinDesc(context, asset.getStoreCode(), asset.getBin())));
        assetEquipment.setAssetParentHierarchy(this.readInforAssetHierarchy(context, assetCode));
        if (assetEquipment.getAssetParentHierarchy().getLOCATIONID() != null) {
            asset.setHierarchyLocationCode(assetEquipment.getAssetParentHierarchy().getLOCATIONID().getLOCATIONCODE());
            asset.setHierarchyLocationDesc(assetEquipment.getAssetParentHierarchy().getLOCATIONID().getDESCRIPTION());
        }
        if (assetEquipment.getAssetParentHierarchy().getPositionDependency() != null) {
            PositionDependency positionDep = assetEquipment.getAssetParentHierarchy().getPositionDependency();
            asset.setHierarchyPositionCode(positionDep.getDEPENDENTPOSITION().getPOSITIONID().getEQUIPMENTCODE());
            asset.setHierarchyPositionDesc(positionDep.getDEPENDENTPOSITION().getPOSITIONID().getDESCRIPTION());
            asset.setHierarchyPositionDependent(true);
            asset.setHierarchyPositionCostRollUp(DataTypeTools.decodeBoolean(positionDep.getDEPENDENTPOSITION().getCOSTROLLUP()));
            if (positionDep.getNONDEPENDENTASSET() != null) {
                asset.setHierarchyAssetCode(positionDep.getNONDEPENDENTASSET().getASSETID().getEQUIPMENTCODE());
                asset.setHierarchyAssetDesc(positionDep.getNONDEPENDENTASSET().getASSETID().getDESCRIPTION());
                asset.setHierarchyAssetCostRollUp(DataTypeTools.decodeBoolean(positionDep.getNONDEPENDENTASSET().getCOSTROLLUP()));
                asset.setHierarchyAssetDependent(false);
            }
            if (positionDep.getNONDEPENDENTPRIMARYSYSTEM() != null) {
                asset.setHierarchyPrimarySystemCode(positionDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
                asset.setHierarchyPrimarySystemDesc(positionDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
                asset.setHierarchyPrimarySystemCostRollUp(DataTypeTools.decodeBoolean(positionDep.getNONDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP()));
                asset.setHierarchyPrimarySystemDependent(false);
            }
        } else if (assetEquipment.getAssetParentHierarchy().getAssetDependency() != null) {
            AssetDependency assetDep = assetEquipment.getAssetParentHierarchy().getAssetDependency();
            asset.setHierarchyAssetCode(assetDep.getDEPENDENTASSET().getASSETID().getEQUIPMENTCODE());
            asset.setHierarchyAssetDesc(assetDep.getDEPENDENTASSET().getASSETID().getDESCRIPTION());
            asset.setHierarchyAssetCostRollUp(DataTypeTools.decodeBoolean(assetDep.getDEPENDENTASSET().getCOSTROLLUP()));
            asset.setHierarchyAssetDependent(true);
            if (assetDep.getNONDEPENDENTPOSITION() != null) {
                asset.setHierarchyPositionCode(assetDep.getNONDEPENDENTPOSITION().getPOSITIONID().getEQUIPMENTCODE());
                asset.setHierarchyPositionDesc(assetDep.getNONDEPENDENTPOSITION().getPOSITIONID().getDESCRIPTION());
                asset.setHierarchyPositionDependent(false);
                asset.setHierarchyPositionCostRollUp(DataTypeTools.decodeBoolean(assetDep.getNONDEPENDENTPOSITION().getCOSTROLLUP()));
            }
            if (assetDep.getNONDEPENDENTPRIMARYSYSTEM() != null) {
                asset.setHierarchyPrimarySystemCode(assetDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
                asset.setHierarchyPrimarySystemDesc(assetDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
                asset.setHierarchyPrimarySystemCostRollUp(DataTypeTools.decodeBoolean(assetDep.getNONDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP()));
                asset.setHierarchyPrimarySystemDependent(false);
            }
        } else if (assetEquipment.getAssetParentHierarchy().getSystemDependency() != null) {
            SystemDependency systemDep = assetEquipment.getAssetParentHierarchy().getSystemDependency();
            asset.setHierarchySystemCode(systemDep.getDEPENDENTSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
            asset.setHierarchySystemDesc(systemDep.getDEPENDENTSYSTEM().getSYSTEMID().getDESCRIPTION());
            asset.setHierarchySystemCostRollUp(DataTypeTools.decodeBoolean(systemDep.getDEPENDENTSYSTEM().getCOSTROLLUP()));
            asset.setHierarchySystemDependent(true);
            if (systemDep.getNONDEPENDENTPOSITION() != null) {
                asset.setHierarchyPositionCode(systemDep.getNONDEPENDENTPOSITION().getPOSITIONID().getEQUIPMENTCODE());
                asset.setHierarchyPositionDesc(systemDep.getNONDEPENDENTPOSITION().getPOSITIONID().getDESCRIPTION());
                asset.setHierarchyPositionDependent(false);
                asset.setHierarchyPositionCostRollUp(DataTypeTools.decodeBoolean(systemDep.getNONDEPENDENTPOSITION().getCOSTROLLUP()));
            }
            if (systemDep.getNONDEPENDENTASSET() != null) {
                asset.setHierarchyAssetCode(systemDep.getNONDEPENDENTASSET().getASSETID().getEQUIPMENTCODE());
                asset.setHierarchyAssetDesc(systemDep.getNONDEPENDENTASSET().getASSETID().getDESCRIPTION());
                asset.setHierarchyAssetCostRollUp(DataTypeTools.decodeBoolean(systemDep.getNONDEPENDENTASSET().getCOSTROLLUP()));
                asset.setHierarchyAssetDependent(false);
            }
            if (systemDep.getNONDEPENDENTPRIMARYSYSTEM() != null) {
                asset.setHierarchyPrimarySystemCode(systemDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
                asset.setHierarchyPrimarySystemDesc(systemDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
                asset.setHierarchyPrimarySystemCostRollUp(DataTypeTools.decodeBoolean(systemDep.getNONDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP()));
                asset.setHierarchyPrimarySystemDependent(false);
            }
        } else if (assetEquipment.getAssetParentHierarchy().getPrimarySystemDependency() != null) {
            PrimarySystemDependency primarySystemDependency = assetEquipment.getAssetParentHierarchy().getPrimarySystemDependency();
            asset.setHierarchyPrimarySystemCode(primarySystemDependency.getDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
            asset.setHierarchyPrimarySystemDesc(primarySystemDependency.getDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
            asset.setHierarchyPrimarySystemCostRollUp(DataTypeTools.decodeBoolean(primarySystemDependency.getDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP()));
            asset.setHierarchyPrimarySystemDependent(true);
            if (primarySystemDependency.getNONDEPENDENTPOSITION() != null) {
                asset.setHierarchyPositionCode(primarySystemDependency.getNONDEPENDENTPOSITION().getPOSITIONID().getEQUIPMENTCODE());
                asset.setHierarchyPositionDesc(primarySystemDependency.getNONDEPENDENTPOSITION().getPOSITIONID().getDESCRIPTION());
                asset.setHierarchyPositionDependent(false);
                asset.setHierarchyPositionCostRollUp(DataTypeTools.decodeBoolean(primarySystemDependency.getNONDEPENDENTPOSITION().getCOSTROLLUP()));
            }
            if (primarySystemDependency.getNONDEPENDENTASSET() != null) {
                asset.setHierarchyAssetCode(primarySystemDependency.getNONDEPENDENTASSET().getASSETID().getEQUIPMENTCODE());
                asset.setHierarchyAssetDesc(primarySystemDependency.getNONDEPENDENTASSET().getASSETID().getDESCRIPTION());
                asset.setHierarchyAssetCostRollUp(DataTypeTools.decodeBoolean(primarySystemDependency.getNONDEPENDENTASSET().getCOSTROLLUP()));
                asset.setHierarchyAssetDependent(false);
            }
        } else if (assetEquipment.getAssetParentHierarchy().getNonDependentParents() != null) {
            NonDependentParents_Type nonDepParents = assetEquipment.getAssetParentHierarchy().getNonDependentParents();
            if (nonDepParents.getNONDEPENDENTASSET() != null) {
                asset.setHierarchyAssetCode(nonDepParents.getNONDEPENDENTASSET().getASSETID().getEQUIPMENTCODE());
                asset.setHierarchyAssetDesc(nonDepParents.getNONDEPENDENTASSET().getASSETID().getDESCRIPTION());
                asset.setHierarchyAssetCostRollUp(DataTypeTools.decodeBoolean(nonDepParents.getNONDEPENDENTASSET().getCOSTROLLUP()));
                asset.setHierarchyAssetDependent(false);
            }
            if (nonDepParents.getNONDEPENDENTPOSITION() != null) {
                asset.setHierarchyPositionCode(nonDepParents.getNONDEPENDENTPOSITION().getPOSITIONID().getEQUIPMENTCODE());
                asset.setHierarchyPositionDesc(nonDepParents.getNONDEPENDENTPOSITION().getPOSITIONID().getDESCRIPTION());
                asset.setHierarchyPositionDependent(false);
                asset.setHierarchyPositionCostRollUp(DataTypeTools.decodeBoolean(nonDepParents.getNONDEPENDENTPOSITION().getCOSTROLLUP()));
            }
            if (nonDepParents.getNONDEPENDENTPRIMARYSYSTEM() != null) {
                asset.setHierarchyPrimarySystemCode(nonDepParents.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
                asset.setHierarchyPrimarySystemDesc(nonDepParents.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
                asset.setHierarchyPrimarySystemCostRollUp(DataTypeTools.decodeBoolean(nonDepParents.getNONDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP()));
                asset.setHierarchyPrimarySystemDependent(false);
            }
        } else if (assetEquipment.getAssetParentHierarchy().getLocationDependency() != null) {
            LocationDependency locationDep = assetEquipment.getAssetParentHierarchy().getLocationDependency();
            asset.setHierarchyLocationCode(locationDep.getDEPENDENTLOCATION().getLOCATIONID().getLOCATIONCODE());
            asset.setHierarchyLocationDesc(locationDep.getDEPENDENTLOCATION().getLOCATIONID().getDESCRIPTION());
            if (locationDep.getNONDEPENDENTASSET() != null) {
                asset.setHierarchyAssetCode(locationDep.getNONDEPENDENTASSET().getASSETID().getEQUIPMENTCODE());
                asset.setHierarchyAssetDesc(locationDep.getNONDEPENDENTASSET().getASSETID().getDESCRIPTION());
                asset.setHierarchyAssetCostRollUp(DataTypeTools.decodeBoolean(locationDep.getNONDEPENDENTASSET().getCOSTROLLUP()));
                asset.setHierarchyAssetDependent(false);
            }
            if (locationDep.getNONDEPENDENTPOSITION() != null) {
                asset.setHierarchyPositionCode(locationDep.getNONDEPENDENTPOSITION().getPOSITIONID().getEQUIPMENTCODE());
                asset.setHierarchyPositionDesc(locationDep.getNONDEPENDENTPOSITION().getPOSITIONID().getDESCRIPTION());
                asset.setHierarchyPositionDependent(false);
                asset.setHierarchyPositionCostRollUp(DataTypeTools.decodeBoolean(locationDep.getNONDEPENDENTPOSITION().getCOSTROLLUP()));
            }
            if (locationDep.getNONDEPENDENTPRIMARYSYSTEM() != null) {
                asset.setHierarchyPrimarySystemCode(locationDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
                asset.setHierarchyPrimarySystemDesc(locationDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
                asset.setHierarchyPrimarySystemCostRollUp(DataTypeTools.decodeBoolean(locationDep.getNONDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP()));
                asset.setHierarchyPrimarySystemDependent(false);
            }
        }
        return asset;
    }

    private AssetParentHierarchy readInforAssetHierarchy(InforContext context, String assetCode) throws InforException {
        MP0327_GetAssetParentHierarchy_001 getassetph = new MP0327_GetAssetParentHierarchy_001();
        getassetph.setASSETID(new EQUIPMENTID_Type());
        getassetph.getASSETID().setORGANIZATIONID(this.tools.getOrganization(context));
        getassetph.getASSETID().setEQUIPMENTCODE(assetCode);
        MP0327_GetAssetParentHierarchy_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getAssetParentHierarchyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getassetph);
        return result.getResultData().getAssetParentHierarchy();
    }

    private AssetEquipment readInforAsset(InforContext context, String assetCode) throws InforException {
        MP0302_GetAssetEquipment_001 getAsset = new MP0302_GetAssetEquipment_001();
        getAsset.setASSETID(new EQUIPMENTID_Type());
        getAsset.getASSETID().setORGANIZATIONID(this.tools.getOrganization(context));
        getAsset.getASSETID().setEQUIPMENTCODE(assetCode);
        MP0302_GetAssetEquipment_001_Result getAssetResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getAssetEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getAsset);
        return getAssetResult.getResultData().getAssetEquipment();
    }

    private void updateInforAsset(InforContext context, AssetEquipment assetEquipment) throws InforException {
        MP0303_SyncAssetEquipment_001 syncAsset = new MP0303_SyncAssetEquipment_001();
        syncAsset.setAssetEquipment(assetEquipment);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncAssetEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncAsset);
    }

    @Override
    public String updateAsset(InforContext context, Equipment assetParam) throws InforException {
        AssetEquipment assetEquipment = this.readInforAsset(context, assetParam.getCode());
        assetEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(assetEquipment.getCLASSID()), assetEquipment.getUSERDEFINEDAREA(), assetParam.getClassCode(), "OBJ"));
        this.initializeAssetObject(assetEquipment, assetParam, context);
        this.tools.getInforFieldTools().transformWSHubObject(assetEquipment, assetParam, context);
        if (assetParam.getPartCode() != null && assetParam.getPartCode().equals("") && assetEquipment.getPartAssociation() != null) {
            assetEquipment.getPartAssociation().setSTORELOCATION(null);
            assetEquipment.getPartAssociation().getPARTID().getORGANIZATIONID().setORGANIZATIONCODE("");
        }
        this.updateInforAsset(context, assetEquipment);
        return assetParam.getCode();
    }

    @Override
    public String createAsset(InforContext context, Equipment assetParam) throws InforException {
        AssetEquipment assetEquipment = new AssetEquipment();
        assetEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(assetEquipment.getCLASSID()), assetEquipment.getUSERDEFINEDAREA(), assetParam.getClassCode(), "OBJ"));
        this.initializeAssetObject(assetEquipment, assetParam, context);
        this.tools.getInforFieldTools().transformWSHubObject(assetEquipment, assetParam, context);
        MP0301_AddAssetEquipment_001 addAsset = new MP0301_AddAssetEquipment_001();
        addAsset.setAssetEquipment(assetEquipment);
        MP0301_AddAssetEquipment_001_Result addAssetResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addAssetEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addAsset);
        return addAssetResult.getResultData().getASSETID().getEQUIPMENTCODE();
    }

    @Override
    public String deleteAsset(InforContext context, String assetCode) throws InforException {
        MP0304_DeleteAssetEquipment_001 deleteAsset = new MP0304_DeleteAssetEquipment_001();
        deleteAsset.setASSETID(new EQUIPMENTID_Type());
        deleteAsset.getASSETID().setORGANIZATIONID(this.tools.getOrganization(context));
        deleteAsset.getASSETID().setEQUIPMENTCODE(assetCode);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteAssetEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteAsset);
        return assetCode;
    }

    private void initializeAssetObject(AssetEquipment assetInfor, Equipment assetParam, InforContext context) throws InforException {
        if (assetInfor.getASSETID() == null) {
            assetInfor.setASSETID(new EQUIPMENTID_Type());
            assetInfor.getASSETID().setORGANIZATIONID(this.tools.getOrganization(context));
            assetInfor.getASSETID().setEQUIPMENTCODE(assetParam.getCode().toUpperCase().trim());
        }
        if (assetParam.getDescription() != null) {
            assetInfor.getASSETID().setDESCRIPTION(assetParam.getDescription());
        }
        if (assetParam.getHierarchyAssetCode() != null || assetParam.getHierarchyPositionCode() != null || assetParam.getHierarchyPrimarySystemCode() != null || assetParam.getHierarchyLocationCode() != null) {
            this.initializeAssetHierarchy(assetInfor, assetParam, context);
        } else {
            assetInfor.setAssetParentHierarchy(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initializeAssetHierarchy(AssetEquipment assetInfor, Equipment assetParam, InforContext context) {
        block17: {
            block18: {
                block16: {
                    assetParentHierarchy = new AssetParentHierarchy();
                    assetParentHierarchy.setASSETID(new EQUIPMENTID_Type());
                    assetParentHierarchy.getASSETID().setORGANIZATIONID(this.tools.getOrganization(context));
                    assetParentHierarchy.getASSETID().setEQUIPMENTCODE(assetParam.getCode());
                    assetParentHierarchy.setTYPE(new TYPE_Type());
                    assetParentHierarchy.getTYPE().setTYPECODE(assetParam.getTypeCode());
                    hierarchyAsset = new EQUIPMENTID_Type();
                    hierarchyAsset.setORGANIZATIONID(this.tools.getOrganization(context));
                    hierarchyAsset.setEQUIPMENTCODE(assetParam.getHierarchyAssetCode());
                    hierarchyPosition = new EQUIPMENTID_Type();
                    hierarchyPosition.setORGANIZATIONID(this.tools.getOrganization(context));
                    hierarchyPosition.setEQUIPMENTCODE(assetParam.getHierarchyPositionCode());
                    hierarchySystem = new EQUIPMENTID_Type();
                    hierarchySystem.setORGANIZATIONID(this.tools.getOrganization(context));
                    hierarchySystem.setEQUIPMENTCODE(assetParam.getHierarchyPrimarySystemCode());
                    if (assetParam.getHierarchyAssetDependent() == null || !assetParam.getHierarchyAssetDependent().booleanValue()) break block16;
                    this.tools.getDataTypeTools();
                    if (!DataTypeTools.isNotEmpty(assetParam.getHierarchyAssetCode())) break block16;
                    assetParentHierarchy.setAssetDependency(new AssetDependency());
                    this.tools.getDataTypeTools();
                    if (DataTypeTools.isNotEmpty(assetParam.getHierarchyPositionCode())) {
                        assetParentHierarchy.getAssetDependency().setNONDEPENDENTPOSITION(this.createHierarchyPosition(assetParam, hierarchyPosition));
                    }
                    this.tools.getDataTypeTools();
                    if (DataTypeTools.isNotEmpty(assetParam.getHierarchyPrimarySystemCode())) {
                        assetParentHierarchy.getAssetDependency().setNONDEPENDENTPRIMARYSYSTEM(this.createHierarchyPrymarySystem(assetParam, hierarchySystem));
                    }
                    assetParentHierarchy.getAssetDependency().setDEPENDENTASSET(this.createHierarchyAsset(assetParam, hierarchyAsset));
                    break block17;
                }
                if (assetParam.getHierarchyPositionDependent() == null || !assetParam.getHierarchyPositionDependent().booleanValue()) break block18;
                this.tools.getDataTypeTools();
                if (!DataTypeTools.isNotEmpty(assetParam.getHierarchyPositionCode())) break block18;
                assetParentHierarchy.setPositionDependency(new PositionDependency());
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(assetParam.getHierarchyAssetCode())) {
                    assetParentHierarchy.getPositionDependency().setNONDEPENDENTASSET(this.createHierarchyAsset(assetParam, hierarchyAsset));
                }
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(assetParam.getHierarchyPrimarySystemCode())) {
                    assetParentHierarchy.getPositionDependency().setNONDEPENDENTPRIMARYSYSTEM(this.createHierarchyPrymarySystem(assetParam, hierarchySystem));
                }
                assetParentHierarchy.getPositionDependency().setDEPENDENTPOSITION(this.createHierarchyPosition(assetParam, hierarchyPosition));
                break block17;
            }
            if (assetParam.getHierarchyPrimarySystemDependent() == null || !assetParam.getHierarchyPrimarySystemDependent().booleanValue()) ** GOTO lbl-1000
            this.tools.getDataTypeTools();
            if (DataTypeTools.isNotEmpty(assetParam.getHierarchyPrimarySystemCode())) {
                assetParentHierarchy.setPrimarySystemDependency(new PrimarySystemDependency());
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(assetParam.getHierarchyPositionCode())) {
                    assetParentHierarchy.getPrimarySystemDependency().setNONDEPENDENTPOSITION(this.createHierarchyPosition(assetParam, hierarchyPosition));
                }
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(assetParam.getHierarchyAssetCode())) {
                    assetParentHierarchy.getPrimarySystemDependency().setNONDEPENDENTASSET(this.createHierarchyAsset(assetParam, hierarchyAsset));
                }
                assetParentHierarchy.getPrimarySystemDependency().setDEPENDENTPRIMARYSYSTEM(this.createHierarchyPrymarySystem(assetParam, hierarchySystem));
            } else lbl-1000:
            // 2 sources

            {
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(assetParam.getHierarchyLocationCode())) {
                    assetParentHierarchy.setLocationDependency(new LocationDependency());
                    assetParentHierarchy.getLocationDependency().setDEPENDENTLOCATION(new LOCATIONPARENT_Type());
                    assetParentHierarchy.getLocationDependency().getDEPENDENTLOCATION().setLOCATIONID(new LOCATIONID_Type());
                    assetParentHierarchy.getLocationDependency().getDEPENDENTLOCATION().getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
                    assetParentHierarchy.getLocationDependency().getDEPENDENTLOCATION().getLOCATIONID().setLOCATIONCODE(assetParam.getHierarchyLocationCode());
                    this.tools.getDataTypeTools();
                    if (DataTypeTools.isNotEmpty(assetParam.getHierarchyPositionCode())) {
                        assetParentHierarchy.getLocationDependency().setNONDEPENDENTPOSITION(this.createHierarchyPosition(assetParam, hierarchyPosition));
                    }
                    this.tools.getDataTypeTools();
                    if (DataTypeTools.isNotEmpty(assetParam.getHierarchyAssetCode())) {
                        assetParentHierarchy.getLocationDependency().setNONDEPENDENTASSET(this.createHierarchyAsset(assetParam, hierarchyAsset));
                    }
                    this.tools.getDataTypeTools();
                    if (DataTypeTools.isNotEmpty(assetParam.getHierarchyPrimarySystemCode())) {
                        assetParentHierarchy.getLocationDependency().setNONDEPENDENTPRIMARYSYSTEM(this.createHierarchyPrymarySystem(assetParam, hierarchySystem));
                    }
                } else {
                    assetParentHierarchy.setNonDependentParents(new NonDependentParents_Type());
                    this.tools.getDataTypeTools();
                    if (DataTypeTools.isNotEmpty(assetParam.getHierarchyPositionCode())) {
                        assetParentHierarchy.getNonDependentParents().setNONDEPENDENTPOSITION(this.createHierarchyPosition(assetParam, hierarchyPosition));
                    }
                    this.tools.getDataTypeTools();
                    if (DataTypeTools.isNotEmpty(assetParam.getHierarchyAssetCode())) {
                        assetParentHierarchy.getNonDependentParents().setNONDEPENDENTASSET(this.createHierarchyAsset(assetParam, hierarchyAsset));
                    }
                    this.tools.getDataTypeTools();
                    if (DataTypeTools.isNotEmpty(assetParam.getHierarchyPrimarySystemCode())) {
                        assetParentHierarchy.getNonDependentParents().setNONDEPENDENTPRIMARYSYSTEM(this.createHierarchyPrymarySystem(assetParam, hierarchySystem));
                    }
                }
            }
        }
        assetInfor.setAssetParentHierarchy(assetParentHierarchy);
    }

    private ASSETPARENT_Type createHierarchyAsset(Equipment assetParam, EQUIPMENTID_Type hierarchyAsset) {
        ASSETPARENT_Type assetType = new ASSETPARENT_Type();
        assetType.setASSETID(hierarchyAsset);
        assetType.setCOSTROLLUP(DataTypeTools.encodeBoolean(assetParam.getHierarchyAssetCostRollUp(), BooleanType.TRUE_FALSE));
        return assetType;
    }

    private POSITIONPARENT_Type createHierarchyPosition(Equipment assetParam, EQUIPMENTID_Type hierarchyPosition) {
        POSITIONPARENT_Type positionType = new POSITIONPARENT_Type();
        positionType.setPOSITIONID(hierarchyPosition);
        positionType.setCOSTROLLUP(DataTypeTools.encodeBoolean(assetParam.getHierarchyPositionCostRollUp(), BooleanType.TRUE_FALSE));
        return positionType;
    }

    private SYSTEMPARENT_Type createHierarchyPrymarySystem(Equipment assetParam, EQUIPMENTID_Type hierarchySystem) {
        SYSTEMPARENT_Type systemType = new SYSTEMPARENT_Type();
        systemType.setSYSTEMID(hierarchySystem);
        systemType.setCOSTROLLUP(DataTypeTools.encodeBoolean(assetParam.getHierarchyPrimarySystemCostRollUp(), BooleanType.TRUE_FALSE));
        return systemType;
    }
}

