/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.userdefinedscreens.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedTableQueries;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedTableService;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedTableValidator;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDTRow;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class UserDefinedTableServiceImpl
implements UserDefinedTableService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private EntityManager entityManager;

    public UserDefinedTableServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        if (tools.isDatabaseConnectionConfigured()) {
            this.entityManager = tools.getEntityManager();
        }
    }

    @Override
    public String createUserDefinedTableRows(InforContext context, String tableName, List<UDTRow> rows) throws InforException {
        this.tools.demandDatabaseConnection();
        UserDefinedTableValidator.validateOperation(tableName, rows);
        this.entityManager.joinTransaction();
        for (UDTRow row : rows) {
            Map<String, Object> parameters = this.getUDTRowAsMap(row);
            parameters.putAll(UserDefinedTableServiceImpl.getDefaultInsertColumns(context.getCredentials().getUsername()));
            UserDefinedTableQueries.executeInsertQuery(tableName.toUpperCase(), parameters, this.entityManager);
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> readUserDefinedTableRows(InforContext context, String tableName, UDTRow filters, List<String> fieldsToRead) throws InforException {
        this.tools.demandDatabaseConnection();
        UserDefinedTableValidator.validateOperation(tableName, null, filters);
        UserDefinedTableValidator.validateKeyList(fieldsToRead, false);
        Map<String, Object> parameters = this.getUDTRowAsMap(filters);
        Map<String, Class<?>> columnTypes = UserDefinedTableQueries.getColumnTypes(tableName.toUpperCase(), this.entityManager);
        if (fieldsToRead.size() == 0) {
            fieldsToRead = new ArrayList<String>(columnTypes.keySet());
        }
        Long maxRows = this.applicationData.getQueryMaxNumberOfRows();
        List<Map<String, Object>> maps = UserDefinedTableQueries.executeReadQuery(tableName.toUpperCase(), parameters, fieldsToRead, maxRows, this.entityManager);
        return maps;
    }

    @Override
    public int updateUserDefinedTableRows(InforContext context, String tableName, UDTRow fieldsToUpdate, UDTRow filters) throws InforException {
        this.tools.demandDatabaseConnection();
        this.entityManager.joinTransaction();
        UserDefinedTableValidator.validateOperation(tableName, fieldsToUpdate, filters);
        Map<String, Object> updateMapMap = this.getUDTRowAsMap(fieldsToUpdate);
        Map<String, Object> whereMap = this.getUDTRowAsMap(filters);
        updateMapMap.putAll(UserDefinedTableServiceImpl.getDefaultUpdateColumns(context.getCredentials().getUsername()));
        return UserDefinedTableQueries.executeUpdateQuery(tableName, updateMapMap, whereMap, this.entityManager);
    }

    @Override
    public int deleteUserDefinedTableRows(InforContext context, String tableName, UDTRow filters) throws InforException {
        this.tools.demandDatabaseConnection();
        this.entityManager.joinTransaction();
        UserDefinedTableValidator.validateOperation(tableName, null, filters);
        Map<String, Object> filterMap = this.getUDTRowAsMap(filters);
        return UserDefinedTableQueries.executeDeleteQuery(tableName, filterMap, this.entityManager);
    }

    @Override
    public List<UDTRow> getMapsAsUDTRows(String tableName, List<Map<String, Object>> mapRows) throws InforException {
        ArrayList<UDTRow> udtRowList = new ArrayList<UDTRow>();
        for (Map<String, Object> row : mapRows) {
            UDTRow udtRow = this.getMapAsUDTRow(tableName, row);
            udtRowList.add(udtRow);
        }
        return udtRowList;
    }

    @Override
    public UDTRow getMapAsUDTRow(String tableName, Map<String, Object> mapRow) throws InforException {
        Map<String, Class<?>> columnTypes = UserDefinedTableQueries.getColumnTypes(tableName, this.entityManager);
        UDTRow newRow = new UDTRow();
        for (Map.Entry<String, Object> entry : mapRow.entrySet()) {
            Class clazz;
            String key = entry.getKey();
            Object value = entry.getValue();
            Optional<Map.Entry> first = columnTypes.entrySet().stream().filter(type -> ((String)type.getKey()).equals(entry.getKey())).findFirst();
            Class clazz2 = clazz = first.isPresent() ? (Class)first.get().getValue() : String.class;
            if (Date.class.equals((Object)clazz)) {
                newRow.addDate(key, value != null ? (Date)value : null);
            }
            if (BigInteger.class.equals((Object)clazz)) {
                newRow.addInteger(key, value != null ? (BigInteger)value : null);
            }
            if (BigDecimal.class.equals((Object)clazz)) {
                newRow.addDecimal(key, value != null ? (BigDecimal)value : null);
            }
            if (!String.class.equals((Object)clazz)) continue;
            newRow.addString(key, value != null ? (String)value : null);
        }
        return newRow;
    }

    @Override
    public List<Map<String, Object>> getUDTRowsAsMaps(List<UDTRow> rows) {
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
        for (UDTRow row : rows) {
            Map<String, Object> udtRowAsMap = this.getUDTRowAsMap(row);
            rowList.add(udtRowAsMap);
        }
        return rowList;
    }

    @Override
    public Map<String, Object> getUDTRowAsMap(UDTRow row) {
        LinkedHashMap<String, Object> mapa = new LinkedHashMap<String, Object>();
        mapa.putAll(UserDefinedTableServiceImpl.upperMap(row.getDates()));
        mapa.putAll(UserDefinedTableServiceImpl.upperMap(row.getStrings()));
        mapa.putAll(UserDefinedTableServiceImpl.upperMap(row.getIntegers()));
        mapa.putAll(UserDefinedTableServiceImpl.upperMap(row.getDecimals()));
        return mapa;
    }

    private static Map<String, Object> getDefaultInsertColumns(String username) {
        TreeMap<String, Object> mapa = new TreeMap<String, Object>();
        mapa.put("CREATEDBY", username);
        mapa.put("CREATED", new Date());
        mapa.put("UPDATEDBY", null);
        mapa.put("UPDATED", null);
        mapa.put("UPDATECOUNT", new BigInteger("0"));
        return mapa;
    }

    private static Map<String, Object> getDefaultUpdateColumns(String username) {
        TreeMap<String, Object> mapa = new TreeMap<String, Object>();
        mapa.put("UPDATEDBY", username);
        mapa.put("UPDATED", new Date());
        return mapa;
    }

    private static <T> Map<String, T> upperMap(Map<String, T> mapa) {
        if (mapa == null) {
            return new HashMap();
        }
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Map.Entry<String, T> entry : mapa.entrySet()) {
            Object value = null;
            try {
                value = entry.getValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            map.put(entry.getKey().toUpperCase(), value);
        }
        return map;
    }

    static enum DATA_TYPE {
        DATE,
        STRING,
        INTEGER,
        DECIMAL;

    }
}

