/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.userdefinedscreens.entities;

import ch.cern.eam.wshub.core.adapters.BigDecimalAdapter;
import ch.cern.eam.wshub.core.adapters.DateAdapter;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDLEntryType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class UDLEntry
implements Serializable {
    private static final long serialVersionUID = 3824835369799503639L;
    private Object value;
    private UDLEntryType type;
    private String property;
    private BigInteger sequenceNumber;

    public UDLEntry() {
    }

    public UDLEntry(String property, BigInteger sequenceNumber, String value) {
        this(property, sequenceNumber);
        this.setString(value);
    }

    public UDLEntry(String property, BigInteger sequenceNumber, Date value) {
        this(property, sequenceNumber);
        this.setDate(value);
    }

    public UDLEntry(String property, BigInteger sequenceNumber, BigDecimal value) {
        this(property, sequenceNumber);
        this.setNumeric(value);
    }

    public UDLEntry(String property, BigInteger sequenceNumber) {
        if (property == null) {
            throw new IllegalArgumentException("UDL property must not be null");
        }
        if (property.length() > 30) {
            throw new IllegalArgumentException("UDL property string too large to include in a UDL");
        }
        this.value = null;
        this.property = property;
        this.sequenceNumber = sequenceNumber;
        this.type = UDLEntryType.NULL;
    }

    public void setString(String value) {
        if (value != null && value.length() > 64) {
            throw new IllegalArgumentException("String too large to include as a UDL value");
        }
        this.type = UDLEntryType.STRING;
        this.value = value;
    }

    public void setDate(Date value) {
        this.type = UDLEntryType.DATE;
        this.value = value;
    }

    public void setNumeric(BigDecimal value) {
        this.type = UDLEntryType.NUMERIC;
        this.value = value;
    }

    public String getString() {
        return this.type == UDLEntryType.STRING ? (String)this.value : null;
    }

    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getDate() {
        return this.type == UDLEntryType.DATE ? (Date)this.value : null;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getNumeric() {
        return this.type == UDLEntryType.NUMERIC ? (BigDecimal)this.value : null;
    }

    public BigInteger getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setSequenceNumber(BigInteger sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String toString() {
        String initialString = "UDLEntry[property=" + this.property + ", sequenceNumber=" + this.sequenceNumber + ", value=";
        if (this.type == UDLEntryType.NULL) {
            return initialString + "null]";
        }
        if (this.type == UDLEntryType.STRING) {
            return initialString + "\"" + this.value + "\"]";
        }
        return initialString + this.value + "]";
    }
}

