/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders;

import ch.cern.eam.wshub.core.annotations.Operation;
import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.interceptors.LogDataReferenceType;
import ch.cern.eam.wshub.core.services.INFOR_OPERATION;
import ch.cern.eam.wshub.core.services.workorders.entities.MEC;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.List;

public interface MECService {
    public static final String EQUIPMENT_COLUMN_NAME = "equipment";
    public static final String MEC_ID_COLUMN_NAME = "relatedwo";
    public static final String GRID_ID = "WSJOBS_MEC";
    public static final String GRID_WO_TYPE = "BR";

    @Operation(logOperation=INFOR_OPERATION.MEC_GET, logDataReference1=LogDataReferenceType.RESULT)
    public List<String> getWorkOrderMecIDList(InforContext var1, String var2) throws InforException;

    @Operation(logOperation=INFOR_OPERATION.MEC_ADD, logDataReference1=LogDataReferenceType.RESULT)
    public String addWorkOrderEquipment(InforContext var1, MEC var2) throws InforException;

    @Operation(logOperation=INFOR_OPERATION.MEC_DELETE, logDataReference1=LogDataReferenceType.RESULT)
    public String deleteWorkOrderMEC(InforContext var1, String var2, String var3) throws InforException;

    @Operation(logOperation=INFOR_OPERATION.MEC_SYNC, logDataReference1=LogDataReferenceType.RESULT)
    public String syncWorkOrderEquipment(InforContext var1, MEC var2) throws InforException;

    public static void validateInput(String workOrderID) throws InforException {
        if (workOrderID == null) {
            throw Tools.generateFault("workOrderID or mecProperties cannot be null");
        }
    }

    public static void validateInput(MEC mecToAdd) throws InforException {
        if (mecToAdd == null) {
            throw Tools.generateFault("mecToAdd cannot be null");
        }
    }

    public static void validateInput(String parentWorkorderID, String equipmentID) throws InforException {
        if (parentWorkorderID == null || equipmentID == null) {
            throw Tools.generateFault("parentWorkorderID or equipmentID cannot be null");
        }
    }

    public static void validateInput(String parentWorkorderID, String equipmentID, MEC mecProperties) throws InforException {
        if (parentWorkorderID == null || equipmentID == null || mecProperties == null) {
            throw Tools.generateFault("workorderID cannot be null");
        }
    }
}

