/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridField;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestResult;
import ch.cern.eam.wshub.core.services.grids.impl.GridsServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.MECService;
import ch.cern.eam.wshub.core.services.workorders.entities.MEC;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.datastream.schemas.mp_entities.workorderequipment_001.WorkOrderEquipment;
import net.datastream.schemas.mp_fields.ORGANIZATIONID_Type;
import net.datastream.schemas.mp_fields.WOID_Type;
import net.datastream.schemas.mp_functions.mp7394_001.MP7394_AddWorkOrderEquipment_001;
import net.datastream.schemas.mp_functions.mp7396_001.MP7396_RemoveWorkOrderEquipment_001;
import net.datastream.schemas.mp_results.mp7394_001.MP7394_AddWorkOrderEquipment_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class MECServiceImpl
implements MECService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private GridsService gridsService;

    public MECServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.gridsService = new GridsServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public String addWorkOrderEquipment(InforContext context, MEC mecToAdd) throws InforException {
        MECService.validateInput(mecToAdd);
        MP7394_AddWorkOrderEquipment_001 mp7394_addWorkOrderEquipment_001 = new MP7394_AddWorkOrderEquipment_001();
        WorkOrderEquipment workOrderEquipment = new WorkOrderEquipment();
        this.tools.getInforFieldTools().transformWSHubObject(workOrderEquipment, mecToAdd, context);
        mp7394_addWorkOrderEquipment_001.getWorkOrderEquipment().add(workOrderEquipment);
        MP7394_AddWorkOrderEquipment_001_Result res = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addWorkOrderEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), mp7394_addWorkOrderEquipment_001);
        return ((WOID_Type)res.getResultData().getRELATEDWORKORDERID().get(0)).getJOBNUM();
    }

    @Override
    public String deleteWorkOrderMEC(InforContext context, String parentWorkorderID, String mecID) throws InforException {
        MECService.validateInput(parentWorkorderID, mecID);
        MP7396_RemoveWorkOrderEquipment_001 mp7396_removeWorkOrderEquipment_001 = new MP7396_RemoveWorkOrderEquipment_001();
        ORGANIZATIONID_Type organizationid_type = new ORGANIZATIONID_Type();
        organizationid_type.setORGANIZATIONCODE("*");
        WOID_Type woid_typeParent = new WOID_Type();
        woid_typeParent.setJOBNUM(parentWorkorderID);
        woid_typeParent.setORGANIZATIONID(organizationid_type);
        WOID_Type woid_typeEquipment = new WOID_Type();
        woid_typeEquipment.setJOBNUM(mecID);
        woid_typeEquipment.setORGANIZATIONID(organizationid_type);
        mp7396_removeWorkOrderEquipment_001.setWORKORDERID(woid_typeParent);
        mp7396_removeWorkOrderEquipment_001.setRELATEDWORKORDERID(woid_typeEquipment);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).removeWorkOrderEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), mp7396_removeWorkOrderEquipment_001);
        return "OK";
    }

    @Override
    public List<String> getWorkOrderMecIDList(InforContext context, String workorderID) throws InforException {
        MECService.validateInput(workorderID);
        GridRequest gridRequest = new GridRequest("WSJOBS_MEC", GridRequest.GRIDTYPE.LIST, 50);
        gridRequest.addParam("param.workordernum", workorderID);
        gridRequest.addParam("param.organization", this.tools.getOrganizationCode(context));
        gridRequest.addParam("param.workorderrtype", "BR");
        gridRequest.addParam("param.tenant", this.tools.getTenant(context));
        GridRequestResult res = this.gridsService.executeQuery(context, gridRequest);
        List targetColumn = res.getGridFields().stream().filter(gridField -> gridField.getName().equals("relatedwo")).collect(Collectors.toList());
        if (targetColumn.isEmpty()) {
            throw Tools.generateFault("Column with relatedWorkorderID (ID of the MEC) is not in dataspy");
        }
        int targetIndex = ((GridField)targetColumn.get(0)).getOrder();
        List<String> listOfIDs = Arrays.stream(res.getRows()).map(gridRequestRow -> gridRequestRow.getCell()[targetIndex].getContent()).collect(Collectors.toList());
        return listOfIDs;
    }

    @Override
    public String syncWorkOrderEquipment(InforContext context, MEC updatedMEC) throws InforException {
        return "res";
    }
}

