/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.administration.impl;

import ch.cern.eam.wshub.core.annotations.BooleanType;
import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.administration.DataspyService;
import ch.cern.eam.wshub.core.services.administration.entities.DataspyCopy;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import net.datastream.schemas.mp_fields.USERID_Type;
import net.datastream.schemas.mp_functions.mp6516_001.MP6516_CopyScreenDataspy_001;
import net.datastream.schemas.mp_results.mp6516_001.MP6516_CopyScreenDataspy_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class DataspyServiceImpl
implements DataspyService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public DataspyServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public BigDecimal copyDataspy(InforContext context, DataspyCopy dataspyCopy) throws InforException {
        MP6516_CopyScreenDataspy_001 copyScreenDataspy = new MP6516_CopyScreenDataspy_001();
        this.tools.getDataTypeTools();
        copyScreenDataspy.setDDSPYID(DataTypeTools.encodeQuantity(dataspyCopy.getDataspyCode(), "Dataspy Code"));
        copyScreenDataspy.setUSERID(new USERID_Type());
        copyScreenDataspy.getUSERID().setUSERCODE(dataspyCopy.getUserCode());
        this.tools.getDataTypeTools();
        copyScreenDataspy.setDEFAULT(DataTypeTools.encodeBoolean(dataspyCopy.getDefaultDataspy(), BooleanType.PLUS_MINUS));
        MP6516_CopyScreenDataspy_001_Result result = null;
        result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).copyScreenDataspyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), copyScreenDataspy);
        this.tools.getDataTypeTools();
        return DataTypeTools.decodeQuantity(result.getResultData().getSCREENDATASPYID().getDDSPYID());
    }
}

