/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.equipment.EquipmentConfigurationService;
import ch.cern.eam.wshub.core.services.equipment.entities.EquipmentConfigurationEntity;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import net.datastream.schemas.mp_entities.equipmentconfiguration_001.EquipmentConfiguration;
import net.datastream.schemas.mp_fields.EQUIPMENTCONFIGURATIONID_Type;
import net.datastream.schemas.mp_functions.mp3228_001.MP3228_GetEquipmentConfiguration_001;
import net.datastream.schemas.mp_results.mp3228_001.MP3228_GetEquipmentConfiguration_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class EquipmentConfigurationServiceImpl
implements EquipmentConfigurationService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public EquipmentConfigurationServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public String createEquipmentConfiguration(InforContext context, EquipmentConfigurationEntity equipmentConfiguration) throws InforException {
        return null;
    }

    @Override
    public String updateEquipmentConfiguration(InforContext context, EquipmentConfigurationEntity equipmentConfiguration) throws InforException {
        return null;
    }

    private EquipmentConfiguration readInforEquipmentConfiguration(InforContext context, String equipmentConfigurationCode, BigDecimal revisionNum) throws InforException {
        MP3228_GetEquipmentConfiguration_001 getEquipmentConfiguration = new MP3228_GetEquipmentConfiguration_001();
        getEquipmentConfiguration.setEQUIPMENTCONFIGURATIONID(new EQUIPMENTCONFIGURATIONID_Type());
        getEquipmentConfiguration.getEQUIPMENTCONFIGURATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        getEquipmentConfiguration.getEQUIPMENTCONFIGURATIONID().setEQUIPMENTCONFIGURATIONCODE(equipmentConfigurationCode);
        EQUIPMENTCONFIGURATIONID_Type eQUIPMENTCONFIGURATIONID_Type = getEquipmentConfiguration.getEQUIPMENTCONFIGURATIONID();
        this.tools.getDataTypeTools();
        eQUIPMENTCONFIGURATIONID_Type.setREVISIONNUM(DataTypeTools.encodeQuantity(revisionNum, "Revision number"));
        MP3228_GetEquipmentConfiguration_001_Result getEquipmentConfigurationResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getEquipmentConfigurationOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getEquipmentConfiguration);
        return getEquipmentConfigurationResult.getResultData().getEquipmentConfiguration();
    }

    @Override
    public EquipmentConfigurationEntity readEquipmentConfiguration(InforContext context, String equipmentConfigurationCode, BigDecimal revisionNum) throws InforException {
        EquipmentConfiguration inforEquipmentConfiguration = this.readInforEquipmentConfiguration(context, equipmentConfigurationCode, revisionNum);
        EquipmentConfigurationEntity equipmentConfiguration = this.tools.getInforFieldTools().transformInforObject(new EquipmentConfigurationEntity(), inforEquipmentConfiguration);
        this.tools.processRunnables(() -> equipmentConfiguration.setConfigurationCategoryDesc(this.tools.getFieldDescriptionsTools().readCategoryDesc(context, equipmentConfiguration.getConfigurationCategoryCode())), () -> equipmentConfiguration.setConfigurationClassDesc(this.tools.getFieldDescriptionsTools().readClassDesc(context, "OBJ", equipmentConfiguration.getConfigurationClassCode())), () -> equipmentConfiguration.setEquipmentStatusDesc(this.tools.getFieldDescriptionsTools().readUserCodeDesc(context, "OBST", equipmentConfiguration.getEquipmentStatusCode())), () -> equipmentConfiguration.setEquipmentTypeDesc(this.tools.getFieldDescriptionsTools().readUserCodeDesc(context, "OBTP", equipmentConfiguration.getEquipmentTypeCode())));
        return equipmentConfiguration;
    }

    @Override
    public EquipmentConfigurationEntity readEquipmentDefaultConfiguration(InforContext context, String equipmentConfigurationCode) throws InforException {
        return null;
    }

    @Override
    public String deleteEquipmentConfiguration(InforContext context, String equipmentConfigurationCode) throws InforException {
        return null;
    }
}

