/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.tools;

import ch.cern.eam.wshub.core.annotations.InforField;
import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.entities.CustomField;
import ch.cern.eam.wshub.core.services.entities.UserDefinedFields;
import ch.cern.eam.wshub.core.tools.CustomFieldsTools;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.Tools;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import net.datastream.schemas.mp_fields.USERDEFINEDAREA;
import org.openapplications.oagis_segments.AMOUNT;
import org.openapplications.oagis_segments.DATETIME;
import org.openapplications.oagis_segments.QUANTITY;

public class InforFieldTools {
    private CustomFieldsTools customFieldsTools;
    private Tools tools;

    public InforFieldTools(CustomFieldsTools customFieldsTools, Tools tools) {
        this.customFieldsTools = customFieldsTools;
        this.tools = tools;
    }

    public <I, W> I transformWSHubObject(I inforObject, W wshubObject, InforContext context) {
        Arrays.stream(wshubObject.getClass().getDeclaredFields()).filter(wshubField -> wshubField.getAnnotation(InforField.class) != null).filter(wshubField -> !wshubField.getAnnotation(InforField.class).readOnly()).sorted(Comparator.comparing(field -> field.getAnnotation(InforField.class).nullifyParentLevel())).forEach(wshubField -> this.setInforValue(wshubObject, (Field)wshubField, inforObject, context));
        return inforObject;
    }

    public <I, W> W transformInforObject(W wshubObject, I inforObject) {
        Arrays.stream(wshubObject.getClass().getDeclaredFields()).filter(wshubField -> wshubField.getAnnotation(InforField.class) != null).forEach(wshubField -> this.setWSHubValue(wshubObject, (Field)wshubField, inforObject));
        return wshubObject;
    }

    private <I, W> void setInforValue(W wshubObject, Field wshubField, I inforObject, InforContext context) {
        InforField inforField = wshubField.getAnnotation(InforField.class);
        List<String> fieldNamePath = this.convertXPathToPropertyChain(inforObject.getClass(), inforField.xpath()[0], inforField.enforceValidXpath());
        try {
            wshubField.setAccessible(true);
            Object wshubFieldValue = wshubField.get(wshubObject);
            this.setInforFieldByPath(inforObject, fieldNamePath, wshubFieldValue, wshubField, context);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problem: " + exception.getMessage());
        }
    }

    private <I, W> void setWSHubValue(W wshubObject, Field wshubField, I inforObject) {
        try {
            Object inforValue = this.getValue(inforObject, wshubField.getAnnotation(InforField.class));
            if (inforValue == null) {
                return;
            }
            wshubField.setAccessible(true);
            if (inforValue.getClass().equals(String.class)) {
                String stringValue = (String)inforValue;
                if (wshubField.getType().equals(Boolean.class) || wshubField.getType().equals(Boolean.TYPE)) {
                    wshubField.set(wshubObject, DataTypeTools.decodeBoolean(stringValue));
                } else {
                    wshubField.set(wshubObject, stringValue);
                }
            } else if (inforValue.getClass().equals(DATETIME.class)) {
                DATETIME dateTimeValue = (DATETIME)inforValue;
                wshubField.set(wshubObject, DataTypeTools.decodeInforDate(dateTimeValue));
            } else if (inforValue.getClass().equals(AMOUNT.class)) {
                AMOUNT amountValue = (AMOUNT)inforValue;
                wshubField.set(wshubObject, DataTypeTools.decodeAmount(amountValue));
            } else if (inforValue.getClass().equals(QUANTITY.class)) {
                QUANTITY quantityValue = (QUANTITY)inforValue;
                wshubField.set(wshubObject, DataTypeTools.decodeQuantity(quantityValue));
            } else if (inforValue.getClass().equals(USERDEFINEDAREA.class)) {
                USERDEFINEDAREA userDefinedAreaValue = (USERDEFINEDAREA)inforValue;
                wshubField.set(wshubObject, this.customFieldsTools.readInforCustomFields(userDefinedAreaValue));
            } else if (inforValue.getClass().equals(Long.class) || inforValue.getClass().equals(Long.TYPE)) {
                Long longValue = (Long)inforValue;
                wshubField.set(wshubObject, BigInteger.valueOf(longValue));
            } else if ("UserDefinedFields".equals(wshubField.getAnnotation(InforField.class).xpath()[0]) || "StandardUserDefinedFields".equals(wshubField.getAnnotation(InforField.class).xpath()[0])) {
                wshubField.set(wshubObject, this.transformInforObject(new UserDefinedFields(), inforValue));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Property: " + e.getMessage());
        }
    }

    private List<String> convertXPathToPropertyChain(Class inforClass, String xpath, Boolean enforceValidXpath) {
        LinkedList<String> result = new LinkedList<String>();
        try {
            for (String xp : Arrays.asList(xpath.split("/"))) {
                Field field = Arrays.stream(inforClass.getDeclaredFields()).filter(decField -> decField.getAnnotation(XmlElement.class) != null && xp.equalsIgnoreCase(decField.getAnnotation(XmlElement.class).name()) || decField.getAnnotation(XmlAttribute.class) != null && xp.equalsIgnoreCase(decField.getAnnotation(XmlAttribute.class).name())).findFirst().orElse(null);
                result.add(field.getName());
                inforClass = field.getType();
            }
            return result;
        }
        catch (Exception e) {
            if (enforceValidXpath.booleanValue()) {
                System.out.println("Couldn't extract path for: " + xpath);
            }
            return result;
        }
    }

    private <I> Object getValue(I inforObject, List<String> fieldNames) {
        try {
            Object result = inforObject;
            for (String fieldName : fieldNames) {
                Field field = result.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                result = field.get(result);
            }
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private <I> Object getValue(I inforObject, InforField inforField) {
        return Arrays.stream(inforField.xpath()).map(xpath -> this.convertXPathToPropertyChain(inforObject.getClass(), (String)xpath, false)).map(propList -> this.getValue(inforObject, (List<String>)propList)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private void setOrganizationField(Object inforObject, InforContext context) {
        try {
            Field orgField = inforObject.getClass().getDeclaredField("organizationid");
            orgField.setAccessible(true);
            orgField.set(inforObject, this.tools.getOrganization(context));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object setPreviousFields(Object inforObject, List<String> fields) {
        Object inforTempObject = inforObject;
        try {
            for (String field : fields) {
                Field inforField = inforTempObject.getClass().getDeclaredField(field);
                inforField.setAccessible(true);
                Object inforFieldValue = inforField.get(inforTempObject);
                if (inforFieldValue == null) {
                    inforField.set(inforTempObject, inforField.getType().newInstance());
                }
                inforTempObject = inforField.get(inforTempObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inforTempObject;
    }

    private void setSingleField(Object inforObject, String inforFieldName, Object wshubFieldValue, Field wshubField, InforContext context) {
        try {
            Field inforField = inforObject.getClass().getDeclaredField(inforFieldName);
            inforField.setAccessible(true);
            if (wshubFieldValue instanceof Date) {
                Date dateValue = (Date)wshubFieldValue;
                if (dateValue.getTime() == 0L) {
                    inforField.set(inforObject, null);
                } else {
                    this.tools.getDataTypeTools();
                    inforField.set(inforObject, DataTypeTools.encodeInforDate(dateValue, inforFieldName));
                }
            } else if (wshubFieldValue.getClass().equals(BigDecimal.class)) {
                BigDecimal bigDecimalValue = (BigDecimal)wshubFieldValue;
                if (bigDecimalValue.equals(BigDecimal.valueOf(DataTypeTools.NULLIFY_VALUE.intValue()))) {
                    inforField.set(inforObject, null);
                } else if (inforField.getType().equals(AMOUNT.class)) {
                    inforField.set(inforObject, DataTypeTools.encodeAmount(bigDecimalValue, inforFieldName));
                } else if (inforField.getType().equals(QUANTITY.class)) {
                    inforField.set(inforObject, DataTypeTools.encodeQuantity(bigDecimalValue, inforFieldName));
                }
            } else if (wshubFieldValue.getClass().equals(BigInteger.class)) {
                BigInteger bigIntegerValue = (BigInteger)wshubFieldValue;
                if (bigIntegerValue.equals(BigInteger.valueOf(DataTypeTools.NULLIFY_VALUE.intValue()))) {
                    inforField.set(inforObject, null);
                } else {
                    inforField.set(inforObject, bigIntegerValue.longValue());
                }
            } else if (wshubFieldValue.getClass().equals(Boolean.class) || wshubFieldValue.getClass().equals(Boolean.TYPE)) {
                Boolean booleanValue = (Boolean)wshubFieldValue;
                inforField.set(inforObject, DataTypeTools.encodeBoolean(booleanValue, wshubField.getAnnotation(InforField.class).booleanType()));
            } else if (wshubFieldValue.getClass().equals(CustomField[].class)) {
                CustomField[] customFields = (CustomField[])wshubFieldValue;
                USERDEFINEDAREA userdefinedarea = (USERDEFINEDAREA)inforField.get(inforObject);
                this.tools.getCustomFieldsTools().updateInforCustomFields(userdefinedarea, customFields);
            } else if ("UserDefinedFields".equals(wshubField.getAnnotation(InforField.class).xpath()) || "StandardUserDefinedFields".equals(wshubField.getAnnotation(InforField.class).xpath())) {
                UserDefinedFields userDefinedFieldsValue = (UserDefinedFields)wshubFieldValue;
                if (inforField.get(inforObject) == null) {
                    inforField.set(inforObject, inforField.getType().newInstance());
                }
                inforField.set(inforObject, this.transformWSHubObject(inforField.get(inforObject), userDefinedFieldsValue, context));
            } else {
                inforField.set(inforObject, wshubFieldValue);
            }
            this.setOrganizationField(inforObject, context);
        }
        catch (Exception exception) {
            System.out.println("Error in setSingleField: " + exception.getMessage());
        }
    }

    private void setComplexField(Object inforObject, String fieldNameWrapper, String fieldNameValue, Object wshubFieldValue, Field wshubField, InforContext context) {
        try {
            Field inforField = inforObject.getClass().getDeclaredField(fieldNameWrapper);
            inforField.setAccessible(true);
            if (wshubFieldValue.equals("")) {
                inforField.set(inforObject, null);
            } else {
                if (inforField.get(inforObject) == null) {
                    inforField.set(inforObject, inforField.getType().newInstance());
                }
                this.setOrganizationField(inforObject, context);
                this.setSingleField(inforField.get(inforObject), fieldNameValue, wshubFieldValue, wshubField, context);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setInforFieldByPath(Object inforObject, List<String> path, Object wshubFieldValue, Field wshubField, InforContext context) {
        try {
            String fieldName = path.get(0);
            Field inforField = inforObject.getClass().getDeclaredField(fieldName);
            inforField.setAccessible(true);
            if (wshubFieldValue == null) {
                return;
            }
            if (path.size() == 1) {
                this.setSingleField(inforObject, fieldName, wshubFieldValue, wshubField, context);
                return;
            }
            if (wshubFieldValue.equals("")) {
                if (path.size() == wshubField.getAnnotation(InforField.class).nullifyParentLevel() + 1) {
                    inforField.set(inforObject, null);
                }
                if (inforField.get(inforObject) == null) {
                    return;
                }
            }
            if (inforField.get(inforObject) == null) {
                inforField.set(inforObject, inforField.getType().newInstance());
            }
            this.setOrganizationField(inforObject, context);
            this.setInforFieldByPath(inforField.get(inforObject), path.subList(1, path.size()), wshubFieldValue, wshubField, context);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

