/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders;

import ch.cern.eam.wshub.core.annotations.Operation;
import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.interceptors.LogDataReferenceType;
import ch.cern.eam.wshub.core.services.INFOR_OPERATION;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.workorders.entities.EntitySafety;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.List;

public interface SafetyService {
    public static final String GRID_EQUIPMENT = "OSOBJA_ESF";
    public static final String GRID_WORKORDER = "WSJOBS_KSF";
    public static final Integer GRID_ROW_COUNT = 50;
    public static final String GRID_WO_TYPE = "BR";

    @Operation(logOperation=INFOR_OPERATION.SAFETY_GET_LIST, logDataReference1=LogDataReferenceType.RESULT)
    public List<String> getSafetiesIDList(InforContext var1, String var2, ENTITY_TYPE var3) throws InforException;

    @Operation(logOperation=INFOR_OPERATION.SAFETY_GET, logDataReference1=LogDataReferenceType.RESULT)
    public net.datastream.schemas.mp_entities.entitysafety_001.EntitySafety getEntitySafety(InforContext var1, String var2) throws InforException;

    @Operation(logOperation=INFOR_OPERATION.SAFETY_GET_BATCH, logDataReference1=LogDataReferenceType.RESULT)
    public BatchResponse<net.datastream.schemas.mp_entities.entitysafety_001.EntitySafety> getEntitySafetiesBatch(InforContext var1, List<String> var2) throws InforException;

    @Operation(logOperation=INFOR_OPERATION.SAFETY_ADD, logDataReference1=LogDataReferenceType.RESULT)
    public String addSafety(InforContext var1, EntitySafety var2) throws InforException;

    @Operation(logOperation=INFOR_OPERATION.SAFETY_ADD_MULTIPLE, logDataReference1=LogDataReferenceType.RESULT)
    public List<String> addSafeties(InforContext var1, List<EntitySafety> var2) throws InforException;

    @Operation(logOperation=INFOR_OPERATION.SAFETY_ADD, logDataReference1=LogDataReferenceType.RESULT)
    public String addSafetyToEntity(InforContext var1, EntitySafety var2, String var3, String var4) throws InforException;

    @Operation(logOperation=INFOR_OPERATION.SAFETY_ADD_BATCH, logDataReference1=LogDataReferenceType.RESULT)
    public BatchResponse<String> addSafetyToEntitiesBatch(InforContext var1, EntitySafety var2, List<String> var3, String var4) throws InforException;

    @Operation(logOperation=INFOR_OPERATION.SAFETY_DELETE, logDataReference1=LogDataReferenceType.RESULT)
    public String deleteSafety(InforContext var1, String var2) throws InforException;

    @Operation(logOperation=INFOR_OPERATION.SAFETY_DELETE_BATCH, logDataReference1=LogDataReferenceType.RESULT)
    public BatchResponse<String> deleteSafetiesBatch(InforContext var1, List<String> var2) throws InforException;

    @Operation(logOperation=INFOR_OPERATION.SAFETY_SYNC, logDataReference1=LogDataReferenceType.RESULT)
    public String syncEntitySafety(InforContext var1, EntitySafety var2) throws InforException;

    public static void validateInput(EntitySafety input) throws InforException {
        if (input == null) {
            throw Tools.generateFault("Input safety object cannot be null");
        }
    }

    public static void validateInput(List<EntitySafety> input) throws InforException {
        if (input == null) {
            throw Tools.generateFault("Input list cannot be null");
        }
        if (input.isEmpty()) {
            throw Tools.generateFault("Input list cannot be empty");
        }
    }

    public static void validateInput(String input) throws InforException {
        if (input == null) {
            throw Tools.generateFault("Safety code cannot be null");
        }
    }

    public static void validateInput(String entityID, ENTITY_TYPE entityType) throws InforException {
        if (entityID == null || entityType == null) {
            throw Tools.generateFault("entityID or entityType cannot be null");
        }
    }

    public static enum ENTITY_TYPE {
        Workorder,
        Equipment;

    }
}

