/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.annotations.BooleanType;
import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.equipment.SystemService;
import ch.cern.eam.wshub.core.services.equipment.entities.Equipment;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedListService;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.EntityId;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDLValue;
import ch.cern.eam.wshub.core.services.userdefinedscreens.impl.UserDefinedListServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.HashMap;
import java.util.List;
import net.datastream.schemas.mp_entities.systemequipment_001.SystemEquipment;
import net.datastream.schemas.mp_entities.systemequipment_001.SystemParentHierarchy;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.LOCATIONID_Type;
import net.datastream.schemas.mp_fields.LOCATIONPARENT_Type;
import net.datastream.schemas.mp_fields.ORGANIZATIONID_Type;
import net.datastream.schemas.mp_fields.SYSTEMPARENT_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_functions.mp0311_001.MP0311_AddSystemEquipment_001;
import net.datastream.schemas.mp_functions.mp0312_001.MP0312_GetSystemEquipment_001;
import net.datastream.schemas.mp_functions.mp0313_001.MP0313_SyncSystemEquipment_001;
import net.datastream.schemas.mp_functions.mp0314_001.MP0314_DeleteSystemEquipment_001;
import net.datastream.schemas.mp_functions.mp0315_001.MP0315_GetSystemEquipmentDefault_001;
import net.datastream.schemas.mp_functions.mp0329_001.MP0329_GetSystemParentHierarchy_001;
import net.datastream.schemas.mp_results.mp0311_001.MP0311_AddSystemEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0312_001.MP0312_GetSystemEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0315_001.MP0315_GetSystemEquipmentDefault_001_Result;
import net.datastream.schemas.mp_results.mp0329_001.MP0329_GetSystemParentHierarchy_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class SystemServiceImpl
implements SystemService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private UserDefinedListService userDefinedListService;

    public SystemServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.userDefinedListService = new UserDefinedListServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public Equipment readSystemDefault(InforContext context, String organization) throws InforException {
        MP0315_GetSystemEquipmentDefault_001 getSystemEquipmentDefault_001 = new MP0315_GetSystemEquipmentDefault_001();
        if (DataTypeTools.isEmpty(organization)) {
            getSystemEquipmentDefault_001.setORGANIZATIONID(this.tools.getOrganization(context));
        } else {
            getSystemEquipmentDefault_001.setORGANIZATIONID(new ORGANIZATIONID_Type());
            getSystemEquipmentDefault_001.getORGANIZATIONID().setORGANIZATIONCODE(organization);
        }
        MP0315_GetSystemEquipmentDefault_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getSystemEquipmentDefaultOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getSystemEquipmentDefault_001);
        Equipment equipment = this.tools.getInforFieldTools().transformInforObject(new Equipment(), result.getResultData().getSystemEquipment());
        equipment.setUserDefinedList(new HashMap<String, List<UDLValue>>());
        return equipment;
    }

    @Override
    public Equipment readSystem(InforContext context, String systemCode) throws InforException {
        SystemEquipment systemEquipment = this.readSystemInfor(context, systemCode);
        Equipment system = this.tools.getInforFieldTools().transformInforObject(new Equipment(), systemEquipment);
        system.setSystemTypeCode("S");
        if (systemEquipment.getSYSTEMID() != null) {
            system.setCode(systemEquipment.getSYSTEMID().getEQUIPMENTCODE());
            system.setDescription(systemEquipment.getSYSTEMID().getDESCRIPTION());
        }
        MP0329_GetSystemParentHierarchy_001 getsystemh = new MP0329_GetSystemParentHierarchy_001();
        getsystemh.setSYSTEMID(systemEquipment.getSYSTEMID());
        MP0329_GetSystemParentHierarchy_001_Result gethresult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getSystemParentHierarchyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getsystemh);
        systemEquipment.setSystemParentHierarchy(gethresult.getResultData().getSystemParentHierarchy());
        if (systemEquipment.getSystemParentHierarchy().getLOCATIONID() != null) {
            system.setHierarchyLocationCode(systemEquipment.getSystemParentHierarchy().getLOCATIONID().getLOCATIONCODE());
            system.setHierarchyLocationDesc(systemEquipment.getSystemParentHierarchy().getLOCATIONID().getDESCRIPTION());
        }
        if (systemEquipment.getSystemParentHierarchy().getDEPENDENTPRIMARYSYSTEM() != null) {
            system.setHierarchyPrimarySystemCode(systemEquipment.getSystemParentHierarchy().getDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
            system.setHierarchyPrimarySystemDesc(systemEquipment.getSystemParentHierarchy().getDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
            system.setHierarchyPrimarySystemDependent(true);
            system.setHierarchyPrimarySystemCostRollUp(DataTypeTools.decodeBoolean(systemEquipment.getSystemParentHierarchy().getDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP()));
        } else if (systemEquipment.getSystemParentHierarchy().getNONDEPENDENTPRIMARYSYSTEM() != null) {
            system.setHierarchyPrimarySystemCode(systemEquipment.getSystemParentHierarchy().getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
            system.setHierarchyPrimarySystemDesc(systemEquipment.getSystemParentHierarchy().getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
            system.setHierarchyPrimarySystemDependent(false);
            system.setHierarchyPrimarySystemCostRollUp(DataTypeTools.decodeBoolean(systemEquipment.getSystemParentHierarchy().getNONDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP()));
        }
        this.userDefinedListService.readUDLToEntity(context, system, new EntityId("OBJ", systemCode));
        return system;
    }

    public SystemEquipment readSystemInfor(InforContext context, String systemCode) throws InforException {
        MP0312_GetSystemEquipment_001 getSystem = new MP0312_GetSystemEquipment_001();
        getSystem.setSYSTEMID(new EQUIPMENTID_Type());
        getSystem.getSYSTEMID().setORGANIZATIONID(this.tools.getOrganization(context));
        getSystem.getSYSTEMID().setEQUIPMENTCODE(systemCode);
        MP0312_GetSystemEquipment_001_Result getAssetResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getSystemEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getSystem);
        return getAssetResult.getResultData().getSystemEquipment();
    }

    @Override
    public String updateSystem(InforContext context, Equipment systemParam) throws InforException {
        SystemEquipment systemEquipment = this.readSystemInfor(context, systemParam.getCode());
        systemEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(systemEquipment.getCLASSID()), systemEquipment.getUSERDEFINEDAREA(), systemParam.getClassCode(), "OBJ"));
        this.initializeSystemObject(systemEquipment, systemParam, context);
        this.tools.getInforFieldTools().transformWSHubObject(systemEquipment, systemParam, context);
        MP0313_SyncSystemEquipment_001 syncPosition = new MP0313_SyncSystemEquipment_001();
        syncPosition.setSystemEquipment(systemEquipment);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncSystemEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncPosition);
        this.userDefinedListService.writeUDLToEntity(context, systemParam, new EntityId("OBJ", systemParam.getCode()));
        return systemParam.getCode();
    }

    @Override
    public String createSystem(InforContext context, Equipment systemParam) throws InforException {
        SystemEquipment systemEquipment = new SystemEquipment();
        systemEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(systemEquipment.getCLASSID()), systemEquipment.getUSERDEFINEDAREA(), systemParam.getClassCode(), "OBJ"));
        this.initializeSystemObject(systemEquipment, systemParam, context);
        this.tools.getInforFieldTools().transformWSHubObject(systemEquipment, systemParam, context);
        MP0311_AddSystemEquipment_001 addPosition = new MP0311_AddSystemEquipment_001();
        addPosition.setSystemEquipment(systemEquipment);
        MP0311_AddSystemEquipment_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addSystemEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addPosition);
        String systemCode = result.getResultData().getSYSTEMID().getEQUIPMENTCODE();
        this.userDefinedListService.writeUDLToEntityCopyFrom(context, systemParam, new EntityId("OBJ", systemCode));
        return systemCode;
    }

    @Override
    public String deleteSystem(InforContext context, String systemCode) throws InforException {
        MP0314_DeleteSystemEquipment_001 deleteSystem = new MP0314_DeleteSystemEquipment_001();
        deleteSystem.setSYSTEMID(new EQUIPMENTID_Type());
        deleteSystem.getSYSTEMID().setORGANIZATIONID(this.tools.getOrganization(context));
        deleteSystem.getSYSTEMID().setEQUIPMENTCODE(systemCode);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteSystemEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteSystem);
        this.userDefinedListService.deleteUDLFromEntity(context, new EntityId("OBJ", systemCode));
        return systemCode;
    }

    private void initializeSystemObject(SystemEquipment systemInfor, Equipment systemParam, InforContext context) throws InforException {
        if (systemInfor.getSYSTEMID() == null) {
            systemInfor.setSYSTEMID(new EQUIPMENTID_Type());
            systemInfor.getSYSTEMID().setORGANIZATIONID(this.tools.getOrganization(context));
            systemInfor.getSYSTEMID().setEQUIPMENTCODE(systemParam.getCode());
        }
        if (systemParam.getDescription() != null) {
            systemInfor.getSYSTEMID().setDESCRIPTION(systemParam.getDescription());
        }
        if (DataTypeTools.isNotEmpty(systemParam.getHierarchyLocationCode()) || DataTypeTools.isNotEmpty(systemParam.getHierarchyPrimarySystemCode())) {
            this.populateSystemHierarchy(context, systemParam, systemInfor);
        }
    }

    private void populateSystemHierarchy(InforContext context, Equipment systemParam, SystemEquipment systemInfor) {
        SystemParentHierarchy systemParentHierarchy = new SystemParentHierarchy();
        systemParentHierarchy.setSYSTEMID(new EQUIPMENTID_Type());
        systemParentHierarchy.getSYSTEMID().setORGANIZATIONID(this.tools.getOrganization(context));
        systemParentHierarchy.getSYSTEMID().setEQUIPMENTCODE(systemParam.getCode());
        systemParentHierarchy.setTYPE(new TYPE_Type());
        systemParentHierarchy.getTYPE().setTYPECODE("S");
        this.tools.getDataTypeTools();
        if (DataTypeTools.isNotEmpty(systemParam.getHierarchyPrimarySystemCode())) {
            if (systemParam.getHierarchyPrimarySystemDependent() == null || !systemParam.getHierarchyPrimarySystemDependent().booleanValue()) {
                systemParam.setHierarchyAssetDependent(false);
            }
            EQUIPMENTID_Type hierarchySystem = new EQUIPMENTID_Type();
            hierarchySystem.setORGANIZATIONID(this.tools.getOrganization(context));
            hierarchySystem.setEQUIPMENTCODE(systemParam.getHierarchyPrimarySystemCode());
            if (systemParam.getHierarchyPrimarySystemDependent() != null && systemParam.getHierarchyPrimarySystemDependent().booleanValue()) {
                SYSTEMPARENT_Type systemType = new SYSTEMPARENT_Type();
                systemType.setSYSTEMID(hierarchySystem);
                systemType.setCOSTROLLUP(DataTypeTools.encodeBoolean(systemParam.getHierarchyPrimarySystemCostRollUp(), BooleanType.TRUE_FALSE));
                systemParentHierarchy.setDEPENDENTPRIMARYSYSTEM(systemType);
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(systemParam.getHierarchyLocationCode())) {
                    systemParentHierarchy.setLOCATIONID(new LOCATIONID_Type());
                    systemParentHierarchy.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
                    systemParentHierarchy.getLOCATIONID().setLOCATIONCODE(systemParam.getHierarchyLocationCode());
                }
            } else {
                SYSTEMPARENT_Type systemType = new SYSTEMPARENT_Type();
                systemType.setSYSTEMID(hierarchySystem);
                systemType.setCOSTROLLUP(DataTypeTools.encodeBoolean(systemParam.getHierarchyPrimarySystemCostRollUp(), BooleanType.TRUE_FALSE));
                systemParentHierarchy.setNONDEPENDENTPRIMARYSYSTEM(systemType);
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(systemParam.getHierarchyLocationCode())) {
                    systemParentHierarchy.setDEPENDENTLOCATION(new LOCATIONPARENT_Type());
                    systemParentHierarchy.getDEPENDENTLOCATION().setLOCATIONID(new LOCATIONID_Type());
                    systemParentHierarchy.getDEPENDENTLOCATION().getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
                    systemParentHierarchy.getDEPENDENTLOCATION().getLOCATIONID().setLOCATIONCODE(systemParam.getHierarchyLocationCode());
                }
            }
        } else {
            this.tools.getDataTypeTools();
            if (DataTypeTools.isNotEmpty(systemParam.getHierarchyLocationCode())) {
                systemParentHierarchy.setDEPENDENTLOCATION(new LOCATIONPARENT_Type());
                systemParentHierarchy.getDEPENDENTLOCATION().setLOCATIONID(new LOCATIONID_Type());
                systemParentHierarchy.getDEPENDENTLOCATION().getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
                systemParentHierarchy.getDEPENDENTLOCATION().getLOCATIONID().setLOCATIONCODE(systemParam.getHierarchyLocationCode());
            }
        }
        systemInfor.setSystemParentHierarchy(systemParentHierarchy);
    }
}

