/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.annotations.BooleanType;
import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.equipment.EquipmentStructureService;
import ch.cern.eam.wshub.core.services.equipment.entities.EquipmentStructure;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.EQUIPMENTSTRUCTUREID_Type;
import net.datastream.schemas.mp_functions.mp0347_001.MP0347_UpdateEquipmentStructureProperties_001;
import net.datastream.schemas.mp_functions.mp0356_001.MP0356_RemoveEquipmentFromStructure_001;
import net.datastream.schemas.mp_functions.mp0356_001.ParentEquipment;
import net.datastream.schemas.mp_functions.mp3057_001.MP3057_AddEquipmentStructure_001;
import net.datastream.schemas.mp_functions.mp3058_001.MP3058_SyncEquipmentStructure_001;
import net.datastream.schemas.mp_functions.mp3058_001.NewParentEquipment;
import net.datastream.schemas.mp_results.mp3057_001.ResultData;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class EquipmentStructureServiceImpl
implements EquipmentStructureService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public EquipmentStructureServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public EquipmentStructure addEquipmentToStructure(InforContext context, EquipmentStructure equipmentStructure) throws InforException {
        MP3057_AddEquipmentStructure_001 addEqStr = new MP3057_AddEquipmentStructure_001();
        addEqStr.setEquipmentStructure(new net.datastream.schemas.mp_entities.equipmentstructure_001.EquipmentStructure());
        EQUIPMENTSTRUCTUREID_Type strID = new EQUIPMENTSTRUCTUREID_Type();
        addEqStr.getEquipmentStructure().setEQUIPMENTSTRUCTUREID(strID);
        if (equipmentStructure.getChildCode() != null) {
            strID.setEQUIPMENTID(new EQUIPMENTID_Type());
            strID.getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            strID.getEQUIPMENTID().setEQUIPMENTCODE(equipmentStructure.getChildCode().trim().toUpperCase());
        }
        if (equipmentStructure.getNewParentCode() != null) {
            strID.setPARENTEQUIPMENTID(new EQUIPMENTID_Type());
            strID.getPARENTEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            strID.getPARENTEQUIPMENTID().setEQUIPMENTCODE(equipmentStructure.getNewParentCode().trim().toUpperCase());
        }
        net.datastream.schemas.mp_entities.equipmentstructure_001.EquipmentStructure equipmentStructure2 = addEqStr.getEquipmentStructure();
        this.tools.getDataTypeTools();
        equipmentStructure2.setCOSTROLLUP(DataTypeTools.encodeBoolean(equipmentStructure.getCostRollUp(), BooleanType.TRUE_FALSE));
        net.datastream.schemas.mp_entities.equipmentstructure_001.EquipmentStructure equipmentStructure3 = addEqStr.getEquipmentStructure();
        this.tools.getDataTypeTools();
        equipmentStructure3.setDEPENDENTON(DataTypeTools.encodeBoolean(equipmentStructure.getDependent(), BooleanType.TRUE_FALSE));
        if (equipmentStructure.getSequenceNumber() != null && !equipmentStructure.getSequenceNumber().trim().equals("")) {
            addEqStr.getEquipmentStructure().setSEQUENCENUMBER(Long.valueOf(this.tools.getDataTypeTools().encodeLong(equipmentStructure.getSequenceNumber(), "Sequence Number")));
        }
        ResultData result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addEquipmentStructureOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addEqStr).getResultData();
        equipmentStructure.setChildDesc(result.getEQUIPMENTSTRUCTUREID().getEQUIPMENTID().getDESCRIPTION());
        equipmentStructure.setNewParentDesc(result.getEQUIPMENTSTRUCTUREID().getEQUIPMENTID().getDESCRIPTION());
        return equipmentStructure;
    }

    @Override
    public String removeEquipmentFromStructure(InforContext context, EquipmentStructure equipmentStructure) throws InforException {
        MP0356_RemoveEquipmentFromStructure_001 removeeq = new MP0356_RemoveEquipmentFromStructure_001();
        if (equipmentStructure.getChildCode() != null) {
            removeeq.setEQUIPMENTID(new EQUIPMENTID_Type());
            removeeq.getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            removeeq.getEQUIPMENTID().setEQUIPMENTCODE(equipmentStructure.getChildCode().trim().toUpperCase());
        }
        if (equipmentStructure.getParentCode() != null) {
            removeeq.setParentEquipment(new ParentEquipment());
            removeeq.getParentEquipment().setEQUIPMENTID(new EQUIPMENTID_Type());
            removeeq.getParentEquipment().getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            removeeq.getParentEquipment().getEQUIPMENTID().setEQUIPMENTCODE(equipmentStructure.getParentCode().trim().toUpperCase());
        }
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).removeEquipmentFromStructureOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), removeeq);
        return "OK";
    }

    @Override
    public String updateEquipmentStructure(InforContext context, EquipmentStructure equipmentStructure) throws InforException {
        if (equipmentStructure.getNewParentCode() == null || equipmentStructure.getNewParentCode().trim().equals("")) {
            MP0347_UpdateEquipmentStructureProperties_001 updateEqStr = new MP0347_UpdateEquipmentStructureProperties_001();
            if (equipmentStructure.getChildCode() != null) {
                updateEqStr.setChildEquipment(new EQUIPMENTID_Type());
                updateEqStr.getChildEquipment().setORGANIZATIONID(this.tools.getOrganization(context));
                updateEqStr.getChildEquipment().setEQUIPMENTCODE(equipmentStructure.getChildCode().trim().toUpperCase());
            }
            if (equipmentStructure.getParentCode() != null) {
                updateEqStr.setParentEquipment(new EQUIPMENTID_Type());
                updateEqStr.getParentEquipment().setORGANIZATIONID(this.tools.getOrganization(context));
                updateEqStr.getParentEquipment().setEQUIPMENTCODE(equipmentStructure.getParentCode().trim().toUpperCase());
            }
            if (equipmentStructure.getCostRollUp() != null) {
                this.tools.getDataTypeTools();
                updateEqStr.setCOSTROLLUP(DataTypeTools.encodeBoolean(equipmentStructure.getCostRollUp(), BooleanType.TRUE_FALSE));
            }
            if (equipmentStructure.getDependent() != null) {
                this.tools.getDataTypeTools();
                updateEqStr.setDEPENDENTON(DataTypeTools.encodeBoolean(equipmentStructure.getDependent(), BooleanType.TRUE_FALSE));
            }
            this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).updateEquipmentStructurePropertiesOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), updateEqStr);
        } else {
            MP3058_SyncEquipmentStructure_001 synceqpstr = new MP3058_SyncEquipmentStructure_001();
            synceqpstr.setEquipmentStructure(new net.datastream.schemas.mp_entities.equipmentstructure_001.EquipmentStructure());
            if (equipmentStructure.getChildCode() != null) {
                synceqpstr.getEquipmentStructure().setEQUIPMENTSTRUCTUREID(new EQUIPMENTSTRUCTUREID_Type());
                synceqpstr.getEquipmentStructure().getEQUIPMENTSTRUCTUREID().setEQUIPMENTID(new EQUIPMENTID_Type());
                synceqpstr.getEquipmentStructure().getEQUIPMENTSTRUCTUREID().getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
                synceqpstr.getEquipmentStructure().getEQUIPMENTSTRUCTUREID().getEQUIPMENTID().setEQUIPMENTCODE(equipmentStructure.getChildCode().trim().toUpperCase());
            }
            if (equipmentStructure.getParentCode() != null) {
                synceqpstr.getEquipmentStructure().getEQUIPMENTSTRUCTUREID().setPARENTEQUIPMENTID(new EQUIPMENTID_Type());
                synceqpstr.getEquipmentStructure().getEQUIPMENTSTRUCTUREID().getPARENTEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
                synceqpstr.getEquipmentStructure().getEQUIPMENTSTRUCTUREID().getPARENTEQUIPMENTID().setEQUIPMENTCODE(equipmentStructure.getParentCode().trim().toUpperCase());
            }
            net.datastream.schemas.mp_entities.equipmentstructure_001.EquipmentStructure equipmentStructure2 = synceqpstr.getEquipmentStructure();
            this.tools.getDataTypeTools();
            equipmentStructure2.setCOSTROLLUP(DataTypeTools.encodeBoolean(equipmentStructure.getCostRollUp(), BooleanType.TRUE_FALSE));
            net.datastream.schemas.mp_entities.equipmentstructure_001.EquipmentStructure equipmentStructure3 = synceqpstr.getEquipmentStructure();
            this.tools.getDataTypeTools();
            equipmentStructure3.setDEPENDENTON(DataTypeTools.encodeBoolean(equipmentStructure.getDependent(), BooleanType.TRUE_FALSE));
            if (equipmentStructure.getNewParentCode() != null) {
                synceqpstr.setNewParentEquipment(new NewParentEquipment());
                synceqpstr.getNewParentEquipment().setEQUIPMENTID(new EQUIPMENTID_Type());
                synceqpstr.getNewParentEquipment().getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
                synceqpstr.getNewParentEquipment().getEQUIPMENTID().setEQUIPMENTCODE(equipmentStructure.getNewParentCode().trim().toUpperCase());
            }
            this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncEquipmentStructureOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), synceqpstr);
        }
        return "OK";
    }
}

