/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.grids.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridDDSpyFieldsResult;
import ch.cern.eam.wshub.core.services.grids.entities.GridDataspy;
import ch.cern.eam.wshub.core.services.grids.entities.GridMetadataRequestResult;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestFilter;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestResult;
import ch.cern.eam.wshub.core.services.grids.impl.CSVUtils;
import ch.cern.eam.wshub.core.services.grids.impl.InforGrids;
import ch.cern.eam.wshub.core.services.grids.impl.JPAGrids;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class GridsServiceImpl
implements GridsService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private InforGrids inforGrids;
    private JPAGrids jpaGrids;
    public static final Map<String, GridMetadataRequestResult> gridIdCache = new ConcurrentHashMap<String, GridMetadataRequestResult>();

    public GridsServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.inforGrids = new InforGrids(applicationData, tools, this.inforws);
        if (tools.isDatabaseConnectionConfigured()) {
            this.jpaGrids = new JPAGrids(applicationData, tools, this.inforws);
        }
    }

    @Override
    public BatchResponse<GridRequestResult> executeQueryBatch(InforContext context, List<GridRequest> gridRequests) throws InforException {
        return this.tools.batchOperation(context, this::executeQuery, gridRequests);
    }

    @Override
    public GridRequestResult executeQuery(InforContext context, GridRequest gridRequest) throws InforException {
        if (gridRequest.getUseNative().booleanValue() || !this.tools.isDatabaseConnectionConfigured()) {
            return this.inforGrids.executeQuery(context, gridRequest);
        }
        this.tools.demandDatabaseConnection();
        if (DataTypeTools.isEmpty(gridRequest.getDataspyID()) || DataTypeTools.isEmpty(gridRequest.getGridID()) || DataTypeTools.isEmpty(gridRequest.getGridName())) {
            GridMetadataRequestResult gridMetadataInfor = this.getGridMetadataInfor(context, gridRequest.getGridName(), gridRequest.getGridID());
            gridRequest.setGridID(gridMetadataInfor.getGridCode());
            gridRequest.setGridName(gridMetadataInfor.getGridName());
            if (gridRequest.getDataspyID() == null) {
                gridRequest.setDataspyID(gridMetadataInfor.getDataSpyId());
            }
            if (gridRequest.getUserFunctionName() == null) {
                gridRequest.setUserFunctionName(gridMetadataInfor.getGridName());
            }
        }
        GridRequestResult gridRequestResult = this.jpaGrids.executeQuery(context, gridRequest);
        return gridRequestResult;
    }

    @Override
    public GridMetadataRequestResult getGridMetadataInfor(InforContext context, String gridName) {
        return this.getGridMetadataInfor(context, gridName, null);
    }

    public GridMetadataRequestResult getGridMetadataInfor(InforContext context, String gridName, String gridId) {
        try {
            String cacheName = gridName + "#" + gridId;
            if (gridIdCache.containsKey(cacheName)) {
                return gridIdCache.get(cacheName);
            }
            GridRequest gridRequest = new GridRequest("BEWSGR");
            gridRequest.setIncludeMetadata(true);
            gridRequest.setRowCount(1);
            if (gridName != null) {
                gridRequest.getGridRequestFilters().add(new GridRequestFilter("grd_gridname", gridName, "=", GridRequestFilter.JOINER.OR));
            }
            if (gridId != null) {
                gridRequest.getGridRequestFilters().add(new GridRequestFilter("grd_gridid", gridId, "="));
            }
            GridRequestResult result = this.inforGrids.executeQuery(context, gridRequest);
            GridMetadataRequestResult gridData = new GridMetadataRequestResult();
            gridData.setGridName(GridTools.getCellContent("grd_gridname", result.getRows()[0]));
            gridData.setGridCode(GridTools.getCellContent("grd_gridid", result.getRows()[0]));
            gridData.setDataSpyId(GridTools.getCellContent("dds_ddspyid", result.getRows()[0]).replaceAll(",", ""));
            gridIdCache.put(cacheName, gridData);
            return gridData;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public GridMetadataRequestResult getGridMetadata(InforContext context, String gridCode, String viewType) throws InforException {
        this.tools.demandDatabaseConnection();
        return this.getGridMetadata(context, gridCode, viewType, "EN");
    }

    @Override
    public GridMetadataRequestResult getGridMetadata(InforContext context, String gridCode, String viewType, String language) throws InforException {
        this.tools.demandDatabaseConnection();
        return this.jpaGrids.getGridMetadata(context, gridCode, viewType, language);
    }

    @Override
    public GridDDSpyFieldsResult getDDspyFields(InforContext context, String gridCode, String viewType, String ddSpyId, String language) throws InforException {
        this.tools.demandDatabaseConnection();
        return this.jpaGrids.getDDspyFields(context, gridCode, viewType, ddSpyId, language);
    }

    @Override
    public GridDataspy getDefaultDataspy(InforContext context, String gridCode, String viewType) throws InforException {
        this.tools.demandDatabaseConnection();
        return this.jpaGrids.getDefaultDataspy(context, gridCode, viewType);
    }

    @Override
    public String getGridCsvData(InforContext context, GridRequest gridRequest) throws InforException {
        gridRequest.setIncludeMetadata(true);
        GridRequestResult gridRequestResult = this.inforGrids.executeQuery(context, gridRequest);
        return CSVUtils.convertGridRequestResultToCsv(gridRequestResult);
    }
}

