/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.annotations.BooleanType;
import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.entities.Pair;
import ch.cern.eam.wshub.core.services.entities.Signature;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestFilter;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestResult;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestRow;
import ch.cern.eam.wshub.core.services.grids.impl.GridsServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.ChecklistService;
import ch.cern.eam.wshub.core.services.workorders.entities.Activity;
import ch.cern.eam.wshub.core.services.workorders.entities.Finding;
import ch.cern.eam.wshub.core.services.workorders.entities.TaskPlan;
import ch.cern.eam.wshub.core.services.workorders.entities.TaskplanCheckList;
import ch.cern.eam.wshub.core.services.workorders.entities.UserQualification;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityCheckList;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityCheckListDefaultResult;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityCheckListDefinition;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityCheckListSignature;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityChecklistSignatureResponse;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityChecklistSignatureResult;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.datastream.schemas.mp_entities.taskchecklist_001.TaskChecklist;
import net.datastream.schemas.mp_fields.ACTIVITYCODE;
import net.datastream.schemas.mp_fields.ACTIVITYID;
import net.datastream.schemas.mp_fields.ASPECTID_Type;
import net.datastream.schemas.mp_fields.CATEGORYID;
import net.datastream.schemas.mp_fields.CHECKLISTID_Type;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.ESIGNATURE;
import net.datastream.schemas.mp_fields.FINDINGID_Type;
import net.datastream.schemas.mp_fields.POINTTYPEID_Type;
import net.datastream.schemas.mp_fields.TASKLISTID_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_fields.UOMID_Type;
import net.datastream.schemas.mp_fields.USERDEFINEDCODEID_Type;
import net.datastream.schemas.mp_fields.WOID_Type;
import net.datastream.schemas.mp_functions.mp7913_001.MP7913_SyncWorkOrderActivityCheckList_001;
import net.datastream.schemas.mp_functions.mp7914_001.MP7914_GetWorkOrderActivityCheckList_001;
import net.datastream.schemas.mp_functions.mp7916_001.MP7916_AddTaskChecklist_001;
import net.datastream.schemas.mp_functions.mp7997_001.MP7997_PerformWorkOrderActivityCheckList_001;
import net.datastream.schemas.mp_functions.mp7998_001.MP7998_ReviewWorkOrderActivityCheckList_001;
import net.datastream.schemas.mp_functions.mp7999_001.MP7999_GetWorkOrderActivityCheckListDefault_001;
import net.datastream.schemas.mp_functions.mp8000_001.MP8000_CreateFollowUpWorkOrder_001;
import net.datastream.schemas.mp_results.mp7914_001.MP7914_GetWorkOrderActivityCheckList_001_Result;
import net.datastream.schemas.mp_results.mp7999_001.MP7999_GetWorkOrderActivityCheckListDefault_001_Result;
import net.datastream.schemas.mp_results.mp8000_001.MP8000_CreateFollowUpWorkOrder_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class ChecklistServiceImpl
implements ChecklistService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private GridsService gridsService;
    public static final Map<String, String> findingsCache = new ConcurrentHashMap<String, String>();

    public ChecklistServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.gridsService = new GridsServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public WorkOrderActivityChecklistSignatureResult[] getSignatures(InforContext context, String workOrderCode, String activityCode, TaskPlan taskPlan) throws InforException {
        MP7999_GetWorkOrderActivityCheckListDefault_001_Result getResult = this.getSignatureWS(context, workOrderCode, activityCode);
        WorkOrderActivityCheckListDefaultResult workOrderActivityCheckListDefaultResult = new WorkOrderActivityCheckListDefaultResult();
        this.tools.getInforFieldTools().transformInforObject(workOrderActivityCheckListDefaultResult, getResult.getResultData().getWorkOrderActivityCheckListDefault());
        WorkOrderActivityChecklistSignatureResult[] res = this.filterSignatures(workOrderActivityCheckListDefaultResult, taskPlan);
        this.getResponsibilityDescriptions(context, res);
        return res;
    }

    private void getResponsibilityDescriptions(InforContext context, WorkOrderActivityChecklistSignatureResult[] signatures) throws InforException {
        GridRequest gridRequest = new GridRequest("LVUSERRESPONSIBILITIES");
        gridRequest.setDataspyID("4297");
        gridRequest.getParams().put("param.rentity", "RESP");
        LinkedList<GridRequestFilter> filters = new LinkedList<GridRequestFilter>();
        for (WorkOrderActivityChecklistSignatureResult signatureResult : signatures) {
            String responsibilityCode = signatureResult.getResponsibilityCode();
            if (responsibilityCode == null) continue;
            filters.add(new GridRequestFilter("responsibility", responsibilityCode, "=", GridRequestFilter.JOINER.OR, false, false));
        }
        if (filters.size() == 0) {
            return;
        }
        gridRequest.setGridRequestFilters(filters);
        Map<String, String> responsibilityToDescription = GridTools.convertGridResultToMap("responsibility", "description", this.gridsService.executeQuery(context, gridRequest));
        Arrays.stream(signatures).forEach(signature -> {
            if (responsibilityToDescription.containsKey(signature.getResponsibilityCode())) {
                signature.setResponsibilityDescription((String)responsibilityToDescription.get(signature.getResponsibilityCode()));
            }
        });
    }

    private WorkOrderActivityChecklistSignatureResult[] filterSignatures(WorkOrderActivityCheckListDefaultResult workOrderActivityCheckList, TaskPlan taskPlan) {
        boolean performedBy2Hidden;
        String reviewerQualification = workOrderActivityCheckList.getReviewerQualification();
        String performer1Qualification = workOrderActivityCheckList.getPerformer1Qualification();
        String performer2Qualification = workOrderActivityCheckList.getPerformer2Qualification();
        String viewerQualification = taskPlan.getViewOnlyResponsibility();
        List<Object> qualifications = new ArrayList();
        if (workOrderActivityCheckList.getUserQualifications() != null) {
            qualifications = workOrderActivityCheckList.getUserQualifications().stream().map(UserQualification::getUserDefinedCode).collect(Collectors.toList());
        }
        boolean noRequiredQualifications = reviewerQualification == null && performer1Qualification == null && performer2Qualification == null && viewerQualification == null;
        boolean isViewer = noRequiredQualifications || viewerQualification != null && qualifications.contains(viewerQualification);
        boolean isPerformer1 = noRequiredQualifications || performer1Qualification == null && isViewer || qualifications.contains(performer1Qualification);
        boolean isPerformer2 = noRequiredQualifications || performer2Qualification == null && isPerformer1 || qualifications.contains(performer2Qualification);
        boolean isReviewer = noRequiredQualifications || reviewerQualification == null && (isPerformer1 || isPerformer2) || qualifications.contains(reviewerQualification);
        LinkedList<WorkOrderActivityChecklistSignatureResult> signatures = new LinkedList<WorkOrderActivityChecklistSignatureResult>();
        if (isPerformer1 || isReviewer || isViewer) {
            WorkOrderActivityChecklistSignatureResult perf1 = new WorkOrderActivityChecklistSignatureResult();
            perf1.setType("PB01");
            perf1.setSigner(workOrderActivityCheckList.getPerformer1Name());
            perf1.setViewAsViewer(isViewer);
            perf1.setViewAsPerformer(isPerformer1);
            perf1.setViewAsReviewer(isReviewer);
            perf1.setTime(workOrderActivityCheckList.getTimePerf1() != null ? workOrderActivityCheckList.getTimePerf1() : null);
            perf1.setResponsibilityCode(performer1Qualification);
            signatures.add(perf1);
        }
        if (!(performedBy2Hidden = taskPlan.getUserDefinedFields().getUdfchkbox02().booleanValue()) && (isPerformer2 || isReviewer || isViewer)) {
            WorkOrderActivityChecklistSignatureResult perf2 = new WorkOrderActivityChecklistSignatureResult();
            perf2.setType("PB02");
            perf2.setSigner(workOrderActivityCheckList.getPerformer2Name());
            perf2.setViewAsViewer(isViewer);
            perf2.setViewAsPerformer(isPerformer2);
            perf2.setViewAsReviewer(isReviewer);
            perf2.setTime(workOrderActivityCheckList.getTimePerf2() != null ? workOrderActivityCheckList.getTimePerf2() : null);
            perf2.setResponsibilityCode(performer2Qualification);
            signatures.add(perf2);
        }
        if (isPerformer1 || isPerformer2 || isReviewer || isViewer) {
            WorkOrderActivityChecklistSignatureResult reviewer = new WorkOrderActivityChecklistSignatureResult();
            reviewer.setType("RB01");
            reviewer.setSigner(workOrderActivityCheckList.getReviewerName());
            reviewer.setViewAsViewer(isViewer);
            reviewer.setViewAsPerformer(isReviewer);
            reviewer.setViewAsReviewer(isReviewer);
            reviewer.setTime(workOrderActivityCheckList.getTimeRev1() != null ? workOrderActivityCheckList.getTimeRev1() : null);
            if (reviewerQualification == null && performer1Qualification != null && performer2Qualification == null) {
                reviewerQualification = performer1Qualification;
            }
            reviewer.setResponsibilityCode(reviewerQualification);
            signatures.add(reviewer);
        }
        return signatures.toArray(new WorkOrderActivityChecklistSignatureResult[0]);
    }

    private MP7999_GetWorkOrderActivityCheckListDefault_001_Result getSignatureWS(InforContext context, String workOrderCode, String activityCode) throws InforException {
        MP7999_GetWorkOrderActivityCheckListDefault_001 getWorkOrderActivityCheckListDefault = new MP7999_GetWorkOrderActivityCheckListDefault_001();
        this.transformGetWorkOrderActivityCheckListDefaultRequest(getWorkOrderActivityCheckListDefault, workOrderCode, activityCode);
        return this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getWorkOrderActivityCheckListDefaultOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getWorkOrderActivityCheckListDefault);
    }

    private void transformGetWorkOrderActivityCheckListDefaultRequest(MP7999_GetWorkOrderActivityCheckListDefault_001 getWorkOrderActivityCheckListDefault, String workOrderCode, String activityCode) {
        ACTIVITYCODE activityCodeField = new ACTIVITYCODE();
        activityCodeField.setValue(Long.parseLong(activityCode));
        getWorkOrderActivityCheckListDefault.setACTIVITYCODE(activityCodeField);
        WOID_Type workOrderID = new WOID_Type();
        workOrderID.setJOBNUM(workOrderCode);
        workOrderID.setAuto_Generated(Boolean.valueOf(true));
        getWorkOrderActivityCheckListDefault.setWORKORDERID(workOrderID);
    }

    @Override
    public WorkOrderActivityChecklistSignatureResponse eSignWorkOrderActivityChecklist(InforContext context, WorkOrderActivityCheckListSignature workOrderActivityCheckListSignature) throws InforException {
        Signature signature = new Signature();
        signature.setUserCode(workOrderActivityCheckListSignature.getUserCode());
        signature.setPassword(workOrderActivityCheckListSignature.getPassword());
        signature.setSignatureType(workOrderActivityCheckListSignature.getSignatureType());
        context.setSignature(signature);
        if (signature.getSignatureType().endsWith("02")) {
            workOrderActivityCheckListSignature.setSequenceNumber(new BigInteger("2"));
        }
        if (workOrderActivityCheckListSignature.getSignatureType().startsWith("PB")) {
            return this.performWorkOrderActivityChecklist(context, workOrderActivityCheckListSignature);
        }
        return this.reviewWorkOrderActivityCheckList(context, workOrderActivityCheckListSignature);
    }

    private WorkOrderActivityChecklistSignatureResponse performWorkOrderActivityChecklist(InforContext context, WorkOrderActivityCheckListSignature workOrderActivityCheckListSignature) throws InforException {
        MP7997_PerformWorkOrderActivityCheckList_001 performWorkOrderActivityCheckList = new MP7997_PerformWorkOrderActivityCheckList_001();
        this.tools.getInforFieldTools().transformWSHubObject(performWorkOrderActivityCheckList, workOrderActivityCheckListSignature, context);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).performWorkOrderActivityCheckListOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), performWorkOrderActivityCheckList);
        MP7999_GetWorkOrderActivityCheckListDefault_001_Result getResult = this.getSignatureWS(context, workOrderActivityCheckListSignature.getWorkOrderCode(), workOrderActivityCheckListSignature.getActivityCodeValue().toString());
        if (workOrderActivityCheckListSignature.getSequenceNumber() != null && workOrderActivityCheckListSignature.getSequenceNumber().intValue() == 2) {
            return this.transformESIGNATUREtoResponse(getResult.getResultData().getWorkOrderActivityCheckListDefault().getPERFORMEDBYESIGN2().getESIGNATURE());
        }
        return this.transformESIGNATUREtoResponse(getResult.getResultData().getWorkOrderActivityCheckListDefault().getPERFORMEDBYESIGN().getESIGNATURE());
    }

    private WorkOrderActivityChecklistSignatureResponse reviewWorkOrderActivityCheckList(InforContext context, WorkOrderActivityCheckListSignature workOrderActivityCheckListSignature) throws InforException {
        MP7998_ReviewWorkOrderActivityCheckList_001 reviewWorkOrderActivityCheckList = new MP7998_ReviewWorkOrderActivityCheckList_001();
        this.tools.getInforFieldTools().transformWSHubObject(reviewWorkOrderActivityCheckList, workOrderActivityCheckListSignature, context);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).reviewWorkOrderActivityCheckListOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), reviewWorkOrderActivityCheckList);
        MP7999_GetWorkOrderActivityCheckListDefault_001_Result getResult = this.getSignatureWS(context, workOrderActivityCheckListSignature.getWorkOrderCode(), workOrderActivityCheckListSignature.getActivityCodeValue().toString());
        return this.transformESIGNATUREtoResponse(getResult.getResultData().getWorkOrderActivityCheckListDefault().getREVIEWEDBYESIGN().getESIGNATURE());
    }

    private WorkOrderActivityChecklistSignatureResponse transformESIGNATUREtoResponse(ESIGNATURE eSignature) {
        WorkOrderActivityChecklistSignatureResponse response = new WorkOrderActivityChecklistSignatureResponse();
        response.setSigner(eSignature.getUSERID().getDESCRIPTION());
        response.setTimeStamp(DataTypeTools.decodeInforDate(eSignature.getEXTERNALDATETIME()));
        return response;
    }

    @Override
    public String updateWorkOrderChecklist(InforContext context, WorkOrderActivityCheckList workOrderActivityCheckList) throws InforException {
        MP7914_GetWorkOrderActivityCheckList_001 getwoactchl = new MP7914_GetWorkOrderActivityCheckList_001();
        getwoactchl.setCHECKLISTCODE(workOrderActivityCheckList.getCheckListCode());
        MP7914_GetWorkOrderActivityCheckList_001_Result getresult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getWorkOrderActivityCheckListOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getwoactchl);
        net.datastream.schemas.mp_entities.workorderactivitychecklist_001.WorkOrderActivityCheckList workOrderActivityCheckListInfor = getresult.getResultData().getWorkOrderActivityCheckList();
        if (workOrderActivityCheckList.getFollowUp() != null) {
            this.tools.getDataTypeTools();
            workOrderActivityCheckListInfor.setFOLLOWUP(DataTypeTools.encodeBoolean(workOrderActivityCheckList.getFollowUp(), BooleanType.PLUS_MINUS));
        }
        if (workOrderActivityCheckList.getNotApplicableOption() != null) {
            USERDEFINEDCODEID_Type option = new USERDEFINEDCODEID_Type();
            option.setUSERDEFINEDCODE(workOrderActivityCheckList.getNotApplicableOption());
            workOrderActivityCheckListInfor.setNOTAPPLICABLEOPTION(option);
        }
        Function<String, String> getStringBool = key -> String.valueOf(key.equals(workOrderActivityCheckList.getResult()));
        switch (workOrderActivityCheckList.getType()) {
            case "01": {
                if ("COMPLETED".equalsIgnoreCase(workOrderActivityCheckList.getResult())) {
                    workOrderActivityCheckListInfor.setCOMPLETED("true");
                    break;
                }
                workOrderActivityCheckListInfor.setCOMPLETED("false");
                break;
            }
            case "02": {
                workOrderActivityCheckListInfor.setYES(getStringBool.apply("YES"));
                workOrderActivityCheckListInfor.setNO(getStringBool.apply("NO"));
                break;
            }
            case "03": {
                if (workOrderActivityCheckList.getFinding() != null) {
                    workOrderActivityCheckListInfor.setFINDINGID(new FINDINGID_Type());
                    workOrderActivityCheckListInfor.getFINDINGID().setFINDINGCODE(workOrderActivityCheckList.getFinding());
                    break;
                }
                workOrderActivityCheckListInfor.setFINDINGID(null);
                break;
            }
            case "06": {
                if (workOrderActivityCheckList.getFinding() != null) {
                    workOrderActivityCheckListInfor.setFINDINGID(new FINDINGID_Type());
                    workOrderActivityCheckListInfor.getFINDINGID().setFINDINGCODE(workOrderActivityCheckList.getFinding());
                } else {
                    workOrderActivityCheckListInfor.setFINDINGID(null);
                }
            }
            case "04": 
            case "05": {
                BigDecimal possibleNumericValue;
                BigDecimal numericValue = workOrderActivityCheckList.getNumericValue();
                if (numericValue == null && (possibleNumericValue = DataTypeTools.encodeBigDecimal(workOrderActivityCheckList.getResult(), "")) != null) {
                    numericValue = possibleNumericValue;
                }
                this.tools.getDataTypeTools();
                workOrderActivityCheckListInfor.setRESULTVALUE(DataTypeTools.encodeQuantity(numericValue, "Checklists Value"));
                break;
            }
            case "07": {
                workOrderActivityCheckListInfor.setOKFLAG(getStringBool.apply("OK"));
                workOrderActivityCheckListInfor.setREPAIRSNEEDED(getStringBool.apply("REPAIRSNEEDED"));
                if (DataTypeTools.isEmpty(workOrderActivityCheckList.getFinding())) {
                    workOrderActivityCheckListInfor.setRESOLUTIONID(null);
                    break;
                }
                workOrderActivityCheckListInfor.setRESOLUTIONID(new USERDEFINEDCODEID_Type());
                workOrderActivityCheckListInfor.getRESOLUTIONID().setUSERDEFINEDCODE(workOrderActivityCheckList.getFinding());
                break;
            }
            case "08": {
                workOrderActivityCheckListInfor.setGOOD(getStringBool.apply("GOOD"));
                workOrderActivityCheckListInfor.setPOOR(getStringBool.apply("POOR"));
                break;
            }
            case "10": {
                this.tools.getDataTypeTools();
                workOrderActivityCheckListInfor.setRESULTVALUE(DataTypeTools.encodeQuantity(workOrderActivityCheckList.getNumericValue(), "Checklists Value"));
            }
            case "09": {
                workOrderActivityCheckListInfor.setOKFLAG(getStringBool.apply("OK"));
                workOrderActivityCheckListInfor.setADJUSTED(getStringBool.apply("ADJUSTED"));
                break;
            }
            case "12": {
                this.tools.getDataTypeTools();
                workOrderActivityCheckListInfor.setRESULTVALUE(DataTypeTools.encodeQuantity(workOrderActivityCheckList.getNumericValue(), "Checklists Value"));
            }
            case "11": {
                workOrderActivityCheckListInfor.setOKFLAG(getStringBool.apply("OK"));
                workOrderActivityCheckListInfor.setNONCONFORMITYFLAG(getStringBool.apply("NONCONFORMITY"));
            }
        }
        if (workOrderActivityCheckList.getNotes() != null) {
            workOrderActivityCheckListInfor.setNOTES(workOrderActivityCheckList.getNotes());
        }
        MP7913_SyncWorkOrderActivityCheckList_001 syncwoactchl = new MP7913_SyncWorkOrderActivityCheckList_001();
        syncwoactchl.setWorkOrderActivityCheckList(workOrderActivityCheckListInfor);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncWorkOrderActivityCheckListOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncwoactchl);
        return null;
    }

    @Override
    public String createTaskplanChecklist(InforContext context, TaskplanCheckList taskChecklist) throws InforException {
        TaskChecklist taskChecklistInfor = new TaskChecklist();
        taskChecklistInfor.setTASKLISTID(new TASKLISTID_Type());
        taskChecklistInfor.getTASKLISTID().setORGANIZATIONID(this.tools.getOrganization(context));
        taskChecklistInfor.getTASKLISTID().setTASKCODE(taskChecklist.getTaskPlanCode());
        if (taskChecklist.getTaskPlanRevision() == null) {
            taskChecklistInfor.getTASKLISTID().setTASKREVISION(Long.valueOf(0L));
        } else {
            taskChecklistInfor.getTASKLISTID().setTASKREVISION(Long.valueOf(this.tools.getDataTypeTools().encodeLong(taskChecklist.getTaskPlanRevision(), "Task Revision")));
        }
        taskChecklistInfor.setCHECKLISTID(new CHECKLISTID_Type());
        taskChecklistInfor.getCHECKLISTID().setCHECKLISTCODE("0");
        taskChecklistInfor.getCHECKLISTID().setDESCRIPTION(taskChecklist.getChecklistDesc());
        taskChecklistInfor.setSEQUENCE(this.tools.getDataTypeTools().encodeLong(taskChecklist.getSequence(), "Sequence number"));
        taskChecklistInfor.setTYPE(new TYPE_Type());
        taskChecklistInfor.getTYPE().setTYPECODE(taskChecklist.getType());
        taskChecklistInfor.setREQUIREDTOCLOSEDOC(new USERDEFINEDCODEID_Type());
        taskChecklistInfor.getREQUIREDTOCLOSEDOC().setUSERDEFINEDCODE(taskChecklist.getRequiredEntry());
        taskChecklistInfor.setEQUIPMENTLEVEL(new USERDEFINEDCODEID_Type());
        taskChecklistInfor.getEQUIPMENTLEVEL().setUSERDEFINEDCODE(taskChecklist.getEquipmentLevel());
        if (taskChecklist.getFindings() != null) {
            taskChecklistInfor.setPOSSIBLEFINDINGS(taskChecklist.getFindings());
        }
        if (taskChecklist.getUOM() != null) {
            taskChecklistInfor.setUOMID(new UOMID_Type());
            taskChecklistInfor.getUOMID().setUOMCODE(taskChecklist.getUOM());
        }
        if (taskChecklist.getAspectCode() != null) {
            taskChecklistInfor.setASPECTID(new ASPECTID_Type());
            taskChecklistInfor.getASPECTID().setASPECTCODE(taskChecklist.getAspectCode());
        }
        if (taskChecklist.getPointType() != null) {
            taskChecklistInfor.setPOINTTYPEID(new POINTTYPEID_Type());
            taskChecklistInfor.getPOINTTYPEID().setPOINTTYPECODE(taskChecklist.getPointType());
        }
        taskChecklistInfor.setREPEATINGOCCURRENCES(taskChecklist.getRepeatingOccurrences());
        if (taskChecklist.getFollowUpTaskPlan() != null) {
            taskChecklistInfor.setFOLLOWUPTASKID(new TASKLISTID_Type());
            taskChecklistInfor.getFOLLOWUPTASKID().setORGANIZATIONID(this.tools.getOrganization(context));
            taskChecklistInfor.getFOLLOWUPTASKID().setTASKCODE(taskChecklist.getFollowUpTaskPlan());
            if (taskChecklist.getFollowUpTaskPlanRevision() != null) {
                taskChecklistInfor.getFOLLOWUPTASKID().setTASKREVISION(Long.valueOf(this.tools.getDataTypeTools().encodeLong(taskChecklist.getFollowUpTaskPlanRevision(), "Follow Up Task Plan Revision")));
            } else {
                taskChecklistInfor.getFOLLOWUPTASKID().setTASKREVISION(Long.valueOf(0L));
            }
        }
        if (taskChecklist.getClassCode() != null && !taskChecklist.getClassCode().trim().equals("")) {
            taskChecklistInfor.setCLASSID(new CLASSID_Type());
            taskChecklistInfor.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
            taskChecklistInfor.getCLASSID().setCLASSCODE(taskChecklist.getClassCode());
        }
        if (taskChecklist.getCategoryCode() != null && !taskChecklist.getCategoryCode().trim().equals("")) {
            taskChecklistInfor.setCATEGORYID(new CATEGORYID());
            taskChecklistInfor.getCATEGORYID().setCATEGORYCODE(taskChecklist.getCategoryCode());
        }
        MP7916_AddTaskChecklist_001 addTaskChecklist = new MP7916_AddTaskChecklist_001();
        addTaskChecklist.setTaskChecklist(taskChecklistInfor);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addTaskChecklistOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addTaskChecklist);
        return "OK";
    }

    @Override
    public WorkOrderActivityCheckList[] readWorkOrderChecklists(InforContext context, Activity activity) throws InforException {
        GridRequest gridRequest = new GridRequest("3315", "WSJOBS_ACK", "3369");
        gridRequest.setRowCount(2000);
        gridRequest.setUseNative(false);
        gridRequest.getParams().put("param.workordernum", activity.getWorkOrderNumber());
        gridRequest.getParams().put("param.activity", activity.getActivityCode());
        gridRequest.getParams().put("param.jobseq", "0");
        GridRequestResult gridRequestResult = this.gridsService.executeQuery(context, gridRequest);
        LinkedList<WorkOrderActivityCheckList> checklists = new LinkedList<WorkOrderActivityCheckList>();
        for (GridRequestRow row : gridRequestResult.getRows()) {
            checklists.add(this.getCheckList(context, row, activity));
        }
        return checklists.toArray(new WorkOrderActivityCheckList[0]);
    }

    private WorkOrderActivityCheckList getCheckList(InforContext context, GridRequestRow row, Activity activity) throws InforException {
        String required;
        WorkOrderActivityCheckList checklist = new WorkOrderActivityCheckList();
        checklist.setWorkOrderCode(activity.getWorkOrderNumber());
        checklist.setActivityCode(activity.getActivityCode());
        checklist.setCheckListCode(GridTools.getCellContent("checklistcode", row));
        checklist.setSequence(GridTools.getCellContent("checklistsequence", row));
        checklist.setEquipmentCode(GridTools.getCellContent("equipment", row));
        checklist.setEquipmentDesc(GridTools.getCellContent("equipmentdesc", row));
        checklist.setType(GridTools.getCellContent("checklisttype", row));
        checklist.setColor(GridTools.getCellContent("color", row));
        checklist.setFollowUp(DataTypeTools.decodeBoolean(GridTools.getCellContent("followup", row)));
        String followUpWorkOrderActivity = GridTools.getCellContent("followupwoactivity", row);
        this.tools.getDataTypeTools();
        if (DataTypeTools.isNotEmpty(followUpWorkOrderActivity)) {
            checklist.setFollowUpWorkOrder(followUpWorkOrderActivity.split("-")[0]);
        }
        if ("Yes".equals(required = GridTools.getCellContent("requiredtoclosedocument", row))) {
            checklist.setRequiredToClose(true);
        } else {
            checklist.setRequiredToClose(false);
        }
        checklist.setNotes(GridTools.getCellContent("notes", row));
        checklist.setDesc(GridTools.getCellContent("checklistdescription", row));
        checklist.setHideFollowUp(this.cellEquals(row, "hidefollowup", "true"));
        checklist.setMinimumValue(DataTypeTools.encodeBigInteger(GridTools.getCellContent("minimumslidervalue", row), "minimumslidervalue"));
        checklist.setMaximumValue(DataTypeTools.encodeBigInteger(GridTools.getCellContent("maximumslidervalue", row), "maximumslidervalue"));
        checklist.setNotApplicableOption(GridTools.getCellContent("notapplicable", row));
        checklist.setChecklistDefinitionCode(GridTools.getCellContent("taskchecklistcode", row));
        switch (checklist.getType()) {
            case "01": {
                if (this.cellEquals(row, "completed", "true")) {
                    checklist.setResult("COMPLETED");
                    break;
                }
                checklist.setResult(WorkOrderActivityCheckList.ReturnType.NULL);
                break;
            }
            case "02": {
                if (this.cellEquals(row, "yes", "true")) {
                    checklist.setResult("YES");
                    break;
                }
                if (this.cellEquals(row, "no", "true")) {
                    checklist.setResult("NO");
                    break;
                }
                checklist.setResult(null);
                break;
            }
            case "03": {
                checklist.setFinding(GridTools.getCellContent("finding", row));
                checklist.setPossibleFindings(this.getPossibleFindings(context, row));
                break;
            }
            case "06": {
                checklist.setFinding(GridTools.getCellContent("finding", row));
                checklist.setPossibleFindings(this.getPossibleFindings(context, row));
            }
            case "04": 
            case "05": {
                checklist.setNumericValue(DataTypeTools.encodeBigDecimal(GridTools.getCellContent("value", row), ""));
                checklist.setUOM(GridTools.getCellContent("uom", row));
                checklist.setResult(GridTools.getCellContent("value", row));
                break;
            }
            case "08": {
                if (this.cellEquals(row, "good", "true")) {
                    checklist.setResult("GOOD");
                    break;
                }
                if (this.cellEquals(row, "poor", "true")) {
                    checklist.setResult("POOR");
                    break;
                }
                checklist.setResult(WorkOrderActivityCheckList.ReturnType.NULL);
                break;
            }
            case "12": {
                checklist.setNumericValue(DataTypeTools.encodeBigDecimal(GridTools.getCellContent("value", row), ""));
                checklist.setUOM(GridTools.getCellContent("uom", row));
            }
            case "11": {
                if (this.cellEquals(row, "ok", "true")) {
                    checklist.setResult("OK");
                    break;
                }
                if (this.cellEquals(row, "nonconformityfound", "true")) {
                    checklist.setResult("NONCONFORMITY");
                    break;
                }
                checklist.setResult(WorkOrderActivityCheckList.ReturnType.NULL);
                break;
            }
            case "10": {
                checklist.setNumericValue(DataTypeTools.encodeBigDecimal(GridTools.getCellContent("value", row), ""));
                checklist.setUOM(GridTools.getCellContent("uom", row));
            }
            case "09": {
                if (this.cellEquals(row, "ok", "true")) {
                    checklist.setResult("OK");
                    break;
                }
                if (this.cellEquals(row, "adjusted", "true")) {
                    checklist.setResult("ADJUSTED");
                    break;
                }
                checklist.setResult(WorkOrderActivityCheckList.ReturnType.NULL);
                break;
            }
            case "07": {
                checklist.setFinding(GridTools.getCellContent("resolution", row));
                if (this.cellEquals(row, "ok", "true")) {
                    checklist.setResult("OK");
                    break;
                }
                if (this.cellEquals(row, "repairsneeded", "true")) {
                    checklist.setResult("REPAIRSNEEDED");
                    break;
                }
                checklist.setResult(WorkOrderActivityCheckList.ReturnType.NULL);
            }
        }
        return checklist;
    }

    private List<Finding> getPossibleFindings(InforContext context, GridRequestRow row) {
        List<String> possibleFindings = Arrays.asList(GridTools.getCellContent("possiblefindings", row).split(","));
        for (String findingCode2 : possibleFindings) {
            if (findingsCache.containsKey(findingCode2)) continue;
            try {
                GridRequest gridRequest = new GridRequest("ISFIND", GridRequest.GRIDTYPE.LIST);
                gridRequest.addFilter("findingcode", findingCode2, "=");
                findingsCache.put(findingCode2, GridTools.extractSingleResult(this.gridsService.executeQuery(context, gridRequest), "findingdesc"));
            }
            catch (Exception e) {
                this.tools.log(Level.WARNING, "Finding could not be fetched: " + e.getMessage());
            }
        }
        return possibleFindings.stream().map(findingCode -> new Finding((String)findingCode, findingsCache.containsKey(findingCode) ? findingsCache.get(findingCode) : findingCode)).collect(Collectors.toList());
    }

    private boolean cellEquals(GridRequestRow row, String key, String value) {
        return GridTools.getCellContent(key, row) != null && GridTools.getCellContent(key, row).equals(value);
    }

    private String getValue(ResultSet v_result) throws SQLException {
        Double value = v_result.getDouble("ack_value");
        if (v_result.wasNull()) {
            return null;
        }
        return Double.toString(value);
    }

    @Override
    public Long createFollowUpWorkOrders(InforContext context, Activity activity) throws InforException {
        Long activityNumber;
        MP8000_CreateFollowUpWorkOrder_001 createFUWO = new MP8000_CreateFollowUpWorkOrder_001();
        try {
            activityNumber = Long.valueOf(activity.getActivityCode());
        }
        catch (Exception e) {
            throw new InforException("Activity code '" + activity.getActivityCode() + "' is not a valid number.", e.getCause(), null);
        }
        createFUWO.setACTIVITYID(new ACTIVITYID());
        createFUWO.getACTIVITYID().setWORKORDERID(new WOID_Type());
        createFUWO.getACTIVITYID().getWORKORDERID().setJOBNUM(activity.getWorkOrderNumber());
        createFUWO.getACTIVITYID().setACTIVITYCODE(new ACTIVITYCODE());
        createFUWO.getACTIVITYID().getACTIVITYCODE().setValue(activityNumber.longValue());
        createFUWO.getACTIVITYID().getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        MP8000_CreateFollowUpWorkOrder_001_Result createFUWOResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).createFollowUpWorkOrderOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), createFUWO);
        return createFUWOResult.getResultData().getWORKORDERCOUNT();
    }

    @Override
    public WorkOrderActivityCheckListDefinition getChecklistDefinition(InforContext context, TaskPlan taskPlan, String code) throws InforException {
        GridRequest gridRequest = new GridRequest("WSTASK_TCH", 1);
        gridRequest.addParam("param.task", taskPlan.getCode());
        gridRequest.addParam("param.revision", taskPlan.getTaskRevision() == null ? null : taskPlan.getTaskRevision().toString());
        gridRequest.addFilter("checklistitem", code, "EQUALS");
        GridRequestResult result = this.gridsService.executeQuery(context, gridRequest);
        WorkOrderActivityCheckListDefinition definition = GridTools.convertGridResultToObject(WorkOrderActivityCheckListDefinition.class, null, result).stream().findFirst().orElse(null);
        String notApplicableOptionsString = GridTools.extractSingleResult(result, "naoptions");
        if (notApplicableOptionsString == null || "".equals(notApplicableOptionsString)) {
            return definition;
        }
        GridRequest notApplicableOptionsRequest = new GridRequest("LVNAOPTIONS", 2000);
        Map<String, String> notApplicableOptionsMap = GridTools.convertGridResultToMap("code", "description", this.gridsService.executeQuery(context, notApplicableOptionsRequest));
        List<Pair> notApplicableOptions = Arrays.stream(notApplicableOptionsString.split(",")).map(optionCode -> new Pair((String)optionCode, (String)notApplicableOptionsMap.get(optionCode))).collect(Collectors.toList());
        definition.setNotApplicableOptions(notApplicableOptions);
        return definition;
    }
}

