/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.client;

import ch.cern.eam.wshub.core.interceptors.InforInterceptor;
import ch.cern.eam.wshub.core.interceptors.InforInvocationHandler;
import ch.cern.eam.wshub.core.services.administration.DataspyService;
import ch.cern.eam.wshub.core.services.administration.UserGroupMenuService;
import ch.cern.eam.wshub.core.services.administration.UserSetupService;
import ch.cern.eam.wshub.core.services.administration.impl.DataspyServiceImpl;
import ch.cern.eam.wshub.core.services.administration.impl.UserGroupMenuServiceImpl;
import ch.cern.eam.wshub.core.services.administration.impl.UserSetupServiceImpl;
import ch.cern.eam.wshub.core.services.comments.CommentService;
import ch.cern.eam.wshub.core.services.comments.impl.CommentServiceImpl;
import ch.cern.eam.wshub.core.services.documents.DocumentsService;
import ch.cern.eam.wshub.core.services.documents.impl.DocumentsServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.AssetService;
import ch.cern.eam.wshub.core.services.equipment.CategoryService;
import ch.cern.eam.wshub.core.services.equipment.EquipmentConfigurationService;
import ch.cern.eam.wshub.core.services.equipment.EquipmentFacadeService;
import ch.cern.eam.wshub.core.services.equipment.EquipmentGenerationService;
import ch.cern.eam.wshub.core.services.equipment.EquipmentOtherService;
import ch.cern.eam.wshub.core.services.equipment.EquipmentStructureService;
import ch.cern.eam.wshub.core.services.equipment.EquipmentWarrantyCoverageService;
import ch.cern.eam.wshub.core.services.equipment.LinearReferenceService;
import ch.cern.eam.wshub.core.services.equipment.LocationService;
import ch.cern.eam.wshub.core.services.equipment.PMScheduleService;
import ch.cern.eam.wshub.core.services.equipment.PositionService;
import ch.cern.eam.wshub.core.services.equipment.SystemService;
import ch.cern.eam.wshub.core.services.equipment.impl.AssetServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.CategoryServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.EquipmentConfigurationServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.EquipmentFacadeServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.EquipmentGenerationServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.EquipmentOtherServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.EquipmentStructureServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.EquipmentWarrantyCoverageServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.LinearReferenceServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.LocationServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.PMScheduleServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.PositionServiceImpl;
import ch.cern.eam.wshub.core.services.equipment.impl.SystemServiceImpl;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.impl.GridsServiceImpl;
import ch.cern.eam.wshub.core.services.material.PartBinStockService;
import ch.cern.eam.wshub.core.services.material.PartKitService;
import ch.cern.eam.wshub.core.services.material.PartLotService;
import ch.cern.eam.wshub.core.services.material.PartManufacturerService;
import ch.cern.eam.wshub.core.services.material.PartMiscService;
import ch.cern.eam.wshub.core.services.material.PartService;
import ch.cern.eam.wshub.core.services.material.PartStoreService;
import ch.cern.eam.wshub.core.services.material.PhysicalInventoryService;
import ch.cern.eam.wshub.core.services.material.PickTicketService;
import ch.cern.eam.wshub.core.services.material.PurchaseOrdersService;
import ch.cern.eam.wshub.core.services.material.impl.PartBinStockServiceImpl;
import ch.cern.eam.wshub.core.services.material.impl.PartKitServiceImpl;
import ch.cern.eam.wshub.core.services.material.impl.PartLotServiceImpl;
import ch.cern.eam.wshub.core.services.material.impl.PartManufacturerServiceImpl;
import ch.cern.eam.wshub.core.services.material.impl.PartMiscServiceImpl;
import ch.cern.eam.wshub.core.services.material.impl.PartServiceImpl;
import ch.cern.eam.wshub.core.services.material.impl.PartStoreServiceImpl;
import ch.cern.eam.wshub.core.services.material.impl.PhysicalInventoryServiceImpl;
import ch.cern.eam.wshub.core.services.material.impl.PickTicketServiceImpl;
import ch.cern.eam.wshub.core.services.material.impl.PurchaseOrdersImpl;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedListService;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedScreenService;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedTableService;
import ch.cern.eam.wshub.core.services.userdefinedscreens.impl.UserDefinedListServiceImpl;
import ch.cern.eam.wshub.core.services.userdefinedscreens.impl.UserDefinedScreenServiceImpl;
import ch.cern.eam.wshub.core.services.userdefinedscreens.impl.UserDefinedTableServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.CaseService;
import ch.cern.eam.wshub.core.services.workorders.CaseTaskService;
import ch.cern.eam.wshub.core.services.workorders.ChecklistService;
import ch.cern.eam.wshub.core.services.workorders.EmployeeService;
import ch.cern.eam.wshub.core.services.workorders.InspectionService;
import ch.cern.eam.wshub.core.services.workorders.LaborBookingService;
import ch.cern.eam.wshub.core.services.workorders.MECService;
import ch.cern.eam.wshub.core.services.workorders.RouteService;
import ch.cern.eam.wshub.core.services.workorders.SafetyService;
import ch.cern.eam.wshub.core.services.workorders.SalesPriceService;
import ch.cern.eam.wshub.core.services.workorders.StandardWorkOrderChildService;
import ch.cern.eam.wshub.core.services.workorders.StandardWorkOrderService;
import ch.cern.eam.wshub.core.services.workorders.TaskPlanService;
import ch.cern.eam.wshub.core.services.workorders.WorkOrderMiscService;
import ch.cern.eam.wshub.core.services.workorders.WorkOrderService;
import ch.cern.eam.wshub.core.services.workorders.impl.CaseServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.impl.CaseTaskServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.impl.ChecklistServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.impl.EmployeeServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.impl.InspectionServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.impl.LaborBookingServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.impl.MECServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.impl.RouteServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.impl.SafetyServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.impl.SalesPricesImpl;
import ch.cern.eam.wshub.core.services.workorders.impl.StandardWorkOrderChildServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.impl.StandardWorkOrderServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.impl.TaskPlanServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.impl.WorkOrderMiscServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.impl.WorkOrderServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.Tools;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class InforClient
implements Serializable {
    private Tools tools;
    private InvocationHandler invocationHandler;
    private InforWebServicesPT inforWebServicesToolkitClient;
    private BindingProvider bindingProvider;
    private CommentService commentService;
    private WorkOrderService workOrderService;
    private StandardWorkOrderService standardWorkOrderService;
    private StandardWorkOrderChildService standardWorkOrderChildService;
    private CaseService caseService;
    private CaseTaskService caseTaskService;
    private LaborBookingService laborBookingService;
    private WorkOrderMiscService workOrderMiscService;
    private EmployeeService employeeService;
    private ChecklistService checklistService;
    private InspectionService inspectionService;
    private RouteService routeService;
    private TaskPlanService taskPlanService;
    private SalesPriceService salesPriceService;
    private AssetService assetService;
    private PositionService positionService;
    private SystemService systemService;
    private LocationService locationService;
    private EquipmentFacadeService equipmentFacadeService;
    private EquipmentStructureService equipmentStructureService;
    private LinearReferenceService linearReferenceService;
    private PMScheduleService pmScheduleService;
    private EquipmentWarrantyCoverageService equipmentWarrantyCoverageService;
    private EquipmentOtherService equipmentOtherService;
    private PartService partService;
    private PartKitService partKitService;
    private PartMiscService partMiscService;
    private PartStoreService partStoreService;
    private PartManufacturerService partManufacturerService;
    private PartBinStockService partBinStockService;
    private PartLotService partLotService;
    private PurchaseOrdersService purchaseOrdersService;
    private PickTicketService pickTicketService;
    private PhysicalInventoryService physicalInventoryService;
    private UserSetupService userSetupService;
    private GridsService gridsService;
    private DocumentsService documentsService;
    private DataspyService dataspyService;
    private UserGroupMenuService userGroupMenuService;
    private EquipmentGenerationService equipmentGenerationService;
    private EquipmentConfigurationService equipmentConfigurationService;
    private UserDefinedTableService userDefinedTableServices;
    private UserDefinedListService userDefinedListService;
    private UserDefinedScreenService userDefinedScreenService;
    private MECService mecService;
    private SafetyService safetyService;
    private CategoryService categoryService;

    private InforClient() {
    }

    public CommentService getCommentService() {
        return this.commentService;
    }

    public WorkOrderService getWorkOrderService() {
        return this.workOrderService;
    }

    public StandardWorkOrderService getStandardWorkOrderService() {
        return this.standardWorkOrderService;
    }

    public StandardWorkOrderChildService getStandardWorkOrderChildService() {
        return this.standardWorkOrderChildService;
    }

    public void setStandardWorkOrderChildService(StandardWorkOrderChildService standardWorkOrderChildService) {
        this.standardWorkOrderChildService = standardWorkOrderChildService;
    }

    public AssetService getAssetService() {
        return this.assetService;
    }

    public PositionService getPositionService() {
        return this.positionService;
    }

    public SystemService getSystemService() {
        return this.systemService;
    }

    public EquipmentFacadeService getEquipmentFacadeService() {
        return this.equipmentFacadeService;
    }

    public EquipmentStructureService getEquipmentStructureService() {
        return this.equipmentStructureService;
    }

    public LinearReferenceService getLinearReferenceService() {
        return this.linearReferenceService;
    }

    public PMScheduleService getPmScheduleService() {
        return this.pmScheduleService;
    }

    public EquipmentWarrantyCoverageService getEquipmentWarrantyCoverageService() {
        return this.equipmentWarrantyCoverageService;
    }

    public EquipmentOtherService getEquipmentOtherService() {
        return this.equipmentOtherService;
    }

    public PartService getPartService() {
        return this.partService;
    }

    public PartMiscService getPartMiscService() {
        return this.partMiscService;
    }

    public PartStoreService getPartStoreService() {
        return this.partStoreService;
    }

    public PartManufacturerService getPartManufacturerService() {
        return this.partManufacturerService;
    }

    public PartBinStockService getPartBinStockService() {
        return this.partBinStockService;
    }

    public PartLotService getPartLotService() {
        return this.partLotService;
    }

    public LocationService getLocationService() {
        return this.locationService;
    }

    public CaseService getCaseService() {
        return this.caseService;
    }

    public LaborBookingService getLaborBookingService() {
        return this.laborBookingService;
    }

    public WorkOrderMiscService getWorkOrderMiscService() {
        return this.workOrderMiscService;
    }

    public EmployeeService getEmployeeService() {
        return this.employeeService;
    }

    public CaseTaskService getCaseTaskService() {
        return this.caseTaskService;
    }

    public ChecklistService getChecklistService() {
        return this.checklistService;
    }

    public InspectionService getInspectionService() {
        return this.inspectionService;
    }

    public UserSetupService getUserSetupService() {
        return this.userSetupService;
    }

    public GridsService getGridsService() {
        return this.gridsService;
    }

    public PartKitService getPartKitService() {
        return this.partKitService;
    }

    public PurchaseOrdersService getPurchaseOrdersService() {
        return this.purchaseOrdersService;
    }

    public DocumentsService getDocumentsService() {
        return this.documentsService;
    }

    public PickTicketService getPickTicketService() {
        return this.pickTicketService;
    }

    public PhysicalInventoryService getPhysicalInventoryService() {
        return this.physicalInventoryService;
    }

    public UserDefinedTableService getUserDefinedTableServices() {
        return this.userDefinedTableServices;
    }

    public UserDefinedListService getUserDefinedListService() {
        return this.userDefinedListService;
    }

    public InforWebServicesPT getInforWebServicesToolkitClient() {
        return this.inforWebServicesToolkitClient;
    }

    public Tools getTools() {
        return this.tools;
    }

    public EquipmentGenerationService getEquipmentGenerationService() {
        return this.equipmentGenerationService;
    }

    public EquipmentConfigurationService getEquipmentConfigurationService() {
        return this.equipmentConfigurationService;
    }

    public RouteService getRouteService() {
        return this.routeService;
    }

    public DataspyService getDataspyService() {
        return this.dataspyService;
    }

    public UserGroupMenuService getUserGroupMenuService() {
        return this.userGroupMenuService;
    }

    public BindingProvider getBindingProvider() {
        return this.bindingProvider;
    }

    public SafetyService getSafetyService() {
        return this.safetyService;
    }

    public MECService getMECService() {
        return this.mecService;
    }

    public TaskPlanService getTaskPlanService() {
        return this.taskPlanService;
    }

    public SalesPriceService getSalesPriceService() {
        return this.salesPriceService;
    }

    public UserDefinedScreenService getUserDefinedScreenService() {
        return this.userDefinedScreenService;
    }

    public CategoryService getCategoryService() {
        return this.categoryService;
    }

    public static class Builder {
        private String url;
        private String tenant;
        private String defaultOrganizationCode;
        private InforInterceptor inforInterceptor;
        private HandlerResolver soapHandlerResolver;
        private ExecutorService executorService;
        private DataSource dataSource;
        private EntityManagerFactory entityManagerFactory;
        private Logger logger;
        private Boolean withJPAGridsAuthentication = false;

        public Builder(String url) {
            this.url = url;
        }

        public Builder withDefaultTenant(String defaultTenant) {
            this.tenant = defaultTenant;
            return this;
        }

        public Builder withDefaultOrganizationCode(String defaultOrganizationCode) {
            this.defaultOrganizationCode = defaultOrganizationCode;
            return this;
        }

        public Builder withInforInterceptor(InforInterceptor inforInterceptor) {
            this.inforInterceptor = inforInterceptor;
            return this;
        }

        public Builder withSOAPHandlerResolver(HandlerResolver soapHandlerResolver) {
            this.soapHandlerResolver = soapHandlerResolver;
            return this;
        }

        public Builder withExecutorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder withDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder withEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
            this.entityManagerFactory = entityManagerFactory;
            return this;
        }

        public Builder withLogger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder withJPAGridsAuthentication() {
            this.withJPAGridsAuthentication = true;
            return this;
        }

        private <T> T proxy(Class<T> targetClass, T target, InforInterceptor inforInterceptor, Tools tools) {
            return (T)Proxy.newProxyInstance(targetClass.getClassLoader(), new Class[]{targetClass}, new InforInvocationHandler<T>(target, inforInterceptor, tools));
        }

        public InforClient build() {
            InforClient inforClient = new InforClient();
            ApplicationData applicationData = new ApplicationData();
            applicationData.setUrl(this.url);
            applicationData.setOrganization(this.defaultOrganizationCode);
            applicationData.setTenant(this.tenant);
            applicationData.setWithJPAGridsAuthentication(this.withJPAGridsAuthentication);
            Service service = Service.create((QName)new QName("inforws"));
            if (this.soapHandlerResolver != null) {
                service.setHandlerResolver(this.soapHandlerResolver);
            }
            InforWebServicesPT inforWebServicesToolkitClient = (InforWebServicesPT)service.getPort(InforWebServicesPT.class);
            inforClient.bindingProvider = (BindingProvider)inforWebServicesToolkitClient;
            inforClient.bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", applicationData.getUrl());
            inforClient.bindingProvider.getRequestContext().put("set-jaxb-validation-event-handler", false);
            if (this.executorService != null) {
                // empty if block
            }
            Tools tools = new Tools(applicationData, inforWebServicesToolkitClient, this.executorService, this.dataSource, this.entityManagerFactory, this.logger);
            inforClient.tools = tools;
            inforClient.workOrderService = this.proxy(WorkOrderService.class, new WorkOrderServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.standardWorkOrderService = this.proxy(StandardWorkOrderService.class, new StandardWorkOrderServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.standardWorkOrderChildService = this.proxy(StandardWorkOrderChildService.class, new StandardWorkOrderChildServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.commentService = this.proxy(CommentService.class, new CommentServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.caseService = this.proxy(CaseService.class, new CaseServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.caseTaskService = this.proxy(CaseTaskService.class, new CaseTaskServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.checklistService = this.proxy(ChecklistService.class, new ChecklistServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.inspectionService = this.proxy(InspectionService.class, new InspectionServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.laborBookingService = this.proxy(LaborBookingService.class, new LaborBookingServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.workOrderMiscService = this.proxy(WorkOrderMiscService.class, new WorkOrderMiscServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.employeeService = this.proxy(EmployeeService.class, new EmployeeServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.categoryService = this.proxy(CategoryService.class, new CategoryServiceImpl(tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.assetService = this.proxy(AssetService.class, new AssetServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.positionService = this.proxy(PositionService.class, new PositionServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.systemService = this.proxy(SystemService.class, new SystemServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.equipmentFacadeService = this.proxy(EquipmentFacadeService.class, new EquipmentFacadeServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.equipmentStructureService = this.proxy(EquipmentStructureService.class, new EquipmentStructureServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.linearReferenceService = this.proxy(LinearReferenceService.class, new LinearReferenceServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.pmScheduleService = this.proxy(PMScheduleService.class, new PMScheduleServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.equipmentWarrantyCoverageService = this.proxy(EquipmentWarrantyCoverageService.class, new EquipmentWarrantyCoverageServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.equipmentOtherService = this.proxy(EquipmentOtherService.class, new EquipmentOtherServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.partService = this.proxy(PartService.class, new PartServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.partMiscService = this.proxy(PartMiscService.class, new PartMiscServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.partStoreService = this.proxy(PartStoreService.class, new PartStoreServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.partManufacturerService = this.proxy(PartManufacturerService.class, new PartManufacturerServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.partBinStockService = this.proxy(PartBinStockService.class, new PartBinStockServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.partLotService = this.proxy(PartLotService.class, new PartLotServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.locationService = this.proxy(LocationService.class, new LocationServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.partKitService = this.proxy(PartKitService.class, new PartKitServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.purchaseOrdersService = this.proxy(PurchaseOrdersService.class, new PurchaseOrdersImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.userSetupService = this.proxy(UserSetupService.class, new UserSetupServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.gridsService = this.proxy(GridsService.class, new GridsServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.documentsService = this.proxy(DocumentsService.class, new DocumentsServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.pickTicketService = this.proxy(PickTicketService.class, new PickTicketServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.physicalInventoryService = this.proxy(PhysicalInventoryService.class, new PhysicalInventoryServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.equipmentGenerationService = this.proxy(EquipmentGenerationService.class, new EquipmentGenerationServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.equipmentConfigurationService = this.proxy(EquipmentConfigurationService.class, new EquipmentConfigurationServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.dataspyService = this.proxy(DataspyService.class, new DataspyServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.userGroupMenuService = this.proxy(UserGroupMenuService.class, new UserGroupMenuServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.userDefinedTableServices = this.proxy(UserDefinedTableService.class, new UserDefinedTableServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.userDefinedListService = this.proxy(UserDefinedListService.class, new UserDefinedListServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.routeService = this.proxy(RouteService.class, new RouteServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.mecService = this.proxy(MECService.class, new MECServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.inforWebServicesToolkitClient = inforWebServicesToolkitClient;
            inforClient.safetyService = this.proxy(SafetyService.class, new SafetyServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.taskPlanService = this.proxy(TaskPlanService.class, new TaskPlanServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.salesPriceService = this.proxy(SalesPriceService.class, new SalesPricesImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            inforClient.userDefinedScreenService = this.proxy(UserDefinedScreenService.class, new UserDefinedScreenServiceImpl(applicationData, tools, inforWebServicesToolkitClient), this.inforInterceptor, tools);
            if (!tools.isDatabaseConnectionConfigured()) {
                this.logger.log(Level.WARNING, "Some of the services might require a database connection.");
            }
            return inforClient;
        }
    }
}

