/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.userdefinedscreens.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedScreenService;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDTRow;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.datastream.schemas.mp_fields.USERDEFINEDSCREENFIELDDATA_Type;
import net.datastream.schemas.mp_fields.USERDEFINEDSCREENFIELDVALUELIST;
import net.datastream.schemas.mp_fields.USERDEFINEDSCREENFIELDVALUEPAIR;
import net.datastream.schemas.mp_functions.mp6441_001.MP6441_ProcessUserDefinedScreenService_001;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class UserDefinedScreenServiceImpl
implements UserDefinedScreenService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public UserDefinedScreenServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public String createUserDefinedScreenRow(InforContext inforContext, String screenName, UDTRow udtRow) throws InforException {
        this.tools.performInforOperation(inforContext, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).processUserDefinedScreenServiceOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), this.getUserDefinedScreenService(screenName, "ADD", udtRow));
        return screenName;
    }

    @Override
    public String deleteUserDefinedScreenRow(InforContext inforContext, String screenName, UDTRow udtRow) throws InforException {
        this.tools.performInforOperation(inforContext, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).processUserDefinedScreenServiceOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), this.getUserDefinedScreenService(screenName, "DELETE", udtRow));
        return screenName;
    }

    private MP6441_ProcessUserDefinedScreenService_001 getUserDefinedScreenService(String screenName, String screenAction, UDTRow udtRow) throws InforException {
        MP6441_ProcessUserDefinedScreenService_001 userDefinedScreenService = new MP6441_ProcessUserDefinedScreenService_001();
        userDefinedScreenService.setUserDefinedScreenService(new net.datastream.schemas.mp_entities.userdefinedscreenservice_001.UserDefinedScreenService());
        userDefinedScreenService.getUserDefinedScreenService().setUSERDEFINEDSCREENNAME(screenName);
        userDefinedScreenService.getUserDefinedScreenService().setUSERDEFINEDSERVICEACTION(screenAction);
        userDefinedScreenService.getUserDefinedScreenService().setUSERDEFINEDSCREENFIELDVALUELIST(new USERDEFINEDSCREENFIELDVALUELIST());
        List udsFields = userDefinedScreenService.getUserDefinedScreenService().getUSERDEFINEDSCREENFIELDVALUELIST().getUSERDEFINEDSCREENFIELDVALUEPAIR();
        udsFields.addAll(this.getPairList(udtRow.getStrings()));
        udsFields.addAll(this.getPairList(udtRow.getDates()));
        udsFields.addAll(this.getPairList(udtRow.getDates()));
        return userDefinedScreenService;
    }

    private <T> List<USERDEFINEDSCREENFIELDVALUEPAIR> getPairList(Map<String, T> values) throws InforException {
        LinkedList<USERDEFINEDSCREENFIELDVALUEPAIR> result = new LinkedList<USERDEFINEDSCREENFIELDVALUEPAIR>();
        if (values == null) {
            return new LinkedList<USERDEFINEDSCREENFIELDVALUEPAIR>();
        }
        for (String value : values.keySet()) {
            result.add(this.getPair(value, values.get(value)));
        }
        return result;
    }

    private <T> USERDEFINEDSCREENFIELDVALUEPAIR getPair(String fieldName, T fieldValue) throws InforException {
        USERDEFINEDSCREENFIELDVALUEPAIR pair = new USERDEFINEDSCREENFIELDVALUEPAIR();
        pair.setUSERDEFINEDSCREENFIELDNAME(fieldName);
        pair.setUSERDEFINEDSCREENFIELDVALUE(new USERDEFINEDSCREENFIELDDATA_Type());
        if (fieldValue instanceof String) {
            pair.getUSERDEFINEDSCREENFIELDVALUE().setTEXTDATA((String)fieldValue);
        }
        if (fieldValue instanceof BigDecimal) {
            pair.getUSERDEFINEDSCREENFIELDVALUE().setNUMERICDATA(DataTypeTools.encodeAmount((BigDecimal)fieldValue, fieldName));
        }
        if (fieldValue instanceof Date) {
            pair.getUSERDEFINEDSCREENFIELDVALUE().setDATETIMEDATA(DataTypeTools.encodeInforDate((Date)fieldValue, fieldName));
        }
        return pair;
    }
}

