/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.entities;

import java.util.Arrays;

public class AspectPoint
implements Comparable<AspectPoint> {
    private String aspectCode;
    private String pointCode;
    private String pointType;

    public String getAspectCode() {
        return this.aspectCode;
    }

    public void setAspectCode(String aspectCode) {
        this.aspectCode = aspectCode;
    }

    public String getPointCode() {
        return this.pointCode;
    }

    public void setPointCode(String pointCode) {
        this.pointCode = pointCode;
    }

    public String getPointType() {
        return this.pointType;
    }

    public void setPointType(String pointType) {
        this.pointType = pointType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aspectCode == null ? 0 : this.aspectCode.hashCode());
        result = 31 * result + (this.pointCode == null ? 0 : this.pointCode.hashCode());
        result = 31 * result + (this.pointType == null ? 0 : this.pointType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AspectPoint other = (AspectPoint)obj;
        if (this.aspectCode == null ? other.aspectCode != null : !this.aspectCode.equals(other.aspectCode)) {
            return false;
        }
        if (this.pointCode == null ? other.pointCode != null : !this.pointCode.equals(other.pointCode)) {
            return false;
        }
        return !(this.pointType == null ? other.pointType != null : !this.pointType.equals(other.pointType));
    }

    public int getOrder(String pointType1, String pointType2) {
        String[] pointTypes = new String[]{"VOLU", "SOLC", "MCP", "SOLT", "HUIS", "LAV", "WC", "URI", "DOU", "AUX", "EQFI", "TSH", "TSV", "SGS", "POUB", "BUR", "TAB", "TEL", "INT", "LAMP", "CEN"};
        try {
            int pt1 = Arrays.asList(pointTypes).indexOf(pointType1);
            int pt2 = Arrays.asList(pointTypes).indexOf(pointType2);
            if (pt1 == pt2) {
                return 0;
            }
            if (pt1 < pt2) {
                return -1;
            }
            if (pt1 > pt2) {
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int compareTo(AspectPoint ap2) {
        if (this.getOrder(this.pointType, ap2.getPointType()) < 0) {
            return -1;
        }
        if (this.getOrder(this.pointType, ap2.getPointType()) > 0) {
            return 1;
        }
        if (this.getOrder(this.pointType, ap2.getPointType()) == 0) {
            if (this.aspectCode.compareTo(ap2.getAspectCode()) < 0) {
                return -1;
            }
            if (this.aspectCode.compareTo(ap2.getAspectCode()) > 0) {
                return 1;
            }
            if (this.aspectCode.compareTo(ap2.getAspectCode()) == 0) {
                return 0;
            }
        }
        return 0;
    }
}

