/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.comments.CommentService;
import ch.cern.eam.wshub.core.services.comments.entities.Comment;
import ch.cern.eam.wshub.core.services.comments.impl.CommentServiceImpl;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.impl.GridsServiceImpl;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedListService;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.EntityId;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDLValue;
import ch.cern.eam.wshub.core.services.userdefinedscreens.impl.UserDefinedListServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.StandardWorkOrderService;
import ch.cern.eam.wshub.core.services.workorders.WorkOrderService;
import ch.cern.eam.wshub.core.services.workorders.entities.StandardWorkOrder;
import ch.cern.eam.wshub.core.services.workorders.impl.StandardWorkOrderServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.datastream.schemas.mp_entities.workorder_001.WorkOrder;
import net.datastream.schemas.mp_fields.ORGANIZATIONID_Type;
import net.datastream.schemas.mp_fields.STATUS_Type;
import net.datastream.schemas.mp_fields.WOID_Type;
import net.datastream.schemas.mp_functions.mp0023_001.MP0023_AddWorkOrder_001;
import net.datastream.schemas.mp_functions.mp0024_001.MP0024_GetWorkOrder_001;
import net.datastream.schemas.mp_functions.mp0025_001.MP0025_SyncWorkOrder_001;
import net.datastream.schemas.mp_functions.mp0026_001.MP0026_GetWorkOrderDefault_001;
import net.datastream.schemas.mp_functions.mp0055_001.MP0055_DeleteWorkOrder_001;
import net.datastream.schemas.mp_functions.mp7161_001.MP7161_ChangeWorkOrderStatus_001;
import net.datastream.schemas.mp_results.mp0023_001.MP0023_AddWorkOrder_001_Result;
import net.datastream.schemas.mp_results.mp0024_001.MP0024_GetWorkOrder_001_Result;
import net.datastream.schemas.mp_results.mp0026_001.MP0026_GetWorkOrderDefault_001_Result;
import net.datastream.schemas.mp_results.mp0026_001.ResultData;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class WorkOrderServiceImpl
implements WorkOrderService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private CommentService comments;
    private StandardWorkOrderService standardWorkOrderService;
    private GridsService gridsService;
    private UserDefinedListService userDefinedListService;

    public WorkOrderServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.comments = new CommentServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
        this.standardWorkOrderService = new StandardWorkOrderServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
        this.gridsService = new GridsServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
        this.userDefinedListService = new UserDefinedListServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public BatchResponse<String> createWorkOrderBatch(InforContext context, List<ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder> workOrderParam) {
        return this.tools.batchOperation(context, this::createWorkOrder, workOrderParam);
    }

    @Override
    public BatchResponse<ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder> readWorkOrderBatch(InforContext context, List<String> workOrderNumbers) {
        return this.tools.batchOperation(context, this::readWorkOrder, workOrderNumbers);
    }

    @Override
    public BatchResponse<String> updateWorkOrderBatch(InforContext context, List<ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder> workOrders) {
        return this.tools.batchOperation(context, this::updateWorkOrder, workOrders);
    }

    @Override
    public BatchResponse<String> deleteWorkOrderBatch(InforContext context, List<String> workOrderNumbers) {
        return this.tools.batchOperation(context, this::deleteWorkOrder, workOrderNumbers);
    }

    @Override
    public ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder readWorkOrder(InforContext context, String number) throws InforException {
        WorkOrder inforWorkOrder = this.readWorkOrderInfor(context, number);
        ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder workOrder = this.tools.getInforFieldTools().transformInforObject(new ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder(), inforWorkOrder);
        this.tools.processRunnables(() -> workOrder.setAssignedToDesc(this.tools.getFieldDescriptionsTools().readPersonDesc(context, workOrder.getAssignedTo())), () -> workOrder.setDepartmentDesc(this.tools.getFieldDescriptionsTools().readDepartmentDesc(context, workOrder.getDepartmentCode())), () -> workOrder.setClassDesc(this.tools.getFieldDescriptionsTools().readClassDesc(context, "EVNT", workOrder.getClassCode())), () -> workOrder.setCostCodeDesc(this.tools.getFieldDescriptionsTools().readCostCodeDesc(context, workOrder.getCostCode())), () -> this.userDefinedListService.readUDLToEntity(context, workOrder, new EntityId("EVNT", number)));
        return workOrder;
    }

    public WorkOrder readWorkOrderInfor(InforContext context, String number) throws InforException {
        MP0024_GetWorkOrder_001 getWorkOrder = new MP0024_GetWorkOrder_001();
        getWorkOrder.setWORKORDERID(new WOID_Type());
        getWorkOrder.getWORKORDERID().setJOBNUM(number);
        getWorkOrder.getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        MP0024_GetWorkOrder_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getWorkOrderOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getWorkOrder);
        return result.getResultData().getWorkOrder();
    }

    @Override
    public ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder readWorkOrderDefault(InforContext context, String number) throws InforException {
        MP0026_GetWorkOrderDefault_001 getWorkOrderDefault = new MP0026_GetWorkOrderDefault_001();
        getWorkOrderDefault.setORGANIZATIONID(new ORGANIZATIONID_Type());
        getWorkOrderDefault.getORGANIZATIONID().setORGANIZATIONCODE(context.getOrganizationCode());
        MP0026_GetWorkOrderDefault_001_Result getWODefaultResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getWorkOrderDefaultOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getWorkOrderDefault);
        ResultData resultData = getWODefaultResult.getResultData();
        ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder workOrder = new ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder();
        if (resultData.getSTATUS() != null) {
            workOrder.setStatusCode(resultData.getSTATUS().getSTATUSCODE());
        }
        if (resultData.getTYPE() != null) {
            workOrder.setTypeCode(resultData.getTYPE().getTYPECODE());
        }
        if (resultData.getTARGETDATE() != null) {
            this.tools.getDataTypeTools();
            workOrder.setScheduledStartDate(DataTypeTools.decodeInforDate(resultData.getTARGETDATE()));
        }
        if (resultData.getSCHEDEND() != null) {
            this.tools.getDataTypeTools();
            workOrder.setScheduledEndDate(DataTypeTools.decodeInforDate(resultData.getSCHEDEND()));
        }
        if (resultData.getREPORTED() != null) {
            this.tools.getDataTypeTools();
            workOrder.setReportedDate(DataTypeTools.decodeInforDate(resultData.getREPORTED()));
        }
        workOrder.setUserDefinedList(new HashMap<String, ArrayList<UDLValue>>());
        return workOrder;
    }

    @Override
    public String createWorkOrder(InforContext context, ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder workorderParam) throws InforException {
        WorkOrder inforWorkOrder = workorderParam.getCopyFrom() == null ? new WorkOrder() : this.duplicateWorkOrder(context, workorderParam.getCopyFrom());
        if (inforWorkOrder.getWORKORDERID() == null) {
            inforWorkOrder.setWORKORDERID(new WOID_Type());
        }
        inforWorkOrder.getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        inforWorkOrder.getWORKORDERID().setJOBNUM("0");
        inforWorkOrder.setFIXED("V");
        if (workorderParam.getStandardWO() != null && !workorderParam.getStandardWO().trim().equals("")) {
            StandardWorkOrder standardWorkOrder = this.standardWorkOrderService.readStandardWorkOrder(context, workorderParam.getStandardWO());
            if (workorderParam.getDescription() == null) {
                workorderParam.setDescription(standardWorkOrder.getDesc());
            }
            if (workorderParam.getClassCode() == null) {
                workorderParam.setClassCode(standardWorkOrder.getWoClassCode());
            }
            if (workorderParam.getPriorityCode() == null) {
                workorderParam.setPriorityCode(standardWorkOrder.getPriorityCode());
            }
            if (workorderParam.getTypeCode() == null) {
                workorderParam.setTypeCode(standardWorkOrder.getWorkOrderTypeCode());
            }
            if (workorderParam.getProblemCode() == null) {
                workorderParam.setProblemCode(standardWorkOrder.getProblemCode());
            }
            if (workorderParam.getCustomFields() == null) {
                workorderParam.setCustomFields(standardWorkOrder.getCustomFields());
            }
            if (workorderParam.getUserDefinedFields() == null) {
                workorderParam.setUserDefinedFields(standardWorkOrder.getUserDefinedFields());
            }
        }
        inforWorkOrder.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(inforWorkOrder.getCLASSID()), inforWorkOrder.getUSERDEFINEDAREA(), workorderParam.getClassCode(), "EVNT"));
        this.tools.getInforFieldTools().transformWSHubObject(inforWorkOrder, workorderParam, context);
        if (workorderParam.getCopyFrom() != null && inforWorkOrder.getUSERDEFINEDAREA() != null && inforWorkOrder.getUSERDEFINEDAREA().getCUSTOMFIELD() != null) {
            inforWorkOrder.getUSERDEFINEDAREA().getCUSTOMFIELD().stream().forEach(customField -> customField.setChanged("true"));
        }
        MP0023_AddWorkOrder_001 addWO = new MP0023_AddWorkOrder_001();
        addWO.setWorkOrder(inforWorkOrder);
        MP0023_AddWorkOrder_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addWorkOrderOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addWO);
        if (workorderParam.getComment() != null && !workorderParam.getComment().trim().equals("")) {
            Comment comment = new Comment();
            comment.setEntityCode("EVNT");
            comment.setEntityKeyCode(result.getResultData().getJOBNUM());
            comment.setText(workorderParam.getComment());
            comment.setTypeCode("*");
            this.comments.createComment(context, comment);
        }
        String workOrderNumber = result.getResultData().getJOBNUM();
        this.userDefinedListService.writeUDLToEntityCopyFrom(context, workorderParam, new EntityId("EVNT", workOrderNumber));
        return workOrderNumber;
    }

    private WorkOrder duplicateWorkOrder(InforContext context, String workOrderCode) throws InforException {
        WorkOrder workOrder = this.readWorkOrderInfor(context, workOrderCode);
        workOrder.getWORKORDERID().setJOBNUM("0");
        if (this.isClearingActivitiesRequired(context, workOrder)) {
            workOrder.setActivities(null);
        }
        return workOrder;
    }

    private boolean isClearingActivitiesRequired(InforContext context, WorkOrder workOrder) throws InforException {
        if (workOrder.getSTANDARDWO() == null || workOrder.getSTANDARDWO().getSTDWOCODE() == null) {
            return false;
        }
        if (workOrder.getActivities() == null || workOrder.getActivities().getActivity() == null || workOrder.getActivities().getActivity().size() == 0) {
            return false;
        }
        GridRequest gridRequest = new GridRequest("WSSTWO_ACT", GridRequest.GRIDTYPE.LIST, 1);
        gridRequest.addParam("param.stwocode", workOrder.getSTANDARDWO().getSTDWOCODE());
        return GridTools.isNotEmpty(this.gridsService.executeQuery(context, gridRequest));
    }

    @Override
    public String updateWorkOrder(InforContext context, ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder workorderParam) throws InforException {
        WorkOrder inforWorkOrder = this.readWorkOrderInfor(context, workorderParam.getNumber());
        inforWorkOrder.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(inforWorkOrder.getCLASSID()), inforWorkOrder.getUSERDEFINEDAREA(), workorderParam.getClassCode(), "EVNT"));
        this.tools.getInforFieldTools().transformWSHubObject(inforWorkOrder, workorderParam, context);
        MP0025_SyncWorkOrder_001 syncWO = new MP0025_SyncWorkOrder_001();
        syncWO.setWorkOrder(inforWorkOrder);
        if (workorderParam.isConfirmedIncompleteChecklist() != null && workorderParam.isConfirmedIncompleteChecklist().booleanValue()) {
            syncWO.setConfirmincompletechecklist("confirmed");
        }
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncWorkOrderOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncWO);
        String workOrderNumber = inforWorkOrder.getWORKORDERID().getJOBNUM();
        this.userDefinedListService.writeUDLToEntity(context, workorderParam, new EntityId("EVNT", workOrderNumber));
        return workOrderNumber;
    }

    @Override
    public String deleteWorkOrder(InforContext context, String workOrderNumber) throws InforException {
        MP0055_DeleteWorkOrder_001 deleteWO = new MP0055_DeleteWorkOrder_001();
        deleteWO.setWORKORDERID(new WOID_Type());
        deleteWO.getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        deleteWO.getWORKORDERID().setJOBNUM(workOrderNumber);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteWorkOrderOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteWO);
        this.userDefinedListService.deleteUDLFromEntity(context, new EntityId("EVNT", workOrderNumber));
        return workOrderNumber;
    }

    @Override
    public String updateWorkOrderStatus(InforContext context, String workOrderNumber, String statusCode) throws InforException {
        MP7161_ChangeWorkOrderStatus_001 changeWOStatus = new MP7161_ChangeWorkOrderStatus_001();
        changeWOStatus.setWORKORDERID(new WOID_Type());
        changeWOStatus.getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        changeWOStatus.getWORKORDERID().setJOBNUM(workOrderNumber);
        changeWOStatus.setNEWSTATUS(new STATUS_Type());
        changeWOStatus.getNEWSTATUS().setSTATUSCODE(statusCode);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).changeWorkOrderStatusOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), changeWOStatus);
        return workOrderNumber;
    }
}

