/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.tools;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.entities.BatchSingleResponse;
import ch.cern.eam.wshub.core.services.entities.Credentials;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.CustomFieldsTools;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.ExceptionInfo;
import ch.cern.eam.wshub.core.tools.FieldDescriptionTools;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.InforFieldTools;
import ch.cern.eam.wshub.core.tools.InforOperation;
import ch.cern.eam.wshub.core.tools.WSHubOperation;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import javax.xml.ws.Holder;
import javax.xml.ws.soap.SOAPFaultException;
import net.datastream.schemas.mp_fields.BaseSchemaRequestElement;
import net.datastream.schemas.mp_fields.ESIGNATURE;
import net.datastream.schemas.mp_fields.ORGANIZATIONID_Type;
import net.datastream.schemas.mp_functions.MessageConfigType;
import net.datastream.schemas.mp_functions.MessageItemConfigType;
import net.datastream.schemas.mp_functions.SessionType;
import net.datastream.wsdls.inforws.InforWebServicesPT;
import org.w3c.dom.NodeList;
import org.xmlsoap.schemas.ws._2002._04.secext.ObjectFactory;
import org.xmlsoap.schemas.ws._2002._04.secext.Password;
import org.xmlsoap.schemas.ws._2002._04.secext.Security;
import org.xmlsoap.schemas.ws._2002._04.secext.Username;
import org.xmlsoap.schemas.ws._2002._04.secext.UsernameToken;

public class Tools {
    private ApplicationData applicationData;
    private InforWebServicesPT inforws;
    private ExecutorService executorService;
    private DataSource dataSource;
    private EntityManagerFactory entityManagerFactory;
    private Logger logger;
    private CustomFieldsTools customFieldsTools;
    private DataTypeTools dataTypeTools;
    private FieldDescriptionTools fieldDescriptionsTools;
    private GridTools gridTools;
    private InforFieldTools inforFieldTools;

    public Tools(ApplicationData applicationData, InforWebServicesPT inforWebServicesToolkitClient, ExecutorService executorService, DataSource dataSource, EntityManagerFactory entityManagerFactory, Logger logger) {
        this.applicationData = applicationData;
        this.inforws = inforWebServicesToolkitClient;
        this.executorService = executorService;
        this.dataSource = dataSource;
        this.entityManagerFactory = entityManagerFactory;
        this.customFieldsTools = new CustomFieldsTools(this, applicationData, this.inforws);
        this.inforFieldTools = new InforFieldTools(this.customFieldsTools, this);
        this.dataTypeTools = new DataTypeTools(this);
        this.fieldDescriptionsTools = new FieldDescriptionTools(this, applicationData, this.inforws);
        this.gridTools = new GridTools(this);
        this.logger = logger;
    }

    public EntityManager getEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public CustomFieldsTools getCustomFieldsTools() {
        return this.customFieldsTools;
    }

    public DataTypeTools getDataTypeTools() {
        return this.dataTypeTools;
    }

    public FieldDescriptionTools getFieldDescriptionsTools() {
        return this.fieldDescriptionsTools;
    }

    public GridTools getGridTools() {
        return this.gridTools;
    }

    public InforFieldTools getInforFieldTools() {
        return this.inforFieldTools;
    }

    public void log(Level logLevel, String message) {
        if (this.logger != null) {
            this.logger.log(logLevel, message);
        }
    }

    public Security createSecurityHeader(InforContext context) throws InforException {
        if (context == null || context.getCredentials() == null) {
            throw Tools.generateFault("Credentials must be initialized.");
        }
        ObjectFactory of = new ObjectFactory();
        Security security = of.createSecurity();
        Username un = of.createUsername();
        un.setValue(context.getCredentials().getUsername().toUpperCase() + "@" + this.getTenant(context));
        Password pass = of.createPassword();
        pass.setValue(context.getCredentials().getPassword());
        UsernameToken unt = of.createUsernameToken();
        unt.setPassword(pass);
        unt.setUsername(un);
        security.getAny().add(unt);
        return security;
    }

    public SessionType createInforSession(InforContext context) {
        SessionType session = new SessionType();
        session.setSessionId(context.getSessionID());
        return session;
    }

    public MessageConfigType createMessageConfig() {
        MessageConfigType messageConfigType = new MessageConfigType();
        MessageItemConfigType returnAlertsMessageItemConfigType = new MessageItemConfigType();
        returnAlertsMessageItemConfigType.setName("returnAlerts");
        returnAlertsMessageItemConfigType.setValue("false");
        messageConfigType.getConfigItem().add(returnAlertsMessageItemConfigType);
        return messageConfigType;
    }

    public ORGANIZATIONID_Type getOrganization(InforContext inforContext) {
        ORGANIZATIONID_Type org = new ORGANIZATIONID_Type();
        if (inforContext != null && inforContext.getOrganizationCode() != null) {
            org.setORGANIZATIONCODE(inforContext.getOrganizationCode());
        } else {
            org.setORGANIZATIONCODE(this.applicationData.getOrganization());
        }
        return org;
    }

    public String getOrganizationCode(InforContext inforContext) {
        if (inforContext != null && inforContext.getOrganizationCode() != null) {
            return inforContext.getOrganizationCode();
        }
        return this.applicationData.getOrganization();
    }

    public String getTenant(InforContext inforContext) {
        if (inforContext != null && inforContext.getTenant() != null) {
            return inforContext.getTenant();
        }
        return this.applicationData.getTenant();
    }

    public static InforException generateFault(String reason) {
        return new InforException(reason, null, null);
    }

    public static InforException generateFault(String reason, ExceptionInfo[] errors) {
        return new InforException(reason, null, errors);
    }

    public <T> BatchResponse<T> processCallables(List<Callable<T>> mylist) {
        List responseList = null;
        try {
            List<Future<T>> result = this.executorService.invokeAll(mylist, 2L, TimeUnit.MINUTES);
            responseList = result.stream().map(future -> {
                try {
                    return new BatchSingleResponse(future.get(), null);
                }
                catch (ExecutionException exception) {
                    if (exception.getCause() instanceof SOAPFaultException) {
                        SOAPFaultException soapFaultException = (SOAPFaultException)exception.getCause();
                        return new BatchSingleResponse<Object>(null, this.decodeExceptionInfoList(soapFaultException));
                    }
                    return new BatchSingleResponse<Object>(null, exception.getCause().getMessage());
                }
                catch (Exception exception) {
                    return new BatchSingleResponse<Object>(null, "Server error");
                }
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BatchResponse response = new BatchResponse();
        response.setResponseList(responseList);
        return response;
    }

    public void processRunnables(Runnable ... runnables) throws InforException {
        this.processRunnables(Arrays.asList(runnables));
    }

    public void processRunnables(List<Runnable> mylist) throws InforException {
        try {
            this.executorService.invokeAll(mylist.stream().map(runnable -> Executors.callable(runnable)).collect(Collectors.toList()), 2L, TimeUnit.MINUTES);
        }
        catch (Exception exception) {
            this.log(Level.SEVERE, "Error during Tools.processRunnables() execution: " + exception.getMessage());
        }
    }

    private String decodeExceptionInfoList(SOAPFaultException soapFaultException) {
        String errorMessage = soapFaultException.getMessage();
        try {
            NodeList nodeList = soapFaultException.getFault().getDetail().getFirstChild().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                errorMessage = errorMessage + ", " + nodeList.item(i).getFirstChild().getLastChild().getTextContent();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return errorMessage;
    }

    public InforContext getInforContext(Credentials credentials, String sessionID) {
        if (credentials != null) {
            return new InforContext(credentials);
        }
        return new InforContext(sessionID);
    }

    public InforContext getInforContext(Credentials credentials) {
        return new InforContext(credentials);
    }

    public InforContext getInforContext(String username, String password) {
        Credentials credentials = new Credentials();
        credentials.setUsername(username);
        credentials.setPassword(password);
        return this.getInforContext(credentials);
    }

    public void closeConnection(Connection connection, Statement statement, ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log(Level.SEVERE, "Couldn't close the DB connection: " + e.getMessage());
        }
    }

    public void demandDatabaseConnection() throws InforException {
        if (this.entityManagerFactory == null || this.getDataSource() == null) {
            throw Tools.generateFault("This operation requires DB connection.");
        }
    }

    public boolean isDatabaseConnectionConfigured() {
        return this.entityManagerFactory != null && this.getDataSource() != null;
    }

    public <A, R> BatchResponse<R> batchOperation(InforContext context, WSHubOperation<A, R> operation, List<A> arguments) {
        List callableList = arguments.stream().map(argument -> () -> operation.apply(context, argument)).collect(Collectors.toList());
        return this.processCallables(callableList);
    }

    public <A, R, T> Map<T, R> batchOperationToMap(List<A> arguments, BatchResponse<R> results, Map<T, A> map) {
        List responses = results.getResponseList().stream().map(response -> response.getResponse()).collect(Collectors.toList());
        if (arguments.size() != responses.size()) {
            throw new RuntimeException("The size of the results and the arguments does not match");
        }
        Function<Object, List> getKeysFromValue = value -> map.entrySet().stream().filter(entry -> entry.getValue() == value).map(entry -> entry.getKey()).collect(Collectors.toList());
        HashMap returnMap = new HashMap();
        for (int i = 0; i < responses.size(); ++i) {
            List keys = getKeysFromValue.apply(arguments.get(i));
            Object result = responses.get(i);
            keys.forEach(key -> returnMap.put(key, result));
        }
        return returnMap;
    }

    public <A, R> R performInforOperation(InforContext context, InforOperation<A, R> operation, A argument) throws InforException {
        Security security = null;
        String organization = this.getOrganizationCode(context);
        String sessionTerminationScenario = "terminate";
        Holder holder = null;
        MessageConfigType messageConfigType = this.createMessageConfig();
        if (context.getKeepSession() != null && context.getKeepSession().booleanValue()) {
            sessionTerminationScenario = null;
        }
        if (context.getCredentials() != null) {
            security = this.createSecurityHeader(context);
        } else {
            holder = new Holder((Object)this.createInforSession(context));
        }
        if (argument instanceof BaseSchemaRequestElement && context.getSignature() != null) {
            ((BaseSchemaRequestElement)argument).setESIGNATURE(this.inforFieldTools.transformWSHubObject(new ESIGNATURE(), context.getSignature(), context));
        }
        String tenant = this.getTenant(context);
        return operation.apply(argument, organization, security, sessionTerminationScenario, holder, messageConfigType, tenant);
    }
}

