/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.tools;

import ch.cern.eam.wshub.core.annotations.BooleanType;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.LOCATIONID_Type;
import org.openapplications.oagis_segments.AMOUNT;
import org.openapplications.oagis_segments.DATETIME;
import org.openapplications.oagis_segments.DATETIMEqual;
import org.openapplications.oagis_segments.QUANTITY;

public class DataTypeTools {
    private Tools tools;
    private static String[] formatStrings = new String[]{"dd-MMM-yyyy HH:mm", "dd-MMM-yyyy", "dd-MM-yyyy", "dd-MM-yyyy HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd", "dd/MM/yyyy HH:mm:ss", "dd/MM/yyyy"};
    public static final Integer NULLIFY_VALUE = Integer.MAX_VALUE;

    public DataTypeTools(Tools tools) {
        this.tools = tools;
    }

    public static Calendar convertStringToCalendar(String date) {
        if (date == null || date.trim().equals("")) {
            return null;
        }
        if ("SYSDATE".equalsIgnoreCase(date.trim())) {
            return Calendar.getInstance();
        }
        for (String formatString : formatStrings) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat(formatString, Locale.ENGLISH);
                formatter.setLenient(false);
                Date parsedDate = formatter.parse(date);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(parsedDate);
                return calendar;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static Date convertStringToDate(String date) {
        Calendar calendar = DataTypeTools.convertStringToCalendar(date);
        return calendar != null ? calendar.getTime() : null;
    }

    public static DATETIME encodeInforDate(Date dateValue, String dateLabel) throws InforException {
        if (dateValue.getTime() == 0L) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateValue);
        DATETIME inforDateTime = new DATETIME();
        inforDateTime.setSUBSECOND(BigInteger.valueOf(0L));
        inforDateTime.setSECOND(BigInteger.valueOf(calendar.get(13)));
        inforDateTime.setMINUTE(BigInteger.valueOf(calendar.get(12)));
        inforDateTime.setHOUR(BigInteger.valueOf(calendar.get(11)));
        inforDateTime.setDAY(BigInteger.valueOf(calendar.get(5)));
        inforDateTime.setMONTH(BigInteger.valueOf(calendar.get(2) + 1));
        try {
            DatatypeFactory dataTypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar yearCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            yearCalendar.setYear(calendar.get(1));
            inforDateTime.setYEAR(yearCalendar);
        }
        catch (Exception exception) {
            // empty catch block
        }
        inforDateTime.setQualifier(DATETIMEqual.OTHER);
        inforDateTime.setTIMEZONE("UTC");
        return inforDateTime;
    }

    public static DATETIME formatDate(String dateValue, String dateLabel) throws InforException {
        if (dateValue == null || dateValue.trim().equals("")) {
            return null;
        }
        Calendar calendar = DataTypeTools.convertStringToCalendar(dateValue);
        if (calendar == null) {
            throw Tools.generateFault(dateLabel + " has invalid format. Please change it to dd-MMM-yyyy [HH:mm]");
        }
        DATETIME inforDateTime = new DATETIME();
        inforDateTime.setSUBSECOND(BigInteger.valueOf(0L));
        inforDateTime.setSECOND(BigInteger.valueOf(calendar.get(13)));
        inforDateTime.setMINUTE(BigInteger.valueOf(calendar.get(12)));
        inforDateTime.setHOUR(BigInteger.valueOf(calendar.get(11)));
        inforDateTime.setDAY(BigInteger.valueOf(calendar.get(5)));
        inforDateTime.setMONTH(BigInteger.valueOf(calendar.get(2) + 1));
        try {
            DatatypeFactory dataTypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar yearCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
            yearCalendar.setYear(calendar.get(1));
            inforDateTime.setYEAR(yearCalendar);
        }
        catch (Exception exception) {
            // empty catch block
        }
        inforDateTime.setQualifier(DATETIMEqual.OTHER);
        inforDateTime.setTIMEZONE("UTC");
        return inforDateTime;
    }

    public String retrieveDate(DATETIME inforDateTime, String dateFormat) {
        Calendar cal = Calendar.getInstance();
        cal.set(inforDateTime.getYEAR().getYear(), inforDateTime.getMONTH().intValue() - 1, inforDateTime.getDAY().intValue(), inforDateTime.getHOUR().intValue(), inforDateTime.getMINUTE().intValue(), inforDateTime.getSECOND().intValue());
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat, Locale.ENGLISH);
        return formatter.format(cal.getTime()).toUpperCase();
    }

    public String retrieveDate(DATETIME inforDateTime) {
        return this.retrieveDate(inforDateTime, "dd-MMM-yyyy HH:mm");
    }

    public static Date decodeInforDate(DATETIME inforDateTime) {
        if (inforDateTime == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(inforDateTime.getYEAR().getYear(), inforDateTime.getMONTH().intValue() - 1, inforDateTime.getDAY().intValue(), inforDateTime.getHOUR().intValue(), inforDateTime.getMINUTE().intValue(), inforDateTime.getSECOND().intValue());
        cal.set(14, 0);
        return cal.getTime();
    }

    public static QUANTITY encodeQuantity(BigDecimal numberValue, String numberLabel) throws InforException {
        if (numberValue == null) {
            return null;
        }
        if (numberValue.toBigInteger().intValue() == NULLIFY_VALUE.intValue()) {
            return null;
        }
        numberValue = numberValue.stripTrailingZeros();
        int numberOfDec = Math.max(0, numberValue.scale());
        numberValue = numberValue.scaleByPowerOfTen(numberOfDec);
        numberValue = numberValue.setScale(0);
        QUANTITY quantity = new QUANTITY();
        try {
            quantity.setSIGN(numberValue.signum() < 0 ? "-" : "+");
            quantity.setNUMOFDEC(BigInteger.valueOf(numberOfDec));
            quantity.setVALUE(numberValue.abs());
            quantity.setQualifier("OTHER");
            quantity.setUOM("default");
        }
        catch (NumberFormatException e) {
            throw Tools.generateFault(numberLabel + " couldn't be parsed");
        }
        return quantity;
    }

    public static BigDecimal decodeQuantity(QUANTITY inforNumber) {
        if (inforNumber != null) {
            BigDecimal bc = inforNumber.getVALUE().divide(new BigDecimal(Math.pow(10.0, inforNumber.getNUMOFDEC().intValue())), 6, RoundingMode.HALF_UP);
            if (inforNumber.getSIGN() != null && inforNumber.getSIGN().equals("-")) {
                bc = bc.negate();
            }
            return bc.stripTrailingZeros();
        }
        return null;
    }

    public static AMOUNT encodeAmount(BigDecimal numberValue, String numberLabel) throws InforException {
        if (numberValue == null) {
            return null;
        }
        numberValue = numberValue.stripTrailingZeros();
        int numberOfDec = Math.max(0, numberValue.scale());
        numberValue = numberValue.scaleByPowerOfTen(numberOfDec);
        numberValue = numberValue.setScale(0);
        AMOUNT amount = new AMOUNT();
        try {
            amount.setSIGN(numberValue.signum() < 0 ? "-" : "+");
            amount.setNUMOFDEC(BigInteger.valueOf(numberOfDec));
            amount.setVALUE(numberValue.abs());
            amount.setCURRENCY("default");
            amount.setDRCR("C");
            amount.setQualifier("OTHER");
        }
        catch (NumberFormatException e) {
            throw Tools.generateFault(numberLabel + " couldn't be parsed.");
        }
        return amount;
    }

    public static BigDecimal decodeAmount(AMOUNT inforNumber) {
        if (inforNumber != null) {
            BigDecimal bc = inforNumber.getVALUE().divide(new BigDecimal(Math.pow(10.0, inforNumber.getNUMOFDEC().intValue())), 6, RoundingMode.HALF_UP);
            if (inforNumber.getSIGN() != null && inforNumber.getSIGN().equals("-")) {
                bc = bc.negate();
            }
            return bc;
        }
        return null;
    }

    public long encodeLong(String longValue, String longLabel) throws InforException {
        long value;
        try {
            value = Long.valueOf(longValue);
        }
        catch (NumberFormatException e) {
            throw Tools.generateFault(longLabel + " couldn't be parsed.");
        }
        return value;
    }

    public double encodeDouble(String doubleValue, String longLabel) throws InforException {
        double value;
        try {
            value = Double.valueOf(doubleValue);
        }
        catch (NumberFormatException e) {
            throw Tools.generateFault(longLabel + " couldn't be parsed.");
        }
        return value;
    }

    public static BigDecimal encodeBigDecimal(String stringValue, String valueLabel) throws InforException {
        if (DataTypeTools.isEmpty(stringValue)) {
            return null;
        }
        stringValue = stringValue.replace(",", "");
        try {
            return new BigDecimal(stringValue);
        }
        catch (NumberFormatException e) {
            throw Tools.generateFault(valueLabel + " couldn't be parsed.");
        }
    }

    public static String decodeBigDecimal(BigDecimal bigDecimalValue) {
        return bigDecimalValue == null ? null : bigDecimalValue.toPlainString();
    }

    public static BigInteger encodeBigInteger(String stringValue, String valueLabel) throws InforException {
        if (DataTypeTools.isEmpty(stringValue)) {
            return null;
        }
        stringValue = stringValue.replace(",", "");
        try {
            return new BigInteger(stringValue);
        }
        catch (NumberFormatException e) {
            throw Tools.generateFault(valueLabel + " couldn't be parsed.");
        }
    }

    public static String decodeBigInteger(BigInteger bigIntegerValue) {
        return String.valueOf(bigIntegerValue);
    }

    public static String encodeBoolean(Boolean value, BooleanType returnType) {
        String resultStr = null;
        if (value == null) {
            value = false;
        }
        switch (returnType) {
            case TRUE_FALSE: {
                resultStr = value != false ? "true" : "false";
                break;
            }
            case YES_NO: {
                resultStr = value != false ? "yes" : "no";
                break;
            }
            case ONE_ZERO: {
                resultStr = value != false ? "1" : "0";
                break;
            }
            case PLUS_MINUS: {
                resultStr = value != false ? "+" : "-";
            }
        }
        return resultStr;
    }

    public static Boolean decodeBoolean(String value) {
        return value == null ? null : Boolean.valueOf("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value) || "+".equalsIgnoreCase(value) || "-1".equalsIgnoreCase(value));
    }

    public static boolean isTrueValue(String value) {
        return value != null && value.trim().toUpperCase().equals("TRUE");
    }

    public static boolean isFalseValue(String value) {
        return value == null || value.trim().toUpperCase().equals("FALSE");
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().equals("");
    }

    public static boolean isNotEmpty(String value) {
        return !DataTypeTools.isEmpty(value);
    }

    public String decodeBoolean(Boolean value) {
        if (value == null) {
            return null;
        }
        if (value.booleanValue()) {
            return "true";
        }
        return "false";
    }

    public static <T> T nonNullOrDefault(T newValue, T defaultValue) {
        return newValue == null ? defaultValue : newValue;
    }

    public static String toCodeString(CLASSID_Type classIdType) {
        return classIdType == null ? null : classIdType.getCLASSCODE();
    }

    public static String toCodeString(LOCATIONID_Type locationIdType) {
        return locationIdType == null ? null : locationIdType.getLOCATIONCODE();
    }

    public static Long convertBigIntegerToLong(BigInteger value) {
        return value == null ? null : Long.valueOf(value.longValueExact());
    }
}

