/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.administration.entities;

import ch.cern.eam.wshub.core.adapters.DateAdapter;
import ch.cern.eam.wshub.core.annotations.InforField;
import ch.cern.eam.wshub.core.services.entities.CustomField;
import ch.cern.eam.wshub.core.services.entities.Department;
import ch.cern.eam.wshub.core.services.entities.UserDefinedFields;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@Entity
@Table(name="R5USERS")
@NamedQueries(value={@NamedQuery(name="ALL_ACTIVE_USERS", query="Select user from EAMUser user WHERE user.classCode IS NULL OR user.classCode <> '*INA'"), @NamedQuery(name="ALL_GROUP_MEMBER_USERNAMES", query="Select userCode from EAMUser user WHERE user.userGroup = :group")})
public class EAMUser
implements Serializable {
    private static final long serialVersionUID = 1149632956701915140L;
    public static final String ALL_ACTIVE_USERS = "ALL_ACTIVE_USERS";
    public static final String ALL_GROUP_MEMBER_USERNAMES = "ALL_GROUP_MEMBER_USERNAMES";
    @Id
    @Column(name="USR_CODE")
    @InforField(xpath={"USERID/USERCODE"})
    private String userCode;
    @Column(name="USR_DESC")
    @InforField(xpath={"USERID/DESCRIPTION"})
    private String userDesc;
    @Column(name="USR_GROUP")
    @InforField(xpath={"USERGROUP"})
    private String userGroup;
    @Column(name="USR_EXPUSER")
    @Temporal(value=TemporalType.DATE)
    @InforField(xpath={"USEREXPIREDATE"})
    private Date userIDExpirationDate;
    @XmlTransient
    @Transient
    @InforField(xpath={"PASSWORD"})
    private String password;
    @Transient
    @InforField(xpath={"PASSEXPIREDATE"})
    private Date passwordExpirationDate;
    @Column(name="USR_EMAILADDRESS")
    @InforField(xpath={"EMAIL"})
    private String emailAddress;
    @Column(name="USR_MRC")
    @InforField(xpath={"DEPARTMENTCODE"})
    private String department;
    @Column(name="USR_CLASS")
    @InforField(xpath={"CLASSID/CLASSCODE"})
    private String classCode;
    @Column(name="USR_LOCALE")
    @InforField(xpath={"LOCALE"})
    private String locale;
    @Transient
    private String employeeCode;
    @Transient
    private String employeeDesc;
    @Transient
    @InforField(xpath={"USERDEFINEDAREA"})
    private CustomField[] customFields;
    @Transient
    @InforField(xpath={"StandardUserDefinedFields"})
    private UserDefinedFields userDefinedFields;
    @Transient
    private Map<String, Department> departmentalSecurity;

    public String getUserCode() {
        return this.userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getUserDesc() {
        return this.userDesc;
    }

    public void setUserDesc(String userDesc) {
        this.userDesc = userDesc;
    }

    public String getUserGroup() {
        return this.userGroup;
    }

    public void setUserGroup(String userGroup) {
        this.userGroup = userGroup;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    @XmlElementWrapper(name="customFields")
    @XmlElement(name="customField")
    public CustomField[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
    }

    public String getClassCode() {
        return this.classCode;
    }

    public void setClassCode(String classCode) {
        this.classCode = classCode;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getUserIDExpirationDate() {
        return this.userIDExpirationDate;
    }

    public void setUserIDExpirationDate(Date userIDExpirationDate) {
        this.userIDExpirationDate = userIDExpirationDate;
    }

    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getPasswordExpirationDate() {
        return this.passwordExpirationDate;
    }

    public void setPasswordExpirationDate(Date passwordExpirationDate) {
        this.passwordExpirationDate = passwordExpirationDate;
    }

    public List<String> getUserDepartments() {
        LinkedList<String> userDepartments = new LinkedList<String>();
        if (this.getDepartment() != null) {
            userDepartments.add(this.getDepartment());
        }
        if (this.getUserDefinedFields() != null && this.getUserDefinedFields().getUdfchar10() != null) {
            String[] udfDepartments = this.getUserDefinedFields().getUdfchar10().replaceAll("\\s+", "").trim().split(",");
            userDepartments.addAll(Arrays.asList(udfDepartments));
        }
        Collections.sort(userDepartments);
        return userDepartments;
    }

    public UserDefinedFields getUserDefinedFields() {
        return this.userDefinedFields;
    }

    public void setUserDefinedFields(UserDefinedFields userDefinedFields) {
        this.userDefinedFields = userDefinedFields;
    }

    public String getEmployeeCode() {
        return this.employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public String getEmployeeDesc() {
        return this.employeeDesc;
    }

    public void setEmployeeDesc(String employeeDesc) {
        this.employeeDesc = employeeDesc;
    }

    public Map<String, Department> getDepartmentalSecurity() {
        return this.departmentalSecurity;
    }

    public void setDepartmentalSecurity(Map<String, Department> departmentalSecurity) {
        this.departmentalSecurity = departmentalSecurity;
    }

    public String toString() {
        return "EAMUser [" + (this.userCode != null ? "userCode=" + this.userCode + ", " : "") + (this.userDesc != null ? "userDesc=" + this.userDesc + ", " : "") + (this.userGroup != null ? "userGroup=" + this.userGroup + ", " : "") + (this.userIDExpirationDate != null ? "userIDExpirationDate=" + this.userIDExpirationDate + ", " : "") + (this.password != null ? "password=" + this.password + ", " : "") + (this.passwordExpirationDate != null ? "passwordExpirationDate=" + this.passwordExpirationDate + ", " : "") + (this.emailAddress != null ? "emailAddress=" + this.emailAddress + ", " : "") + (this.department != null ? "department=" + this.department + ", " : "") + (this.classCode != null ? "classCode=" + this.classCode + ", " : "") + (this.customFields != null ? "customFields=" + Arrays.toString(this.customFields) + ", " : "") + (this.userDefinedFields != null ? "userDefinedFields=" + this.userDefinedFields : "") + "]";
    }
}

