/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.administration.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.administration.UserGroupMenuService;
import ch.cern.eam.wshub.core.services.administration.entities.MenuEntryNode;
import ch.cern.eam.wshub.core.services.administration.entities.MenuRequestType;
import ch.cern.eam.wshub.core.services.administration.entities.MenuSpecification;
import ch.cern.eam.wshub.core.services.administration.entities.MenuType;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.ArrayList;
import java.util.List;
import net.datastream.schemas.mp_entities.extmenus_001.ExtMenus;
import net.datastream.schemas.mp_entities.extmenushierarchy_001.ExtMenusHierarchy;
import net.datastream.schemas.mp_fields.EXTMENUID_Type;
import net.datastream.schemas.mp_fields.EXTMENUSHIERARCHYREQUEST_Type;
import net.datastream.schemas.mp_fields.FOLDER_Type;
import net.datastream.schemas.mp_fields.FUNCTIONID_Type;
import net.datastream.schemas.mp_fields.FUNCTION_Type;
import net.datastream.schemas.mp_fields.MENU_Type;
import net.datastream.schemas.mp_fields.USERGROUPID_Type;
import net.datastream.schemas.mp_functions.mp6005_001.MP6005_GetExtMenusHierarchy_001;
import net.datastream.schemas.mp_functions.mp6043_001.MP6043_AddExtMenus_001;
import net.datastream.schemas.mp_functions.mp6045_001.MP6045_DeleteExtMenus_001;
import net.datastream.schemas.mp_results.mp6043_001.MP6043_AddExtMenus_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class UserGroupMenuServiceImpl
implements UserGroupMenuService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public UserGroupMenuServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public String addToMenuHierarchy(InforContext context, MenuSpecification menuSpecification) throws InforException {
        UserGroupMenuService.validateInputNode(menuSpecification);
        MenuEntryNode menuRoot = this.getExtMenuHierarchyAsTree(context, menuSpecification.getForUserGroup(), MenuRequestType.EXCLUDE_PERMISSIONSAND_TABS);
        List<String> pathList = menuSpecification.getMenuPath();
        MenuEntryNode latestMenuEntryNodeFound = this.getLatestMenuEntryByPath(pathList, menuRoot);
        String func = menuSpecification.getFunctionCode();
        if (latestMenuEntryNodeFound.getLevel() == pathList.size()) {
            if (func == null && func.isEmpty()) {
                return "OK";
            }
            for (MenuEntryNode child : latestMenuEntryNodeFound.getChildren()) {
                if (!child.getFunctionId().equals(func)) continue;
                return "OK";
            }
        }
        for (int i = latestMenuEntryNodeFound.getLevel(); i < pathList.size(); ++i) {
            MenuEntryNode addedMenuEntryNode = this.performAddFolderOperation(latestMenuEntryNodeFound, pathList.get(i), menuSpecification.getForUserGroup(), context);
            latestMenuEntryNodeFound.add(addedMenuEntryNode);
            latestMenuEntryNodeFound = addedMenuEntryNode;
        }
        if (func != null && !func.isEmpty()) {
            MenuEntryNode menuEntryNode = this.performAddFunctionOperation(latestMenuEntryNodeFound, func, menuSpecification.getForUserGroup(), context);
        }
        return "OK";
    }

    @Override
    public BatchResponse<String> addToMenuHierarchyBatch(InforContext context, List<MenuSpecification> menuSpecificationList) {
        return this.tools.batchOperation(context, this::addToMenuHierarchy, menuSpecificationList);
    }

    @Override
    public BatchResponse<String> addToMenuHierarchyManyUsergroups(InforContext context, List<String> userGroups, MenuSpecification menuSpecification) {
        ArrayList<MenuSpecification> menuSpecificationList = new ArrayList<MenuSpecification>();
        userGroups.stream().forEach(u -> menuSpecificationList.add(new MenuSpecification(menuSpecification.getMenuPath(), menuSpecification.getFunctionCode(), (String)u)));
        return this.addToMenuHierarchyBatch(context, menuSpecificationList);
    }

    @Override
    public BatchResponse<String> deleteFromMenuHierarchyBatch(InforContext context, List<MenuSpecification> menuSpecificationList) {
        return this.tools.batchOperation(context, this::deleteFromMenuHierarchy, menuSpecificationList);
    }

    @Override
    public BatchResponse<String> deleteFromMenuHierarchyManyUsergroups(InforContext context, List<String> userGroups, MenuSpecification menuSpecification) {
        ArrayList<MenuSpecification> menuSpecificationList = new ArrayList<MenuSpecification>();
        userGroups.stream().forEach(u -> menuSpecificationList.add(new MenuSpecification(menuSpecification.getMenuPath(), menuSpecification.getFunctionCode(), (String)u)));
        return this.deleteFromMenuHierarchyBatch(context, menuSpecificationList);
    }

    private ExtMenusHierarchy getExtMenuHierarchy(InforContext context, String userGroup, MenuRequestType requestType) throws InforException {
        MP6005_GetExtMenusHierarchy_001 getExtMenusHierarchy = new MP6005_GetExtMenusHierarchy_001();
        getExtMenusHierarchy.setUSERGROUPID(new USERGROUPID_Type());
        getExtMenusHierarchy.getUSERGROUPID().setUSERGROUPCODE(userGroup);
        getExtMenusHierarchy.setRequest(EXTMENUSHIERARCHYREQUEST_Type.fromValue((String)requestType.value()));
        ExtMenusHierarchy result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getExtMenusHierarchyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getExtMenusHierarchy).getResultData().getExtMenusHierarchy();
        return result;
    }

    @Override
    public MenuEntryNode getExtMenuHierarchyAsTree(InforContext context, String userGroup, MenuRequestType requestType) throws InforException {
        MenuEntryNode root = new MenuEntryNode();
        ExtMenusHierarchy result = this.getExtMenuHierarchy(context, userGroup, requestType);
        List menus = result.getMENU();
        for (MENU_Type menu : menus) {
            MenuEntryNode mainMenuEntry = new MenuEntryNode(menu);
            root.add(mainMenuEntry);
            menu.getFOLDER().stream().forEach(childFolder -> this.addFolderToMenuNode(mainMenuEntry, (FOLDER_Type)childFolder));
            menu.getFUNCTION().stream().forEach(childFunction -> this.addFunctionToMenuNode(mainMenuEntry, (FUNCTION_Type)childFunction));
        }
        return root;
    }

    private void addFolderToMenuNode(MenuEntryNode currentNode, FOLDER_Type folder) {
        MenuEntryNode newNode = new MenuEntryNode(folder);
        currentNode.add(newNode);
        for (FOLDER_Type childFolder : folder.getFOLDER()) {
            this.addFolderToMenuNode(newNode, childFolder);
        }
        for (FUNCTION_Type childFunction : folder.getFUNCTION()) {
            this.addFunctionToMenuNode(newNode, childFunction);
        }
    }

    private void addFunctionToMenuNode(MenuEntryNode currentNode, FUNCTION_Type function) {
        MenuEntryNode newNode = new MenuEntryNode(function);
        currentNode.add(newNode);
    }

    private MP6043_AddExtMenus_001 fillExtMenus(MenuEntryNode parent, String folderName, String userGroup, InforContext context, String code, String menuType) {
        String id = parent != null ? parent.getId() : "";
        MP6043_AddExtMenus_001 addExtMenus = new MP6043_AddExtMenus_001();
        ExtMenus extMenus = new ExtMenus();
        addExtMenus.setExtMenus(extMenus);
        extMenus.setUSERGROUPID(new USERGROUPID_Type());
        extMenus.getUSERGROUPID().setUSERGROUPCODE(userGroup);
        extMenus.setFUNCTIONID(new FUNCTIONID_Type());
        if (!menuType.equals(MenuType.FUNCTION.getType())) {
            extMenus.getFUNCTIONID().setFUNCTIONDESCRIPTION(folderName);
        }
        extMenus.getFUNCTIONID().setFUNCTIONCODE(code);
        extMenus.setEXTMENUPARENT(id);
        extMenus.setEXTMENUTYPE(menuType);
        Long maxSequenceNumber = parent.getChildren().stream().mapToLong(MenuEntryNode::getSequenceNumber).max().orElse(0L);
        extMenus.setSEQUENCENUMBER(maxSequenceNumber + 1L);
        extMenus.setMOBILE("false");
        return addExtMenus;
    }

    private MenuEntryNode performAddFunctionOperation(MenuEntryNode parent, String functionCode, String userGroup, InforContext context) throws InforException {
        MP6043_AddExtMenus_001 addExtMenus = this.fillExtMenus(parent, "", userGroup, context, functionCode, MenuType.FUNCTION.getType());
        MP6043_AddExtMenus_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addExtMenusOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addExtMenus);
        return new MenuEntryNode(result.getResultData().getExtMenus());
    }

    private MenuEntryNode performAddFolderOperation(MenuEntryNode parent, String folderName, String userGroup, InforContext context) throws InforException {
        String menuType = MenuType.SUBMENU.getType();
        if (parent.getDescription().equals("ROOT_NODE")) {
            menuType = MenuType.MAIN_MENU.getType();
        }
        MP6043_AddExtMenus_001 addExtMenus = this.fillExtMenus(parent, folderName, userGroup, context, "BSFOLD", menuType);
        MP6043_AddExtMenus_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addExtMenusOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addExtMenus);
        return new MenuEntryNode(result.getResultData().getExtMenus());
    }

    private MenuEntryNode getLatestMenuEntryByPath(List<String> pathList, MenuEntryNode menuRoot) {
        boolean found = false;
        boolean endReached = false;
        MenuEntryNode currentNode = menuRoot;
        for (String currentPathEntry : pathList) {
            for (MenuEntryNode childNode : currentNode.getChildren()) {
                if (!childNode.getDescription().equals(currentPathEntry)) continue;
                currentNode = childNode;
                found = true;
                break;
            }
            boolean bl = endReached = !found;
            if (endReached) break;
            found = false;
        }
        return currentNode;
    }

    @Override
    public String deleteFromMenuHierarchy(InforContext context, MenuSpecification menuSpecification) throws InforException {
        UserGroupMenuService.validateInputNode(menuSpecification);
        MenuEntryNode menuRoot = this.getExtMenuHierarchyAsTree(context, menuSpecification.getForUserGroup(), MenuRequestType.EXCLUDE_PERMISSIONSAND_TABS);
        List<String> pathList = menuSpecification.getMenuPath();
        MenuEntryNode latestMenuEntryNodeFound = this.getLatestMenuEntryByPath(pathList, menuRoot);
        if (latestMenuEntryNodeFound.getLevel() != pathList.size()) {
            throw Tools.generateFault("Path doesn't exist");
        }
        String func = menuSpecification.getFunctionCode();
        if (func != null && !func.isEmpty()) {
            for (MenuEntryNode child : latestMenuEntryNodeFound.getChildren()) {
                if (!child.getFunctionId().equals(func)) continue;
                this.performDeleteFunctionOperation(child, menuSpecification.getFunctionCode(), menuSpecification.getForUserGroup(), context);
            }
        } else {
            this.performDeleteFolderOperation(latestMenuEntryNodeFound, menuSpecification.getFunctionCode(), menuSpecification.getForUserGroup(), context);
        }
        return "OK";
    }

    private void performDeleteFunctionOperation(MenuEntryNode entryToDelete, String functionCode, String userGroup, InforContext context) throws InforException {
        entryToDelete.getFunctionId();
        this.performDeleteOperation(entryToDelete, functionCode, userGroup, context, MenuType.FUNCTION.getType());
    }

    private void performDeleteFolderOperation(MenuEntryNode entryToDelete, String functionCode, String userGroup, InforContext context) throws InforException {
        String menuType = MenuType.SUBMENU.getType();
        if (entryToDelete.getParentMenuEntry().getDescription().equals("ROOT_NODE")) {
            menuType = MenuType.MAIN_MENU.getType();
        }
        this.performDeleteOperation(entryToDelete, "BSFOLD", userGroup, context, menuType);
    }

    private void performDeleteOperation(MenuEntryNode entryToDelete, String functionCode, String userGroup, InforContext context, String menuType) throws InforException {
        MP6045_DeleteExtMenus_001 deleteExtMenus = new MP6045_DeleteExtMenus_001();
        ExtMenus extMenus = new ExtMenus();
        deleteExtMenus.setExtMenus(extMenus);
        extMenus.setUSERGROUPID(new USERGROUPID_Type());
        extMenus.getUSERGROUPID().setUSERGROUPCODE(userGroup);
        extMenus.setFUNCTIONID(new FUNCTIONID_Type());
        extMenus.getFUNCTIONID().setFUNCTIONCODE(functionCode);
        extMenus.setEXTMENUID(new EXTMENUID_Type());
        extMenus.getEXTMENUID().setEXTMENUCODE(entryToDelete.getId());
        extMenus.setEXTMENUTYPE(menuType);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteExtMenusOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteExtMenus);
    }
}

