/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.comments.impl;

import ch.cern.eam.wshub.core.annotations.BooleanType;
import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.comments.CommentService;
import ch.cern.eam.wshub.core.services.comments.entities.Comment;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.LinkedList;
import java.util.List;
import net.datastream.schemas.mp_fields.COMMENT_Type;
import net.datastream.schemas.mp_fields.ENTITYCOMMENTID_Type;
import net.datastream.schemas.mp_fields.LANGUAGEID_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_fields.USERID_Type;
import net.datastream.schemas.mp_functions.mp0108_001.CommentsReq;
import net.datastream.schemas.mp_functions.mp0108_001.MP0108_GetComments_001;
import net.datastream.schemas.mp_functions.mp0109_001.MP0109_AddComments_001;
import net.datastream.schemas.mp_functions.mp0110_001.MP0110_SyncComments_001;
import net.datastream.schemas.mp_functions.mp0111_001.MP0111_DeleteComments_001;
import net.datastream.schemas.mp_results.mp0109_001.MP0109_AddComments_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class CommentServiceImpl
implements CommentService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public CommentServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public String createComment(InforContext context, Comment comment) throws InforException {
        if (comment == null) {
            throw Tools.generateFault("Comment can not be empty");
        }
        if (comment.getText() == null || comment.getEntityCode() == null || comment.getEntityKeyCode() == null) {
            throw Tools.generateFault("Please supply entity code, entity key code and comment text.");
        }
        if (comment.getEntityKeyCode().endsWith("#*")) {
            throw Tools.generateFault("Entity key code can't end with '#*'");
        }
        COMMENT_Type commentInfor = new COMMENT_Type();
        if (comment.getEntityCode() != null) {
            commentInfor.setENTITYCOMMENTID(new ENTITYCOMMENTID_Type());
            commentInfor.getENTITYCOMMENTID().setENTITY(comment.getEntityCode());
            commentInfor.getENTITYCOMMENTID().setENTITYKEYCODE(CommentServiceImpl.complementEntityKeyCode(comment.getEntityCode(), comment.getEntityKeyCode(), this.tools.getOrganizationCode(context, comment.getOrganization())));
            commentInfor.getENTITYCOMMENTID().setLANGUAGEID(new LANGUAGEID_Type());
            commentInfor.getENTITYCOMMENTID().getLANGUAGEID().setLANGUAGECODE("EN");
            commentInfor.getENTITYCOMMENTID().setCOMMENTTYPE(new TYPE_Type());
            if (comment.getTypeCode() != null) {
                commentInfor.getENTITYCOMMENTID().getCOMMENTTYPE().setTYPECODE(comment.getTypeCode());
            } else {
                commentInfor.getENTITYCOMMENTID().getCOMMENTTYPE().setTYPECODE("*");
            }
            if (comment.getLineNumber() != null) {
                commentInfor.getENTITYCOMMENTID().setLINENUM(Long.valueOf(this.tools.getDataTypeTools().encodeLong(comment.getLineNumber(), "Line Number")));
            }
        }
        if (comment.getText() != null && !comment.getText().trim().equals("")) {
            commentInfor.setCOMMENTTEXT(comment.getText());
        }
        if (comment.getCreationUserCode() != null) {
            commentInfor.setCREATEDBY(new USERID_Type());
            commentInfor.getCREATEDBY().setUSERCODE(comment.getCreationUserCode());
        }
        commentInfor.setORGANIZATIONID(this.tools.getOrganization(context, comment.getOrganization()));
        if (comment.getPrint() == null) {
            commentInfor.setPRINT("true");
        } else {
            commentInfor.setPRINT(DataTypeTools.encodeBoolean(comment.getPrint(), BooleanType.TRUE_FALSE));
        }
        MP0109_AddComments_001 addComments = new MP0109_AddComments_001();
        addComments.setCOMMENT(commentInfor);
        MP0109_AddComments_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addCommentsOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addComments);
        long lineNumber = result.getResultData().getENTITYCOMMENTID().getLINENUM();
        comment.setLineNumber(String.valueOf(lineNumber));
        return comment.getPk();
    }

    @Override
    public Comment[] readComments(InforContext context, String entityCode, String entityKeyCode, String typeCode) throws InforException {
        return (Comment[])this.readCommentsInfor(context, entityCode, Tools.extractEntityCode(entityKeyCode), typeCode, this.tools.getOrganizationCode(context, Tools.extractOrganizationCode(entityCode))).stream().map(this::convertToComment).toArray(Comment[]::new);
    }

    @Override
    public String updateComment(InforContext context, Comment comment) throws InforException {
        if (comment.getEntityCode() == null || comment.getEntityCode().trim().equals("")) {
            throw Tools.generateFault("Entity Code is required.");
        }
        if (comment.getEntityKeyCode() == null || comment.getEntityKeyCode().trim().equals("")) {
            throw Tools.generateFault("Entity Key Code is required.");
        }
        COMMENT_Type commentInfor = this.readCommentsInfor(context, comment.getEntityCode(), comment.getEntityKeyCode(), comment.getTypeCode(), comment.getOrganization()).stream().filter(commentTemp -> commentTemp.getENTITYCOMMENTID().getLINENUM().toString().equals(comment.getLineNumber())).findFirst().orElse(null);
        if (commentInfor == null) {
            throw Tools.generateFault("Comment not found");
        }
        if (comment.getText() != null && !comment.getText().trim().equals("")) {
            commentInfor.setCOMMENTTEXT(comment.getText());
        }
        if (comment.getPrint() == null) {
            commentInfor.setPRINT("true");
        } else {
            commentInfor.setPRINT(DataTypeTools.encodeBoolean(comment.getPrint(), BooleanType.TRUE_FALSE));
        }
        MP0110_SyncComments_001 syncComments = new MP0110_SyncComments_001();
        syncComments.setCOMMENT(commentInfor);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncCommentsOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncComments);
        return comment.getPk();
    }

    @Override
    public String deleteComment(InforContext context, Comment comment) throws InforException {
        MP0111_DeleteComments_001 deleteComments = new MP0111_DeleteComments_001();
        deleteComments.setENTITYCOMMENTID(new ENTITYCOMMENTID_Type());
        deleteComments.getENTITYCOMMENTID().setENTITY(comment.getEntityCode());
        deleteComments.getENTITYCOMMENTID().setENTITYKEYCODE(CommentServiceImpl.complementEntityKeyCode(comment.getEntityCode(), comment.getEntityKeyCode(), this.tools.getOrganizationCode(context, comment.getOrganization())));
        deleteComments.getENTITYCOMMENTID().setLANGUAGEID(new LANGUAGEID_Type());
        deleteComments.getENTITYCOMMENTID().getLANGUAGEID().setLANGUAGECODE("EN");
        deleteComments.getENTITYCOMMENTID().setCOMMENTTYPE(new TYPE_Type());
        deleteComments.getENTITYCOMMENTID().setLINENUM(Long.valueOf(this.tools.getDataTypeTools().encodeLong(comment.getLineNumber(), "Line Number")));
        if (comment.getTypeCode() != null) {
            deleteComments.getENTITYCOMMENTID().getCOMMENTTYPE().setTYPECODE(comment.getTypeCode());
        } else {
            deleteComments.getENTITYCOMMENTID().getCOMMENTTYPE().setTYPECODE("*");
        }
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteCommentsOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteComments);
        return comment.getPk();
    }

    private List<COMMENT_Type> readCommentsInfor(InforContext context, String entityCode, String entityKeyCode, String typeCode, String organization) throws InforException {
        LinkedList<COMMENT_Type> result = new LinkedList<COMMENT_Type>();
        CommentsReq commentsReq = new CommentsReq();
        commentsReq.setENTITY(entityCode);
        commentsReq.setENTITYKEYCODE(CommentServiceImpl.complementEntityKeyCode(entityCode, entityKeyCode, this.tools.getOrganizationCode(context, organization)));
        commentsReq.setCOMMENTTYPE(new TYPE_Type());
        if (DataTypeTools.isEmpty(typeCode)) {
            commentsReq.getCOMMENTTYPE().setTYPECODE("*");
        } else {
            commentsReq.getCOMMENTTYPE().setTYPECODE(typeCode);
        }
        MP0108_GetComments_001 getComments = new MP0108_GetComments_001();
        getComments.setCommentsReq(commentsReq);
        result.addAll(this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getCommentsOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getComments).getResultData().getComments().getCOMMENT());
        if (DataTypeTools.isEmpty(typeCode) && entityCode.equals("EVNT")) {
            commentsReq.getCOMMENTTYPE().setTYPECODE("+");
            result.addAll(this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getCommentsOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getComments).getResultData().getComments().getCOMMENT());
        }
        return result;
    }

    private Comment convertToComment(COMMENT_Type commentInfor) {
        Comment comment = new Comment();
        if (commentInfor.getCREATEDDATE() != null) {
            comment.setCreationDate(this.tools.getDataTypeTools().retrieveDate(commentInfor.getCREATEDDATE()));
        }
        if (commentInfor.getUPDATEDDATE() != null) {
            comment.setUpdateDate(this.tools.getDataTypeTools().retrieveDate(commentInfor.getUPDATEDDATE()));
        }
        comment.setText(commentInfor.getCOMMENTTEXT());
        if (commentInfor.getCREATEDBY() != null) {
            comment.setCreationUserCode(commentInfor.getCREATEDBY().getUSERCODE());
            comment.setCreationUserDesc(commentInfor.getCREATEDBY().getDESCRIPTION());
        }
        if (commentInfor.getUPDATEDBY() != null) {
            comment.setUpdateUserCode(commentInfor.getUPDATEDBY().getUSERCODE());
            comment.setUpdateUserDesc(commentInfor.getUPDATEDBY().getDESCRIPTION());
        }
        if (commentInfor.getENTITYCOMMENTID() != null) {
            comment.setEntityCode(commentInfor.getENTITYCOMMENTID().getENTITY());
            comment.setEntityKeyCode(Tools.extractEntityCode(commentInfor.getENTITYCOMMENTID().getENTITYKEYCODE()));
            comment.setLineNumber(commentInfor.getENTITYCOMMENTID().getLINENUM().toString());
            if (commentInfor.getENTITYCOMMENTID().getCOMMENTTYPE() != null) {
                comment.setTypeCode(commentInfor.getENTITYCOMMENTID().getCOMMENTTYPE().getTYPECODE());
            }
        }
        comment.setUpdateCount(commentInfor.getRecordid().toString());
        return comment;
    }

    private static String complementEntityKeyCode(String entityCode, String entityKeyCode, String organization) {
        if ("OBJ".equals(entityCode) || "PART".equals(entityCode)) {
            return entityKeyCode + "#" + organization;
        }
        return entityKeyCode;
    }
}

