/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.impl.GridsServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.ChecklistService;
import ch.cern.eam.wshub.core.services.workorders.LaborBookingService;
import ch.cern.eam.wshub.core.services.workorders.TaskPlanService;
import ch.cern.eam.wshub.core.services.workorders.entities.Activity;
import ch.cern.eam.wshub.core.services.workorders.entities.TaskPlan;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityCheckList;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityChecklistSignatureResult;
import ch.cern.eam.wshub.core.services.workorders.impl.ChecklistServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.impl.TaskPlanServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.datastream.schemas.mp_entities.laborbooking_001.LaborBooking;
import net.datastream.schemas.mp_fields.ACTIVITYCODE;
import net.datastream.schemas.mp_fields.ACTIVITYID;
import net.datastream.schemas.mp_fields.DEPARTMENTID_Type;
import net.datastream.schemas.mp_fields.OCCUPATIONTYPEID_Type;
import net.datastream.schemas.mp_fields.PERSONID_Type;
import net.datastream.schemas.mp_fields.TRADEID_Type;
import net.datastream.schemas.mp_fields.WOID_Type;
import net.datastream.schemas.mp_functions.mp0035_001.MP0035_GetActivity_001;
import net.datastream.schemas.mp_functions.mp0037_001.MP0037_AddActivity_001;
import net.datastream.schemas.mp_functions.mp0038_001.MP0038_SyncActivity_001;
import net.datastream.schemas.mp_functions.mp0039_001.MP0039_DeleteActivity_001;
import net.datastream.schemas.mp_functions.mp0042_001.MP0042_AddLaborBooking_001;
import net.datastream.schemas.mp_results.mp0035_001.MP0035_GetActivity_001_Result;
import net.datastream.schemas.mp_results.mp0037_001.MP0037_AddActivity_001_Result;
import net.datastream.schemas.mp_results.mp0038_001.MP0038_SyncActivity_001_Result;
import net.datastream.schemas.mp_results.mp0039_001.MP0039_DeleteActivity_001_Result;
import net.datastream.schemas.mp_results.mp0042_001.MP0042_AddLaborBooking_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class LaborBookingServiceImpl
implements LaborBookingService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private ChecklistService checklistService;
    private GridsService gridsService;
    private TaskPlanService taskPlanService;

    public LaborBookingServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.checklistService = new ChecklistServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
        this.gridsService = new GridsServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
        this.taskPlanService = new TaskPlanServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public List<ch.cern.eam.wshub.core.services.workorders.entities.LaborBooking> readLaborBookings(InforContext context, String workOrderNumber) throws InforException {
        GridRequest gridRequest = new GridRequest("WSJOBS_BOO");
        gridRequest.setUserFunctionName("WSJOBS");
        gridRequest.getParams().put("param.jobnum", workOrderNumber);
        gridRequest.getParams().put("param.headeractivity", "0");
        gridRequest.getParams().put("param.headerjob", "0");
        gridRequest.setRowCount(500);
        return GridTools.convertGridResultToObject(ch.cern.eam.wshub.core.services.workorders.entities.LaborBooking.class, null, this.gridsService.executeQuery(context, gridRequest));
    }

    @Override
    public String createLaborBooking(InforContext context, ch.cern.eam.wshub.core.services.workorders.entities.LaborBooking laborBookingParam) throws InforException {
        LaborBooking laborBookingInfor = new LaborBooking();
        if (laborBookingParam.getEmployeeCode() != null) {
            laborBookingInfor.setEMPLOYEE(new PERSONID_Type());
            laborBookingInfor.getEMPLOYEE().setPERSONCODE(laborBookingParam.getEmployeeCode());
        }
        if (laborBookingParam.getDepartmentCode() != null) {
            laborBookingInfor.setDEPARTMENTID(new DEPARTMENTID_Type());
            laborBookingInfor.getDEPARTMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            laborBookingInfor.getDEPARTMENTID().setDEPARTMENTCODE(laborBookingParam.getDepartmentCode());
        }
        if (laborBookingParam.getDateWorked() != null) {
            this.tools.getDataTypeTools();
            laborBookingInfor.setDATEWORKED(DataTypeTools.encodeInforDate(laborBookingParam.getDateWorked(), "Date Worked"));
        }
        if (laborBookingParam.getHoursWorked() != null) {
            this.tools.getDataTypeTools();
            laborBookingInfor.setHOURSWORKED(DataTypeTools.encodeAmount(laborBookingParam.getHoursWorked(), "Hours Worked"));
        }
        this.tools.getDataTypeTools();
        laborBookingInfor.setTRADERATE(DataTypeTools.encodeAmount(BigDecimal.ZERO, "Trade Rate"));
        if (laborBookingParam.getTypeOfHours() != null) {
            laborBookingInfor.setOCCUPATIONTYPE(new OCCUPATIONTYPEID_Type());
            laborBookingInfor.getOCCUPATIONTYPE().setOCCUPATIONTYPECODE(laborBookingParam.getTypeOfHours());
        }
        if (laborBookingParam.getTradeCode() != null) {
            laborBookingInfor.setTRADEID(new TRADEID_Type());
            laborBookingInfor.getTRADEID().setORGANIZATIONID(this.tools.getOrganization(context));
            laborBookingInfor.getTRADEID().setTRADECODE(laborBookingParam.getTradeCode());
        }
        laborBookingInfor.setACTIVITYID(new ACTIVITYID());
        if (laborBookingParam.getActivityCode() != null) {
            laborBookingInfor.getACTIVITYID().setACTIVITYCODE(new ACTIVITYCODE());
            laborBookingInfor.getACTIVITYID().getACTIVITYCODE().setValue(Long.parseLong(laborBookingParam.getActivityCode()));
        }
        if (laborBookingParam.getWorkOrderNumber() != null) {
            laborBookingInfor.getACTIVITYID().setWORKORDERID(new WOID_Type());
            laborBookingInfor.getACTIVITYID().getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
            laborBookingInfor.getACTIVITYID().getWORKORDERID().setJOBNUM(laborBookingParam.getWorkOrderNumber());
        }
        MP0042_AddLaborBooking_001 addLaborBoking = new MP0042_AddLaborBooking_001();
        addLaborBoking.setLaborBooking(laborBookingInfor);
        MP0042_AddLaborBooking_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addLaborBookingOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addLaborBoking);
        return laborBookingParam.getActivityCode();
    }

    @Override
    public Activity[] readActivities(InforContext context, String workOrderNumber, Boolean includeChecklists) throws InforException {
        try {
            GridRequest gridRequest = new GridRequest("WSJOBS_ACT");
            gridRequest.setRowCount(1000);
            gridRequest.setUserFunctionName("WSJOBS");
            gridRequest.getParams().put("param.jobnum", workOrderNumber);
            this.tools.getGridTools();
            List<Activity> activities = GridTools.convertGridResultToObject(Activity.class, null, this.gridsService.executeQuery(context, gridRequest));
            if (includeChecklists.booleanValue()) {
                List<Runnable> runnables = activities.stream().map(activity -> () -> {
                    try {
                        TaskPlan taskPlan = new TaskPlan();
                        taskPlan.setCode(activity.getTaskCode());
                        taskPlan = this.taskPlanService.getTaskPlan(context, taskPlan);
                        WorkOrderActivityChecklistSignatureResult[] signatures = this.checklistService.getSignatures(context, workOrderNumber, activity.getActivityCode().toString(), taskPlan);
                        if (signatures.length > 0) {
                            activity.setChecklists(this.checklistService.readWorkOrderChecklists(context, (Activity)activity));
                            if (taskPlan.getReviewedByRequired().booleanValue()) {
                                activity.setSignatures(Arrays.stream(signatures).collect(Collectors.toMap(WorkOrderActivityChecklistSignatureResult::getType, Function.identity())));
                            } else if (taskPlan.getPerformedByRequired().booleanValue()) {
                                activity.setSignatures(Arrays.stream(signatures).filter(signature -> !signature.getType().equals("RB01")).collect(Collectors.toMap(WorkOrderActivityChecklistSignatureResult::getType, Function.identity())));
                            }
                            activity.setForceActivityExpansion(taskPlan.getUserDefinedFields().getUdfchkbox03());
                        } else {
                            activity.setChecklists(new WorkOrderActivityCheckList[0]);
                        }
                    }
                    catch (Exception e) {
                        activity.setChecklists(new WorkOrderActivityCheckList[0]);
                    }
                }).collect(Collectors.toList());
                this.tools.processRunnables(runnables);
            }
            return (Activity[])activities.stream().toArray(Activity[]::new);
        }
        catch (Exception e) {
            throw Tools.generateFault("Couldn't fetch activities for this work order: " + e.getMessage());
        }
    }

    @Override
    public String createActivity(InforContext context, Activity activityParam) throws InforException {
        net.datastream.schemas.mp_entities.activity_001.Activity activityInfor = new net.datastream.schemas.mp_entities.activity_001.Activity();
        this.tools.getInforFieldTools().transformWSHubObject(activityInfor, activityParam, context);
        if (activityParam.getTaskCode() != null && !activityParam.getTaskCode().trim().equals("")) {
            activityInfor.getTASKSID().setTASKREVISION(Long.valueOf(0L));
        }
        MP0037_AddActivity_001 addActivity = new MP0037_AddActivity_001();
        addActivity.setActivity(activityInfor);
        MP0037_AddActivity_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addActivityOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addActivity);
        return result.getResultData().getACTIVITYID().getACTIVITYCODE().getValue() + "";
    }

    @Override
    public String updateActivity(InforContext context, Activity activityParam) throws InforException {
        MP0035_GetActivity_001 getActivity = new MP0035_GetActivity_001();
        getActivity.setACTIVITYID(new ACTIVITYID());
        try {
            getActivity.getACTIVITYID().setACTIVITYCODE(new ACTIVITYCODE());
            getActivity.getACTIVITYID().getACTIVITYCODE().setValue(Long.parseLong(activityParam.getActivityCode().toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        getActivity.getACTIVITYID().setWORKORDERID(new WOID_Type());
        getActivity.getACTIVITYID().getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        getActivity.getACTIVITYID().getWORKORDERID().setJOBNUM(activityParam.getWorkOrderNumber());
        MP0035_GetActivity_001_Result getresult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getActivityOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getActivity);
        net.datastream.schemas.mp_entities.activity_001.Activity activityInfor = getresult.getResultData().getActivity();
        this.tools.getInforFieldTools().transformWSHubObject(activityInfor, activityParam, context);
        MP0038_SyncActivity_001 syncActivity = new MP0038_SyncActivity_001();
        syncActivity.setActivity(activityInfor);
        MP0038_SyncActivity_001_Result syncresult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncActivityOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncActivity);
        return syncresult.getResultData().getACTIVITYID().getACTIVITYCODE().getValue() + "";
    }

    @Override
    public String deleteActivity(InforContext context, Activity activityParam) throws InforException {
        MP0039_DeleteActivity_001 deleteActivity = new MP0039_DeleteActivity_001();
        deleteActivity.setACTIVITYID(new ACTIVITYID());
        deleteActivity.getACTIVITYID().setACTIVITYCODE(new ACTIVITYCODE());
        deleteActivity.getACTIVITYID().getACTIVITYCODE().setValue(activityParam.getActivityCode().longValue());
        deleteActivity.getACTIVITYID().setWORKORDERID(new WOID_Type());
        deleteActivity.getACTIVITYID().getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        deleteActivity.getACTIVITYID().getWORKORDERID().setJOBNUM(activityParam.getWorkOrderNumber());
        deleteActivity.setConfirmdeletechecklist("true");
        MP0039_DeleteActivity_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteActivityOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteActivity);
        return result.getResultData().getACTIVITYID().getACTIVITYCODE().getValue() + "";
    }
}

