/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.equipment.CategoryService;
import ch.cern.eam.wshub.core.services.equipment.entities.Category;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import net.datastream.schemas.mp_entities.equipmentcategory_001.EquipmentCategory;
import net.datastream.schemas.mp_fields.CATEGORYID;
import net.datastream.schemas.mp_functions.mp0323_001.MP0323_AddEquipmentCategory_001;
import net.datastream.schemas.mp_functions.mp0324_001.MP0324_GetEquipmentCategory_001;
import net.datastream.schemas.mp_functions.mp0325_001.MP0325_SyncEquipmentCategory_001;
import net.datastream.schemas.mp_functions.mp0326_001.MP0326_DeleteEquipmentCategory_001;
import net.datastream.schemas.mp_results.mp0323_001.MP0323_AddEquipmentCategory_001_Result;
import net.datastream.schemas.mp_results.mp0324_001.MP0324_GetEquipmentCategory_001_Result;
import net.datastream.schemas.mp_results.mp0325_001.MP0325_SyncEquipmentCategory_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class CategoryServiceImpl
implements CategoryService {
    private Tools tools;
    private InforWebServicesPT inforws;

    public CategoryServiceImpl(Tools tools, InforWebServicesPT inforws) {
        this.tools = tools;
        this.inforws = inforws;
    }

    @Override
    public Category readCategory(InforContext context, String categoryCode) throws InforException {
        Category category = this.tools.getInforFieldTools().transformInforObject(new Category(), this.readInforCategory(context, categoryCode), context);
        return category;
    }

    private EquipmentCategory readInforCategory(InforContext context, String categoryCode) throws InforException {
        MP0324_GetEquipmentCategory_001 getEquipmentCategory001 = new MP0324_GetEquipmentCategory_001();
        getEquipmentCategory001.setCATEGORYID(new CATEGORYID());
        getEquipmentCategory001.getCATEGORYID().setCATEGORYCODE(categoryCode);
        MP0324_GetEquipmentCategory_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getEquipmentCategoryOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getEquipmentCategory001);
        return result.getResultData().getEquipmentCategory();
    }

    @Override
    public String updateCategory(InforContext context, Category category) throws InforException {
        EquipmentCategory equipmentCategory = this.readInforCategory(context, category.getCode());
        equipmentCategory.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(equipmentCategory.getCLASSID()), equipmentCategory.getUSERDEFINEDAREA(), category.getClassCode(), "OBJ"));
        this.tools.getInforFieldTools().transformWSHubObject(equipmentCategory, category, context);
        MP0325_SyncEquipmentCategory_001 syncEquipmentCategory = new MP0325_SyncEquipmentCategory_001();
        syncEquipmentCategory.setEquipmentCategory(equipmentCategory);
        MP0325_SyncEquipmentCategory_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncEquipmentCategoryOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncEquipmentCategory);
        return result.getResultData().getCATEGORYID().getCATEGORYCODE();
    }

    @Override
    public String createCategory(InforContext context, Category category) throws InforException {
        EquipmentCategory equipmentCategory = new EquipmentCategory();
        equipmentCategory.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(equipmentCategory.getCLASSID()), equipmentCategory.getUSERDEFINEDAREA(), category.getClassCode(), "OBJ"));
        this.tools.getInforFieldTools().transformWSHubObject(equipmentCategory, category, context);
        MP0323_AddEquipmentCategory_001 addCategory = new MP0323_AddEquipmentCategory_001();
        addCategory.setEquipmentCategory(equipmentCategory);
        MP0323_AddEquipmentCategory_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addEquipmentCategoryOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addCategory);
        String categoryCode = result.getResultData().getCATEGORYID().getCATEGORYCODE();
        return categoryCode;
    }

    @Override
    public String deleteCategory(InforContext context, String categoryCode) throws InforException {
        MP0326_DeleteEquipmentCategory_001 deleteEquipmentCategory = new MP0326_DeleteEquipmentCategory_001();
        deleteEquipmentCategory.setCATEGORYID(new CATEGORYID());
        deleteEquipmentCategory.getCATEGORYID().setCATEGORYCODE(categoryCode);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteEquipmentCategoryOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteEquipmentCategory);
        return categoryCode;
    }
}

