/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.equipment.AssetService;
import ch.cern.eam.wshub.core.services.equipment.entities.Equipment;
import ch.cern.eam.wshub.core.services.equipment.impl.EquipmentHierarchyTools;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedListService;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.EntityId;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDLValue;
import ch.cern.eam.wshub.core.services.userdefinedscreens.impl.UserDefinedListServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import net.datastream.schemas.mp_entities.assetequipment_001.AssetEquipment;
import net.datastream.schemas.mp_entities.assetequipment_001.AssetParentHierarchy;
import net.datastream.schemas.mp_fields.ASSETPARENT_Type;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.LOCATIONPARENT_Type;
import net.datastream.schemas.mp_fields.ORGANIZATIONID_Type;
import net.datastream.schemas.mp_fields.POSITIONPARENT_Type;
import net.datastream.schemas.mp_fields.STORELOCATION;
import net.datastream.schemas.mp_fields.SYSTEMPARENT_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_functions.mp0301_001.MP0301_AddAssetEquipment_001;
import net.datastream.schemas.mp_functions.mp0302_001.MP0302_GetAssetEquipment_001;
import net.datastream.schemas.mp_functions.mp0303_001.MP0303_SyncAssetEquipment_001;
import net.datastream.schemas.mp_functions.mp0304_001.MP0304_DeleteAssetEquipment_001;
import net.datastream.schemas.mp_functions.mp0305_001.MP0305_GetAssetEquipmentDefault_001;
import net.datastream.schemas.mp_functions.mp0327_001.MP0327_GetAssetParentHierarchy_001;
import net.datastream.schemas.mp_results.mp0301_001.MP0301_AddAssetEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0302_001.MP0302_GetAssetEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0305_001.MP0305_GetAssetEquipmentDefault_001_Result;
import net.datastream.schemas.mp_results.mp0327_001.MP0327_GetAssetParentHierarchy_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class AssetServiceImpl
implements AssetService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private UserDefinedListService userDefinedListService;

    public AssetServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.userDefinedListService = new UserDefinedListServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public Equipment readAssetDefault(InforContext context, String organization) throws InforException {
        MP0305_GetAssetEquipmentDefault_001 getAssetEquipmentDefault_001 = new MP0305_GetAssetEquipmentDefault_001();
        if (DataTypeTools.isEmpty(organization)) {
            getAssetEquipmentDefault_001.setORGANIZATIONID(this.tools.getOrganization(context));
        } else {
            getAssetEquipmentDefault_001.setORGANIZATIONID(new ORGANIZATIONID_Type());
            getAssetEquipmentDefault_001.getORGANIZATIONID().setORGANIZATIONCODE(organization);
        }
        MP0305_GetAssetEquipmentDefault_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getAssetEquipmentDefaultOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getAssetEquipmentDefault_001);
        Equipment equipment = this.tools.getInforFieldTools().transformInforObject(new Equipment(), result.getResultData().getAssetEquipment());
        equipment.setUserDefinedList(new HashMap<String, ArrayList<UDLValue>>());
        return equipment;
    }

    @Override
    public Equipment readAsset(InforContext context, String assetCode) throws InforException {
        AssetEquipment assetEquipment = this.readInforAsset(context, assetCode);
        Equipment asset = this.tools.getInforFieldTools().transformInforObject(new Equipment(), assetEquipment);
        asset.setSystemTypeCode("A");
        if (assetEquipment.getASSETID() != null) {
            asset.setCode(assetEquipment.getASSETID().getEQUIPMENTCODE());
            asset.setDescription(assetEquipment.getASSETID().getDESCRIPTION());
        }
        this.tools.processRunnables(() -> asset.setManufacturerDesc(this.tools.getFieldDescriptionsTools().readManufacturerDesc(context, asset.getManufacturerCode())), () -> asset.setBinDesc(this.tools.getFieldDescriptionsTools().readBinDesc(context, asset.getStoreCode(), asset.getBin())), () -> asset.setSystemStatusCode(this.tools.getFieldDescriptionsTools().readSystemCodeForUserCode(context, "OBST", asset.getStatusCode())), () -> this.userDefinedListService.readUDLToEntity(context, asset, new EntityId("OBJ", assetCode)));
        if (assetEquipment.getAssetParentHierarchy().getLOCATIONID() != null) {
            asset.setHierarchyLocationCode(assetEquipment.getAssetParentHierarchy().getLOCATIONID().getLOCATIONCODE());
            asset.setHierarchyLocationDesc(assetEquipment.getAssetParentHierarchy().getLOCATIONID().getDESCRIPTION());
        }
        asset.setHierarchyAssetDependent(assetEquipment.getAssetParentHierarchy().getAssetDependency() != null);
        asset.setHierarchyPositionDependent(assetEquipment.getAssetParentHierarchy().getPositionDependency() != null);
        asset.setHierarchyPrimarySystemDependent(assetEquipment.getAssetParentHierarchy().getPrimarySystemDependency() != null);
        return asset;
    }

    private AssetParentHierarchy readInforAssetHierarchy(InforContext context, String assetCode) throws InforException {
        MP0327_GetAssetParentHierarchy_001 getassetph = new MP0327_GetAssetParentHierarchy_001();
        getassetph.setASSETID(new EQUIPMENTID_Type());
        getassetph.getASSETID().setORGANIZATIONID(this.tools.getOrganization(context));
        getassetph.getASSETID().setEQUIPMENTCODE(assetCode);
        MP0327_GetAssetParentHierarchy_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getAssetParentHierarchyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getassetph);
        return result.getResultData().getAssetParentHierarchy();
    }

    private AssetEquipment readInforAsset(InforContext context, String assetCode) throws InforException {
        MP0302_GetAssetEquipment_001 getAsset = new MP0302_GetAssetEquipment_001();
        getAsset.setASSETID(new EQUIPMENTID_Type());
        getAsset.getASSETID().setORGANIZATIONID(this.tools.getOrganization(context));
        getAsset.getASSETID().setEQUIPMENTCODE(assetCode);
        MP0302_GetAssetEquipment_001_Result getAssetResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getAssetEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getAsset);
        getAssetResult.getResultData().getAssetEquipment().setAssetParentHierarchy(this.readInforAssetHierarchy(context, assetCode));
        return getAssetResult.getResultData().getAssetEquipment();
    }

    private void updateInforAsset(InforContext context, AssetEquipment assetEquipment) throws InforException {
        MP0303_SyncAssetEquipment_001 syncAsset = new MP0303_SyncAssetEquipment_001();
        syncAsset.setAssetEquipment(assetEquipment);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncAssetEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncAsset);
    }

    @Override
    public String updateAsset(InforContext context, Equipment assetParam) throws InforException {
        AssetEquipment assetEquipment = this.readInforAsset(context, assetParam.getCode());
        assetEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(assetEquipment.getCLASSID()), assetEquipment.getUSERDEFINEDAREA(), assetParam.getClassCode(), "OBJ"));
        this.initializeAssetObject(assetEquipment, assetParam, context);
        this.tools.getInforFieldTools().transformWSHubObject(assetEquipment, assetParam, context);
        if (assetParam.getPartCode() != null) {
            if (assetParam.getPartCode().equals("") && assetEquipment.getPartAssociation() != null) {
                assetEquipment.getPartAssociation().setSTORELOCATION(null);
                assetEquipment.getPartAssociation().getPARTID().getORGANIZATIONID().setORGANIZATIONCODE("");
            } else if (!"".equals(assetParam.getPartCode())) {
                if (assetEquipment.getPartAssociation().getSTORELOCATION() == null) {
                    assetEquipment.getPartAssociation().setSTORELOCATION(new STORELOCATION());
                }
                if (assetEquipment.getPartAssociation().getSTORELOCATION().getLOT() == null) {
                    assetEquipment.getPartAssociation().getSTORELOCATION().setLOT("*");
                }
            }
        }
        this.updateInforAsset(context, assetEquipment);
        this.userDefinedListService.writeUDLToEntity(context, assetParam, new EntityId("OBJ", assetParam.getCode()));
        return assetParam.getCode();
    }

    @Override
    public String createAsset(InforContext context, Equipment assetParam) throws InforException {
        AssetEquipment assetEquipment = new AssetEquipment();
        assetEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(assetEquipment.getCLASSID()), assetEquipment.getUSERDEFINEDAREA(), assetParam.getClassCode(), "OBJ"));
        this.initializeAssetObject(assetEquipment, assetParam, context);
        this.tools.getInforFieldTools().transformWSHubObject(assetEquipment, assetParam, context);
        MP0301_AddAssetEquipment_001 addAsset = new MP0301_AddAssetEquipment_001();
        addAsset.setAssetEquipment(assetEquipment);
        MP0301_AddAssetEquipment_001_Result addAssetResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addAssetEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addAsset);
        String equipmentCode = addAssetResult.getResultData().getASSETID().getEQUIPMENTCODE();
        this.userDefinedListService.writeUDLToEntityCopyFrom(context, assetParam, new EntityId("OBJ", equipmentCode));
        return equipmentCode;
    }

    @Override
    public String deleteAsset(InforContext context, String assetCode) throws InforException {
        MP0304_DeleteAssetEquipment_001 deleteAsset = new MP0304_DeleteAssetEquipment_001();
        deleteAsset.setASSETID(new EQUIPMENTID_Type());
        deleteAsset.getASSETID().setORGANIZATIONID(this.tools.getOrganization(context));
        deleteAsset.getASSETID().setEQUIPMENTCODE(assetCode);
        this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteAssetEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteAsset);
        this.userDefinedListService.deleteUDLFromEntity(context, new EntityId("OBJ", assetCode));
        return assetCode;
    }

    private void initializeAssetObject(AssetEquipment assetInfor, Equipment assetParam, InforContext context) throws InforException {
        if (assetInfor.getASSETID() == null) {
            assetInfor.setASSETID(new EQUIPMENTID_Type());
            assetInfor.getASSETID().setORGANIZATIONID(this.tools.getOrganization(context));
            assetInfor.getASSETID().setEQUIPMENTCODE(assetParam.getCode().toUpperCase().trim());
        }
        if (assetParam.getDescription() != null) {
            assetInfor.getASSETID().setDESCRIPTION(assetParam.getDescription());
        }
        if (assetParam.getHierarchyAssetCode() != null || assetParam.getHierarchyPositionCode() != null || assetParam.getHierarchyPrimarySystemCode() != null || assetParam.getHierarchyLocationCode() != null) {
            try {
                this.initializeAssetHierarchy(assetInfor, assetParam, context);
            }
            catch (Exception e) {
                this.tools.log(Level.SEVERE, e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void initializeAssetHierarchy(AssetEquipment assetInfor, Equipment assetParam, InforContext context) throws InforException {
        AssetParentHierarchy hierarchy = new AssetParentHierarchy();
        hierarchy.setASSETID(new EQUIPMENTID_Type());
        hierarchy.getASSETID().setEQUIPMENTCODE(assetParam.getCode());
        hierarchy.getASSETID().setORGANIZATIONID(this.tools.getOrganization(context));
        hierarchy.setTYPE(new TYPE_Type());
        hierarchy.getTYPE().setTYPECODE("A");
        ASSETPARENT_Type assetParent = EquipmentHierarchyTools.readAssetParent(assetInfor.getAssetParentHierarchy());
        POSITIONPARENT_Type positionParent = EquipmentHierarchyTools.readPositionParent(assetInfor.getAssetParentHierarchy());
        SYSTEMPARENT_Type primarySystemParent = EquipmentHierarchyTools.readPrimarySystemParent(assetInfor.getAssetParentHierarchy());
        LOCATIONPARENT_Type locationParent = EquipmentHierarchyTools.readLocationParent(assetInfor.getAssetParentHierarchy());
        List<SYSTEMPARENT_Type> systemParents = EquipmentHierarchyTools.readSystemsParent(assetInfor.getAssetParentHierarchy());
        EquipmentHierarchyTools.HIERARCHY_TYPE currentHierarchyType = EquipmentHierarchyTools.readHierarchyType(assetInfor.getAssetParentHierarchy());
        assetParent = EquipmentHierarchyTools.createAssetParent(this.tools.getOrganizationCode(context), assetParam.getHierarchyAssetCode(), assetParam.getHierarchyAssetCostRollUp(), assetParent);
        positionParent = EquipmentHierarchyTools.createPositionParent(this.tools.getOrganizationCode(context), assetParam.getHierarchyPositionCode(), assetParam.getHierarchyPositionCostRollUp(), positionParent);
        primarySystemParent = EquipmentHierarchyTools.createPrimarySystemParent(this.tools.getOrganizationCode(context), assetParam.getHierarchyPrimarySystemCode(), assetParam.getHierarchyPrimarySystemCostRollUp(), primarySystemParent);
        locationParent = EquipmentHierarchyTools.createLocationParent(this.tools.getOrganizationCode(context), assetParam.getHierarchyLocationCode(), locationParent);
        switch (EquipmentHierarchyTools.getNewHierarchyType(assetParam, currentHierarchyType)) {
            case ASSET_DEP: {
                hierarchy.setAssetDependency(EquipmentHierarchyTools.createAssetDependencyForAsset(assetParent, positionParent, primarySystemParent, systemParents));
                break;
            }
            case POSITION_DEP: {
                hierarchy.setPositionDependency(EquipmentHierarchyTools.createPositionDependencyForAsset(assetParent, positionParent, primarySystemParent, systemParents));
                break;
            }
            case PRIM_SYSTEM_DEP: {
                hierarchy.setPrimarySystemDependency(EquipmentHierarchyTools.createPrimarySystemDependencyForAsset(assetParent, positionParent, primarySystemParent, systemParents));
                break;
            }
            case LOCATION_DEP: {
                hierarchy.setLocationDependency(EquipmentHierarchyTools.createLocationDependencyForAsset(assetParent, positionParent, primarySystemParent, systemParents, locationParent));
                break;
            }
            default: {
                hierarchy.setNonDependentParents(EquipmentHierarchyTools.createNonDependentParentsForAsset(assetParent, positionParent, primarySystemParent, systemParents));
            }
        }
        assetInfor.setAssetParentHierarchy(hierarchy);
    }
}

