/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.material.PhysicalInventoryService;
import ch.cern.eam.wshub.core.services.material.entities.PhysicalInventory;
import ch.cern.eam.wshub.core.services.material.entities.PhysicalInventoryRow;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigInteger;
import net.datastream.schemas.mp_entities.inventorytransaction_001.InventoryTransaction;
import net.datastream.schemas.mp_entities.inventorytransactiondefault_001.InventoryTransactionDefault;
import net.datastream.schemas.mp_entities.physicalinventoryline_001.PhysicalInventoryLine;
import net.datastream.schemas.mp_fields.STOREID_Type;
import net.datastream.schemas.mp_fields.TRANSACTIONID_Type;
import net.datastream.schemas.mp_fields.TRANSACTIONLINEID;
import net.datastream.schemas.mp_functions.mp1217_001.MP1217_AddInventoryTransaction_001;
import net.datastream.schemas.mp_functions.mp1218_001.MP1218_SyncInventoryTransaction_001;
import net.datastream.schemas.mp_functions.mp1219_001.MP1219_GetInventoryTransactionDefault_001;
import net.datastream.schemas.mp_functions.mp1220_001.MP1220_GetInventoryTransaction_001;
import net.datastream.schemas.mp_functions.mp1294_001.MP1294_SyncPhysicalInventoryLine_001;
import net.datastream.schemas.mp_functions.mp2244_001.MP2244_GetPhysicalInventoryLine_001;
import net.datastream.schemas.mp_results.mp1217_001.MP1217_AddInventoryTransaction_001_Result;
import net.datastream.schemas.mp_results.mp1220_001.ResultData;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class PhysicalInventoryServiceImpl
implements PhysicalInventoryService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public PhysicalInventoryServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public PhysicalInventory createPhysicalInventory(InforContext context, PhysicalInventory physicalInventory) throws InforException {
        InventoryTransaction inventoryTransaction = new InventoryTransaction();
        inventoryTransaction.setTRANSACTIONID(new TRANSACTIONID_Type());
        inventoryTransaction.getTRANSACTIONID().setTRANSACTIONCODE("0");
        this.tools.getInforFieldTools().transformWSHubObject(inventoryTransaction, physicalInventory, context);
        MP1217_AddInventoryTransaction_001 addInventoryTransaction = new MP1217_AddInventoryTransaction_001();
        addInventoryTransaction.setInventoryTransaction(inventoryTransaction);
        MP1217_AddInventoryTransaction_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addInventoryTransactionOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addInventoryTransaction);
        return this.tools.getInforFieldTools().transformInforObject(new PhysicalInventory(), result.getResultData().getInventoryTransaction(), context);
    }

    @Override
    public PhysicalInventory readPhysicalInventory(InforContext context, String code) throws InforException {
        ResultData resultData = this.getInventoryResultData(context, code);
        PhysicalInventory physicalInventory = this.tools.getInforFieldTools().transformInforObject(new PhysicalInventory(), resultData.getInventoryTransaction(), context);
        if (resultData.getCREATEDBY() != null) {
            physicalInventory.setCreatedBy(resultData.getCREATEDBY().getUSERCODE());
        }
        if (resultData.getCREATEDDATE() != null) {
            this.tools.getDataTypeTools();
            physicalInventory.setCreatedDate(DataTypeTools.decodeInforDate(resultData.getCREATEDDATE()));
        }
        return physicalInventory;
    }

    @Override
    public PhysicalInventory updatePhysicalInventory(InforContext context, PhysicalInventory physicalInventory) throws InforException {
        InventoryTransaction inventoryTransaction = this.getInventoryResultData(context, physicalInventory.getCode()).getInventoryTransaction();
        this.tools.getInforFieldTools().transformWSHubObject(inventoryTransaction, physicalInventory, context);
        MP1218_SyncInventoryTransaction_001 syncInventoryTransaction = new MP1218_SyncInventoryTransaction_001();
        syncInventoryTransaction.setInventoryTransaction(inventoryTransaction);
        InventoryTransaction result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncInventoryTransactionOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncInventoryTransaction).getResultData().getInventoryTransaction();
        return this.tools.getInforFieldTools().transformInforObject(new PhysicalInventory(), result, context);
    }

    private ResultData getInventoryResultData(InforContext context, String code) throws InforException {
        MP1220_GetInventoryTransaction_001 getInventoryTransaction = new MP1220_GetInventoryTransaction_001();
        getInventoryTransaction.setTRANSACTIONID(new TRANSACTIONID_Type());
        getInventoryTransaction.getTRANSACTIONID().setTRANSACTIONCODE(code);
        getInventoryTransaction.getTRANSACTIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        return this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getInventoryTransactionOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getInventoryTransaction).getResultData();
    }

    @Override
    public PhysicalInventoryRow readPhysicalInventoryLine(InforContext context, PhysicalInventoryRow row) throws InforException {
        return this.tools.getInforFieldTools().transformInforObject(new PhysicalInventoryRow(), this.getLine(context, row.getPhysicalInventoryCode(), row.getLineNumber()), context);
    }

    @Override
    public PhysicalInventoryRow updatePhysicalInventoryLine(InforContext context, PhysicalInventoryRow row) throws InforException {
        PhysicalInventoryLine physicalInventoryLine = this.getLine(context, row.getPhysicalInventoryCode(), row.getLineNumber());
        this.tools.getInforFieldTools().transformWSHubObject(physicalInventoryLine, row, context);
        this.tools.getDataTypeTools();
        physicalInventoryLine.setPHYSICALQUANTITY(DataTypeTools.encodeQuantity(row.getPhysicalQuantity(), "Physical Quantity"));
        MP1294_SyncPhysicalInventoryLine_001 syncPhysicalInventoryLine = new MP1294_SyncPhysicalInventoryLine_001();
        syncPhysicalInventoryLine.setPhysicalInventoryLine(physicalInventoryLine);
        PhysicalInventoryLine result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncPhysicalInventoryLineOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncPhysicalInventoryLine).getResultData().getPhysicalInventoryLine();
        return this.tools.getInforFieldTools().transformInforObject(new PhysicalInventoryRow(), result, context);
    }

    private PhysicalInventoryLine getLine(InforContext context, String code, BigInteger lineNumber) throws InforException {
        TRANSACTIONLINEID transactionLineId = new TRANSACTIONLINEID();
        transactionLineId.setTRANSACTIONID(new TRANSACTIONID_Type());
        transactionLineId.getTRANSACTIONID().setTRANSACTIONCODE(code);
        transactionLineId.getTRANSACTIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        this.tools.getDataTypeTools();
        transactionLineId.setTRANSACTIONLINENUM(DataTypeTools.convertBigIntegerToLong(lineNumber));
        MP2244_GetPhysicalInventoryLine_001 getPhysicalInventoryLine = new MP2244_GetPhysicalInventoryLine_001();
        getPhysicalInventoryLine.setTRANSACTIONLINEID(transactionLineId);
        return this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getPhysicalInventoryLineOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getPhysicalInventoryLine).getResultData().getPhysicalInventoryLine();
    }

    @Override
    public PhysicalInventory readDefaultPhysicalInventory(InforContext context, String storeCode) throws InforException {
        MP1219_GetInventoryTransactionDefault_001 getInventoryTransactionDefault = new MP1219_GetInventoryTransactionDefault_001();
        getInventoryTransactionDefault.setSTOREID(new STOREID_Type());
        getInventoryTransactionDefault.getSTOREID().setSTORECODE(storeCode);
        getInventoryTransactionDefault.getSTOREID().setORGANIZATIONID(this.tools.getOrganization(context));
        InventoryTransactionDefault inventoryTransactionDefault = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getInventoryTransactionDefaultOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getInventoryTransactionDefault).getResultData().getInventoryTransactionDefault();
        return this.tools.getInforFieldTools().transformInforObject(new PhysicalInventory(), inventoryTransactionDefault, context);
    }
}

