/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.material.PickTicketService;
import ch.cern.eam.wshub.core.services.material.entities.PickTicket;
import ch.cern.eam.wshub.core.services.material.entities.PickTicketPart;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import net.datastream.schemas.mp_entities.picklist_001.PickList;
import net.datastream.schemas.mp_entities.picklistpart_001.PickListPart;
import net.datastream.schemas.mp_fields.PARTID_Type;
import net.datastream.schemas.mp_fields.PICKLISTPARTID_Type;
import net.datastream.schemas.mp_fields.PICKLIST_Type;
import net.datastream.schemas.mp_functions.mp0211_001.MP0211_GetPickList_001;
import net.datastream.schemas.mp_functions.mp0296_001.MP0296_AddPickList_001;
import net.datastream.schemas.mp_functions.mp0297_001.MP0297_SyncPickList_001;
import net.datastream.schemas.mp_functions.mp1223_001.MP1223_AddPickListPart_001;
import net.datastream.schemas.mp_results.mp0211_001.MP0211_GetPickList_001_Result;
import net.datastream.schemas.mp_results.mp0296_001.MP0296_AddPickList_001_Result;
import net.datastream.schemas.mp_results.mp0297_001.MP0297_SyncPickList_001_Result;
import net.datastream.schemas.mp_results.mp1223_001.MP1223_AddPickListPart_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;
import org.openapplications.oagis_segments.QUANTITY;

public class PickTicketServiceImpl
implements PickTicketService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public PickTicketServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public String createPickTicket(InforContext context, PickTicket pickTicketParam) throws InforException {
        PickList pickList = new PickList();
        pickList.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(pickList.getCLASSID()), pickList.getUSERDEFINEDAREA(), pickTicketParam.getClassCode(), "PICK"));
        this.tools.getInforFieldTools().transformWSHubObject(pickList, pickTicketParam, context);
        if (pickList.getPICKLISTID() != null) {
            pickList.getPICKLISTID().setPICKLIST("");
        }
        MP0296_AddPickList_001 createPickTicket = new MP0296_AddPickList_001();
        createPickTicket.setPickList(pickList);
        MP0296_AddPickList_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addPickListOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), createPickTicket);
        return result.getPICKLISTID().getPICKLIST();
    }

    @Override
    public String updatePickTicket(InforContext context, PickTicket pickTicketParam) throws InforException {
        PickList pickList = this.readPickList(context, pickTicketParam.getCode());
        pickList.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, DataTypeTools.toCodeString(pickList.getCLASSID()), pickList.getUSERDEFINEDAREA(), pickTicketParam.getClassCode(), "PICK"));
        this.tools.getInforFieldTools().transformWSHubObject(pickList, pickTicketParam, context);
        MP0297_SyncPickList_001 syncPickTicket = new MP0297_SyncPickList_001();
        syncPickTicket.setPickList(pickList);
        MP0297_SyncPickList_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncPickListOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncPickTicket);
        return result.getResultData().getPICKLISTID().getPICKLIST();
    }

    public PickList readPickList(InforContext context, String code) throws InforException {
        MP0211_GetPickList_001 getPickList = new MP0211_GetPickList_001();
        getPickList.setPICKLISTID(new PICKLIST_Type());
        getPickList.getPICKLISTID().setPICKLIST(code);
        MP0211_GetPickList_001_Result pickListResult = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getPickListOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getPickList);
        return pickListResult.getResultData().getPickList();
    }

    @Override
    public PickTicket readPickTicket(InforContext context, String code) throws InforException {
        PickList pickList = this.readPickList(context, code);
        PickTicket pickTicket = this.tools.getInforFieldTools().transformInforObject(new PickTicket(), pickList, context);
        return pickTicket;
    }

    @Override
    public String addPartToPickTicket(InforContext context, PickTicketPart pickTicketPartParam) throws InforException {
        MP1223_AddPickListPart_001 addPickListPart = new MP1223_AddPickListPart_001();
        addPickListPart.setPickListPart(new PickListPart());
        QUANTITY quantity1 = new QUANTITY();
        quantity1.setVALUE(new BigDecimal(pickTicketPartParam.getQuantity()));
        quantity1.setUOM("default");
        quantity1.setSIGN("+");
        quantity1.setQualifier("OTHER");
        quantity1.setNUMOFDEC(new BigDecimal(0).toBigInteger());
        addPickListPart.getPickListPart().setQUANTITYREQUIRED(quantity1);
        PICKLISTPARTID_Type picklist_type = new PICKLISTPARTID_Type();
        picklist_type.setPARTID(new PARTID_Type());
        picklist_type.getPARTID().setPARTCODE(pickTicketPartParam.getPartCode());
        picklist_type.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
        picklist_type.setPICKLISTID(new PICKLIST_Type());
        picklist_type.getPICKLISTID().setPICKLIST(pickTicketPartParam.getPickTicket());
        addPickListPart.getPickListPart().setPICKLISTPARTID(picklist_type);
        MP1223_AddPickListPart_001_Result result = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addPickListPartOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addPickListPart);
        return result.toString();
    }
}

