/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestResult;
import ch.cern.eam.wshub.core.services.grids.impl.GridsServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.SafetyService;
import ch.cern.eam.wshub.core.services.workorders.impl.Safety;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.datastream.schemas.mp_entities.entitysafety_001.EntitySafety;
import net.datastream.schemas.mp_entities.worksafety_001.WorkSafety;
import net.datastream.schemas.mp_functions.mp3219_001.MP3219_AddEntitySafety_001;
import net.datastream.schemas.mp_functions.mp3220_001.MP3220_SyncEntitySafety_001;
import net.datastream.schemas.mp_functions.mp3221_001.MP3221_DeleteEntitySafety_001;
import net.datastream.schemas.mp_functions.mp3222_001.MP3222_GetEntitySafety_001;
import net.datastream.schemas.mp_functions.mp7983_001.MP7983_GetWorkSafety_001;
import net.datastream.schemas.mp_functions.mp7984_001.MP7984_AddWorkSafety_001;
import net.datastream.schemas.mp_functions.mp7985_001.MP7985_SyncWorkSafety_001;
import net.datastream.schemas.mp_functions.mp7986_001.MP7986_DeleteWorkSafety_001;
import net.datastream.wsdls.inforws.InforWebServicesPT;
import org.openapplications.oagis_segments.QUANTITY;

public class SafetyServiceImpl
implements SafetyService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private GridsService gridsService;

    public SafetyServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.gridsService = new GridsServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public BatchResponse<List<Safety>> readSafetiesBatch(InforContext context, String entityType, List<String> entityCode) {
        List callableList = entityCode.stream().map(code -> () -> this.readSafeties(context, entityType, (String)code)).collect(Collectors.toList());
        return this.tools.processCallables(callableList);
    }

    @Override
    public BatchResponse<String> setSafetiesBatch(InforContext context, String entityType, Map<String, List<Safety>> entityCodeToSafeties) {
        List callableList = entityCodeToSafeties.keySet().stream().map(code -> () -> this.setSafeties(context, entityType, (String)code, (List)entityCodeToSafeties.get(code))).collect(Collectors.toList());
        return this.tools.processCallables(callableList);
    }

    @Override
    public List<Safety> readSafeties(InforContext context, String entityType, String entityCode) throws InforException {
        GridRequest request = new GridRequest();
        request.setGridType(GridRequest.GRIDTYPE.LIST);
        if (this.isWorkOrder(entityType)) {
            request.setGridName("WSJOBS_KSF");
            request.addParam("param.workordernum", entityCode);
            request.addParam("parameter.r5role", "");
            request.setUserFunctionName("WSJOBS");
        } else if (this.isObject(entityType)) {
            request.setGridName("OSOBJA_ESF");
            request.setUserFunctionName("OSOBJA");
            request.addParam("parameter.object", entityCode);
            request.addParam("parameter.objorganization", this.tools.getOrganizationCode(context));
        } else {
            throw Tools.generateFault("Invalid entityType");
        }
        GridRequestResult result = this.gridsService.executeQuery(context, request);
        List<Safety> safeties = GridTools.convertGridResultToObject(Safety.class, null, result);
        safeties.stream().forEach(safety -> safety.setUserDefinedFields(null));
        return safeties;
    }

    @Override
    public String setSafeties(InforContext context, String entityType, String entityCode, List<Safety> safeties) throws InforException {
        if (!this.isWorkOrder(entityType) && !this.isObject(entityType)) {
            throw Tools.generateFault("Invalid entityType");
        }
        Map<String, Safety> currentSafetiesMap = this.toMap(this.readSafeties(context, entityType, entityCode));
        for (Safety safety : safeties) {
            if (safety == null) continue;
            String id = safety.getId();
            Safety currentSafety = currentSafetiesMap.get(id);
            currentSafetiesMap.remove(id);
            if (safety.getReadOnly()) continue;
            if (currentSafety == null) {
                this.addSafety(context, entityType, entityCode, safety);
                continue;
            }
            if (!Safety.canBeChangedBy(currentSafety, safety)) continue;
            this.syncSafety(context, entityType, entityCode, safety);
        }
        for (Safety safety : currentSafetiesMap.values()) {
            this.removeSafety(context, entityType, safety.getId());
        }
        return "OK";
    }

    @Override
    public Safety readSafety(InforContext context, String entityType, String safetyCode) throws InforException {
        if (this.isObject(entityType)) {
            MP3222_GetEntitySafety_001 getEntitySafety = new MP3222_GetEntitySafety_001();
            getEntitySafety.setSAFETYCODE(safetyCode);
            EntitySafety inforSafety = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getEntitySafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getEntitySafety).getResultData().getEntitySafety();
            Safety safety = new Safety();
            return this.tools.getInforFieldTools().transformInforObject(safety, inforSafety, context);
        }
        if (this.isWorkOrder(entityType)) {
            MP7983_GetWorkSafety_001 getWorkSafety = new MP7983_GetWorkSafety_001();
            getWorkSafety.setSAFETYCODE(safetyCode);
            WorkSafety workSafety = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getWorkSafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getWorkSafety).getResultData().getWorkSafety();
            Safety safety = new Safety();
            return this.tools.getInforFieldTools().transformInforObject(safety, workSafety, context);
        }
        throw Tools.generateFault("Invalid entityType");
    }

    private String getFullEntityCode(InforContext context, String entityType, String entityCode) {
        String extension = this.isObject(entityType) ? "#" + this.tools.getOrganizationCode(context) : "";
        return entityCode + extension;
    }

    private EntitySafety transformToEntitySafety(InforContext context, String entityType, String entityCode, Safety safety, EntitySafety original) throws InforException {
        EntitySafety entitySafetyInfor = original == null ? new EntitySafety() : original;
        this.tools.getInforFieldTools().transformWSHubObject(entitySafetyInfor, safety, context);
        if (safety.getId() == null) {
            entitySafetyInfor.setSAFETYCODE("0");
        }
        entitySafetyInfor.setENTITY(entityType);
        entitySafetyInfor.setENTITYSAFETYCODE(this.getFullEntityCode(context, entityType, entityCode));
        entitySafetyInfor.getHAZARDID().setREVISIONNUM(this.getRevisionQUANTITY(context, safety, entitySafetyInfor.getHAZARDID().getREVISIONNUM(), true));
        entitySafetyInfor.getPRECAUTIONID().setREVISIONNUM(this.getRevisionQUANTITY(context, safety, entitySafetyInfor.getPRECAUTIONID().getREVISIONNUM(), false));
        return entitySafetyInfor;
    }

    private WorkSafety transformToWorkSafety(InforContext context, String entityType, String entityCode, Safety safety, WorkSafety original) throws InforException {
        WorkSafety workSafetyInfor = original == null ? new WorkSafety() : original;
        this.tools.getInforFieldTools().transformWSHubObject(workSafetyInfor, safety, context);
        if (safety.getId() == null) {
            workSafetyInfor.setSAFETYCODE("0");
        }
        workSafetyInfor.setENTITY(entityType);
        workSafetyInfor.setENTITYSAFETYCODE(this.getFullEntityCode(context, entityType, entityCode));
        workSafetyInfor.getHAZARDID().setREVISIONNUM(this.getRevisionQUANTITY(context, safety, workSafetyInfor.getHAZARDID().getREVISIONNUM(), true));
        workSafetyInfor.getPRECAUTIONID().setREVISIONNUM(this.getRevisionQUANTITY(context, safety, workSafetyInfor.getPRECAUTIONID().getREVISIONNUM(), false));
        return workSafetyInfor;
    }

    private void addSafety(InforContext context, String entityType, String entityCode, Safety safety) throws InforException {
        if (this.isObject(entityType)) {
            EntitySafety entitySafetyInfor = this.transformToEntitySafety(context, entityType, entityCode, safety, null);
            entitySafetyInfor.setSAFETYCODE("0");
            MP3219_AddEntitySafety_001 addEntitySafety = new MP3219_AddEntitySafety_001();
            addEntitySafety.getEntitySafety().add(entitySafetyInfor);
            this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addEntitySafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addEntitySafety);
        } else if (this.isWorkOrder(entityType)) {
            WorkSafety workSafetyInfor = this.transformToWorkSafety(context, entityType, entityCode, safety, null);
            workSafetyInfor.setSAFETYCODE("0");
            MP7984_AddWorkSafety_001 addWorkSafety_001 = new MP7984_AddWorkSafety_001();
            addWorkSafety_001.getWorkSafety().add(workSafetyInfor);
            this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).addWorkSafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addWorkSafety_001);
        } else {
            throw Tools.generateFault("Invalid entityType");
        }
    }

    private void removeSafety(InforContext context, String entityType, String safetyId) throws InforException {
        if (this.isObject(entityType)) {
            MP3221_DeleteEntitySafety_001 deleteEntitySafety = new MP3221_DeleteEntitySafety_001();
            deleteEntitySafety.setSAFETYCODE(safetyId);
            this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteEntitySafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteEntitySafety);
        } else if (this.isWorkOrder(entityType)) {
            MP7986_DeleteWorkSafety_001 deleteWorkSafety = new MP7986_DeleteWorkSafety_001();
            deleteWorkSafety.setSAFETYCODE(safetyId);
            this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).deleteWorkSafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteWorkSafety);
        } else {
            throw Tools.generateFault("Invalid entityType");
        }
    }

    private void syncSafety(InforContext context, String entityType, String entityCode, Safety safety) throws InforException {
        if (this.isObject(entityType)) {
            MP3222_GetEntitySafety_001 getEntitySafety = new MP3222_GetEntitySafety_001();
            getEntitySafety.setSAFETYCODE(safety.getId());
            EntitySafety previousSafety = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getEntitySafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getEntitySafety).getResultData().getEntitySafety();
            EntitySafety entitySafetyInfor = this.transformToEntitySafety(context, entityType, entityCode, safety, previousSafety);
            MP3220_SyncEntitySafety_001 syncEntitySafety = new MP3220_SyncEntitySafety_001();
            syncEntitySafety.setEntitySafety(entitySafetyInfor);
            this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncEntitySafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncEntitySafety);
        } else if (this.isWorkOrder(entityType)) {
            MP7983_GetWorkSafety_001 getWorkSafety = new MP7983_GetWorkSafety_001();
            getWorkSafety.setSAFETYCODE(safety.getId());
            WorkSafety previousSafety = this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).getWorkSafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getWorkSafety).getResultData().getWorkSafety();
            WorkSafety workSafetyInfor = this.transformToWorkSafety(context, entityType, entityCode, safety, previousSafety);
            MP7985_SyncWorkSafety_001 syncWorkSafety = new MP7985_SyncWorkSafety_001();
            syncWorkSafety.setWorkSafety(workSafetyInfor);
            this.tools.performInforOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).syncWorkSafetyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncWorkSafety);
        } else {
            throw Tools.generateFault("Invalid entityType");
        }
    }

    private QUANTITY getRevisionQUANTITY(InforContext context, Safety safety, QUANTITY oldQuantity, boolean isHazard) throws InforException {
        String id = isHazard ? safety.getHazardCode() : safety.getPrecautionCode();
        String label = isHazard ? "Hazard Code" : "Precaution Code";
        return oldQuantity == null ? DataTypeTools.encodeQuantity(this.getLatestRevision(context, id, isHazard), label) : oldQuantity;
    }

    private BigDecimal getLatestRevision(InforContext context, String id, boolean isHazard) throws InforException {
        if (id == null) {
            throw Tools.generateFault(isHazard ? "Hazard Code is null" : "Precaution Code is null");
        }
        GridRequest gridRequest = new GridRequest(isHazard ? "LVSAFETYHAZARD" : "LVPRECAUTION", GridRequest.GRIDTYPE.LOV);
        gridRequest.addFilter(isHazard ? "hazardcode" : "precaution", id, "=");
        gridRequest.setRowCount(1);
        String revision = GridTools.extractSingleResult(this.gridsService.executeQuery(context, gridRequest), "revision");
        return new BigDecimal(revision);
    }

    private Map<String, Safety> toMap(List<Safety> safeties) {
        return safeties.stream().collect(Collectors.toMap(Safety::getId, Function.identity(), (firstSafety, otherSafety) -> firstSafety));
    }

    private boolean isWorkOrder(String entityType) {
        return entityType.equals("EVNT");
    }

    private boolean isObject(String entityType) {
        return entityType.equals("OBJ");
    }
}

