/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.userdefinedscreens.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedScreenService;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDTRow;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.datastream.schemas.mp_fields.USERDEFINEDSCREENFIELDDATA_Type;
import net.datastream.schemas.mp_fields.USERDEFINEDSCREENFIELDVALUELIST;
import net.datastream.schemas.mp_fields.USERDEFINEDSCREENFIELDVALUEPAIR;
import net.datastream.schemas.mp_functions.mp6441_001.MP6441_ProcessUserDefinedScreenService_001;
import net.datastream.schemas.mp_results.mp6441_001.MP6441_ProcessUserDefinedScreenService_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class UserDefinedScreenServiceImpl
implements UserDefinedScreenService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public UserDefinedScreenServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public String createUserDefinedScreenRow(InforContext inforContext, String screenName, UDTRow udtRow) throws InforException {
        MP6441_ProcessUserDefinedScreenService_001 userDefinedScreenService = this.initUserDefinedScreenService(screenName, "ADD");
        this.addFields(userDefinedScreenService, udtRow);
        this.tools.performInforOperation(inforContext, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).processUserDefinedScreenServiceOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), userDefinedScreenService);
        return screenName;
    }

    @Override
    public String updateUserDefinedScreenRow(InforContext inforContext, String screenName, UDTRow fieldsToUpdate, UDTRow filters) throws InforException {
        MP6441_ProcessUserDefinedScreenService_001 userDefinedScreenServiceGet = this.initUserDefinedScreenService(screenName, "GET");
        this.addFields(userDefinedScreenServiceGet, filters);
        MP6441_ProcessUserDefinedScreenService_001_Result result = this.tools.performInforOperation(inforContext, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).processUserDefinedScreenServiceOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), userDefinedScreenServiceGet);
        MP6441_ProcessUserDefinedScreenService_001 userDefinedScreenServiceUpdate = new MP6441_ProcessUserDefinedScreenService_001();
        userDefinedScreenServiceUpdate.setUserDefinedScreenService(result.getResultData().getUserDefinedScreenService());
        userDefinedScreenServiceUpdate.getUserDefinedScreenService().setUSERDEFINEDSERVICEACTION("UPDATE");
        userDefinedScreenServiceUpdate.getUserDefinedScreenService().getUSERDEFINEDSCREENFIELDVALUELIST().getUSERDEFINEDSCREENFIELDVALUEPAIR().removeIf(pair -> fieldsToUpdate.getAllKeys().contains(pair.getUSERDEFINEDSCREENFIELDNAME()));
        this.addFields(userDefinedScreenServiceUpdate, fieldsToUpdate);
        this.tools.performInforOperation(inforContext, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).processUserDefinedScreenServiceOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), userDefinedScreenServiceUpdate);
        return screenName;
    }

    @Override
    public String deleteUserDefinedScreenRow(InforContext inforContext, String screenName, UDTRow udtRow) throws InforException {
        MP6441_ProcessUserDefinedScreenService_001 userDefinedScreenService = this.initUserDefinedScreenService(screenName, "DELETE");
        this.addFields(userDefinedScreenService, udtRow);
        this.tools.performInforOperation(inforContext, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((InforWebServicesPT)this.inforws).processUserDefinedScreenServiceOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), userDefinedScreenService);
        return screenName;
    }

    private void addFields(MP6441_ProcessUserDefinedScreenService_001 processUserDefinedScreenService, UDTRow row) throws InforException {
        List udsFieldsFilter = processUserDefinedScreenService.getUserDefinedScreenService().getUSERDEFINEDSCREENFIELDVALUELIST().getUSERDEFINEDSCREENFIELDVALUEPAIR();
        udsFieldsFilter.addAll(this.getPairList(row.getStrings()));
        udsFieldsFilter.addAll(this.getPairList(row.getDates()));
        udsFieldsFilter.addAll(this.getPairList(row.getDecimals()));
    }

    private MP6441_ProcessUserDefinedScreenService_001 initUserDefinedScreenService(String screenName, String screenAction) {
        MP6441_ProcessUserDefinedScreenService_001 userDefinedScreenService = new MP6441_ProcessUserDefinedScreenService_001();
        userDefinedScreenService.setUserDefinedScreenService(new net.datastream.schemas.mp_entities.userdefinedscreenservice_001.UserDefinedScreenService());
        userDefinedScreenService.getUserDefinedScreenService().setUSERDEFINEDSCREENNAME(screenName);
        userDefinedScreenService.getUserDefinedScreenService().setUSERDEFINEDSERVICEACTION(screenAction);
        userDefinedScreenService.getUserDefinedScreenService().setUSERDEFINEDSCREENFIELDVALUELIST(new USERDEFINEDSCREENFIELDVALUELIST());
        return userDefinedScreenService;
    }

    private <T> List<USERDEFINEDSCREENFIELDVALUEPAIR> getPairList(Map<String, T> values) throws InforException {
        LinkedList<USERDEFINEDSCREENFIELDVALUEPAIR> result = new LinkedList<USERDEFINEDSCREENFIELDVALUEPAIR>();
        if (values == null) {
            return new LinkedList<USERDEFINEDSCREENFIELDVALUEPAIR>();
        }
        for (String value : values.keySet()) {
            if (values.get(value) == null) continue;
            result.add(this.getPair(value, values.get(value)));
        }
        return result;
    }

    private <T> USERDEFINEDSCREENFIELDVALUEPAIR getPair(String fieldName, T fieldValue) throws InforException {
        USERDEFINEDSCREENFIELDVALUEPAIR pair = new USERDEFINEDSCREENFIELDVALUEPAIR();
        pair.setUSERDEFINEDSCREENFIELDNAME(fieldName);
        pair.setUSERDEFINEDSCREENFIELDVALUE(new USERDEFINEDSCREENFIELDDATA_Type());
        if (fieldValue instanceof String) {
            pair.getUSERDEFINEDSCREENFIELDVALUE().setTEXTDATA((String)fieldValue);
        }
        if (fieldValue instanceof BigDecimal) {
            pair.getUSERDEFINEDSCREENFIELDVALUE().setNUMERICDATA(DataTypeTools.encodeAmount((BigDecimal)fieldValue, fieldName));
        }
        if (fieldValue instanceof Date) {
            pair.getUSERDEFINEDSCREENFIELDVALUE().setDATETIMEDATA(DataTypeTools.encodeInforDate((Date)fieldValue, fieldName));
        }
        return pair;
    }
}

