/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.administration.impl;

import ch.cern.eam.wshub.core.annotations.BooleanType;
import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.administration.DataspyService;
import ch.cern.eam.wshub.core.services.administration.entities.DataspyCopy;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.impl.GridsServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import net.datastream.schemas.mp_fields.SCREENDATASPYID_Type;
import net.datastream.schemas.mp_fields.USERID_Type;
import net.datastream.schemas.mp_functions.mp6516_001.MP6516_CopyScreenDataspy_001;
import net.datastream.schemas.mp_functions.mp6518_001.MP6518_DeleteScreenDataspy_001;
import net.datastream.schemas.mp_results.mp6516_001.MP6516_CopyScreenDataspy_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class DataspyServiceImpl
implements DataspyService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;
    private GridsService gridsService;

    public DataspyServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
        this.gridsService = new GridsServiceImpl(applicationData, tools, eamWebServicesToolkitClient);
    }

    @Override
    public String copyDataspy(EAMContext context, DataspyCopy dataspyCopy) throws EAMException {
        MP6516_CopyScreenDataspy_001 copyScreenDataspy = new MP6516_CopyScreenDataspy_001();
        this.tools.getDataTypeTools();
        copyScreenDataspy.setDDSPYID(DataTypeTools.encodeQuantity(dataspyCopy.getDataspyCode(), "Dataspy Code"));
        copyScreenDataspy.setUSERID(new USERID_Type());
        copyScreenDataspy.getUSERID().setUSERCODE(dataspyCopy.getUserCode());
        this.tools.getDataTypeTools();
        copyScreenDataspy.setDEFAULT(DataTypeTools.encodeBoolean(dataspyCopy.getDefaultDataspy(), BooleanType.PLUS_MINUS));
        MP6516_CopyScreenDataspy_001_Result result = null;
        result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).copyScreenDataspyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), copyScreenDataspy);
        GridRequest gridRequest = new GridRequest("BEWSDP", 1);
        gridRequest.addFilter("dds_owner", dataspyCopy.getUserCode(), "=");
        gridRequest.sortBy("dds_ddspyid", "DESC");
        return GridTools.extractSingleResult(this.gridsService.executeQuery(context, gridRequest), "dds_ddspyid").replace(",", "");
    }

    @Override
    public String deleteDataspy(EAMContext context, BigDecimal dataspyId) throws EAMException {
        MP6518_DeleteScreenDataspy_001 deleteScreenDataspy = new MP6518_DeleteScreenDataspy_001();
        deleteScreenDataspy.setSCREENDATASPYID(new SCREENDATASPYID_Type());
        deleteScreenDataspy.getSCREENDATASPYID().setDDSPYID(DataTypeTools.encodeQuantity(dataspyId, "Dataspy ID"));
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).deleteScreenDataspyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteScreenDataspy);
        return dataspyId.toPlainString();
    }
}

