/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.entities;

import ch.cern.eam.wshub.core.adapters.BigDecimalAdapter;
import ch.cern.eam.wshub.core.adapters.BooleanAdapter;
import ch.cern.eam.wshub.core.adapters.DateAdapter;
import ch.cern.eam.wshub.core.annotations.EAMField;
import ch.cern.eam.wshub.core.services.entities.CustomField;
import ch.cern.eam.wshub.core.services.entities.UserDefinedFields;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedListHelpable;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDLValue;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;

@Entity
@Table(name="R5OBJECTS")
public class Equipment
implements Serializable,
UserDefinedListHelpable {
    private static final long serialVersionUID = 7865040704362527306L;
    @Column(name="OBJ_DESC")
    @EAMField(xpath={"ASSETID/DESCRIPTION", "POSITIONID/DESCRIPTION", "SYSTEMID/DESCRIPTION"}, readOnly=true)
    private String description;
    @Id
    @Column(name="OBJ_CODE")
    @EAMField(xpath={"ASSETID/EQUIPMENTCODE", "POSITIONID/EQUIPMENTCODE", "SYSTEMID/EQUIPMENTCODE"}, readOnly=true)
    private String code;
    @Transient
    @EAMField(xpath={"ASSETID/ORGANIZATIONID/ORGANIZATIONCODE", "POSITIONID/ORGANIZATIONID/ORGANIZATIONCODE", "SYSTEMID/ORGANIZATIONID/ORGANIZATIONCODE"}, readOnly=true)
    private String organization;
    @Column(name="OBJ_OBTYPE")
    @EAMField(xpath={"TYPE/TYPECODE"})
    private String typeCode;
    @EAMField(xpath={"TYPE/DESCRIPTION"}, readOnly=true)
    private String typeDesc;
    private String systemTypeCode;
    @Transient
    @EAMField(xpath={"EQUIPMENTALIAS"})
    private String alias;
    @Transient
    @EAMField(xpath={"CLASSID/CLASSCODE"}, nullifyParentLevel=1)
    private String classCode;
    @Transient
    @EAMField(xpath={"CLASSID/DESCRIPTION"}, readOnly=true)
    private String classDesc;
    @Transient
    @EAMField(xpath={"CATEGORYID/CATEGORYCODE"}, nullifyParentLevel=1)
    private String categoryCode;
    @Transient
    @EAMField(xpath={"CATEGORYID/DESCRIPTION"}, readOnly=true)
    private String categoryDesc;
    @Transient
    @EAMField(xpath={"recordid"})
    private BigInteger updateCount;
    @Transient
    @EAMField(xpath={"OUTOFSERVICE"})
    private Boolean outOfService;
    @Transient
    @EAMField(xpath={"INPRODUCTION"})
    private Boolean inProduction;
    @Transient
    @EAMField(xpath={"PROFILEID/OBJECTCODE"})
    private String profileCode;
    @Transient
    @EAMField(xpath={"STATUS/STATUSCODE"}, nullifyParentLevel=1)
    private String statusCode;
    @Transient
    @EAMField(xpath={"STATUS/DESCRIPTION"}, readOnly=true)
    private String statusDesc;
    @Transient
    private String systemStatusCode;
    @Transient
    @EAMField(xpath={"COSTCODEID/COSTCODE"}, nullifyParentLevel=1)
    private String costCode;
    @Transient
    @EAMField(xpath={"COSTCODEID/DESCRIPTION"}, nullifyParentLevel=0)
    private String costCodeDesc;
    @Transient
    @EAMField(xpath={"DEPARTMENTID/DEPARTMENTCODE"}, nullifyParentLevel=1)
    private String departmentCode;
    @Transient
    @EAMField(xpath={"DEPARTMENTID/DESCRIPTION"}, nullifyParentLevel=0)
    private String departmentDesc;
    @Transient
    @EAMField(xpath={"USERDEFINEDAREA"})
    private CustomField[] customFields;
    @Transient
    @EAMField(xpath={"COMMISSIONDATE"})
    private Date comissionDate;
    @Transient
    @EAMField(xpath={"ASSETVALUE"})
    private BigDecimal equipmentValue;
    @Transient
    @EAMField(xpath={"ASSIGNEDTO/PERSONCODE"}, nullifyParentLevel=1)
    private String assignedTo;
    @Transient
    @EAMField(xpath={"ASSIGNEDTO/DESCRIPTION"}, readOnly=true)
    private String assignedToDesc;
    @Transient
    @EAMField(xpath={"METERUNIT"})
    private String meterUnit;
    @Transient
    @EAMField(xpath={"CRITICALITYID/CRITICALITY"}, nullifyParentLevel=1)
    private String criticality;
    @Transient
    @EAMField(xpath={"CGMP"})
    private String cGMP;
    @Transient
    @EAMField(xpath={"ORIGINALRECEIPTDATE"})
    private Date originalReceiptDate;
    @Transient
    @EAMField(xpath={"EQUIPMENTSTATEID/STATECODE"}, enforceValidXpath=false, nullifyParentLevel=1)
    private String stateCode;
    @Transient
    @EAMField(xpath={"EQUIPMENTSTATEID/DESCRIPTION"}, readOnly=true)
    private String stateDesc;
    @Transient
    @EAMField(xpath={"ManufacturerInfo/MANUFACTURERCODE"}, nullifyParentLevel=0)
    private String manufacturerCode;
    @Transient
    private String manufacturerDesc;
    @Transient
    @EAMField(xpath={"ManufacturerInfo/SERIALNUMBER"}, nullifyParentLevel=0)
    private String serialNumber;
    @Transient
    @EAMField(xpath={"ManufacturerInfo/MODEL"}, nullifyParentLevel=0)
    private String model;
    @Transient
    @EAMField(xpath={"ManufacturerInfo/MODELREVISION"}, nullifyParentLevel=0)
    private String revision;
    @Transient
    @EAMField(xpath={"ManufacturerInfo/XCOORDINATE"}, nullifyParentLevel=0)
    private BigDecimal xCoordinate;
    @Transient
    @EAMField(xpath={"ManufacturerInfo/YCOORDINATE"}, nullifyParentLevel=0)
    private BigDecimal yCoordinate;
    @Transient
    @EAMField(xpath={"ManufacturerInfo/ZCOORDINATE"}, nullifyParentLevel=0)
    private BigDecimal zCoordinate;
    @Transient
    @EAMField(xpath={"VENDOR"}, nullifyParentLevel=0)
    private String vendor;
    @Transient
    @EAMField(xpath={"FacilityConditionIndex/COSTOFNEEDEDREPAIRS"}, nullifyParentLevel=0)
    private BigDecimal costOfNeededRepairs;
    @Transient
    @EAMField(xpath={"FacilityConditionIndex/REPLACEMENTVALUE"}, nullifyParentLevel=0)
    private BigDecimal replacementValue;
    @Transient
    @EAMField(xpath={"FacilityConditionIndex/FACILITYCONDITIONINDEX"}, nullifyParentLevel=0)
    private BigDecimal facilityConditionIndex;
    @Transient
    @EAMField(xpath={"FacilityConditionIndex/YEARBUILT"}, nullifyParentLevel=0)
    private BigDecimal yearBuilt;
    @Transient
    @EAMField(xpath={"FacilityConditionIndex/SERVICELIFE"}, nullifyParentLevel=0)
    private BigDecimal serviceLifetime;
    @Transient
    @EAMField(xpath={"AssetParentHierarchy/AssetDependency/DEPENDENTASSET/ASSETID/EQUIPMENTCODE", "AssetParentHierarchy/PositionDependency/NONDEPENDENTASSET/ASSETID/EQUIPMENTCODE", "AssetParentHierarchy/PrimarySystemDependency/NONDEPENDENTASSET/ASSETID/EQUIPMENTCODE", "AssetParentHierarchy/SystemDependency/NONDEPENDENTASSET/ASSETID/EQUIPMENTCODE", "AssetParentHierarchy/LocationDependency/NONDEPENDENTASSET/ASSETID/EQUIPMENTCODE", "AssetParentHierarchy/NonDependentParents/NONDEPENDENTASSET/ASSETID/EQUIPMENTCODE", "PositionParentHierarchy/AssetDependency/DEPENDENTASSET/ASSETID/EQUIPMENTCODE", "PositionParentHierarchy/PositionDependency/NONDEPENDENTASSET/ASSETID/EQUIPMENTCODE", "PositionParentHierarchy/PrimarySystemDependency/NONDEPENDENTASSET/ASSETID/EQUIPMENTCODE", "PositionParentHierarchy/SystemDependency/NONDEPENDENTASSET/ASSETID/EQUIPMENTCODE", "PositionParentHierarchy/LocationDependency/NONDEPENDENTASSET/ASSETID/EQUIPMENTCODE", "PositionParentHierarchy/NonDependentParents/NONDEPENDENTASSET/ASSETID/EQUIPMENTCODE"}, readOnly=true)
    private String hierarchyAssetCode;
    @Transient
    @EAMField(xpath={"AssetParentHierarchy/AssetDependency/DEPENDENTASSET/ASSETID/DESCRIPTION", "AssetParentHierarchy/PositionDependency/NONDEPENDENTASSET/ASSETID/DESCRIPTION", "AssetParentHierarchy/PrimarySystemDependency/NONDEPENDENTASSET/ASSETID/DESCRIPTION", "AssetParentHierarchy/SystemDependency/NONDEPENDENTASSET/ASSETID/DESCRIPTION", "AssetParentHierarchy/LocationDependency/NONDEPENDENTASSET/ASSETID/DESCRIPTION", "AssetParentHierarchy/NonDependentParents/NONDEPENDENTASSET/ASSETID/DESCRIPTION", "PositionParentHierarchy/AssetDependency/DEPENDENTASSET/ASSETID/DESCRIPTION", "PositionParentHierarchy/PositionDependency/NONDEPENDENTASSET/ASSETID/DESCRIPTION", "PositionParentHierarchy/PrimarySystemDependency/NONDEPENDENTASSET/ASSETID/DESCRIPTION", "PositionParentHierarchy/SystemDependency/NONDEPENDENTASSET/ASSETID/DESCRIPTION", "PositionParentHierarchy/LocationDependency/NONDEPENDENTASSET/ASSETID/DESCRIPTION", "PositionParentHierarchy/NonDependentParents/NONDEPENDENTASSET/ASSETID/DESCRIPTION"}, readOnly=true)
    private String hierarchyAssetDesc;
    @Transient
    @EAMField(xpath={"AssetParentHierarchy/AssetDependency/DEPENDENTASSET/ASSETID/ORGANIZATIONID/ORGANIZATIONCODE", "AssetParentHierarchy/PositionDependency/NONDEPENDENTASSET/ASSETID/ORGANIZATIONID/ORGANIZATIONCODE", "AssetParentHierarchy/PrimarySystemDependency/NONDEPENDENTASSET/ASSETID/ORGANIZATIONID/ORGANIZATIONCODE", "AssetParentHierarchy/SystemDependency/NONDEPENDENTASSET/ASSETID/ORGANIZATIONID/ORGANIZATIONCODE", "AssetParentHierarchy/LocationDependency/NONDEPENDENTASSET/ASSETID/ORGANIZATIONID/ORGANIZATIONCODE", "AssetParentHierarchy/NonDependentParents/NONDEPENDENTASSET/ASSETID/ORGANIZATIONID/ORGANIZATIONCODE", "PositionParentHierarchy/AssetDependency/DEPENDENTASSET/ASSETID/ORGANIZATIONID/ORGANIZATIONCODE", "PositionParentHierarchy/PositionDependency/NONDEPENDENTASSET/ASSETID/ORGANIZATIONID/ORGANIZATIONCODE", "PositionParentHierarchy/PrimarySystemDependency/NONDEPENDENTASSET/ASSETID/ORGANIZATIONID/ORGANIZATIONCODE", "PositionParentHierarchy/SystemDependency/NONDEPENDENTASSET/ASSETID/ORGANIZATIONID/ORGANIZATIONCODE", "PositionParentHierarchy/LocationDependency/NONDEPENDENTASSET/ASSETID/ORGANIZATIONID/ORGANIZATIONCODE", "PositionParentHierarchy/NonDependentParents/NONDEPENDENTASSET/ASSETID/ORGANIZATIONID/ORGANIZATIONCODE"}, readOnly=true)
    private String hierarchyAssetOrg;
    @Transient
    private Boolean hierarchyAssetDependent;
    @Transient
    @EAMField(xpath={"AssetParentHierarchy/AssetDependency/DEPENDENTASSET/COSTROLLUP", "AssetParentHierarchy/PositionDependency/NONDEPENDENTASSET/COSTROLLUP", "AssetParentHierarchy/PrimarySystemDependency/NONDEPENDENTASSET/COSTROLLUP", "AssetParentHierarchy/SystemDependency/NONDEPENDENTASSET/COSTROLLUP", "AssetParentHierarchy/LocationDependency/NONDEPENDENTASSET/COSTROLLUP", "AssetParentHierarchy/NonDependentParents/NONDEPENDENTASSET/COSTROLLUP", "PositionParentHierarchy/AssetDependency/DEPENDENTASSET/COSTROLLUP", "PositionParentHierarchy/PositionDependency/NONDEPENDENTASSET/COSTROLLUP", "PositionParentHierarchy/PrimarySystemDependency/NONDEPENDENTASSET/COSTROLLUP", "PositionParentHierarchy/SystemDependency/NONDEPENDENTASSET/COSTROLLUP", "PositionParentHierarchy/LocationDependency/NONDEPENDENTASSET/COSTROLLUP", "PositionParentHierarchy/NonDependentParents/NONDEPENDENTASSET/COSTROLLUP"}, readOnly=true)
    private Boolean hierarchyAssetCostRollUp;
    @Transient
    @EAMField(xpath={"AssetParentHierarchy/AssetDependency/NONDEPENDENTPOSITION/POSITIONID/EQUIPMENTCODE", "AssetParentHierarchy/PositionDependency/DEPENDENTPOSITION/POSITIONID/EQUIPMENTCODE", "AssetParentHierarchy/PrimarySystemDependency/NONDEPENDENTPOSITION/POSITIONID/EQUIPMENTCODE", "AssetParentHierarchy/SystemDependency/NONDEPENDENTPOSITION/POSITIONID/EQUIPMENTCODE", "AssetParentHierarchy/LocationDependency/NONDEPENDENTPOSITION/POSITIONID/EQUIPMENTCODE", "AssetParentHierarchy/NonDependentParents/NONDEPENDENTPOSITION/POSITIONID/EQUIPMENTCODE", "PositionParentHierarchy/AssetDependency/NONDEPENDENTPOSITION/POSITIONID/EQUIPMENTCODE", "PositionParentHierarchy/PositionDependency/DEPENDENTPOSITION/POSITIONID/EQUIPMENTCODE", "PositionParentHierarchy/PrimarySystemDependency/NONDEPENDENTPOSITION/POSITIONID/EQUIPMENTCODE", "PositionParentHierarchy/SystemDependency/NONDEPENDENTPOSITION/POSITIONID/EQUIPMENTCODE", "PositionParentHierarchy/LocationDependency/NONDEPENDENTPOSITION/POSITIONID/EQUIPMENTCODE", "PositionParentHierarchy/NonDependentParents/NONDEPENDENTPOSITION/POSITIONID/EQUIPMENTCODE"}, readOnly=true)
    private String hierarchyPositionCode;
    @Transient
    @EAMField(xpath={"AssetParentHierarchy/AssetDependency/NONDEPENDENTPOSITION/POSITIONID/DESCRIPTION", "AssetParentHierarchy/PositionDependency/DEPENDENTPOSITION/POSITIONID/DESCRIPTION", "AssetParentHierarchy/PrimarySystemDependency/NONDEPENDENTPOSITION/POSITIONID/DESCRIPTION", "AssetParentHierarchy/SystemDependency/NONDEPENDENTPOSITION/POSITIONID/DESCRIPTION", "AssetParentHierarchy/LocationDependency/NONDEPENDENTPOSITION/POSITIONID/DESCRIPTION", "AssetParentHierarchy/NonDependentParents/NONDEPENDENTPOSITION/POSITIONID/DESCRIPTION", "PositionParentHierarchy/AssetDependency/NONDEPENDENTPOSITION/POSITIONID/DESCRIPTION", "PositionParentHierarchy/PositionDependency/DEPENDENTPOSITION/POSITIONID/DESCRIPTION", "PositionParentHierarchy/PrimarySystemDependency/NONDEPENDENTPOSITION/POSITIONID/DESCRIPTION", "PositionParentHierarchy/SystemDependency/NONDEPENDENTPOSITION/POSITIONID/DESCRIPTION", "PositionParentHierarchy/LocationDependency/NONDEPENDENTPOSITION/POSITIONID/DESCRIPTION", "PositionParentHierarchy/NonDependentParents/NONDEPENDENTPOSITION/POSITIONID/DESCRIPTION"}, readOnly=true)
    private String hierarchyPositionDesc;
    @Transient
    @EAMField(xpath={"AssetParentHierarchy/AssetDependency/NONDEPENDENTPOSITION/POSITIONID/ORGANIZATIONID/ORGANIZATIONCODE", "AssetParentHierarchy/PositionDependency/DEPENDENTPOSITION/POSITIONID/ORGANIZATIONID/ORGANIZATIONCODE", "AssetParentHierarchy/PrimarySystemDependency/NONDEPENDENTPOSITION/POSITIONID/ORGANIZATIONID/ORGANIZATIONCODE", "AssetParentHierarchy/SystemDependency/NONDEPENDENTPOSITION/POSITIONID/ORGANIZATIONID/ORGANIZATIONCODE", "AssetParentHierarchy/LocationDependency/NONDEPENDENTPOSITION/POSITIONID/ORGANIZATIONID/ORGANIZATIONCODE", "AssetParentHierarchy/NonDependentParents/NONDEPENDENTPOSITION/POSITIONID/ORGANIZATIONID/ORGANIZATIONCODE", "PositionParentHierarchy/AssetDependency/NONDEPENDENTPOSITION/POSITIONID/ORGANIZATIONID/ORGANIZATIONCODE", "PositionParentHierarchy/PositionDependency/DEPENDENTPOSITION/POSITIONID/ORGANIZATIONID/ORGANIZATIONCODE", "PositionParentHierarchy/PrimarySystemDependency/NONDEPENDENTPOSITION/POSITIONID/ORGANIZATIONID/ORGANIZATIONCODE", "PositionParentHierarchy/SystemDependency/NONDEPENDENTPOSITION/POSITIONID/ORGANIZATIONID/ORGANIZATIONCODE", "PositionParentHierarchy/LocationDependency/NONDEPENDENTPOSITION/POSITIONID/ORGANIZATIONID/ORGANIZATIONCODE", "PositionParentHierarchy/NonDependentParents/NONDEPENDENTPOSITION/POSITIONID/ORGANIZATIONID/ORGANIZATIONCODE"}, readOnly=true)
    private String hierarchyPositionOrg;
    @Transient
    private Boolean hierarchyPositionDependent;
    @Transient
    @EAMField(xpath={"AssetParentHierarchy/AssetDependency/NONDEPENDENTPOSITION/COSTROLLUP", "AssetParentHierarchy/PositionDependency/DEPENDENTPOSITION/COSTROLLUP", "AssetParentHierarchy/PrimarySystemDependency/NONDEPENDENTPOSITION/COSTROLLUP", "AssetParentHierarchy/SystemDependency/NONDEPENDENTPOSITION/COSTROLLUP", "AssetParentHierarchy/LocationDependency/NONDEPENDENTPOSITION/COSTROLLUP", "AssetParentHierarchy/NonDependentParents/NONDEPENDENTPOSITION/COSTROLLUP", "PositionParentHierarchy/AssetDependency/NONDEPENDENTPOSITION/COSTROLLUP", "PositionParentHierarchy/PositionDependency/DEPENDENTPOSITION/COSTROLLUP", "PositionParentHierarchy/PrimarySystemDependency/NONDEPENDENTPOSITION/COSTROLLUP", "PositionParentHierarchy/SystemDependency/NONDEPENDENTPOSITION/COSTROLLUP", "PositionParentHierarchy/LocationDependency/NONDEPENDENTPOSITION/COSTROLLUP", "PositionParentHierarchy/NonDependentParents/NONDEPENDENTPOSITION/COSTROLLUP"}, readOnly=true)
    private Boolean hierarchyPositionCostRollUp;
    @Transient
    @EAMField(xpath={"AssetParentHierarchy/AssetDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/EQUIPMENTCODE", "AssetParentHierarchy/PositionDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/EQUIPMENTCODE", "AssetParentHierarchy/PrimarySystemDependency/DEPENDENTPRIMARYSYSTEM/SYSTEMID/EQUIPMENTCODE", "AssetParentHierarchy/SystemDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/EQUIPMENTCODE", "AssetParentHierarchy/LocationDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/EQUIPMENTCODE", "AssetParentHierarchy/NonDependentParents/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/EQUIPMENTCODE", "PositionParentHierarchy/AssetDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/EQUIPMENTCODE", "PositionParentHierarchy/PositionDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/EQUIPMENTCODE", "PositionParentHierarchy/PrimarySystemDependency/DEPENDENTPRIMARYSYSTEM/SYSTEMID/EQUIPMENTCODE", "PositionParentHierarchy/SystemDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/EQUIPMENTCODE", "PositionParentHierarchy/LocationDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/EQUIPMENTCODE", "PositionParentHierarchy/NonDependentParents/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/EQUIPMENTCODE", "SystemParentHierarchy/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/EQUIPMENTCODE", "SystemParentHierarchy/DEPENDENTPRIMARYSYSTEM/SYSTEMID/EQUIPMENTCODE"}, readOnly=true)
    private String hierarchyPrimarySystemCode;
    @Transient
    @EAMField(xpath={"AssetParentHierarchy/AssetDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/DESCRIPTION", "AssetParentHierarchy/PositionDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/DESCRIPTION", "AssetParentHierarchy/PrimarySystemDependency/DEPENDENTPRIMARYSYSTEM/SYSTEMID/DESCRIPTION", "AssetParentHierarchy/SystemDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/DESCRIPTION", "AssetParentHierarchy/LocationDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/DESCRIPTION", "AssetParentHierarchy/NonDependentParents/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/DESCRIPTION", "PositionParentHierarchy/AssetDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/DESCRIPTION", "PositionParentHierarchy/PositionDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/DESCRIPTION", "PositionParentHierarchy/PrimarySystemDependency/DEPENDENTPRIMARYSYSTEM/SYSTEMID/DESCRIPTION", "PositionParentHierarchy/SystemDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/DESCRIPTION", "PositionParentHierarchy/LocationDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/DESCRIPTION", "PositionParentHierarchy/NonDependentParents/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/DESCRIPTION", "SystemParentHierarchy/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/DESCRIPTION", "SystemParentHierarchy/DEPENDENTPRIMARYSYSTEM/SYSTEMID/DESCRIPTION"}, readOnly=true)
    private String hierarchyPrimarySystemDesc;
    @Transient
    @EAMField(xpath={"AssetParentHierarchy/AssetDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/ORGANIZATIONID/ORGANIZATIONCODE", "AssetParentHierarchy/PositionDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/ORGANIZATIONID/ORGANIZATIONCODE", "AssetParentHierarchy/PrimarySystemDependency/DEPENDENTPRIMARYSYSTEM/SYSTEMID/ORGANIZATIONID/ORGANIZATIONCODE", "AssetParentHierarchy/SystemDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/ORGANIZATIONID/ORGANIZATIONCODE", "AssetParentHierarchy/LocationDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/ORGANIZATIONID/ORGANIZATIONCODE", "AssetParentHierarchy/NonDependentParents/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/ORGANIZATIONID/ORGANIZATIONCODE", "PositionParentHierarchy/AssetDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/ORGANIZATIONID/ORGANIZATIONCODE", "PositionParentHierarchy/PositionDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/ORGANIZATIONID/ORGANIZATIONCODE", "PositionParentHierarchy/PrimarySystemDependency/DEPENDENTPRIMARYSYSTEM/SYSTEMID/ORGANIZATIONID/ORGANIZATIONCODE", "PositionParentHierarchy/SystemDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/ORGANIZATIONID/ORGANIZATIONCODE", "PositionParentHierarchy/LocationDependency/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/ORGANIZATIONID/ORGANIZATIONCODE", "PositionParentHierarchy/NonDependentParents/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/ORGANIZATIONID/ORGANIZATIONCODE", "SystemParentHierarchy/NONDEPENDENTPRIMARYSYSTEM/SYSTEMID/ORGANIZATIONID/ORGANIZATIONCODE", "SystemParentHierarchy/DEPENDENTPRIMARYSYSTEM/SYSTEMID/ORGANIZATIONID/ORGANIZATIONCODE"}, readOnly=true)
    private String hierarchyPrimarySystemOrg;
    @Transient
    private Boolean hierarchyPrimarySystemDependent;
    @Transient
    @EAMField(xpath={"AssetParentHierarchy/AssetDependency/NONDEPENDENTPRIMARYSYSTEM/COSTROLLUP", "AssetParentHierarchy/PositionDependency/NONDEPENDENTPRIMARYSYSTEM/COSTROLLUP", "AssetParentHierarchy/PrimarySystemDependency/DEPENDENTPRIMARYSYSTEM/COSTROLLUP", "AssetParentHierarchy/SystemDependency/NONDEPENDENTPRIMARYSYSTEM/COSTROLLUP", "AssetParentHierarchy/LocationDependency/NONDEPENDENTPRIMARYSYSTEM/COSTROLLUP", "AssetParentHierarchy/NonDependentParents/NONDEPENDENTPRIMARYSYSTEM/COSTROLLUP", "PositionParentHierarchy/AssetDependency/NONDEPENDENTPRIMARYSYSTEM/COSTROLLUP", "PositionParentHierarchy/PositionDependency/NONDEPENDENTPRIMARYSYSTEM/COSTROLLUP", "PositionParentHierarchy/PrimarySystemDependency/DEPENDENTPRIMARYSYSTEM/COSTROLLUP", "PositionParentHierarchy/SystemDependency/NONDEPENDENTPRIMARYSYSTEM/COSTROLLUP", "PositionParentHierarchy/LocationDependency/NONDEPENDENTPRIMARYSYSTEM/COSTROLLUP", "PositionParentHierarchy/NonDependentParents/NONDEPENDENTPRIMARYSYSTEM/COSTROLLUP", "SystemParentHierarchy/NONDEPENDENTPRIMARYSYSTEM/COSTROLLUP", "SystemParentHierarchy/DEPENDENTPRIMARYSYSTEM/COSTROLLUP"}, readOnly=true)
    private Boolean hierarchyPrimarySystemCostRollUp;
    @Transient
    private String hierarchySystemCode;
    @Transient
    private String hierarchySystemDesc;
    @Transient
    private Boolean hierarchySystemDependent;
    @Transient
    private Boolean hierarchySystemCostRollUp;
    @Transient
    private String hierarchyLocationCode;
    @Transient
    private String hierarchyLocationDesc;
    @Transient
    @EAMField(xpath={"PartAssociation/PARTID/PARTCODE"}, enforceValidXpath=false, nullifyParentLevel=0)
    private String partCode;
    @Transient
    @EAMField(xpath={"PartAssociation/PARTID/DESCRIPTION"}, enforceValidXpath=false, readOnly=true)
    private String partDesc;
    @Transient
    @EAMField(xpath={"PartAssociation/STORELOCATION/STOREID/STORECODE"}, enforceValidXpath=false, nullifyParentLevel=0)
    private String storeCode;
    @Transient
    @EAMField(xpath={"PartAssociation/STORELOCATION/STOREID/DESCRIPTION"}, enforceValidXpath=false, readOnly=true)
    private String storeDesc;
    @Transient
    @EAMField(xpath={"PartAssociation/STORELOCATION/BIN"}, enforceValidXpath=false, nullifyParentLevel=0)
    private String bin;
    @Transient
    private String binDesc;
    @Transient
    @EAMField(xpath={"PartAssociation/STORELOCATION/LOT"}, enforceValidXpath=false, nullifyParentLevel=0)
    private String lot;
    @Transient
    @EAMField(xpath={"LINEARREFERENCEDETAILS/LINEARREFPRECISION"}, nullifyParentLevel=0)
    private String linearRefPrecision;
    @Transient
    @EAMField(xpath={"LINEARREFERENCEDETAILS/LINEARREFUOM"}, nullifyParentLevel=0)
    private String linearRefUOM;
    @Transient
    @EAMField(xpath={"LINEARREFERENCEDETAILS/EQUIPMENTLENGTH"}, nullifyParentLevel=0)
    private BigDecimal linearRefEquipmentLength;
    @Transient
    @EAMField(xpath={"LINEARREFERENCEDETAILS/EQUIPMENTLENGTHUOM"}, nullifyParentLevel=0)
    private String linearRefEquipmentLengthUOM;
    @Transient
    @EAMField(xpath={"LINEARREFERENCEDETAILS/GEOGRAPHICALREFERENCE"}, nullifyParentLevel=0)
    private String linearRefGeographicalRef;
    @Transient
    @EAMField(xpath={"Variables/VARIABLE1"}, nullifyParentLevel=0)
    private String variable1;
    @Transient
    @EAMField(xpath={"Variables/VARIABLE2"}, nullifyParentLevel=0)
    private String variable2;
    @Transient
    @EAMField(xpath={"Variables/VARIABLE3"}, nullifyParentLevel=0)
    private String variable3;
    @Transient
    @EAMField(xpath={"Variables/VARIABLE4"}, nullifyParentLevel=0)
    private String variable4;
    @Transient
    @EAMField(xpath={"Variables/VARIABLE5"}, nullifyParentLevel=0)
    private String variable5;
    @Transient
    @EAMField(xpath={"Variables/VARIABLE6"}, nullifyParentLevel=0)
    private String variable6;
    @Transient
    @EAMField(xpath={"DORMANT/DORMANTSTART"})
    private Date dormantStart;
    @Transient
    @EAMField(xpath={"DORMANT/DORMANTEND"})
    private Date dormantEnd;
    @Transient
    @EAMField(xpath={"DORMANT/DORMANTREUSE"})
    private String dormantReusePeriod;
    @Transient
    @EAMField(xpath={"UserDefinedFields"})
    private UserDefinedFields userDefinedFields;
    @Transient
    @EAMField(xpath={"SAFETY"})
    private String safety;
    @Transient
    @EAMField(xpath={"ORIGINALINSTALLDATE"})
    private Date originalInstallDate;
    @Transient
    @EAMField(xpath={"XLOCATION"})
    private BigDecimal xLocation;
    @Transient
    @EAMField(xpath={"YLOCATION"})
    private BigDecimal yLocation;
    @Transient
    private String lastLocationCode;
    @Transient
    private String lastLocationDesc;
    @Transient
    private String cernMachine;
    @Transient
    private Integer cernCao;
    @Transient
    private Double cernX;
    @Transient
    private Double cernY;
    @Transient
    private Double cernZ;
    @Transient
    private String cernPos;
    @Transient
    private String cernFonc;
    @Transient
    private String copyFrom;
    @Transient
    private HashMap<String, ArrayList<UDLValue>> userDefinedList;
    @Transient
    @EAMField(xpath={"FleetVehicleInfo/ISVEHICLE"}, nullifyParentLevel=0)
    private Boolean vehicle;
    @Transient
    @EAMField(xpath={"FleetVehicleInfo/ISRENTAL"}, nullifyParentLevel=0)
    private Boolean rental;
    @Transient
    @EAMField(xpath={"FleetVehicleInfo/VEHICLETYPE/TYPECODE"}, nullifyParentLevel=1)
    private String vehicleTypeCode;
    @Transient
    @EAMField(xpath={"FleetVehicleInfo/AVAILABILITYSTATUS/STATUSCODE"}, nullifyParentLevel=1)
    private String availabilityStatus;
    @Transient
    @EAMField(xpath={"FleetVehicleInfo/ISSUETO/PERSONCODE"}, nullifyParentLevel=1)
    private String issueTo;
    @Transient
    @EAMField(xpath={"CHECKLISTFILTER"})
    private String equipmentFilter;
    @EAMField(xpath={"WORKSPACEID/WORKSPACENUMBER"})
    private String workspaceNo;
    @EAMField(xpath={"FUELID/FUELCODE"})
    private String primaryFuel;

    public String getSystemStatusCode() {
        return this.systemStatusCode;
    }

    public void setSystemStatusCode(String systemStatusCode) {
        this.systemStatusCode = systemStatusCode;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getClassCode() {
        return this.classCode;
    }

    public void setClassCode(String classCode) {
        this.classCode = classCode;
    }

    public String getClassDesc() {
        return this.classDesc;
    }

    public void setClassDesc(String classDesc) {
        this.classDesc = classDesc;
    }

    public BigInteger getUpdateCount() {
        return this.updateCount;
    }

    public void setUpdateCount(BigInteger updateCount) {
        this.updateCount = updateCount;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusDesc() {
        return this.statusDesc;
    }

    public void setStatusDesc(String statusDesc) {
        this.statusDesc = statusDesc;
    }

    public String getDepartmentCode() {
        return this.departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }

    public String getDepartmentDesc() {
        return this.departmentDesc;
    }

    public void setDepartmentDesc(String departmentDesc) {
        this.departmentDesc = departmentDesc;
    }

    @JsonProperty(value="customField")
    @XmlElementWrapper(name="customFields")
    @XmlElement(name="customField")
    public CustomField[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
    }

    public String getCategoryCode() {
        return this.categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public String getCategoryDesc() {
        return this.categoryDesc;
    }

    public void setCategoryDesc(String categoryDesc) {
        this.categoryDesc = categoryDesc;
    }

    public String getCostCode() {
        return this.costCode;
    }

    public void setCostCode(String costCode) {
        this.costCode = costCode;
    }

    public String getCostCodeDesc() {
        return this.costCodeDesc;
    }

    public void setCostCodeDesc(String costCodeDesc) {
        this.costCodeDesc = costCodeDesc;
    }

    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getComissionDate() {
        return this.comissionDate;
    }

    public void setComissionDate(Date comissionDate) {
        this.comissionDate = comissionDate;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getEquipmentValue() {
        return this.equipmentValue;
    }

    public void setEquipmentValue(BigDecimal equipmentValue) {
        this.equipmentValue = equipmentValue;
    }

    public String getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(String assignedTo) {
        this.assignedTo = assignedTo;
    }

    public String getMeterUnit() {
        return this.meterUnit;
    }

    public void setMeterUnit(String meterUnit) {
        this.meterUnit = meterUnit;
    }

    public String getCriticality() {
        return this.criticality;
    }

    public void setCriticality(String criticality) {
        this.criticality = criticality;
    }

    public String getManufacturerCode() {
        return this.manufacturerCode;
    }

    public void setManufacturerCode(String manufacturerCode) {
        this.manufacturerCode = manufacturerCode;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getxCoordinate() {
        return this.xCoordinate;
    }

    public void setxCoordinate(BigDecimal xCoordinate) {
        this.xCoordinate = xCoordinate;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getyCoordinate() {
        return this.yCoordinate;
    }

    public void setyCoordinate(BigDecimal yCoordinate) {
        this.yCoordinate = yCoordinate;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getzCoordinate() {
        return this.zCoordinate;
    }

    public void setzCoordinate(BigDecimal zCoordinate) {
        this.zCoordinate = zCoordinate;
    }

    public String getPartCode() {
        return this.partCode;
    }

    public void setPartCode(String partCode) {
        this.partCode = partCode;
    }

    public UserDefinedFields getUserDefinedFields() {
        return this.userDefinedFields;
    }

    public void setUserDefinedFields(UserDefinedFields userDefinedFields) {
        this.userDefinedFields = userDefinedFields;
    }

    public String getHierarchyAssetCode() {
        return this.hierarchyAssetCode;
    }

    public void setHierarchyAssetCode(String hierarchyAssetCode) {
        this.hierarchyAssetCode = hierarchyAssetCode;
    }

    public String getHierarchyAssetDesc() {
        return this.hierarchyAssetDesc;
    }

    public void setHierarchyAssetDesc(String hierarchyAssetDesc) {
        this.hierarchyAssetDesc = hierarchyAssetDesc;
    }

    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    public Boolean getHierarchyAssetDependent() {
        return this.hierarchyAssetDependent;
    }

    public void setHierarchyAssetDependent(Boolean hierarchyAssetDependent) {
        this.hierarchyAssetDependent = hierarchyAssetDependent;
    }

    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    public Boolean getHierarchyAssetCostRollUp() {
        return this.hierarchyAssetCostRollUp;
    }

    public void setHierarchyAssetCostRollUp(Boolean hierarchyAssetCostRollUp) {
        this.hierarchyAssetCostRollUp = hierarchyAssetCostRollUp;
    }

    public String getHierarchyPositionCode() {
        return this.hierarchyPositionCode;
    }

    public void setHierarchyPositionCode(String hierarchyPositionCode) {
        this.hierarchyPositionCode = hierarchyPositionCode;
    }

    public String getHierarchyPositionDesc() {
        return this.hierarchyPositionDesc;
    }

    public void setHierarchyPositionDesc(String hierarchyPositionDesc) {
        this.hierarchyPositionDesc = hierarchyPositionDesc;
    }

    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    public Boolean getHierarchyPositionDependent() {
        return this.hierarchyPositionDependent;
    }

    public void setHierarchyPositionDependent(Boolean hierarchyPositionDependent) {
        this.hierarchyPositionDependent = hierarchyPositionDependent;
    }

    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    public Boolean getHierarchyPositionCostRollUp() {
        return this.hierarchyPositionCostRollUp;
    }

    public void setHierarchyPositionCostRollUp(Boolean hierarchyPositionCostRollUp) {
        this.hierarchyPositionCostRollUp = hierarchyPositionCostRollUp;
    }

    public String getHierarchyLocationCode() {
        return this.hierarchyLocationCode;
    }

    public void setHierarchyLocationCode(String hierarchyLocationCode) {
        this.hierarchyLocationCode = hierarchyLocationCode;
    }

    public String getHierarchyLocationDesc() {
        return this.hierarchyLocationDesc;
    }

    public void setHierarchyLocationDesc(String hierarchyLocationDesc) {
        this.hierarchyLocationDesc = hierarchyLocationDesc;
    }

    public String getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getSystemTypeCode() {
        return this.systemTypeCode;
    }

    public void setSystemTypeCode(String systemTypeCode) {
        this.systemTypeCode = systemTypeCode;
    }

    public String getTypeDesc() {
        return this.typeDesc;
    }

    public void setTypeDesc(String typeDesc) {
        this.typeDesc = typeDesc;
    }

    public String getPartDesc() {
        return this.partDesc;
    }

    public void setPartDesc(String partDesc) {
        this.partDesc = partDesc;
    }

    public String getStoreCode() {
        return this.storeCode;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public String getBin() {
        return this.bin;
    }

    public void setBin(String bin) {
        this.bin = bin;
    }

    public String getLot() {
        return this.lot;
    }

    public void setLot(String lot) {
        this.lot = lot;
    }

    public String getLinearRefPrecision() {
        return this.linearRefPrecision;
    }

    public void setLinearRefPrecision(String linearRefPrecision) {
        this.linearRefPrecision = linearRefPrecision;
    }

    public String getLinearRefUOM() {
        return this.linearRefUOM;
    }

    public void setLinearRefUOM(String linearRefUOM) {
        this.linearRefUOM = linearRefUOM;
    }

    public String getLinearRefGeographicalRef() {
        return this.linearRefGeographicalRef;
    }

    public void setLinearRefGeographicalRef(String linearRefGeographicalRef) {
        this.linearRefGeographicalRef = linearRefGeographicalRef;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getLinearRefEquipmentLength() {
        return this.linearRefEquipmentLength;
    }

    public void setLinearRefEquipmentLength(BigDecimal linearRefEquipmentLength) {
        this.linearRefEquipmentLength = linearRefEquipmentLength;
    }

    public String getLinearRefEquipmentLengthUOM() {
        return this.linearRefEquipmentLengthUOM;
    }

    public void setLinearRefEquipmentLengthUOM(String linearRefEquipmentLengthUOM) {
        this.linearRefEquipmentLengthUOM = linearRefEquipmentLengthUOM;
    }

    public String getVariable1() {
        return this.variable1;
    }

    public void setVariable1(String variable1) {
        this.variable1 = variable1;
    }

    public String getVariable2() {
        return this.variable2;
    }

    public void setVariable2(String variable2) {
        this.variable2 = variable2;
    }

    public String getVariable3() {
        return this.variable3;
    }

    public void setVariable3(String variable3) {
        this.variable3 = variable3;
    }

    public String getVariable4() {
        return this.variable4;
    }

    public void setVariable4(String variable4) {
        this.variable4 = variable4;
    }

    public String getVariable5() {
        return this.variable5;
    }

    public void setVariable5(String variable5) {
        this.variable5 = variable5;
    }

    public String getVariable6() {
        return this.variable6;
    }

    public void setVariable6(String variable6) {
        this.variable6 = variable6;
    }

    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getDormantStart() {
        return this.dormantStart;
    }

    public void setDormantStart(Date dormantStart) {
        this.dormantStart = dormantStart;
    }

    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getDormantEnd() {
        return this.dormantEnd;
    }

    public void setDormantEnd(Date dormantEnd) {
        this.dormantEnd = dormantEnd;
    }

    public String getDormantReusePeriod() {
        return this.dormantReusePeriod;
    }

    public void setDormantReusePeriod(String dormantReusePeriod) {
        this.dormantReusePeriod = dormantReusePeriod;
    }

    public String getcGMP() {
        return this.cGMP;
    }

    public void setcGMP(String cGMP) {
        this.cGMP = cGMP;
    }

    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    public Boolean getOutOfService() {
        return this.outOfService;
    }

    public void setOutOfService(Boolean outOfService) {
        this.outOfService = outOfService;
    }

    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    public Boolean getInProduction() {
        return this.inProduction;
    }

    public void setInProduction(Boolean inProduction) {
        this.inProduction = inProduction;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getCostOfNeededRepairs() {
        return this.costOfNeededRepairs;
    }

    public void setCostOfNeededRepairs(BigDecimal costOfNeededRepairs) {
        this.costOfNeededRepairs = costOfNeededRepairs;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getReplacementValue() {
        return this.replacementValue;
    }

    public void setReplacementValue(BigDecimal replacementValue) {
        this.replacementValue = replacementValue;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getFacilityConditionIndex() {
        return this.facilityConditionIndex;
    }

    public void setFacilityConditionIndex(BigDecimal facilityConditionIndex) {
        this.facilityConditionIndex = facilityConditionIndex;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getYearBuilt() {
        return this.yearBuilt;
    }

    public void setYearBuilt(BigDecimal yearBuilt) {
        this.yearBuilt = yearBuilt;
    }

    @XmlJavaTypeAdapter(value=BigDecimalAdapter.class)
    public BigDecimal getServiceLifetime() {
        return this.serviceLifetime;
    }

    public void setServiceLifetime(BigDecimal serviceLifetime) {
        this.serviceLifetime = serviceLifetime;
    }

    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getOriginalReceiptDate() {
        return this.originalReceiptDate;
    }

    public void setOriginalReceiptDate(Date originalReceiptDate) {
        this.originalReceiptDate = originalReceiptDate;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getSafety() {
        return this.safety;
    }

    public void setSafety(String safety) {
        this.safety = safety;
    }

    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getOriginalInstallDate() {
        return this.originalInstallDate;
    }

    public void setOriginalInstallDate(Date originalInstallDate) {
        this.originalInstallDate = originalInstallDate;
    }

    public String getAssignedToDesc() {
        return this.assignedToDesc;
    }

    public void setAssignedToDesc(String assignedToDesc) {
        this.assignedToDesc = assignedToDesc;
    }

    public String getManufacturerDesc() {
        return this.manufacturerDesc;
    }

    public void setManufacturerDesc(String manufacturerDesc) {
        this.manufacturerDesc = manufacturerDesc;
    }

    public String getStoreDesc() {
        return this.storeDesc;
    }

    public void setStoreDesc(String storeDesc) {
        this.storeDesc = storeDesc;
    }

    public String getBinDesc() {
        return this.binDesc;
    }

    public void setBinDesc(String binDesc) {
        this.binDesc = binDesc;
    }

    public String getLastLocationCode() {
        return this.lastLocationCode;
    }

    public void setLastLocationCode(String lastLocationCode) {
        this.lastLocationCode = lastLocationCode;
    }

    public String getLastLocationDesc() {
        return this.lastLocationDesc;
    }

    public void setLastLocationDesc(String lastLocationDesc) {
        this.lastLocationDesc = lastLocationDesc;
    }

    public String getCernMachine() {
        return this.cernMachine;
    }

    public void setCernMachine(String cernMachine) {
        this.cernMachine = cernMachine;
    }

    public Integer getCernCao() {
        return this.cernCao;
    }

    public void setCernCao(Integer cernCao) {
        this.cernCao = cernCao;
    }

    public Double getCernX() {
        return this.cernX;
    }

    public void setCernX(Double cernX) {
        this.cernX = cernX;
    }

    public Double getCernY() {
        return this.cernY;
    }

    public void setCernY(Double cernY) {
        this.cernY = cernY;
    }

    public Double getCernZ() {
        return this.cernZ;
    }

    public void setCernZ(Double cernZ) {
        this.cernZ = cernZ;
    }

    public String getCernPos() {
        return this.cernPos;
    }

    public void setCernPos(String cernPos) {
        this.cernPos = cernPos;
    }

    public String getCernFonc() {
        return this.cernFonc;
    }

    public void setCernFonc(String cernFonc) {
        this.cernFonc = cernFonc;
    }

    public String getHierarchyPrimarySystemCode() {
        return this.hierarchyPrimarySystemCode;
    }

    public void setHierarchyPrimarySystemCode(String hierarchyPrimarySystemCode) {
        this.hierarchyPrimarySystemCode = hierarchyPrimarySystemCode;
    }

    public String getHierarchyPrimarySystemDesc() {
        return this.hierarchyPrimarySystemDesc;
    }

    public void setHierarchyPrimarySystemDesc(String hierarchyPrimarySystemDesc) {
        this.hierarchyPrimarySystemDesc = hierarchyPrimarySystemDesc;
    }

    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    public Boolean getHierarchyPrimarySystemDependent() {
        return this.hierarchyPrimarySystemDependent;
    }

    public void setHierarchyPrimarySystemDependent(Boolean hierarchyPrimarySystemDependent) {
        this.hierarchyPrimarySystemDependent = hierarchyPrimarySystemDependent;
    }

    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    public Boolean getHierarchyPrimarySystemCostRollUp() {
        return this.hierarchyPrimarySystemCostRollUp;
    }

    public void setHierarchyPrimarySystemCostRollUp(Boolean hierarchyPrimarySystemCostRollUp) {
        this.hierarchyPrimarySystemCostRollUp = hierarchyPrimarySystemCostRollUp;
    }

    public BigDecimal getxLocation() {
        return this.xLocation;
    }

    public void setxLocation(BigDecimal xLocation) {
        this.xLocation = xLocation;
    }

    public BigDecimal getyLocation() {
        return this.yLocation;
    }

    public void setyLocation(BigDecimal yLocation) {
        this.yLocation = yLocation;
    }

    public String getStateCode() {
        return this.stateCode;
    }

    public void setStateCode(String stateCode) {
        this.stateCode = stateCode;
    }

    public String getStateDesc() {
        return this.stateDesc;
    }

    public void setStateDesc(String stateDesc) {
        this.stateDesc = stateDesc;
    }

    public String getProfileCode() {
        return this.profileCode;
    }

    public void setProfileCode(String profileCode) {
        this.profileCode = profileCode;
    }

    public String getHierarchySystemCode() {
        return this.hierarchySystemCode;
    }

    public void setHierarchySystemCode(String hierarchySystemCode) {
        this.hierarchySystemCode = hierarchySystemCode;
    }

    public String getHierarchySystemDesc() {
        return this.hierarchySystemDesc;
    }

    public void setHierarchySystemDesc(String hierarchySystemDesc) {
        this.hierarchySystemDesc = hierarchySystemDesc;
    }

    public Boolean getHierarchySystemDependent() {
        return this.hierarchySystemDependent;
    }

    public void setHierarchySystemDependent(Boolean hierarchySystemDependent) {
        this.hierarchySystemDependent = hierarchySystemDependent;
    }

    public Boolean getHierarchySystemCostRollUp() {
        return this.hierarchySystemCostRollUp;
    }

    public void setHierarchySystemCostRollUp(Boolean hierarchySystemCostRollUp) {
        this.hierarchySystemCostRollUp = hierarchySystemCostRollUp;
    }

    @Override
    public String getCopyFrom() {
        return this.copyFrom;
    }

    public void setCopyFrom(String copyFrom) {
        this.copyFrom = copyFrom;
    }

    @Override
    public HashMap<String, ArrayList<UDLValue>> getUserDefinedList() {
        return this.userDefinedList;
    }

    @Override
    public void setUserDefinedList(HashMap<String, ArrayList<UDLValue>> userDefinedList) {
        this.userDefinedList = userDefinedList;
    }

    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    public Boolean getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(Boolean vehicle) {
        this.vehicle = vehicle;
    }

    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    public Boolean getRental() {
        return this.rental;
    }

    public void setRental(Boolean rental) {
        this.rental = rental;
    }

    public String getVehicleTypeCode() {
        return this.vehicleTypeCode;
    }

    public void setVehicleTypeCode(String vehicleTypeCode) {
        this.vehicleTypeCode = vehicleTypeCode;
    }

    public String getHierarchyAssetOrg() {
        return this.hierarchyAssetOrg;
    }

    public void setHierarchyAssetOrg(String hierarchyAssetOrg) {
        this.hierarchyAssetOrg = hierarchyAssetOrg;
    }

    public String getHierarchyPositionOrg() {
        return this.hierarchyPositionOrg;
    }

    public void setHierarchyPositionOrg(String hierarchyPositionOrg) {
        this.hierarchyPositionOrg = hierarchyPositionOrg;
    }

    public String getHierarchyPrimarySystemOrg() {
        return this.hierarchyPrimarySystemOrg;
    }

    public void setHierarchyPrimarySystemOrg(String hierarchyPrimarySystemOrg) {
        this.hierarchyPrimarySystemOrg = hierarchyPrimarySystemOrg;
    }

    public String getAvailabilityStatus() {
        return this.availabilityStatus;
    }

    public void setAvailabilityStatus(String availabilityStatus) {
        this.availabilityStatus = availabilityStatus;
    }

    public String getIssueTo() {
        return this.issueTo;
    }

    public void setIssueTo(String issueTo) {
        this.issueTo = issueTo;
    }

    public String getEquipmentFilter() {
        return this.equipmentFilter;
    }

    public void setEquipmentFilter(String equipmentFilter) {
        this.equipmentFilter = equipmentFilter;
    }

    public String getWorkspaceNo() {
        return this.workspaceNo;
    }

    public void setWorkspaceNo(String workspaceNo) {
        this.workspaceNo = workspaceNo;
    }

    public String getPrimaryFuel() {
        return this.primaryFuel;
    }

    public void setPrimaryFuel(String primaryFuel) {
        this.primaryFuel = primaryFuel;
    }

    public String toString() {
        return "Equipment [" + (String)(this.description != null ? "description=" + this.description + ", " : "") + (String)(this.code != null ? "code=" + this.code + ", " : "") + (String)(this.typeCode != null ? "typeCode=" + this.typeCode + ", " : "") + (String)(this.alias != null ? "alias=" + this.alias + ", " : "") + (String)(this.typeDesc != null ? "typeDesc=" + this.typeDesc + ", " : "") + (String)(this.classCode != null ? "classCode=" + this.classCode + ", " : "") + (String)(this.classDesc != null ? "classDesc=" + this.classDesc + ", " : "") + (String)(this.categoryCode != null ? "categoryCode=" + this.categoryCode + ", " : "") + (String)(this.categoryDesc != null ? "categoryDesc=" + this.categoryDesc + ", " : "") + (String)(this.updateCount != null ? "updateCount=" + String.valueOf(this.updateCount) + ", " : "") + (String)(this.outOfService != null ? "outOfService=" + this.outOfService + ", " : "") + (String)(this.inProduction != null ? "inProduction=" + this.inProduction + ", " : "") + (String)(this.statusCode != null ? "statusCode=" + this.statusCode + ", " : "") + (String)(this.statusDesc != null ? "statusDesc=" + this.statusDesc + ", " : "") + (String)(this.costCode != null ? "costCode=" + this.costCode + ", " : "") + (String)(this.departmentCode != null ? "departmentCode=" + this.departmentCode + ", " : "") + (String)(this.departmentDesc != null ? "departmentDesc=" + this.departmentDesc + ", " : "") + (String)(this.customFields != null ? "customFields=" + Arrays.toString(this.customFields) + ", " : "") + (String)(this.comissionDate != null ? "comissionDate=" + String.valueOf(this.comissionDate) + ", " : "") + (String)(this.equipmentValue != null ? "equipmentValue=" + String.valueOf(this.equipmentValue) + ", " : "") + (String)(this.assignedTo != null ? "assignedTo=" + this.assignedTo + ", " : "") + (String)(this.assignedToDesc != null ? "assignedToDesc=" + this.assignedToDesc + ", " : "") + (String)(this.meterUnit != null ? "meterUnit=" + this.meterUnit + ", " : "") + (String)(this.criticality != null ? "criticality=" + this.criticality + ", " : "") + (String)(this.cGMP != null ? "cGMP=" + this.cGMP + ", " : "") + (String)(this.cGMP != null ? "cGMP=" + this.cGMP + ", " : "") + (String)(this.originalReceiptDate != null ? "originalReceiptDate=" + String.valueOf(this.originalReceiptDate) + ", " : "") + (String)(this.manufacturerCode != null ? "manufacturerCode=" + this.manufacturerCode + ", " : "") + (String)(this.manufacturerDesc != null ? "manufacturerDesc=" + this.manufacturerDesc + ", " : "") + (String)(this.serialNumber != null ? "serialNumber=" + this.serialNumber + ", " : "") + (String)(this.model != null ? "model=" + this.model + ", " : "") + (String)(this.revision != null ? "revision=" + this.revision + ", " : "") + (String)(this.xCoordinate != null ? "xCoordinate=" + String.valueOf(this.xCoordinate) + ", " : "") + (String)(this.yCoordinate != null ? "yCoordinate=" + String.valueOf(this.yCoordinate) + ", " : "") + (String)(this.zCoordinate != null ? "zCoordinate=" + String.valueOf(this.zCoordinate) + ", " : "") + (String)(this.costOfNeededRepairs != null ? "costOfNeededRepairs=" + String.valueOf(this.costOfNeededRepairs) + ", " : "") + (String)(this.replacementValue != null ? "replacementValue=" + String.valueOf(this.replacementValue) + ", " : "") + (String)(this.facilityConditionIndex != null ? "facilityConditionIndex=" + String.valueOf(this.facilityConditionIndex) + ", " : "") + (String)(this.yearBuilt != null ? "yearBuilt=" + String.valueOf(this.yearBuilt) + ", " : "") + (String)(this.serviceLifetime != null ? "serviceLifetime=" + String.valueOf(this.serviceLifetime) + ", " : "") + (String)(this.hierarchyAssetCode != null ? "hierarchyAssetCode=" + this.hierarchyAssetCode + ", " : "") + (String)(this.hierarchyAssetDesc != null ? "hierarchyAssetDesc=" + this.hierarchyAssetDesc + ", " : "") + (String)(this.hierarchyAssetDependent != null ? "hierarchyAssetDependent=" + this.hierarchyAssetDependent + ", " : "") + (String)(this.hierarchyAssetCostRollUp != null ? "hierarchyAssetCostRollUp=" + this.hierarchyAssetCostRollUp + ", " : "") + (String)(this.hierarchyPositionCode != null ? "hierarchyPositionCode=" + this.hierarchyPositionCode + ", " : "") + (String)(this.hierarchyPositionDesc != null ? "hierarchyPositionDesc=" + this.hierarchyPositionDesc + ", " : "") + (String)(this.hierarchyPositionDependent != null ? "hierarchyPositionDependent=" + this.hierarchyPositionDependent + ", " : "") + (String)(this.hierarchyPositionCostRollUp != null ? "hierarchyPositionCostRollUp=" + this.hierarchyPositionCostRollUp + ", " : "") + (String)(this.hierarchyPrimarySystemCode != null ? "hierarchyPrimarySystemCode=" + this.hierarchyPrimarySystemCode + ", " : "") + (String)(this.hierarchyPrimarySystemDesc != null ? "hierarchyPrimarySystemDesc=" + this.hierarchyPrimarySystemDesc + ", " : "") + (String)(this.hierarchyPrimarySystemDependent != null ? "hierarchyPrimarySystemDependent=" + this.hierarchyPrimarySystemDependent + ", " : "") + (String)(this.hierarchyPrimarySystemCostRollUp != null ? "hierarchyPrimarySystemCostRollUp=" + this.hierarchyPrimarySystemCostRollUp + ", " : "") + (String)(this.hierarchyLocationCode != null ? "hierarchyLocationCode=" + this.hierarchyLocationCode + ", " : "") + (String)(this.hierarchyLocationDesc != null ? "hierarchyLocationDesc=" + this.hierarchyLocationDesc + ", " : "") + (String)(this.partCode != null ? "partCode=" + this.partCode + ", " : "") + (String)(this.partDesc != null ? "partDesc=" + this.partDesc + ", " : "") + (String)(this.storeCode != null ? "storeCode=" + this.storeCode + ", " : "") + (String)(this.storeDesc != null ? "storeDesc=" + this.storeDesc + ", " : "") + (String)(this.bin != null ? "bin=" + this.bin + ", " : "") + (String)(this.binDesc != null ? "binDesc=" + this.binDesc + ", " : "") + (String)(this.lot != null ? "lot=" + this.lot + ", " : "") + (String)(this.linearRefPrecision != null ? "linearRefPrecision=" + this.linearRefPrecision + ", " : "") + (String)(this.linearRefUOM != null ? "linearRefUOM=" + this.linearRefUOM + ", " : "") + (String)(this.linearRefEquipmentLength != null ? "linearRefEquipmentLength=" + String.valueOf(this.linearRefEquipmentLength) + ", " : "") + (String)(this.linearRefEquipmentLengthUOM != null ? "linearRefEquipmentLengthUOM=" + this.linearRefEquipmentLengthUOM + ", " : "") + (String)(this.linearRefGeographicalRef != null ? "linearRefGeographicalRef=" + this.linearRefGeographicalRef + ", " : "") + (String)(this.variable1 != null ? "variable1=" + this.variable1 + ", " : "") + (String)(this.variable2 != null ? "variable2=" + this.variable2 + ", " : "") + (String)(this.variable3 != null ? "variable3=" + this.variable3 + ", " : "") + (String)(this.variable4 != null ? "variable4=" + this.variable4 + ", " : "") + (String)(this.variable5 != null ? "variable5=" + this.variable5 + ", " : "") + (String)(this.variable6 != null ? "variable6=" + this.variable6 + ", " : "") + (String)(this.dormantStart != null ? "dormantStart=" + String.valueOf(this.dormantStart) + ", " : "") + (String)(this.dormantEnd != null ? "dormantEnd=" + String.valueOf(this.dormantEnd) + ", " : "") + (String)(this.dormantReusePeriod != null ? "dormantReusePeriod=" + this.dormantReusePeriod + ", " : "") + (String)(this.userDefinedFields != null ? "userDefinedFields=" + String.valueOf(this.userDefinedFields) + ", " : "") + (String)(this.safety != null ? "safety=" + this.safety + ", " : "") + (String)(this.originalInstallDate != null ? "originalInstallDate=" + String.valueOf(this.originalInstallDate) + ", " : "") + (String)(this.lastLocationCode != null ? "lastLocationCode=" + this.lastLocationCode + ", " : "") + (String)(this.lastLocationDesc != null ? "lastLocationDesc=" + this.lastLocationDesc + ", " : "") + (String)(this.cernMachine != null ? "cernMachine=" + this.cernMachine + ", " : "") + (String)(this.cernCao != null ? "cernCao=" + this.cernCao + ", " : "") + (String)(this.cernX != null ? "cernX=" + this.cernX + ", " : "") + (String)(this.cernY != null ? "cernY=" + this.cernY + ", " : "") + (String)(this.cernZ != null ? "cernZ=" + this.cernZ + ", " : "") + (String)(this.cernPos != null ? "cernPos=" + this.cernPos + ", " : "") + (String)(this.cernFonc != null ? "cernFonc=" + this.cernFonc + ", " : "") + (String)(this.copyFrom != null ? "copyFrom=" + this.copyFrom + ", " : "") + (String)(this.userDefinedList != null ? "userDefinedList=" + String.valueOf(this.userDefinedList) : "") + "]";
    }
}

