/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.client.EAMContext;
import ch.cern.eam.wshub.core.services.equipment.AssetService;
import ch.cern.eam.wshub.core.services.equipment.entities.Equipment;
import ch.cern.eam.wshub.core.services.equipment.impl.EquipmentHierarchyTools;
import ch.cern.eam.wshub.core.services.userdefinedscreens.UserDefinedListService;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.EntityId;
import ch.cern.eam.wshub.core.services.userdefinedscreens.entities.UDLValue;
import ch.cern.eam.wshub.core.services.userdefinedscreens.impl.UserDefinedListServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.EAMException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import net.datastream.schemas.mp_entities.assetequipment_001.AssetEquipment;
import net.datastream.schemas.mp_entities.assetequipment_001.AssetParentHierarchy;
import net.datastream.schemas.mp_fields.ASSETPARENT_Type;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.LOCATIONPARENT_Type;
import net.datastream.schemas.mp_fields.POSITIONPARENT_Type;
import net.datastream.schemas.mp_fields.STORELOCATION;
import net.datastream.schemas.mp_fields.SYSTEMPARENT_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_functions.mp0301_001.MP0301_AddAssetEquipment_001;
import net.datastream.schemas.mp_functions.mp0302_001.MP0302_GetAssetEquipment_001;
import net.datastream.schemas.mp_functions.mp0303_001.MP0303_SyncAssetEquipment_001;
import net.datastream.schemas.mp_functions.mp0304_001.MP0304_DeleteAssetEquipment_001;
import net.datastream.schemas.mp_functions.mp0305_001.MP0305_GetAssetEquipmentDefault_001;
import net.datastream.schemas.mp_functions.mp0327_001.MP0327_GetAssetParentHierarchy_001;
import net.datastream.schemas.mp_results.mp0301_001.MP0301_AddAssetEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0302_001.MP0302_GetAssetEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0305_001.MP0305_GetAssetEquipmentDefault_001_Result;
import net.datastream.schemas.mp_results.mp0327_001.MP0327_GetAssetParentHierarchy_001_Result;
import net.datastream.wsdls.eamws.EAMWebServicesPT;

public class AssetServiceImpl
implements AssetService {
    private Tools tools;
    private EAMWebServicesPT eamws;
    private ApplicationData applicationData;
    private UserDefinedListService userDefinedListService;

    public AssetServiceImpl(ApplicationData applicationData, Tools tools, EAMWebServicesPT eamWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.eamws = eamWebServicesToolkitClient;
        this.userDefinedListService = new UserDefinedListServiceImpl(applicationData, tools, eamWebServicesToolkitClient);
    }

    @Override
    public Equipment readAssetDefault(EAMContext context, String organization) throws EAMException {
        MP0305_GetAssetEquipmentDefault_001 getAssetEquipmentDefault_001 = new MP0305_GetAssetEquipmentDefault_001();
        getAssetEquipmentDefault_001.setORGANIZATIONID(this.tools.getOrganization(context, organization));
        MP0305_GetAssetEquipmentDefault_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getAssetEquipmentDefaultOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getAssetEquipmentDefault_001);
        Equipment equipment = this.tools.getEAMFieldTools().transformEAMObject(new Equipment(), result.getResultData().getAssetEquipment(), context);
        equipment.setUserDefinedList(new HashMap<String, ArrayList<UDLValue>>());
        return equipment;
    }

    @Override
    public Equipment readAsset(EAMContext context, String assetCode, String organization) throws EAMException {
        AssetEquipment assetEquipment = this.readEAMAsset(context, assetCode, organization);
        Equipment asset = this.tools.getEAMFieldTools().transformEAMObject(new Equipment(), assetEquipment, context);
        asset.setSystemTypeCode("A");
        this.tools.processRunnables(() -> asset.setManufacturerDesc(this.tools.getFieldDescriptionsTools().readManufacturerDesc(context, asset.getManufacturerCode())), () -> asset.setBinDesc(this.tools.getFieldDescriptionsTools().readBinDesc(context, asset.getStoreCode(), asset.getBin())), () -> asset.setSystemStatusCode(this.tools.getFieldDescriptionsTools().readSystemCodeForUserCode(context, "OBST", asset.getStatusCode())), () -> this.userDefinedListService.readUDLToEntity(context, asset, new EntityId("OBJ", assetCode)));
        if (assetEquipment.getAssetParentHierarchy().getLOCATIONID() != null) {
            asset.setHierarchyLocationCode(assetEquipment.getAssetParentHierarchy().getLOCATIONID().getLOCATIONCODE());
            asset.setHierarchyLocationDesc(assetEquipment.getAssetParentHierarchy().getLOCATIONID().getDESCRIPTION());
        }
        asset.setHierarchyAssetDependent(assetEquipment.getAssetParentHierarchy().getAssetDependency() != null);
        asset.setHierarchyPositionDependent(assetEquipment.getAssetParentHierarchy().getPositionDependency() != null);
        asset.setHierarchyPrimarySystemDependent(assetEquipment.getAssetParentHierarchy().getPrimarySystemDependency() != null);
        return asset;
    }

    private AssetParentHierarchy readEAMAssetHierarchy(EAMContext context, String assetCode, String organization) throws EAMException {
        MP0327_GetAssetParentHierarchy_001 getassetph = new MP0327_GetAssetParentHierarchy_001();
        getassetph.setASSETID(new EQUIPMENTID_Type());
        getassetph.getASSETID().setORGANIZATIONID(this.tools.getOrganization(context, organization));
        getassetph.getASSETID().setEQUIPMENTCODE(assetCode);
        MP0327_GetAssetParentHierarchy_001_Result result = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getAssetParentHierarchyOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getassetph);
        return result.getResultData().getAssetParentHierarchy();
    }

    private AssetEquipment readEAMAsset(EAMContext context, String assetCode, String organization) throws EAMException {
        MP0302_GetAssetEquipment_001 getAsset = new MP0302_GetAssetEquipment_001();
        getAsset.setASSETID(new EQUIPMENTID_Type());
        getAsset.getASSETID().setORGANIZATIONID(this.tools.getOrganization(context, organization));
        getAsset.getASSETID().setEQUIPMENTCODE(assetCode);
        MP0302_GetAssetEquipment_001_Result getAssetResult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).getAssetEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), getAsset);
        getAssetResult.getResultData().getAssetEquipment().setAssetParentHierarchy(this.readEAMAssetHierarchy(context, assetCode, organization));
        return getAssetResult.getResultData().getAssetEquipment();
    }

    @Override
    public String updateAsset(EAMContext context, Equipment assetParam) throws EAMException {
        AssetEquipment assetEquipment = this.readEAMAsset(context, assetParam.getCode(), assetParam.getOrganization());
        assetEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getEAMCustomFields(context, DataTypeTools.toCodeString(assetEquipment.getCLASSID()), assetEquipment.getUSERDEFINEDAREA(), assetParam.getClassCode(), "OBJ"));
        this.initializeAssetObject(assetEquipment, assetParam, context);
        this.tools.getEAMFieldTools().transformWSHubObject(assetEquipment, assetParam, context);
        if (assetParam.getPartCode() != null) {
            if (assetParam.getPartCode().equals("") && assetEquipment.getPartAssociation() != null) {
                assetEquipment.getPartAssociation().setSTORELOCATION(null);
                assetEquipment.getPartAssociation().getPARTID().getORGANIZATIONID().setORGANIZATIONCODE("");
            } else if (!"".equals(assetParam.getPartCode())) {
                if (assetEquipment.getPartAssociation().getSTORELOCATION() == null) {
                    assetEquipment.getPartAssociation().setSTORELOCATION(new STORELOCATION());
                }
                if (assetEquipment.getPartAssociation().getSTORELOCATION().getLOT() == null) {
                    assetEquipment.getPartAssociation().getSTORELOCATION().setLOT("*");
                }
            }
        }
        MP0303_SyncAssetEquipment_001 syncAsset = new MP0303_SyncAssetEquipment_001();
        syncAsset.setAssetEquipment(assetEquipment);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).syncAssetEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), syncAsset);
        this.userDefinedListService.writeUDLToEntity(context, assetParam, new EntityId("OBJ", assetParam.getCode()));
        return assetParam.getCode();
    }

    @Override
    public String createAsset(EAMContext context, Equipment assetParam) throws EAMException {
        AssetEquipment assetEquipment = new AssetEquipment();
        assetEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getEAMCustomFields(context, DataTypeTools.toCodeString(assetEquipment.getCLASSID()), assetEquipment.getUSERDEFINEDAREA(), assetParam.getClassCode(), "OBJ"));
        this.initializeAssetObject(assetEquipment, assetParam, context);
        this.tools.getEAMFieldTools().transformWSHubObject(assetEquipment, assetParam, context);
        MP0301_AddAssetEquipment_001 addAsset = new MP0301_AddAssetEquipment_001();
        addAsset.setAssetEquipment(assetEquipment);
        MP0301_AddAssetEquipment_001_Result addAssetResult = this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).addAssetEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), addAsset);
        String equipmentCode = addAssetResult.getResultData().getASSETID().getEQUIPMENTCODE();
        this.userDefinedListService.writeUDLToEntityCopyFrom(context, assetParam, new EntityId("OBJ", equipmentCode));
        return equipmentCode;
    }

    @Override
    public String deleteAsset(EAMContext context, String assetCode, String organization) throws EAMException {
        MP0304_DeleteAssetEquipment_001 deleteAsset = new MP0304_DeleteAssetEquipment_001();
        deleteAsset.setASSETID(new EQUIPMENTID_Type());
        deleteAsset.getASSETID().setORGANIZATIONID(this.tools.getOrganization(context, organization));
        deleteAsset.getASSETID().setEQUIPMENTCODE(assetCode);
        this.tools.performEAMOperation(context, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((EAMWebServicesPT)this.eamws).deleteAssetEquipmentOp(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), deleteAsset);
        this.userDefinedListService.deleteUDLFromEntity(context, new EntityId("OBJ", assetCode));
        return assetCode;
    }

    private void initializeAssetObject(AssetEquipment assetEAM, Equipment assetParam, EAMContext context) throws EAMException {
        if (assetEAM.getASSETID() == null) {
            assetEAM.setASSETID(new EQUIPMENTID_Type());
            assetEAM.getASSETID().setORGANIZATIONID(this.tools.getOrganization(context, assetParam.getOrganization()));
            assetEAM.getASSETID().setEQUIPMENTCODE(assetParam.getCode().toUpperCase().trim());
        }
        if (assetParam.getDescription() != null) {
            assetEAM.getASSETID().setDESCRIPTION(assetParam.getDescription());
        }
        if (assetParam.getHierarchyAssetCode() != null || assetParam.getHierarchyPositionCode() != null || assetParam.getHierarchyPrimarySystemCode() != null || assetParam.getHierarchyLocationCode() != null) {
            try {
                this.initializeAssetHierarchy(assetEAM, assetParam, context);
            }
            catch (Exception e) {
                this.tools.log(Level.SEVERE, e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void initializeAssetHierarchy(AssetEquipment assetEAM, Equipment assetParam, EAMContext context) throws EAMException {
        AssetParentHierarchy hierarchy = new AssetParentHierarchy();
        hierarchy.setASSETID(new EQUIPMENTID_Type());
        hierarchy.getASSETID().setEQUIPMENTCODE(assetParam.getCode());
        hierarchy.getASSETID().setORGANIZATIONID(this.tools.getOrganization(context, assetParam.getOrganization()));
        hierarchy.setTYPE(new TYPE_Type());
        hierarchy.getTYPE().setTYPECODE("A");
        ASSETPARENT_Type assetParent = EquipmentHierarchyTools.readAssetParent(assetEAM.getAssetParentHierarchy());
        POSITIONPARENT_Type positionParent = EquipmentHierarchyTools.readPositionParent(assetEAM.getAssetParentHierarchy());
        SYSTEMPARENT_Type primarySystemParent = EquipmentHierarchyTools.readPrimarySystemParent(assetEAM.getAssetParentHierarchy());
        LOCATIONPARENT_Type locationParent = EquipmentHierarchyTools.readLocationParent(assetEAM.getAssetParentHierarchy());
        List<SYSTEMPARENT_Type> systemParents = EquipmentHierarchyTools.readSystemsParent(assetEAM.getAssetParentHierarchy());
        EquipmentHierarchyTools.HIERARCHY_TYPE currentHierarchyType = EquipmentHierarchyTools.readHierarchyType(assetEAM.getAssetParentHierarchy());
        assetParent = EquipmentHierarchyTools.createAssetParent(this.tools.getOrganizationCode(context, assetParam.getHierarchyAssetOrg()), assetParam.getHierarchyAssetCode(), assetParam.getHierarchyAssetCostRollUp(), assetParent);
        positionParent = EquipmentHierarchyTools.createPositionParent(this.tools.getOrganizationCode(context, assetParam.getHierarchyPositionOrg()), assetParam.getHierarchyPositionCode(), assetParam.getHierarchyPositionCostRollUp(), positionParent);
        primarySystemParent = EquipmentHierarchyTools.createPrimarySystemParent(this.tools.getOrganizationCode(context, assetParam.getHierarchyPrimarySystemOrg()), assetParam.getHierarchyPrimarySystemCode(), assetParam.getHierarchyPrimarySystemCostRollUp(), primarySystemParent);
        locationParent = EquipmentHierarchyTools.createLocationParent(this.tools.getOrganizationCode(context), assetParam.getHierarchyLocationCode(), locationParent);
        switch (EquipmentHierarchyTools.getNewHierarchyType(assetParam, currentHierarchyType)) {
            case ASSET_DEP: {
                hierarchy.setAssetDependency(EquipmentHierarchyTools.createAssetDependencyForAsset(assetParent, positionParent, primarySystemParent, systemParents));
                break;
            }
            case POSITION_DEP: {
                hierarchy.setPositionDependency(EquipmentHierarchyTools.createPositionDependencyForAsset(assetParent, positionParent, primarySystemParent, systemParents));
                break;
            }
            case PRIM_SYSTEM_DEP: {
                hierarchy.setPrimarySystemDependency(EquipmentHierarchyTools.createPrimarySystemDependencyForAsset(assetParent, positionParent, primarySystemParent, systemParents));
                break;
            }
            case LOCATION_DEP: {
                hierarchy.setLocationDependency(EquipmentHierarchyTools.createLocationDependencyForAsset(assetParent, positionParent, primarySystemParent, systemParents, locationParent));
                break;
            }
            default: {
                hierarchy.setNonDependentParents(EquipmentHierarchyTools.createNonDependentParentsForAsset(assetParent, positionParent, primarySystemParent, systemParents));
            }
        }
        assetEAM.setAssetParentHierarchy(hierarchy);
    }
}

